/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.result.LazyCaptureGroupsResult;
import com.oracle.truffle.regex.runtime.nodes.DispatchNode;

@GenerateUncached
public abstract class LazyCaptureGroupGetResultNode
extends Node {
    public abstract int[] execute(LazyCaptureGroupsResult var1);

    @Specialization(guards={"receiver.getResult() == null", "receiver.getFindStartCallTarget() == null"})
    static int[] doLazyCaptureGroupsCalc(LazyCaptureGroupsResult receiver, @Cached.Shared(value="calcResult") @Cached DispatchNode calcResult) {
        calcResult.execute(receiver.getCaptureGroupCallTarget(), receiver.createArgsCGNoFindStart());
        return receiver.getResult();
    }

    @Specialization(guards={"receiver.getResult() == null", "receiver.getFindStartCallTarget() != null"})
    static int[] doLazyCaptureGroupsCalcWithFindStart(LazyCaptureGroupsResult receiver, @Cached.Exclusive @Cached DispatchNode calcStart, @Cached.Shared(value="calcResult") @Cached DispatchNode calcResult) {
        int start = (Integer)calcStart.execute(receiver.getFindStartCallTarget(), receiver.createArgsFindStart());
        calcResult.execute(receiver.getCaptureGroupCallTarget(), receiver.createArgsCG(start));
        return receiver.getResult();
    }

    @Specialization(guards={"receiver.getResult() != null"})
    int[] doLazyCaptureGroups(LazyCaptureGroupsResult receiver) {
        return receiver.getResult();
    }
}

