/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.AssertUtils;
import com.oracle.truffle.api.interop.DefaultBooleanExports;
import com.oracle.truffle.api.interop.DefaultByteExports;
import com.oracle.truffle.api.interop.DefaultCharacterExports;
import com.oracle.truffle.api.interop.DefaultDoubleExports;
import com.oracle.truffle.api.interop.DefaultFloatExports;
import com.oracle.truffle.api.interop.DefaultIntegerExports;
import com.oracle.truffle.api.interop.DefaultLongExports;
import com.oracle.truffle.api.interop.DefaultShortExports;
import com.oracle.truffle.api.interop.DefaultStringExports;
import com.oracle.truffle.api.interop.InteropAccessor;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.LegacyMetaObjectWrapper;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

@GenerateLibrary(assertions=Asserts.class, receiverType=TruffleObject.class)
@GenerateLibrary.DefaultExport.Repeat(value={@GenerateLibrary.DefaultExport(value=DefaultBooleanExports.class), @GenerateLibrary.DefaultExport(value=DefaultIntegerExports.class), @GenerateLibrary.DefaultExport(value=DefaultByteExports.class), @GenerateLibrary.DefaultExport(value=DefaultShortExports.class), @GenerateLibrary.DefaultExport(value=DefaultLongExports.class), @GenerateLibrary.DefaultExport(value=DefaultFloatExports.class), @GenerateLibrary.DefaultExport(value=DefaultDoubleExports.class), @GenerateLibrary.DefaultExport(value=DefaultCharacterExports.class), @GenerateLibrary.DefaultExport(value=DefaultStringExports.class)})
public abstract class InteropLibrary
extends Library {
    static final LibraryFactory<InteropLibrary> FACTORY = LibraryFactory.resolve(InteropLibrary.class);

    protected InteropLibrary() {
    }

    public boolean isNull(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"asBoolean"})
    public boolean isBoolean(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isBoolean"})
    public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"execute"})
    public boolean isExecutable(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isExecutable"})
    public Object execute(Object receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"instantiate"})
    public boolean isInstantiable(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isInstantiable"})
    public Object instantiate(Object receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"asString"})
    public boolean isString(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isString"})
    public String asString(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"fitsInByte", "fitsInShort", "fitsInInt", "fitsInLong", "fitsInFloat", "fitsInDouble", "asByte", "asShort", "asInt", "asLong", "asFloat", "asDouble"})
    public boolean isNumber(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInByte(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInShort(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInInt(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInLong(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInFloat(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInDouble(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public byte asByte(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public short asShort(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public int asInt(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public long asLong(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public float asFloat(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public double asDouble(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getMembers", "isMemberReadable", "readMember", "isMemberModifiable", "isMemberInsertable", "writeMember", "isMemberRemovable", "removeMember", "isMemberInvocable", "invokeMember", "isMemberInternal", "hasMemberReadSideEffects", "hasMemberWriteSideEffects"})
    public boolean hasMembers(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasMembers"})
    public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    public final Object getMembers(Object receiver) throws UnsupportedMessageException {
        return this.getMembers(receiver, false);
    }

    @GenerateLibrary.Abstract(ifExported={"readMember"})
    public boolean isMemberReadable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMemberReadable"})
    public Object readMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"writeMember"})
    public boolean isMemberModifiable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"writeMember"})
    public boolean isMemberInsertable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMemberModifiable", "isMemberInsertable"})
    public void writeMember(Object receiver, String member, Object value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"removeMember"})
    public boolean isMemberRemovable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMemberRemovable"})
    public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"invokeMember"})
    public boolean isMemberInvocable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMemberInvocable"})
    public Object invokeMember(Object receiver, String member, Object ... arguments) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
        throw UnsupportedMessageException.create();
    }

    public boolean isMemberInternal(Object receiver, String member) {
        return false;
    }

    public final boolean isMemberWritable(Object receiver, String member) {
        return this.isMemberModifiable(receiver, member) || this.isMemberInsertable(receiver, member);
    }

    public final boolean isMemberExisting(Object receiver, String member) {
        return this.isMemberReadable(receiver, member) || this.isMemberModifiable(receiver, member) || this.isMemberRemovable(receiver, member) || this.isMemberInvocable(receiver, member);
    }

    public boolean hasMemberReadSideEffects(Object receiver, String member) {
        return false;
    }

    public boolean hasMemberWriteSideEffects(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"readArrayElement", "writeArrayElement", "removeArrayElement", "isArrayElementModifiable", "isArrayElementRemovable", "isArrayElementReadable", "getArraySize"})
    public boolean hasArrayElements(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasArrayElements"})
    public Object readArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasArrayElements"})
    public long getArraySize(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasArrayElements"})
    public boolean isArrayElementReadable(Object receiver, long index) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isArrayElementModifiable", "isArrayElementInsertable"})
    public void writeArrayElement(Object receiver, long index, Object value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isArrayElementRemovable"})
    public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"writeArrayElement"})
    public boolean isArrayElementModifiable(Object receiver, long index) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"writeArrayElement"})
    public boolean isArrayElementInsertable(Object receiver, long index) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"removeArrayElement"})
    public boolean isArrayElementRemovable(Object receiver, long index) {
        return false;
    }

    public final boolean isArrayElementWritable(Object receiver, long index) {
        return this.isArrayElementModifiable(receiver, index) || this.isArrayElementInsertable(receiver, index);
    }

    public final boolean isArrayElementExisting(Object receiver, long index) {
        return this.isArrayElementModifiable(receiver, index) || this.isArrayElementReadable(receiver, index) || this.isArrayElementRemovable(receiver, index);
    }

    @GenerateLibrary.Abstract(ifExported={"asPointer"})
    public boolean isPointer(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isPointer"})
    public long asPointer(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    public void toNative(Object receiver) {
    }

    public Instant asInstant(Object receiver) throws UnsupportedMessageException {
        if (this.isDate(receiver) && this.isTime(receiver) && this.isTimeZone(receiver)) {
            LocalDate date = this.asDate(receiver);
            LocalTime time = this.asTime(receiver);
            ZoneId zone = this.asTimeZone(receiver);
            return InteropLibrary.toInstant(date, time, zone);
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    private static Instant toInstant(LocalDate date, LocalTime time, ZoneId zone) {
        return ZonedDateTime.of(date, time, zone).toInstant();
    }

    public final boolean isInstant(Object receiver) {
        return this.isDate(receiver) && this.isTime(receiver) && this.isTimeZone(receiver);
    }

    @GenerateLibrary.Abstract(ifExported={"asTimeZone", "asInstant"})
    public boolean isTimeZone(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isTimeZone", "asInstant"})
    public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"asDate", "asInstant"})
    public boolean isDate(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isTime", "asInstant"})
    public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"asTime", "asInstant"})
    public boolean isTime(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isTime", "asInstant"})
    public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"asDuration"})
    public boolean isDuration(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isDuration"})
    public Duration asDuration(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"throwException"})
    public boolean isException(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isException"})
    public RuntimeException throwException(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"getSourceLocation"})
    public boolean hasSourceLocation(Object receiver) {
        SourceSection location;
        TruffleLanguage.Env env = InteropLibrary.getLegacyEnv(receiver, false);
        return env != null && (location = InteropAccessor.ACCESSOR.languageSupport().legacyFindSourceLocation(env, receiver)) != null;
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"hasSourceLocation"})
    public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
        SourceSection location;
        TruffleLanguage.Env env = InteropLibrary.getLegacyEnv(receiver, false);
        if (env != null && (location = InteropAccessor.ACCESSOR.languageSupport().legacyFindSourceLocation(env, receiver)) != null) {
            return location;
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"getLanguage"})
    public boolean hasLanguage(Object receiver) {
        return InteropLibrary.getLegacyEnv(receiver, false) != null;
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"hasLanguage"})
    public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
        TruffleLanguage.Env env = InteropLibrary.getLegacyEnv(receiver, false);
        if (env != null) {
            return InteropAccessor.ACCESSOR.languageSupport().getSPI(env).getClass();
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"getMetaObject"})
    public boolean hasMetaObject(Object receiver) {
        Object metaObject;
        TruffleLanguage.Env env = InteropLibrary.getLegacyEnv(receiver, false);
        return env != null && (metaObject = InteropAccessor.ACCESSOR.languageSupport().legacyFindMetaObject(env, receiver)) != null;
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"hasMetaObject"})
    public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
        Object metaObject;
        TruffleLanguage.Env env = InteropLibrary.getLegacyEnv(receiver, false);
        if (env != null && (metaObject = InteropAccessor.ACCESSOR.languageSupport().legacyFindMetaObject(env, receiver)) != null) {
            return new LegacyMetaObjectWrapper(receiver, metaObject);
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"hasLanguage", "getLanguage"})
    public Object toDisplayString(Object receiver, boolean allowSideEffects) {
        TruffleLanguage.Env env = InteropLibrary.getLegacyEnv(receiver, false);
        if (env != null && allowSideEffects) {
            return InteropAccessor.ACCESSOR.languageSupport().legacyToString(env, receiver);
        }
        return receiver.getClass().getTypeName() + "@" + Integer.toHexString(System.identityHashCode(receiver));
    }

    private static TruffleLanguage.Env getLegacyEnv(Object receiver, boolean nullForhost) {
        return InteropAccessor.ACCESSOR.engineSupport().getLegacyLanguageEnv(receiver, nullForhost);
    }

    public final Object toDisplayString(Object receiver) {
        return this.toDisplayString(receiver, true);
    }

    @GenerateLibrary.Abstract(ifExported={"getMetaQualifiedName", "getMetaSimpleName", "isMetaInstance"})
    public boolean isMetaObject(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMetaObject"})
    public Object getMetaQualifiedName(Object metaObject) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isMetaObject"})
    public Object getMetaSimpleName(Object metaObject) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isMetaObject"})
    public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    public static LibraryFactory<InteropLibrary> getFactory() {
        return FACTORY;
    }

    protected final boolean assertAdopted() {
        assert (this.getRootNode() != null) : "Invalid library usage. Cached library must be adopted by a RootNode before it is executed.";
        return true;
    }

    static class Asserts
    extends InteropLibrary {
        @Node.Child
        private InteropLibrary delegate;

        Asserts(InteropLibrary delegate) {
            this.delegate = delegate;
        }

        private static boolean isMultiThreaded(Object receiver) {
            Accessor.EngineSupport engine = InteropAccessor.ACCESSOR.engineSupport();
            if (engine == null) {
                return false;
            }
            return engine.isMultiThreaded(receiver);
        }

        @Override
        public boolean accepts(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            return this.delegate.accepts(receiver);
        }

        @Override
        public boolean isNull(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isNull(receiver);
            assert (!result || this.notOtherType(receiver, Type.NULL));
            return result;
        }

        private boolean notOtherType(Object receiver, Type type) {
            if (receiver instanceof LegacyMetaObjectWrapper) {
                return true;
            }
            assert (type == Type.NULL || !this.delegate.isNull(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type == Type.BOOLEAN || !this.delegate.isBoolean(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type == Type.STRING || !this.delegate.isString(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type == Type.NUMBER || !this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type == Type.DATE_TIME_ZONE || !this.delegate.isDate(receiver) && !this.delegate.isTime(receiver) && !this.delegate.isTimeZone(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type == Type.DURATION || !this.delegate.isDuration(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type == Type.META_OBJECT || !this.delegate.isMetaObject(receiver)) : AssertUtils.violationInvariant(receiver);
            return true;
        }

        @Override
        public boolean isBoolean(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.isBoolean(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isBoolean(receiver);
            if (result) {
                try {
                    this.delegate.asBoolean(receiver);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!result || this.notOtherType(receiver, Type.BOOLEAN));
            return result;
        }

        @Override
        public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asBoolean(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasBoolean = this.delegate.isBoolean(receiver);
            try {
                boolean result = this.delegate.asBoolean(receiver);
                assert (wasBoolean) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.BOOLEAN));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasBoolean) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public boolean isExecutable(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isExecutable(receiver);
            return result;
        }

        @Override
        public Object execute(Object receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.execute(receiver, arguments);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArguments(receiver, arguments));
            boolean wasExecutable = this.delegate.isExecutable(receiver);
            try {
                Object result = this.delegate.execute(receiver, arguments);
                assert (wasExecutable) : AssertUtils.violationInvariant(receiver, arguments);
                assert (AssertUtils.validReturn(receiver, result));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException || e instanceof ArityException || e instanceof UnsupportedTypeException) : AssertUtils.violationInvariant(receiver, arguments);
                assert (!(e instanceof UnsupportedMessageException) || !wasExecutable) : AssertUtils.violationInvariant(receiver, arguments);
                throw e;
            }
        }

        @Override
        public boolean isInstantiable(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isInstantiable(receiver);
            return result;
        }

        @Override
        public Object instantiate(Object receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.instantiate(receiver, arguments);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArguments(receiver, arguments));
            boolean wasInstantiable = this.delegate.isInstantiable(receiver);
            try {
                Object result = this.delegate.instantiate(receiver, arguments);
                assert (wasInstantiable) : AssertUtils.violationInvariant(receiver, arguments);
                assert (AssertUtils.validReturn(receiver, result));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException || e instanceof ArityException || e instanceof UnsupportedTypeException) : AssertUtils.violationInvariant(receiver, arguments);
                assert (!(e instanceof UnsupportedMessageException) || !wasInstantiable) : AssertUtils.violationInvariant(receiver, arguments);
                throw e;
            }
        }

        @Override
        public boolean isString(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.isString(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isString(receiver);
            if (result) {
                try {
                    this.delegate.asString(receiver);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!result || this.notOtherType(receiver, Type.STRING));
            return result;
        }

        @Override
        public String asString(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asString(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasString = this.delegate.isString(receiver);
            try {
                String result = this.delegate.asString(receiver);
                assert (wasString) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasString) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public boolean isNumber(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isNumber(receiver);
            assert (!result || this.notOtherType(receiver, Type.NUMBER));
            return result;
        }

        @Override
        public boolean fitsInByte(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInByte(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInByte(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInShort(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInInt(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInLong(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInFloat(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInDouble(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asByte(receiver);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            return fits;
        }

        @Override
        public boolean fitsInShort(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInShort(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInShort(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInInt(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInLong(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInFloat(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInDouble(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asShort(receiver);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            return fits;
        }

        @Override
        public boolean fitsInInt(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInInt(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInInt(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInLong(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInDouble(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asInt(receiver);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            return fits;
        }

        @Override
        public boolean fitsInLong(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInLong(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInLong(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asLong(receiver);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            return fits;
        }

        @Override
        public boolean fitsInFloat(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInFloat(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInFloat(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asFloat(receiver);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            return fits;
        }

        @Override
        public boolean fitsInDouble(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInDouble(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInDouble(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asDouble(receiver);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            return fits;
        }

        @Override
        public byte asByte(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                byte result = this.delegate.asByte(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInByte(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (result == this.delegate.asShort(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (result == this.delegate.asInt(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((long)result == this.delegate.asLong(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((float)result == this.delegate.asFloat(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((double)result == this.delegate.asDouble(receiver)) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public short asShort(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                short result = this.delegate.asShort(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInShort(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (result == this.delegate.asInt(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((long)result == this.delegate.asLong(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((float)result == this.delegate.asFloat(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((double)result == this.delegate.asDouble(receiver)) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public int asInt(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                int result = this.delegate.asInt(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInInt(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((long)result == this.delegate.asLong(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((double)result == this.delegate.asDouble(receiver)) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public long asLong(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                long result = this.delegate.asLong(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInLong(receiver)) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public float asFloat(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                float result = this.delegate.asFloat(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInFloat(receiver)) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public double asDouble(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                double result = this.delegate.asDouble(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInDouble(receiver)) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public boolean hasMembers(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            return this.delegate.hasMembers(receiver);
        }

        @Override
        public Object readMember(Object receiver, String identifier) throws UnsupportedMessageException, UnknownIdentifierException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.readMember(receiver, identifier);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean wasReadable = this.delegate.isMemberReadable(receiver, identifier);
            try {
                Object result = this.delegate.readMember(receiver, identifier);
                assert (this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (wasReadable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (AssertUtils.validReturn(receiver, result));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException || e instanceof UnknownIdentifierException) : AssertUtils.violationPost(receiver, e);
                throw e;
            }
        }

        @Override
        public void writeMember(Object receiver, String identifier, Object value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.writeMember(receiver, identifier, value);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            assert (AssertUtils.validArgument(receiver, value));
            boolean wasWritable = this.delegate.isMemberModifiable(receiver, identifier) || this.delegate.isMemberInsertable(receiver, identifier);
            try {
                this.delegate.writeMember(receiver, identifier, value);
                assert (this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (wasWritable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException || e instanceof UnknownIdentifierException || e instanceof UnsupportedTypeException) : AssertUtils.violationPost(receiver, e);
                throw e;
            }
        }

        @Override
        public void removeMember(Object receiver, String identifier) throws UnsupportedMessageException, UnknownIdentifierException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.removeMember(receiver, identifier);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean wasRemovable = this.delegate.isMemberRemovable(receiver, identifier);
            try {
                this.delegate.removeMember(receiver, identifier);
                assert (this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (wasRemovable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException || e instanceof UnknownIdentifierException) : AssertUtils.violationPost(receiver, e);
                throw e;
            }
        }

        @Override
        public Object invokeMember(Object receiver, String identifier, Object ... arguments) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.invokeMember(receiver, identifier, arguments);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            assert (AssertUtils.validArguments(receiver, arguments));
            boolean wasInvocable = this.delegate.isMemberInvocable(receiver, identifier);
            try {
                Object result = this.delegate.invokeMember(receiver, identifier, arguments);
                assert (this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (wasInvocable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (AssertUtils.validReturn(receiver, result));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException || e instanceof ArityException || e instanceof UnknownIdentifierException || e instanceof UnsupportedTypeException) : AssertUtils.violationPost(receiver, e);
                throw e;
            }
        }

        @Override
        public Object getMembers(Object receiver, boolean internal) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                Object result = this.delegate.getMembers(receiver, internal);
                assert (AssertUtils.validReturn(receiver, result));
                assert (Asserts.isMultiThreaded(receiver) || Asserts.assertMemberKeys(receiver, result, internal));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e);
                throw e;
            }
        }

        private static boolean assertMemberKeys(Object receiver, Object result, boolean internal) {
            long arraySize;
            assert (result != null) : AssertUtils.violationPost(receiver, result);
            InteropLibrary uncached = InteropLibrary.getFactory().getUncached(result);
            assert (uncached.hasArrayElements(result)) : AssertUtils.violationPost(receiver, result);
            try {
                arraySize = uncached.getArraySize(result);
            }
            catch (UnsupportedMessageException e) {
                assert (false) : AssertUtils.violationPost(receiver, e);
                return true;
            }
            int i = 0;
            while ((long)i < arraySize) {
                block13: {
                    Object element;
                    assert (uncached.isArrayElementReadable(result, i)) : AssertUtils.violationPost(receiver, result);
                    try {
                        element = uncached.readArrayElement(result, i);
                    }
                    catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                        assert (false) : AssertUtils.violationPost(receiver, result);
                        return true;
                    }
                    assert (InteropLibrary.getFactory().getUncached().isString(element)) : AssertUtils.violationPost(receiver, element);
                    try {
                        InteropLibrary.getFactory().getUncached().asString(element);
                    }
                    catch (UnsupportedMessageException e) {
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError((Object)AssertUtils.violationInvariant(result, i));
                    }
                }
                ++i;
            }
            return true;
        }

        @Override
        public boolean hasMemberReadSideEffects(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean result = this.delegate.hasMemberReadSideEffects(receiver, identifier);
            assert (!result || this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (!result || this.delegate.isMemberReadable(receiver, identifier) || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean hasMemberWriteSideEffects(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean result = this.delegate.hasMemberWriteSideEffects(receiver, identifier);
            assert (!result || this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (!result || this.delegate.isMemberWritable(receiver, identifier) || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isMemberReadable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean result = this.delegate.isMemberReadable(receiver, identifier);
            assert (!result || this.delegate.hasMembers(receiver) && !this.delegate.isMemberInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isMemberModifiable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean result = this.delegate.isMemberModifiable(receiver, identifier);
            assert (!result || this.delegate.hasMembers(receiver) && !this.delegate.isMemberInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isMemberInsertable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean result = this.delegate.isMemberInsertable(receiver, identifier);
            assert (!result || this.delegate.hasMembers(receiver) && !this.delegate.isMemberExisting(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isMemberRemovable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean result = this.delegate.isMemberRemovable(receiver, identifier);
            assert (!result || this.delegate.hasMembers(receiver) && !this.delegate.isMemberInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isMemberInvocable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean result = this.delegate.isMemberInvocable(receiver, identifier);
            assert (!result || this.delegate.hasMembers(receiver) && !this.delegate.isMemberInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isMemberInternal(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, identifier));
            boolean result = this.delegate.isMemberInternal(receiver, identifier);
            assert (!result || this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean hasArrayElements(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            return this.delegate.hasArrayElements(receiver);
        }

        @Override
        public Object readArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.readArrayElement(receiver, index);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasReadable = this.delegate.isArrayElementReadable(receiver, index);
            try {
                Object result = this.delegate.readArrayElement(receiver, index);
                assert (this.delegate.hasArrayElements(receiver)) : AssertUtils.violationInvariant(receiver, index);
                assert (wasReadable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, index);
                assert (AssertUtils.validReturn(receiver, result));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException || e instanceof InvalidArrayIndexException) : AssertUtils.violationPost(receiver, e);
                throw e;
            }
        }

        @Override
        public void writeArrayElement(Object receiver, long index, Object value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.writeArrayElement(receiver, index, value);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, value));
            boolean wasWritable = this.delegate.isArrayElementModifiable(receiver, index) || this.delegate.isArrayElementInsertable(receiver, index);
            try {
                this.delegate.writeArrayElement(receiver, index, value);
                assert (this.delegate.hasArrayElements(receiver)) : AssertUtils.violationInvariant(receiver, index);
                assert (wasWritable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, index);
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException || e instanceof UnsupportedTypeException || e instanceof InvalidArrayIndexException) : AssertUtils.violationPost(receiver, e);
                throw e;
            }
        }

        @Override
        public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.removeArrayElement(receiver, index);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasRemovable = this.delegate.isArrayElementRemovable(receiver, index);
            try {
                this.delegate.removeArrayElement(receiver, index);
                assert (this.delegate.hasArrayElements(receiver)) : AssertUtils.violationInvariant(receiver, index);
                assert (wasRemovable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, index);
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException || e instanceof InvalidArrayIndexException) : AssertUtils.violationPost(receiver, e);
                throw e;
            }
        }

        @Override
        public long getArraySize(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                long result = this.delegate.getArraySize(receiver);
                assert (this.delegate.hasArrayElements(receiver)) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e);
                throw e;
            }
        }

        @Override
        public boolean isArrayElementReadable(Object receiver, long identifier) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isArrayElementReadable(receiver, identifier);
            assert (!result || this.delegate.hasArrayElements(receiver) && !this.delegate.isArrayElementInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isArrayElementModifiable(Object receiver, long identifier) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isArrayElementModifiable(receiver, identifier);
            assert (!result || this.delegate.hasArrayElements(receiver) && !this.delegate.isArrayElementInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isArrayElementInsertable(Object receiver, long identifier) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isArrayElementInsertable(receiver, identifier);
            assert (!result || this.delegate.hasArrayElements(receiver) && !this.delegate.isArrayElementExisting(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isArrayElementRemovable(Object receiver, long identifier) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isArrayElementRemovable(receiver, identifier);
            assert (!result || this.delegate.hasArrayElements(receiver) && !this.delegate.isArrayElementInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            return result;
        }

        @Override
        public boolean isPointer(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isPointer(receiver);
            return result;
        }

        @Override
        public void toNative(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean wasPointer = this.delegate.isPointer(receiver);
            this.delegate.toNative(receiver);
            assert (!wasPointer || this.delegate.isPointer(receiver)) : AssertUtils.violationInvariant(receiver);
        }

        @Override
        public long asPointer(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asPointer(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasPointer = this.delegate.isPointer(receiver);
            try {
                long result = this.delegate.asPointer(receiver);
                assert (wasPointer) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasPointer) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asDate(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean hasDate = this.delegate.isDate(receiver);
            try {
                LocalDate result = this.delegate.asDate(receiver);
                assert (hasDate) : AssertUtils.violationInvariant(receiver);
                assert (!this.delegate.isTimeZone(receiver) || this.delegate.isTime(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DATE_TIME_ZONE));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hasDate) : AssertUtils.violationInvariant(receiver);
                assert (!this.delegate.isTimeZone(receiver) || !this.delegate.isTime(receiver) || this.hasFixedTimeZone(receiver)) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asTime(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean hasTime = this.delegate.isTime(receiver);
            try {
                LocalTime result = this.delegate.asTime(receiver);
                assert (hasTime) : AssertUtils.violationInvariant(receiver);
                assert (!this.delegate.isTimeZone(receiver) || this.delegate.isDate(receiver) || this.hasFixedTimeZone(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DATE_TIME_ZONE));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hasTime) : AssertUtils.violationInvariant(receiver);
                assert (!this.delegate.isTimeZone(receiver) || !this.delegate.isDate(receiver)) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asTimeZone(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean hasTimeZone = this.delegate.isTimeZone(receiver);
            try {
                ZoneId result = this.delegate.asTimeZone(receiver);
                assert (hasTimeZone) : AssertUtils.violationInvariant(receiver);
                assert ((this.delegate.isDate(receiver) || result.getRules().isFixedOffset()) && this.delegate.isTime(receiver) || !this.delegate.isDate(receiver) && !this.delegate.isTime(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DATE_TIME_ZONE));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hasTimeZone) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        private boolean hasFixedTimeZone(Object receiver) {
            try {
                return this.delegate.asTimeZone(receiver).getRules().isFixedOffset();
            }
            catch (InteropException e) {
                throw new AssertionError((Object)AssertUtils.violationInvariant(receiver));
            }
        }

        @Override
        public Duration asDuration(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asDuration(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasDuration = this.delegate.isDuration(receiver);
            try {
                Duration result = this.delegate.asDuration(receiver);
                assert (wasDuration) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DURATION));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasDuration) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public Instant asInstant(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asInstant(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean hasDateAndTime = this.delegate.isDate(receiver) && this.delegate.isTime(receiver) && this.delegate.isTimeZone(receiver);
            try {
                Instant result = this.delegate.asInstant(receiver);
                assert (hasDateAndTime) : AssertUtils.violationInvariant(receiver);
                assert (ZonedDateTime.of(this.delegate.asDate(receiver), this.delegate.asTime(receiver), this.delegate.asTimeZone(receiver)).toInstant().equals(result)) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DATE_TIME_ZONE));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hasDateAndTime) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public boolean isDate(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isDate(receiver);
            assert (!this.delegate.isTimeZone(receiver) || this.delegate.isTime(receiver) && result || (!this.delegate.isTime(receiver) || this.hasFixedTimeZone(receiver)) && !result) : AssertUtils.violationInvariant(receiver);
            assert (!result || this.notOtherType(receiver, Type.DATE_TIME_ZONE));
            return result;
        }

        @Override
        public boolean isTime(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isTime(receiver);
            assert (!this.delegate.isTimeZone(receiver) || (this.delegate.isDate(receiver) || this.hasFixedTimeZone(receiver)) && result || !this.delegate.isDate(receiver) && !result) : AssertUtils.violationInvariant(receiver);
            assert (!result || this.notOtherType(receiver, Type.DATE_TIME_ZONE));
            return result;
        }

        @Override
        public boolean isTimeZone(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isTimeZone(receiver);
            assert (!result || (this.delegate.isDate(receiver) || this.hasFixedTimeZone(receiver)) && this.delegate.isTime(receiver) || !this.delegate.isDate(receiver) && !this.delegate.isTime(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!result || this.notOtherType(receiver, Type.DATE_TIME_ZONE));
            return result;
        }

        @Override
        public boolean isDuration(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isDuration(receiver);
            assert (!result || this.notOtherType(receiver, Type.DURATION));
            return result;
        }

        @Override
        public boolean isException(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isException(receiver);
            return result;
        }

        @Override
        public RuntimeException throwException(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.throwException(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasException = this.delegate.isException(receiver);
            boolean unsupported = false;
            try {
                try {
                    throw this.delegate.throwException(receiver);
                }
                catch (InteropException e) {
                    assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                    assert (!wasException) : AssertUtils.violationInvariant(receiver);
                    unsupported = true;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                if (!unsupported) assert (wasException) : AssertUtils.violationInvariant(receiver);
                throw throwable;
            }
        }

        @Override
        public Object toDisplayString(Object receiver, boolean allowSideEffects) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validNonInteropArgument(receiver, allowSideEffects));
            Object result = this.delegate.toDisplayString(receiver, allowSideEffects);
            assert (Asserts.assertString(receiver, result));
            return result;
        }

        private static boolean assertString(Object receiver, Object string) {
            block4: {
                InteropLibrary uncached = InteropLibrary.getFactory().getUncached(string);
                assert (uncached.isString(string)) : AssertUtils.violationPost(receiver, string);
                try {
                    assert (uncached.asString(string) != null) : AssertUtils.violationPost(receiver, string);
                }
                catch (UnsupportedMessageException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            return true;
        }

        @Override
        public boolean hasSourceLocation(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.hasSourceLocation(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.hasSourceLocation(receiver);
            if (result) {
                try {
                    assert (this.delegate.getSourceLocation(receiver) != null) : AssertUtils.violationPost(receiver, result);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {}
            } else assert (this.assertHasNoSourceSection(receiver));
            return result;
        }

        private boolean assertHasNoSourceSection(Object receiver) {
            try {
                this.delegate.getSourceLocation(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getSourceLocation(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasSourceLocation = this.delegate.hasSourceLocation(receiver);
            try {
                SourceSection result = this.delegate.getSourceLocation(receiver);
                assert (wasHasSourceLocation) : AssertUtils.violationInvariant(receiver);
                assert (result != null) : AssertUtils.violationPost(receiver, result);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasSourceLocation) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public boolean hasLanguage(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.hasLanguage(receiver);
            if (result) {
                try {
                    assert (this.delegate.getLanguage(receiver) != null) : AssertUtils.violationPost(receiver, result);
                }
                catch (InteropException e) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {}
            } else assert (this.assertHasNoLanguage(receiver));
            return result;
        }

        private boolean assertHasNoLanguage(Object receiver) {
            try {
                this.delegate.getLanguage(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getLanguage(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasLanguage = this.delegate.hasLanguage(receiver);
            try {
                Class<? extends TruffleLanguage<?>> result = this.delegate.getLanguage(receiver);
                assert (wasHasLanguage) : AssertUtils.violationInvariant(receiver);
                assert (result != null) : AssertUtils.violationPost(receiver, result);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasLanguage) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public boolean hasMetaObject(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.hasMetaObject(receiver);
            if (result ? !$assertionsDisabled && !this.assertHasMetaObject(receiver, result) : !$assertionsDisabled && !this.assertHasNoMetaObject(receiver)) {
                throw new AssertionError();
            }
            return result;
        }

        private boolean assertHasMetaObject(Object receiver, boolean result) {
            try {
                Object meta = this.delegate.getMetaObject(receiver);
                assert (Asserts.verifyMetaObject(receiver, meta));
            }
            catch (InteropException e) {
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        private static boolean verifyMetaObject(Object receiver, Object meta) throws UnsupportedMessageException {
            assert (meta != null) : AssertUtils.violationPost(receiver, meta);
            InteropLibrary metaLib = InteropLibrary.getFactory().getUncached(meta);
            assert (metaLib.isMetaObject(meta)) : AssertUtils.violationPost(receiver, meta);
            assert (metaLib.isMetaInstance(meta, receiver)) : AssertUtils.violationPost(receiver, meta);
            assert (metaLib.getMetaSimpleName(meta) != null) : AssertUtils.violationPost(receiver, meta);
            assert (metaLib.getMetaQualifiedName(meta) != null) : AssertUtils.violationPost(receiver, meta);
            return true;
        }

        private boolean assertHasNoMetaObject(Object receiver) {
            try {
                this.delegate.getMetaObject(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getMetaObject(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasMetaObject = this.delegate.hasMetaObject(receiver);
            try {
                Object result = this.delegate.getMetaObject(receiver);
                assert (wasHasMetaObject) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.verifyMetaObject(receiver, result));
                assert (result != null) : AssertUtils.violationPost(receiver, result);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasMetaObject) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public boolean isMetaObject(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result = this.delegate.isMetaObject(receiver);
            if (result) {
                assert (this.assertMetaObject(receiver));
            } else {
                assert (this.assertNoMetaObject(receiver));
                assert (!result || this.notOtherType(receiver, Type.META_OBJECT));
            }
            return result;
        }

        private boolean assertNoMetaObject(Object receiver) {
            try {
                this.delegate.isMetaInstance(receiver, receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            try {
                this.delegate.getMetaSimpleName(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            try {
                this.delegate.getMetaQualifiedName(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return true;
        }

        private boolean assertMetaObject(Object receiver) {
            block10: {
                block9: {
                    block8: {
                        try {
                            this.delegate.isMetaInstance(receiver, receiver);
                        }
                        catch (UnsupportedMessageException e) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError((Object)AssertUtils.violationInvariant(receiver));
                        }
                    }
                    try {
                        assert (Asserts.assertString(receiver, this.delegate.getMetaSimpleName(receiver))) : AssertUtils.violationInvariant(receiver);
                    }
                    catch (UnsupportedMessageException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError((Object)AssertUtils.violationInvariant(receiver));
                    }
                }
                try {
                    assert (Asserts.assertString(receiver, this.delegate.getMetaQualifiedName(receiver))) : AssertUtils.violationInvariant(receiver);
                }
                catch (UnsupportedMessageException e) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)AssertUtils.violationInvariant(receiver));
                }
            }
            return true;
        }

        @Override
        public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getMetaQualifiedName(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasMetaObject = this.delegate.isMetaObject(receiver);
            try {
                Object result = this.delegate.getMetaQualifiedName(receiver);
                assert (wasMetaObject) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.assertString(receiver, result));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasMetaObject) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getMetaSimpleName(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasMetaObject = this.delegate.isMetaObject(receiver);
            try {
                Object result = this.delegate.getMetaSimpleName(receiver);
                assert (wasMetaObject) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.assertString(receiver, result));
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasMetaObject) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        @Override
        public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.isMetaInstance(receiver, instance);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validArgument(receiver, instance));
            boolean wasMetaObject = this.delegate.isMetaObject(receiver);
            try {
                boolean result = this.delegate.isMetaInstance(receiver, instance);
                assert (wasMetaObject) : AssertUtils.violationInvariant(receiver);
                return result;
            }
            catch (InteropException e) {
                assert (e instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasMetaObject) : AssertUtils.violationInvariant(receiver);
                throw e;
            }
        }

        public static enum Type {
            NULL,
            BOOLEAN,
            DATE_TIME_ZONE,
            DURATION,
            STRING,
            NUMBER,
            POINTER,
            META_OBJECT;

        }
    }
}

