
#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Genereal Ledger
#
#======================================================================


use SL::payment;
require "format/print_payment.pl";
use SL::IS;
1;
# end of main


# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')



sub generate_report {
 &{$form->{nextsub}}(\%myconfig, \%$form);

}





sub add {

  $form->{title} = "Add";

  $form->{callback} = "$form->{script}?action=add&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

 # $form->create_links("AR", \%myconfig, "customer");
#  $taxincluded = $form->{taxincluded};
 $form->create_links("AP", \%myconfig, "vendor");
   payment->get_chart(\%myconfig, \%$form);

  # build the popup menus

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];
 $form->{currency} = $curr[0];

  map { $form->{selectcurrency} .= "<option>$_\n" } @curr;

 # forex
  $form->{forex} = $form->{exchangerate};

 if($form->{transdate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{transdate};
 }
  # we use this only to set a default date
  payment->transaction(\%myconfig, \%$form);

  
if($lastdate){
 $form->{transdate}=$lastdate;
$form->{batch}=$lastbatch;
}

 # $form->{rowcount} = 1;


 $form->{sort}="invnumber";
   payment->last_invoice(\%myconfig, \%$form);
   $form->{pyid}=$form->{lastinvnumber};
   $form->{pyid}++;
   $form->{nextfocus}="transtype";

  &update;
}



sub update {

  @a = ();
  $count = 0;
  @flds = (qw( no  ar_id invoice  status ));
  $fulltotal=0;
  for $i ( 1 .. $form->{rowcount}) {
    map { delete $form->{"${_}_$i"} } @flds;
 #   delete $form->{"ar_id_$i"}
  }
  # if(!$form->{id}){
    payment->get_ar_list(\%myconfig, \%$form);

   $i = 1;
   foreach $ref (@{ $form->{GL} }) {
    $form->{"ap_id_$i"} = $ref->{id};
    $form->{"invoice_$i"} = $ref->{invnumber};
   $form->{"amount1_$i"} = $ref->{amount};
 
  #  &form_row($i++);
  $i++;
  }
 # }
 # $i++;
   $form->{rowcount}=$i;
   
  
  for $i (1 .. $form->{rowcount}) {
 $form->{"total_$i"} = $form->parse_amount($myconfig, $form->{"total_$i"});
   unless ($form->{"ap_id_$i"} eq "") {
      # take accno apart
     # ($form->{"invoice_$i"}) = split(/--/, $form->{"accno_$i"});
    # $form->dberror($query);
      if($form->{"total_$i"} eq ""){
       $form->{"ap_id1"}=$form->{"ap_id_$i"};
      	payment->get_AP(\%myconfig, \%$form);
	$form->{"total_$i"} = $form->parse_amount($myconfig, $form->{"total_$i"});
	$form->{"amount1_$i"} = $form->{"amount1"};
	$form->{"due_$i"} = $form->{"amount1_$i"}-$form->{"paid"} ;
	$form->{"ap_date_$i"} = $form->{"ap_date"};
	$form->{"description_$i"} = $form->{"description"};
	$form->{"ap_id_$i"} = $form->{"ap_id"};
	$form->{"status_$i"} = "Full Payment";

#$form->dberror($form->{"ap_date_$i"});

	if($form->{"invnumber"} eq ""){
		$form->{"invoice_$i"}="";
	$form->{"ap_date_$i"} ="";
	$form->{"description_$i"} = "";
		$form->{"total_$i"}="";
		$form->{"status_$i"}="";
		$form->{"ap_id_$i"} ="";
	}
      }else{
       $form->{"ap_id1"}=$form->{"ap_id_$i"};
      	payment->get_AP(\%myconfig, \%$form);
	#$form->{"total_$i"} = $form->{"total"};
	#$form->{"ap_id_$i"} = $form->{"ap_id"};

	if($form->{"invnumber"} eq ""){
		$form->{"invoice_$i"}="";
		$form->{"total_$i"}="";
		$form->{"status_$i"}="";
		$form->{"ap_id_$i"} ="";
	$form->{"ap_date_$i"} = "";
	$form->{"description_$i"} = "";

	}
	else{
		$amount1 =$form->{"amount1"};
		$paid =$form->{"paid"};
		$total=$form->parse_amount($myconfig, $form->{"total_$i"});
		$form->{"ap_date_$i"} = $form->{"ap_date"};
		$form->{"ap_id_$i"} = $form->{"ap_id"};
		$form->{"description_$i"} = $form->{"description"};
		if(!$form->{id}){
		$all = $amount1-$paid-$total ;
		}else{
		$all = $amount1-$paid +$form->{"lasttotal_$i"}-$total;
		
		}
		$form->{"due_$i"}=$all ;
	$form->{"amount1_$i"} = $form->{"amount1"};
		if($all == 0){
				$form->{"status_$i"} = "Full Payment ";
		}else{
				$form->{"status_$i"} = "Part Payment";
		}
	}
      }

      $fulltotal +=$form->parse_amount($myconfig, $form->{"total_$i"});

      push @a, {};
      $j = $#a;
      
      map { $a[$j]->{$_} = $form->{"${_}_$i"} } @flds;
      $count++;
    }
  }

  for $i (1 .. $count) {
    $j = $i - 1;
    map { $form->{"${_}_$i"} = $a[$j]->{$_} } @flds;
  }

  for $i ($count + 1 .. $form->{rowcount}) {
    map { delete $form->{"${_}_$i"} } @flds;
  }

  $form->{rowcount} = $count;
$form->{vendor_key}=$form->{vendor};

##eware change
#if(!$form->{amount}){
#	$form->{amount}=$fulltotal
#}
#if(!$form->{source}){
#	$form->{source}=$form->{orid};
#}
	  $check = new IS $myconfig{countrycode};
  $check->init;
  $form->{text_amount} = $check->num2text($form->{amount});
 # $form->dberror($form->{text_amount});
 if(   $form->{decimal}>0){
	 $form->{text_amount} .= " And ". $check->num2text($form->{decimal})." Cents";
 }
  $form->{text_amount} .=" Only";
  ###eware change end

  
  &display_form;
  
}


sub display_form {

  &form_header;

  #$form->{rowcount}++;
  for $i (1 .. $form->{rowcount}) {
    &form_row($i);
  }
 $fulltotal = $form->format_amount(\%myconfig, $fulltotal, 2, "0");

 print qq|<tr class=listsubtotal bgcolor=333366>

  <td></td>
  <td></td>
  <td align=right><input type=hidden name=fulltotal value=$fulltotal>$fulltotal</td>
  <td></td>
  <td></td>
 <td></td>

</tr>


|;
  &form_footer;

}



sub print {

  &form_header_print;

  $form->{rowcount}++;
  $form->{rownumber}=0;
  for $i (1 .. $form->{rowcount}) {
    if($form->{"total_$i"}){
   $form->{rownumber}++;
   &form_row_print($i);
    }
  }
 $form->{amount} = $form->format_amount(\%myconfig, $form->{amount}, 2, "&nbsp;");
 print qq|<tr >

  <td><hr noshade size=2> &nbsp;</td>
   <td><hr noshade size=2> <b>Total</b></td>
  <td align=right><hr noshade size=2><b><input type=hidden name=fulltotal value=$fulltotal>$form->{amount}</b></td>
 <td><hr noshade size=2> &nbsp;</td>

</tr>

<tr >

  <td colspan=4 align=right> <br><br><b>Computer generated Payment Voucher <br> No Signature required</b></td>

</tr>
|;
  &form_footer_print;

}

sub form_row {
  my $i = shift;

$form->{"lasttotal_$i"} = $form->{"total_$i"} if $form->{"lasttotal_$i"} eq "";

$form->{"total_$i"} = $form->format_amount(\%myconfig, $form->{"total_$i"}, 2);
$form->{"amount1_$i"} = $form->format_amount(\%myconfig, $form->{"amount1_$i"}, 2);
$form->{"due_$i"} = $form->format_amount(\%myconfig, $form->{"due_$i"}, 2,"0.00");

  print qq|<tr>
  <td>$i) $form->{"ap_date_$i"} <input type=hidden name=ap_date_$i value=$form->{"ap_date_$i"}>
  <input type=hidden name=ap_id_$i value=$form->{"ap_id_$i"}>
  <input type=hidden name=description_$i value=$form->{"description_$i"}>
  </td>
  <td><input type=hidden name="invoice_$i" size=10 value="$form->{"invoice_$i"}">$form->{"invoice_$i"}</td>
  <td align =right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="total_$i" size=10 value="$form->{"total_$i"}"></td>
  <td align =right>$form->{"amount1_$i"}</td>
  <td align =right>$form->{"due_$i"}</td>
  <td align=center><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="status_$i" type=hidden value='$form->{"status_$i"}'>$form->{"status_$i"}</td>

</tr>
<input type=hidden name=rowcount value=$i>
<input type=hidden name=amount1_$i value=$form->{"amount1_$i"}>
<input type=hidden name=due_$i value=$form->{"due_$i"}>
<input type=hidden name=lasttotal_$i value=$form->{"lasttotal_$i"}>

|;


}


sub form_header {
   my $chart;
   my $vendor;

    payment->get_chart(\%myconfig, \%$form);

  #EXCHANGE RATE	
  foreach $item (qw( currency)) {
    $form->{"select$item"} =~ s/ selected//;
    $form->{"select$item"} =~ s/option>\Q$form->{$item}\E/option selected>$form->{$item}/;
  }

  $form->{exchangerate} = $form->format_amount(\%myconfig, $form->{exchangerate});

  $exchangerate = qq|&nbsp;|;
  if ($form->{currency} ne $form->{defaultcurrency}) {
    if ($form->{forex}) {
      $exchangerate = qq|<input type=hidden name=exchangerate value=$form->{exchangerate}>$form->{exchangerate}|;
    } else {
      $exchangerate = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=exchangerate size=10 value=$form->{exchangerate}>|;
    }
  }
  $exchangerate .= qq|
<input type=hidden name=forex value=$form->{forex}>
|;


#  foreach $item (split /\n/, $form->{chart}) {
#    ($key, $value) = split /--/, $item;
#  ($key1, $value1) = split /--/, $form->{"chart_key"};

#		if ($key eq $key1) {
 #     			$chart .= "<option selected>$key--$value\n";
#
 #  		} else {
#			if($form->{"chart"} eq ''){
#					$chart .= "<option>$key--$value\n";
#			}else{
#					$chart .= "<option>$key--$value\n";
#				}
#		}
 # }
 $form->{"chart"} =~ s/option>\Q$form->{chart_key}\E/option selected>$form->{chart_key}/;
 $form->{"vendor"} =~ s/option>\Q$form->{vendor_key}\E/option selected>$form->{vendor_key}/;

   


  $title = $form->{title};
  $form->{title} = $locale->text("$title Payment Voucher");

# $locale->text('Add General Ledger Transaction')
# $locale->text('Edit General Ledger Transaction')

  map { $form->{$_} =~ s/"/&quot;/g } qw(source description chart);

  #if (($rows = $form->numtextrows($form->{description}, 50)) > 1) {
 #   $description = qq|<textarea name=description rows=$rows cols=50 wrap=soft>$form->{description}</textarea>|;
 # } else {
#    $description = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=description size=50 value="$form->{description}">|;
 # }


  $colspan = 6;


  $form->header;
  $form->{title1}=qq|$form->{title} [ Payment No : $form->{pyid}, Vendor : $form->{vendor_key}, Date : $form->{transdate} ]|;

  print qq|
<script>
<!--

function stb(){
         parent.document.title ="$form->{title1};document.myform.$form->{nextfocus}.focus();";
}


// -->
</script>


<body bgcolor=ffffff onLoad=stb()>

<form  name=myform method=post action=$form->{script}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=id type=hidden value=$form->{id}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=chart type=hidden value="$form->{chart}">
<input type=hidden name=closedto value=$form->{closedto}>
<input type=hidden name=locked value=$form->{locked}>
<input type=hidden name=title value="$title">
<input type=hidden name=sort value="invnumber">
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=keys >

<table border=1 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>
<table border=0>
<tr>

  <th align=right>|.$locale->text('Trans No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transtype size=4 value="$form->{transtype}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=batch size=6 value="$form->{batch}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transno  size=4 value="$form->{transno}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subtransno size=2 value="$form->{subtransno}"></td>

</tr>
<tr>
  <th align=right>|.$locale->text('Vendor Acc NO.').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendor >$form->{vendor}</select></td>
  <th align=right>|.$locale->text('Date').qq| ($myconfig{dateformat})</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdate size=11 value=$form->{transdate}>
             <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].transdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    
  </td>
  
  </tr>

<tr>

  <th align=right>|.$locale->text('Voucher No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=pyid value="$form->{pyid}"></td>
  
  <th>Last Payment No : $form->{lastinvnumber}<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=lastinvnumber  type=hidden value="$form->{lastinvnumber}"></th>


</tr>

<tr>
  <th align=right>|.$locale->text('Cheque No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=source value="$form->{source}"></td>

  <th align=right>|.$locale->text('Payment Acc No.').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=chart_key>$form->{"chart"}</select></td>
</tr>

<tr>

  <th align=right>|.$locale->text('Amount').qq|</th>
  <td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=amount value="$form->{amount}"></td>


  <th align=right>|.$locale->text('Currency').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=currency>$form->{selectcurrency}</select></td>
  <th align=right>|.$locale->text('Exchangerate').qq|</th>
  <td>$exchangerate</td>

  <input type=hidden name=selectcurrency value="$form->{selectcurrency}">
  <input type=hidden name=defaultcurrency value=$form->{defaultcurrency}>
  <input type=hidden name=fxgain_accno value=$form->{fxgain_accno}>
  <input type=hidden name=fxloss_accno value=$form->{fxloss_accno}>
</tr>

</table>
</td></tr>

<tr class=listheading bgcolor=336666>

  <th><font color=ffffff>|.$locale->text('Date').qq|</th>
  <th><font color=ffffff>|.$locale->text('Invoice').qq|</th>
  <th><font color=ffffff>|.$locale->text('Total').qq|</th>
  <th><font color=ffffff>|.$locale->text('Amount').qq|</th>
  <th><font color=ffffff>|.$locale->text('Due').qq|</th>
  <th><font color=ffffff>|.$locale->text('Status').qq|</th>

</tr>
|;

}


sub form_footer {

  print qq|

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=action value='Update'>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

</table>

<br>
|;

  $transdate = $form->datetonum($form->{transdate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);

  if ($form->{id}) {
    print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
|;

    if (!$form->{revtrans}) {
      if (!$form->{locked}) {
	print qq|
	    <input class=submit type=submit name=action value="|.$locale->text('Save').qq|">

	<input class=submit type=submit name=action value="|.$locale->text('Delete').qq|">
|;
      }
    }

    if ($transdate > $closedto) {
      print qq|
      
|;
    }

  } else {
    if ($transdate > $closedto) {
      print qq|<input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
 <input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
     <input class=submit type=submit name=action value="|.$locale->text('Save').qq|">|;
    }
  }

  print "</form>

</body>
</html>
";

}


sub save {

  # check if there is something in source and date
   $form->isblank("pyid", $locale->text('Voucher Number missing!'));
 $form->isblank("source", $locale->text('Cheque Number missing!'));
  $form->isblank("transdate", $locale->text('Transaction Date missing!'));
  $form->isblank("amount", $locale->text('Amount missing!'));

  $transdate = $form->datetonum($form->{transdate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  
#$form->error($fulltotal);
$fulltotal =$form->parse_amount($myconfig, $form->{fulltotal});
$amounttotal =$form->parse_amount($myconfig, $form->{amount});

  if ($fulltotal ne $amounttotal) {
    $form->error($locale->text("Amount and the total is different!"));
  }

 # this is just for the wise guys
  $form->error($locale->text('Cannot post transaction for a closed period!')) if ($transdate <= $closedto);
if($form->{id}){
payment->delete_receipt(\%myconfig, \%$form);

}
  $rc = payment->add(\%myconfig, \%$form);

    if ($rc == -1) {
    $form->error($locale->text("Amount and the total is different!"));
  }

  if ($rc == -2) {
    $form->error($locale->text("Debit and credit out of balance!"));
  }
  $form->header;
	print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

	print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Do you want to create another Payment?').qq|</h4>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes New Payment').qq|">

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

</form>
|;
  #$form->isposted($rc);

}


sub yes_new_payment {

 &add();

}
sub more{
  @columns = qw(sr id transno transdate pyid  vendor source curr amount employee ) if ($form->{nextsub} eq "searchall");;
 @columns = qw(sr id transno transdate pyid  invnumber vendornumber name source  chart_id description curr amount employee subtotal) if ($form->{nextsub} eq "searchall2");
    map { $form->{"l_$_"} = "checked" if $form->{"l_$_"} eq "Y" } @columns;

 &search  if ($form->{nextsub} eq "searchall");
 &search2  if ($form->{nextsub} eq "searchall2");
}

####the below function is tobe deleted
sub search {
   $form->{datefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};

  $form->{title} = $locale->text('Payment Voucher')." ".$locale->text('Reports');

  $form->header;
 $form->all_vc(\%myconfig, "vendor");

  $selection = "<option selected>" . $locale->text('All Vendors') . "\n";

  foreach $ref (@{ $form->{all_customer} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }


  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<input type=hidden name=sort value=pyid>
<input type=hidden name=add value=1>
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>
<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendor>$selection</select></td>
</tr>


<tr>

  <th align=right>|.$locale->text('P/V No.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=pyid size=11 value=$form->{pyid}></td>

</tr>


<tr>

  <th align=right>|.$locale->text('Source.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=source size=11 value=$form->{source}></td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|<br></th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=datefrom size=11  title=($myconfig{dateformat}) value=$form->{datefrom}><link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script></td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=dateto size=11 title=($myconfig{dateformat})>   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar2Callback(date, month, year)
        {
            document.forms['search'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar2Callback', 'javascript/images/');
    //-->
    </script></td>

</tr>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>

      <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=checkbox value=Y $form->{l_sr}>&nbsp;|.$locale->text('SR').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=checkbox value=Y $form->{l_id}>&nbsp;|.$locale->text('ID').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transno" class=checkbox type=checkbox value=Y $form->{l_transno}>&nbsp;|.$locale->text('Transno').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=checkbox value=Y $form->{l_transdate}>&nbsp;|.$locale->text('Date').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_pyid" class=checkbox type=checkbox value=Y $form->{l_pyid}>&nbsp;|.$locale->text('P/V No').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_vendor" class=checkbox type=checkbox value=Y $form->{l_vendor}>&nbsp;|.$locale->text('Vendor').qq|<br>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_source" class=checkbox type=checkbox value=Y $form->{l_source}>&nbsp;|.$locale->text('Source').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_curr" class=checkbox type=checkbox value=Y $form->{l_curr}>&nbsp;|.$locale->text('Currency').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=checkbox value=Y $form->{l_amount}>&nbsp;|.$locale->text('Amount').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_employee" class=checkbox type=checkbox value=Y $form->{l_employee}>&nbsp;|.$locale->text('Employee').qq|

    
    </td>

  </tr>


</table>
</td>

</tr>
</table>

<input type=hidden name=nextsub value=searchall>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}

sub search_short {
   $form->{datefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};

  $form->{title} = $locale->text('Payment Voucher')." ".$locale->text('Reports');

  $form->header;
 $form->all_vc(\%myconfig, "vendor");

  $selection = "<option selected>" . $locale->text('All Vendors') . "\n";

  foreach $ref (@{ $form->{all_customer} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }


  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<input type=hidden name=sort value=pyid>
<input type=hidden name=add value=1>
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>
<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendor>$selection</select></td>
</tr>


<tr>

  <th align=right>|.$locale->text('P/V No.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=pyid size=11 value=$form->{pyid}></td>

</tr>


<tr>

  <th align=right>|.$locale->text('Source.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=source size=11 value=$form->{source}></td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|<br></th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=datefrom size=11  title=($myconfig{dateformat}) value=$form->{datefrom}><link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script></td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=dateto size=11 title=($myconfig{dateformat})>   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar2Callback(date, month, year)
        {
            document.forms['search'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar2Callback', 'javascript/images/');
    //-->
    </script></td>

</tr>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>

|;
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=hidden value=Y $form->{l_sr}>&nbsp;| if $form->{l_sr};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=hidden value=Y $form->{l_id}>&nbsp;| if $form->{l_id};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transno" class=checkbox type=hidden value=Y $form->{l_transno}>&nbsp;| if $form->{l_transno};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=hidden value=Y $form->{l_transdate}>&nbsp;| if $form->{l_transdate};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_pyid" class=checkbox type=hidden value=Y $form->{l_pyid}>&nbsp;| if $form->{l_pyid};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_vendor" class=checkbox type=hidden value=Y $form->{l_vendor}>&nbsp;| if $form->{l_vendor};
 print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_source" class=checkbox type=hidden value=Y $form->{l_source}>&nbsp;| if $form->{l_source};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_curr" class=checkbox type=hidden value=Y $form->{l_curr}>&nbsp;| if $form->{l_curr};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=hidden value=Y $form->{l_amount}>&nbsp;| if $form->{l_amount};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_employee" class=checkbox type=hidden value=Y $form->{l_employee}>&nbsp;| if $form->{l_employee};

print qq|

    
    </td>

  </tr>


</table>
</td>

</tr>
</table>

<input type=hidden name=nextsub value=searchall>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('More').qq|">
</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}

sub continue{
 &generate_report;
}
sub search2 {
  $form->{datefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};
       payment->get_chart(\%myconfig, \%$form);
$form->{chart}="<option>--All Payment--". $form->{chart};

  #  $form->{datefrom} =$form->current_date(\%myconfig) if $form->{currentdate};

  $form->{title} = $locale->text('Payment Voucher')." ".$locale->text('Reports');

  $form->header;
 $form->all_vc(\%myconfig, "vendor");

  $selection = "<option selected>" . $locale->text('All Vendors') . "\n";

  foreach $ref (@{ $form->{all_customer} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }


  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<input type=hidden name=sort value=pyid>
<input type=hidden name=add value=1>
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>
<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendor>$selection</select></td>
</tr>


<tr>

  <th align=right>|.$locale->text('P/V No.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=pyid size=11 value=$form->{pyid}></td>

</tr>


<tr>

  <th align=right>|.$locale->text('Source.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=source size=11 value=$form->{source}></td>

</tr>
<tr>
  <th align=right>|.$locale->text('Payment Acc No.').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=chart_key>$form->{chart}</select></td>
</tr>

<tr>

<th align=right>|.$locale->text('From').qq|<br></th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=datefrom size=11 title=($myconfig{dateformat}) value=$form->{datefrom}>
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=dateto size=11  title=($myconfig{dateformat})>
<script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar2Callback(date, month, year)
        {
            document.forms['search'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar2Callback', 'javascript/images/');
    //-->
    </script>
    </td>

</tr>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>

    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=checkbox value=Y $form->{l_sr}>&nbsp;|.$locale->text('SR').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=checkbox value=Y $form->{l_id}>&nbsp;|.$locale->text('ID').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transno" class=checkbox type=checkbox value=Y  $form->{l_transno}>&nbsp;|.$locale->text('Transno').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=checkbox value=Y  $form->{l_transdate}>&nbsp;|.$locale->text('Date').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_pyid" class=checkbox type=checkbox value=Y  $form->{l_pyid}>&nbsp;|.$locale->text('P/V No').qq|
   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_vendornumber" class=checkbox type=checkbox value=Y  $form->{l_vendornumber}>&nbsp;|.$locale->text('Vendor No.').qq|<br>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" class=checkbox type=checkbox value=Y  $form->{l_name}>&nbsp;|.$locale->text('Vendor').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_source" class=checkbox type=checkbox value=Y  $form->{l_source}>&nbsp;|.$locale->text('Source').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_curr" class=checkbox type=checkbox value=Y  $form->{l_curr}>&nbsp;|.$locale->text('Currency').qq|
     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_chart_id" class=checkbox type=checkbox value=Y  $form->{l_chart_id}>&nbsp;|.$locale->text('Payment Account').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_description" class=checkbox type=checkbox value=Y  $form->{l_description}>&nbsp;|.$locale->text('Payment Description').qq|<br>
   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_invnumber" class=checkbox type=checkbox value=Y  $form->{l_invnumber}>&nbsp;|.$locale->text('Invoice Number').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=checkbox value=Y  $form->{l_amount}>&nbsp;|.$locale->text('Amount').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_employee" class=checkbox type=checkbox value=Y  $form->{l_employee}>&nbsp;|.$locale->text('Employee').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=checkbox value=Y  $form->{l_subtotal}>&nbsp;|.$locale->text('Subtotal').qq|


    </td>

  </tr>


</table>
</td>

</tr>
</table>

<input type=hidden name=nextsub value=searchall2>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}
sub search2_short {
  $form->{datefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};
       payment->get_chart(\%myconfig, \%$form);
$form->{chart}="<option>--All Payment--". $form->{chart};

  #  $form->{datefrom} =$form->current_date(\%myconfig) if $form->{currentdate};

  $form->{title} = $locale->text('Payment Voucher')." ".$locale->text('Reports');

  $form->header;
 $form->all_vc(\%myconfig, "vendor");

  $selection = "<option selected>" . $locale->text('All Vendors') . "\n";

  foreach $ref (@{ $form->{all_customer} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }


  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<input type=hidden name=sort value=pyid>
<input type=hidden name=add value=1>
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>
<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendor>$selection</select></td>
</tr>


<tr>

  <th align=right>|.$locale->text('P/V No.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=pyid size=11 value=$form->{pyid}></td>

</tr>


<tr>

  <th align=right>|.$locale->text('Source.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=source size=11 value=$form->{source}></td>

</tr>
<tr>
  <th align=right>|.$locale->text('Payment Acc No.').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=chart_key>$form->{chart}</select></td>
</tr>

<tr>

<th align=right>|.$locale->text('From').qq|<br></th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=datefrom size=11 title=($myconfig{dateformat}) value=$form->{datefrom}>
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=dateto size=11  title=($myconfig{dateformat})>
<script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar2Callback(date, month, year)
        {
            document.forms['search'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar2Callback', 'javascript/images/');
    //-->
    </script>
    </td>

</tr>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
|;

print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=hidden value=Y $form->{l_sr}>&nbsp;| if $form->{l_sr};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=hidden value=Y $form->{l_id}>&nbsp;| if $form->{l_id};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transno" class=checkbox type=hidden value=Y  $form->{l_transno}>&nbsp;| if $form->{l_transno};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=hidden value=Y  $form->{l_transdate}>&nbsp;| if $form->{l_transdate};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_pyid" class=checkbox type=hidden value=Y  $form->{l_pyid}>&nbsp;| if $form->{l_pyid};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_vendornumber" class=checkbox type=hidden value=Y  $form->{l_vendornumber}>&nbsp;| if $form->{l_vendornumber};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" class=checkbox type=hidden value=Y  $form->{l_name}>&nbsp;| if $form->{l_name};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_source" class=checkbox type=hidden value=Y  $form->{l_source}>&nbsp;| if $form->{l_source};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_curr" class=checkbox type=hidden value=Y  $form->{l_curr}>&nbsp;| if $form->{l_curr};
print qq|     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_chart_id" class=checkbox type=hidden value=Y  $form->{l_chart_id}>&nbsp;| if $form->{l_chart_id};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_description" class=checkbox type=hidden value=Y  $form->{l_description}>&nbsp;| if $form->{l_description};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_invnumber" class=checkbox type=hidden value=Y  $form->{l_invnumber}>&nbsp;| if $form->{l_invnumber};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=hidden value=Y  $form->{l_amount}>&nbsp;| if $form->{l_amount};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_employee" class=checkbox type=hidden value=Y  $form->{l_employee}>&nbsp;| if $form->{l_employee};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=hidden value=Y  $form->{l_subtotal}>&nbsp;| if $form->{l_subtotal};

print qq|


    </td>

  </tr>


</table>
</td>

</tr>
</table>

<input type=hidden name=nextsub value=searchall2>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('More').qq|">
</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}


sub searchall {

     $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
    
  $callback = "$form->{script}?action=searchall&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";


  $form->{title} = $locale->text('List of Payment Voucher');

  unless ($form->{category} eq 'X') {
    $form->{title} .= " : ".$locale->text($acctype{$form->{category}});
  }

  ($vendor, $form->{vendor_id}) = split(/--/, $form->{vendor});
  if ($form->{vendor_id}) {
    $callback .= "&vendor=$form->{vendor}";
    $option .= $vendor;
  }
  
  
  if ($form->{pyid}) {
    $callback .= "&oyid=$form->{pyid}";
    $option .= "\n<br>" if $option;
  #  $option .= $locale->text('debit')." : $form->{debit} $form->{debit}";
  }
  if ($form->{source}) {
    $callback .= "&source=$form->{source}";
    $option .= "\n<br>" if $option;
   # $option .= $locale->text('credit')." : $form->{credit} $form->{credit}";
  }
  
    if ($form->{datefrom}) {
    $callback .= "&datefrom=$form->{datefrom}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('From')." ".$locale->date(\%myconfig, $form->{datefrom}, 1);
  }
  if ($form->{dateto}) {
    $callback .= "&dateto=$form->{dateto}";
    if ($form->{datefrom}) {
      $option .= " ";
    } else {
      $option .= "\n<br>" if $option;
    }
    $option .= $locale->text('To')." ".$locale->date(\%myconfig, $form->{dateto}, 1);
  }

  
 payment->list_transactions(\%myconfig, \%$form);

 @columns = $form->sort_columns(qw(id transno transdate pyid  vendor source curr amount employee ));
  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }
  @columns = $form->sort_columns(pyid );
   if ($form->{"l_sr"} eq "Y") {
      unshift (@column_index, "sr") ;

      # add column to callback
      $callback .= "&l_sr=Y";
     $href .= "&l_sr=Y";
  }



  $href = "$callback&sort=$form->{sort}";        # needed for accno


  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }

  $callback .= "&category=$form->{category}";
  $href .= "&category=$form->{category}";

  $column_header{sr} = "<th><font color=ffffff>".$locale->text('SR')."</a></th>";
   $column_header{id} = "<th><a class=listheading href=$callback&sort=id><font color=ffffff>".$locale->text('ID')."</a></th>";
  $column_header{transno} = "<th><a class=listheading href=$callback&sort=transdate><font color=ffffff>".$locale->text('Trans. No.')."</a></th>";
  $column_header{transdate} = "<th><a class=listheading href=$callback&sort=transdate><font color=ffffff>".$locale->text('Date')."</a></th>";
  $column_header{pyid} = "<th><a class=listheading href=$callback&sort=pyid><font color=ffffff>".$locale->text('P/V No')."</a></th>";
  #$column_header{customer} = "<th><a class=listheading href=$callback&sort=customer><font color=ffffff>".$locale->text('Customer')."</a></th>";
  $column_header{source} = "<th><a class=listheading href=$callback&sort=source><font color=ffffff>".$locale->text('Source')."</a></th>";
 $column_header{vendor} = "<th><font color=ffffff>".$locale->text('Vendor')."</th>";
 $column_header{curr} = "<th><font color=ffffff>".$locale->text('Currency')."</th>";
 $column_header{amount} = "<th><font color=ffffff>".$locale->text('Amount')."</th>";
  $column_header{employee} = "<th><a class=listheading href=$callback&sort=employee><font color=ffffff>".$locale->text('Employee')."</a></th>";
  $colspan = $#column_index + 1;

  $form->header;
	    $option ='' if(!$form->{l_option})  ;

  print  qq|
 <body bgcolor=ffffff>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$option</td></tr>

<tr class=listheading bgcolor=336666>
|;

map { print  "$column_header{$_}\n" } @column_index;

print  "</tr>";

  # add sort to callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  # initial item for subtotals
  if (@{ $form->{GL} }) {
    $sameitem = $form->{GL}->[0]->{$form->{sort}};
  }

  foreach $ref (@{ $form->{report} }) {
    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
      }
    }


    $customer =$ref->{vendornumber}."--".$ref->{vendor_id};

    $column_data{id} = "<td><a href=payment.pl?action=edit&sort=transdate&id=$ref->{id}&source=".$form->escape($ref->{source})."&vendorno=".$form->escape($customer)."&l_transdate=Y&l_invnumber=Y&l_amount=Y&l_subtotal1=Y&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{id}</a></td>";
    $column_data{pyid} = "<td><a href=payment.pl?action=edit&sort=transdate&id=$ref->{id}&source=".$form->escape($ref->{source})."&vendorno=".$form->escape($customer)."&l_transdate=Y&l_invnumber=Y&l_amount=Y&l_subtotal1=Y&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{pyid}</a></td>";
  # #  $column_data{customer} = "<td>$ref->{customer}</td>";
    $column_data{transno} = "<td>$ref->{transtype}-$ref->{batch}-$ref->{transno}$ref->{subtransno}</td>";
    $column_data{transdate} = "<td>$ref->{transdate}</td>";
    $column_data{source} = "<td>$ref->{source}</td>";
      $column_data{vendor} = "<td>$ref->{name}</td>";
    $column_data{curr} = "<td>$ref->{curr}</td>";
     $column_data{amount} = "<td>$ref->{amount}</td>";
   $column_data{employee} = "<td>$ref->{employee}</td>";

    $i++; $i %= 2;$j++;
   $column_data{sr} = "<td>$j</td>";
    print  "<tr class=listrow$i $mouseaction[$i] >";
    map { print "$column_data{$_}\n" } @column_index;
    print  "</tr>";

  }




  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;


  print  qq|
<tr class=listtotal bgcolor=000000>|;

  map { print  "$column_data{$_}\n" } @column_index;

  print  qq|</tr>
 </table>

<p>
|
.$locale->text('Click on "Receipt" to edit Transaction')
.qq|
<br>


</body>
</html>
|;

}
sub pagetableheader {

print qq|
<tr $listheading >|;

if($form->{l_sr}){
	print "<th $listprint>$line".$locale->text('SR')."$line</th>";
}
  map { print "\n$column_header{$_}" } @column_index;

  print qq|
  </tr>
|;


}

sub sortheading {
 	print qq|<tr>
	<td $listprint colspan=$colspan><br><b>$column_title{"$form->{sort}"} :</b>$ref->{"$form->{sort}"}
|;
if($form->{sort} eq "vendornumber"){
 	  print qq|
	  	&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{name} :</b>$ref->{name}|;
  }

if($form->{sort} eq "chart_id"){
 	  print qq|
	  	&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{description} :</b>$ref->{description}|;
  }
  
  if($form->{sort} eq "pyid"){
 	  print qq|
	  	&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{name} :</b>$ref->{name}&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{transdate} :</b>$ref->{transdate}&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{source} :</b>$ref->{source}|;
  }
 	print qq|
	</td>
	</tr>
|;

	
}

sub searchall2 {

     $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
    
  $callback = "$form->{script}?action=searchall2&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";


  $form->{title} = $locale->text('List of Payment Voucher');

  unless ($form->{category} eq 'X') {
    $form->{title} .= " : ".$locale->text($acctype{$form->{category}});
  }

  ($vendor, $form->{vendor_id}) = split(/--/, $form->{vendor});
  if ($form->{vendor_id}) {
    $callback .= "&vendor=$form->{vendor}";
    $option .= $vendor;
  }
   ( $form->{payment_id},$payment) = split(/--/, $form->{chart_key});
   
   $form->{chart_key}=$form->escape("$form->{chart_key}");
  if ($form->{payment_id}) {
    $callback .= "&chart_key=$form->{chart_key}";
    $option .= $payment;
  }
  

  
  if ($form->{pyid}) {
    $callback .= "&pyid=$form->{pyid}";
    $option .= "\n<br>" if $option;
  #  $option .= $locale->text('debit')." : $form->{debit} $form->{debit}";
  }
  if ($form->{source}) {
    $callback .= "&source=$form->{source}";
    $option .= "\n<br>" if $option;
   # $option .= $locale->text('credit')." : $form->{credit} $form->{credit}";
  }
  
    if ($form->{datefrom}) {
    $callback .= "&datefrom=$form->{datefrom}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('From')." ".$locale->date(\%myconfig, $form->{datefrom}, 1);
  }
  if ($form->{dateto}) {
    $callback .= "&dateto=$form->{dateto}";
    if ($form->{datefrom}) {
      $option .= " ";
    } else {
      $option .= "\n<br>" if $option;
    }
    $option .= $locale->text('To')." ".$locale->date(\%myconfig, $form->{dateto}, 1);
  }

  
 payment->list_transactions2(\%myconfig, \%$form);

 @columns = $form->sort_columns(qw(id transno transdate pyid  vendornumber  name source invnumber chart_id description  curr amount employee ));
  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }
  @columns = $form->sort_columns(pyid );


  $href = "$callback&sort=$form->{sort}";        # needed for accno


  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
    
      if($form->{sort} eq "vendornumber"){
  @column_index = grep !/name/, @column_index;	  
  }
   if ($form->{"l_sr"} eq "Y") {
      unshift (@column_index, "sr") ;

      # add column to callback
      $callback .= "&l_sr=Y";
     $href .= "&l_sr=Y";
  }


    if($form->{sort} eq "chart_id"){
  @column_index = grep !/description/, @column_index;	  
  }
    if($form->{sort} eq "pyid"){
  @column_index = grep !/vendornumber/, @column_index;	  
  @column_index = grep !/name/, @column_index;	  
  @column_index = grep !/source/, @column_index;	  
  }

  }

  $callback .= "&category=$form->{category}";
  $href .= "&category=$form->{category}";

   $column_title{sr} = 	    $locale->text('SR');
   $column_title{id} = 	    $locale->text('ID');
  $column_title{transno} = 	    $locale->text('Trans. No.');
   $column_title{transdate} = 	    $locale->text('Date');
  $column_title{pyid} = 	    $locale->text('Pay No');
  $column_title{source} = 	    $locale->text('Source');
  $column_title{invnumber} = 	    $locale->text('Invoice');
  $column_title{chart_id} = 	    $locale->text('P/Acc');
  $column_title{description} = 	    $locale->text('P/Desc');
  $column_title{vendornumber} = 	    $locale->text('Vendor No.');
  $column_title{name} = 	    $locale->text('Vendor');
  $column_title{curr} = 	    $locale->text('Curr');
  $column_title{amount} = 	    $locale->text('Amount');
  $column_title{employee} = 	    $locale->text('Employee');

  
 $column_header{sr} = "<th><font color=ffffff>$column_title{sr}</a></th>";
   $column_header{id} = "<th><a class=listheading href=$callback&sort=id><font color=ffffff>$column_title{id}</a></th>";
  $column_header{transno} = "<th><a class=listheading href=$callback&sort=transdate><font color=ffffff>$column_title{transno}</a></th>";
  $column_header{transdate} = "<th><a class=listheading href=$callback&sort=transdate><font color=ffffff>$column_title{transdate}</a></th>";
  $column_header{pyid} = "<th><a class=listheading href=$callback&sort=pyid><font color=ffffff>$column_title{pyid}</a></th>";
  $column_header{source} = "<th><a class=listheading href=$callback&sort=pyid><font color=ffffff>$column_title{source}</a></th>";
 $column_header{vendornumber} = "<th><a class=listheading href=$callback&sort=vendornumber><font color=ffffff>$column_title{vendornumber}</a></th>";
 $column_header{name} = "<th><font color=ffffff>$column_title{name}</th>";
 $column_header{invnumber} = "<th><font color=ffffff>$column_title{invnumber}</th>";
 $column_header{chart_id} = "<th><font color=ffffff><a class=listheading href=$callback&sort=chart_id>$column_title{chart_id}</th>";
 $column_header{description} = "<th><font color=ffffff>$column_title{description}</th>";
 $column_header{curr} = "<th><font color=ffffff>$column_title{curr}</th>";
 $column_header{amount} = "<th><font color=ffffff>$column_title{amount}</th>";
  $column_header{employee} = "<th><a class=listheading href=$callback&sort=employee><font color=ffffff>$column_title{employee}</a></th>";
  $colspan = $#column_index + 1;

  $form->header;
	    $option ='' if(!$form->{l_option})  ;

  print  qq|
 <body bgcolor=ffffff>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$option</td></tr>

<tr class=listheading bgcolor=336666>
|;

map { print  "$column_header{$_}\n" } @column_index;

print  "</tr>";

  # add sort to callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  # initial item for subtotals
  if (@{ $form->{report} }) {
    $sameitem = $form->{report}->[0]->{$form->{sort}};
  }

  foreach $ref (@{ $form->{report} }) {
    # if item ne sort print subtotal
  	  if(!$stopprintheading){
		  if ($form->{l_subtotal} eq 'Y') {
				 &sortheading;
				 
		  }
		$stopprintheading="true";
	  }
	  
    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
	&sortheading;
      }
    }
  $subtotalamount += $ref->{amount};
    $totalamount += $ref->{amount};
  $ref->{amount} = $form->format_amount(\%myconfig, $ref->{amount}, 2, "&nbsp;");
 

    $customer =$ref->{vendornumber}."--".$ref->{vendor_id};

    $column_data{id} = "<td><a href=payment.pl?action=edit&sort=transdate&id=$ref->{id}&source=".$form->escape($ref->{source})."&vendorno=".$form->escape($customer)."&l_transdate=Y&l_invnumber=Y&l_amount=Y&l_subtotal1=Y&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{id}</a></td>";
    $column_data{pyid} = "<td><a href=payment.pl?action=edit&sort=transdate&id=$ref->{id}&source=".$form->escape($ref->{source})."&vendorno=".$form->escape($customer)."&l_transdate=Y&l_invnumber=Y&l_amount=Y&l_subtotal1=Y&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{pyid}</a></td>";
  # #  $column_data{customer} = "<td>$ref->{customer}</td>";
    $column_data{transno} = "<td>$ref->{transtype}-$ref->{batch}-$ref->{transno}$ref->{subtransno}</td>";
    $column_data{transdate} = "<td>$ref->{transdate}</td>";
    $column_data{invnumber} = "<td>$ref->{invnumber}</td>";
    $column_data{source} = "<td>$ref->{source}</td>";
    $column_data{chart_id} = "<td>$ref->{chart_id}</td>";
    $column_data{description} = "<td>$ref->{description}</td>";

      $column_data{name} = "<td>$ref->{name}</td>";
    $column_data{vendornumber} = "<td>$ref->{vendornumber}</td>";
     $column_data{curr} = "<td>$ref->{curr}</td>";
     $column_data{amount} = "<td align=right>".($ref->{amount}*-1)."</td>";
   $column_data{employee} = "<td>$ref->{employee}</td>";

    $i++; $i %= 2;$j++;
   $column_data{sr} = "<td>$j</td>";
    print  "<tr class=listrow$i $mouseaction[$i] >";
    map { print "$column_data{$_}\n" } @column_index;
    print  "</tr>";

  }




  &gl_subtotal if ($form->{l_subtotal} eq 'Y');


  $totalamount*=-1;
  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;
  $column_data{amount} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."$line</th>";


  print  qq|
<tr class=listtotal bgcolor=000000>|;

  map { print  "$column_data{$_}\n" } @column_index;

  print  qq|</tr>
 </table>

<p>
|
.$locale->text('Click on "Voucher" to edit Transaction')
.qq|
<br>


</body>
</html>
|;

}


sub delete {

  $form->{title} = $locale->text('Confirm!');

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  foreach $key (keys %$form) {
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>$form->{title}</font></h2>

<h4>|.$locale->text('Are you sure you want to delete Transaction').qq| $form->{source}</h4>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Transaction').qq|">
</form>

</body>
</html>
|;

}


sub yes_delete_transaction {
#payment->delete_receipt(\%myconfig, \%$form);
  $form->isdeleted(payment->delete_receipt(\%myconfig, \%$form));

}

sub edit {

  payment->transaction(\%myconfig, \%$form);
 
 $form->create_links("AP", \%myconfig, "vendor");

  # build the popup menus

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];
  #$form->{currency} = $curr[0];

  map { $form->{selectcurrency} .= "<option>$_\n" } @curr;

  $form->{locked} = ($form->datetonum($form->{transdate}, \%myconfig) <= $form->datetonum($form->{closedto}, \%myconfig));

  $form->{title} = "Edit";
   $form->{nextfocus}="transtype";

  &form_header;

  $i = 1;
  foreach $ref (@{ $form->{GL} }) {
    $form->{"total_$i"} = $ref->{amount};
    $form->{"ap_date_$i"} = $ref->{ap_date};
    $form->{"status_$i"} = $ref->{status};
    $form->{"ap_id_$i"} = $ref->{ap_chart_id};
    $form->{"invoice_$i"} = $ref->{invnumber};
    $form->{"amount1_$i"} = $ref->{amount1};
    $form->{"due_$i"} = $ref->{due};
    $fulltotal+=$form->{"total_$i"};
    &form_row($i++);
  }

#  &form_row($i);
 $fulltotal = $form->format_amount(\%myconfig, $fulltotal, 2, "0");

 print qq|<tr class=listsubtotal bgcolor=333366>

  <td></td>
  <td></td>
  <td align=right><input type=hidden name=fulltotal value=$fulltotal>$fulltotal</td>
  <td></td>
  <td></td>
 <td></td>

</tr>


|;
  &form_footer;
}

sub gl_subtotal {
$subtotalamount*=-1;
   $subtotalamount = $form->format_amount(\%myconfig, $subtotalamount, 2, "&nbsp;");
  map { $column_data{$_} = "<td class=listsubtotal >&nbsp;</td>" } qw(sr id transno transdate pyid  vendornumber  name source invnumber chart_id description  curr  employee);
  $column_data{amount} = "<th align=right $listprint >$line$subtotalamount$line</font></td>";


  print "<tr class=listsubtotal bgcolor=333366>";
  map { print "$column_data{$_}\n" } @column_index;
  print "</tr>";

  $subtotalamount = 0;

  $sameitem = $ref->{$form->{sort}};

}

