#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Genereal Ledger
#
#======================================================================


use SL::GL;
use POSIX qw(strftime);
$form->{rowcount}=35;

1;
# end of main


# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')


sub add {

  $form->{title} = "Add";

  $form->{callback} = "$form->{script}?action=add&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&source=$form->{source}&description=$form->{description}&accno1_1=$form->{accno1_1}";


 if($form->{transdate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{transdate};
 }
  # we use this only to set a default date
  GL->transaction(\%myconfig, \%$form);

if($lastdate){
 $form->{transdate}=$lastdate;
$form->{batch}=$lastbatch;
}

  $form->{rowcount} = 1;
  &display_form;
}



sub search {
 $form->{datefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};

 # $form->{title} .= " ".$locale->text('Reports');

  $form->header;
  if(!$form->{sort}){
	  $form->{sort}="transno";
  }
  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<form method=post action=$form->{script} name=myform>

<!--input type=hidden name=sort value=transdate-->
<input type=hidden name=sort value=$form->{sort}>
<input type=hidden name=title value="$form->{title}">
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>


<tr>

  <th align=right>|.$locale->text('Ref No.').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=source size=20 value='$form->{source}'></td>

</tr>
<tr>

  <th align=right>|.$locale->text('Trans No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transtypeno  size=4 value="$form->{transtypeno}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=batchno size=6 value="$form->{batchno}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transnono  size=4 value="$form->{transnono}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subtransno  size=2 value="$form->{subtransnono}"></td>
   <th align=right>|.$locale->text('Project No.').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=projectno size=20></td>

</tr>

<tr>
 <th align=right>|.$locale->text('Sub No.').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subbno size=20></td>
</tr>
<tr>
 <th align=right>|.$locale->text('Account No.').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=accno1 size=20 value='$form->{accno1}'></td>
</tr>

<tr>

  <th align=right>|.$locale->text('From').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=datefrom size=11 title=$myconfig{dateformat} value=$form->{datefrom}>
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    
  </td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=dateto size=11  title=$myconfig{dateformat}>
    <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
   
  </td>

</tr>

<tr>

  <th align=right>|.$locale->text('Description').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=description size=50 value="$form->{description}"></td>

</tr>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<tr>
|;
#if($form->{subtitle} eq "GENERAL LEDGER"){
  print qq|<th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=X checked>&nbsp;|.$locale->text('All').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=F>&nbsp;|.$locale->text('Fixed Asset').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=A>&nbsp;|.$locale->text('Asset').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=L>&nbsp;|.$locale->text('Liability').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=Q>&nbsp;|.$locale->text('Equity').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=I>&nbsp;|.$locale->text('Income').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=E>&nbsp;|.$locale->text('Expense').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=D>&nbsp;|.$locale->text('Debtor').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=C>&nbsp;|.$locale->text('Creditor').qq|<br>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=checkbox value=Y $form->{l_sr}>&nbsp;|.$locale->text('SR').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=checkbox value=Y $form->{l_id}>&nbsp;|.$locale->text('ID').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=checkbox value=Y $form->{l_transdate}>&nbsp;|.$locale->text('Date').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_source" class=checkbox type=checkbox value=Y $form->{l_source}>&nbsp;|.$locale->text('Ref No').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_description" class=checkbox type=checkbox value=Y $form->{l_description}>&nbsp;|.$locale->text('Description').qq|<br>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_debit" class=checkbox type=checkbox value=Y $form->{l_debit}>&nbsp;|.$locale->text('Debit').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_credit" class=checkbox type=checkbox value=Y $form->{l_credit}>&nbsp;|.$locale->text('Credit').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_accno" class=checkbox type=checkbox value=Y $form->{l_accno}>&nbsp;|.$locale->text('Account').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_accdesc" class=checkbox type=checkbox value=Y $form->{l_accdesc}>&nbsp;|.$locale->text('Account Description').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_batch" class=checkbox type=checkbox value=Y $form->{l_batch}>&nbsp;|.$locale->text('Trans No.').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_project" class=checkbox type=checkbox value=Y $form->{l_project}>&nbsp;|.$locale->text('Project No.').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subb" class=checkbox type=checkbox value=Y $form->{l_subb}>&nbsp;|.$locale->text('Sub No.').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_gifi_accno" class=checkbox type=checkbox value=Y $form->{l_gifi_accno}>&nbsp;|.$locale->text('GIFI').qq|<br>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=checkbox value=Y $form->{l_amount}>&nbsp;|.$locale->text('Amount').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=checkbox value=Y $form->{l_subtotal}>&nbsp;|.$locale->text('Subtotal').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_total" class=checkbox type=checkbox value=Y $form->{l_total}>&nbsp;|.$locale->text('Total').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_grandtotal" class=checkbox type=checkbox value=Y $form->{l_grandtotal}>&nbsp;|.$locale->text('Grand Total').qq|

    </td>
  </tr>|;
#}




print qq|
</table>
</td>

</tr>
</table>
<input type=hidden name=rowcount value=$form->{rowcount}>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
<br>
</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}



sub search_short {
  $form->{datefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};

  $form->{title} .= " ".$locale->text('Reports');

  $form->header;
  if(!$form->{sort}){
	  $form->{sort}="transno";
  }
  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>
<body bgcolor=ffffff  onLoad=stb()>

<form method=post action=$form->{script} name=myform>

<!--input type=hidden name=sort value=transdate-->
<input type=hidden name=sort value=$form->{sort}>
<input type=hidden name=title value="$form->{title}">
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>


<tr>

  <th align=right>|.$locale->text('Ref No.').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=source size=20 value="$form->{source}"></td>

</tr>
<tr>
 <th align=right>|.$locale->text('Account No.').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=accno1 size=20 value="$form->{accno1}"></td>
</tr>

<tr>

  <th align=right>|.$locale->text('From').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=datefrom size=11 title=$myconfig{dateformat} value=$form->{datefrom}>
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    
  </td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=dateto size=11  title=$myconfig{dateformat}>
    <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
   
  </td>

</tr>

<tr>

  <th align=right>|.$locale->text('Description').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=description size=50 value="$form->{description}"></td>

</tr>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<tr>
|;
#if($form->{subtitle} eq "GENERAL LEDGER"){
  print qq|<th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=X checked>&nbsp;|.$locale->text('All').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=F>&nbsp;|.$locale->text('Fixed Asset').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=A>&nbsp;|.$locale->text('Asset').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=L>&nbsp;|.$locale->text('Liability').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=Q>&nbsp;|.$locale->text('Equity').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=I>&nbsp;|.$locale->text('Income').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=E>&nbsp;|.$locale->text('Expense').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=D>&nbsp;|.$locale->text('Debtor').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="category" class=radio type=radio value=C>&nbsp;|.$locale->text('Creditor').qq|<br>
|;
    
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=hidden value=Y $form->{l_sr}>&nbsp;| if $form->{l_sr};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=hidden value=Y $form->{l_id}>&nbsp;| if $form->{l_id};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=hidden value=Y $form->{l_transdate}>&nbsp;| if $form->{l_transdate};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_source" class=checkbox type=hidden value=Y $form->{l_source}>&nbsp;| if $form->{l_source};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_description" class=checkbox type=hidden value=Y $form->{l_description}>&nbsp;| if $form->{l_description};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_debit" class=checkbox type=hidden value=Y $form->{l_debit}>&nbsp;| if $form->{l_debit};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_credit" class=checkbox type=hidden value=Y $form->{l_credit}>&nbsp;| if $form->{l_credit};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_accno" class=checkbox type=hidden value=Y $form->{l_accno}>&nbsp;| if $form->{l_accno};
 print qq|       <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_accdesc" class=checkbox type=hidden value=Y $form->{l_accdesc}>&nbsp;| if $form->{l_accdesc};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_batch" class=checkbox type=hidden value=Y $form->{l_batch}>&nbsp;| if $form->{l_batch};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_project" class=checkbox type=hidden value=Y $form->{l_project}>&nbsp;| if $form->{l_project};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subb" class=checkbox type=hidden value=Y $form->{l_subb}>&nbsp;| if $form->{l_subb};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_gifi_accno" class=checkbox type=hidden value=Y $form->{l_gifi_accno}>&nbsp;| if $form->{l_gifi_accno};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=hidden value=Y $form->{l_amount}>&nbsp;| if $form->{l_amount};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=hidden value=Y $form->{l_subtotal}>&nbsp;| if $form->{l_subtotal};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_total" class=checkbox type=hidden value=Y $form->{l_total}>&nbsp;| if $form->{l_total};
print qq|        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_grandtotal" class=checkbox type=hidden value=Y $form->{l_grandtotal}>&nbsp;| if $form->{l_grandtotal};

print qq|    
    </td>
  </tr>|;
#}




print qq|
</table>
</td>

</tr>
</table>
<input type=hidden name=rowcount value=$form->{rowcount}>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
<input class=submit type=submit name=action value="|.$locale->text('More').qq|">
<br>
</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}


sub more{
 @columns = qw(sr project subb transdate  batch id  source   accno accdesc   gifi_accno debit credit amount);
    map { $form->{"l_$_"} = "checked" if $form->{"l_$_"} eq "Y" } @columns;

 &search;
}


sub print {
 $form->{print}="true";
 &continue;
}

sub continue {
	&generate_report_all;
}


sub pageheading{
  print  qq|<table border=0 width=100%>
	<tr>
		<td align=left width=10%>
		<table border=0 width=10%>
		<tr>
			<th align=left><font size=3>$dbname</font></th>
		</tr>
		<tr>
			<th align=left nowrap><font size=3>F/Y : $form->{fy}</font></th>
		</tr>
		</table>		
		<td align=center width=80%>		
		<table border=0 width=80%>
		<tr>
			<th align=center><font size=3>$form->{company}</font></th>
		</tr>
		<tr>
			<th align=center><font size=3>$form->{title}</font></th>
		</tr>
		</table>
		
		</td>
		<td align=right width=10% nowrap>PG. $pagenum</td>
	</tr>
</table>
<!--p $listprint><font size=3>$dbname</font></p>
<p $listprint><font size=3>F/Y : $form->{fy}</font></p>
<H1  $listprint  align=center><font size=4>$form->{company}<br>$form->{title}</font></H1-->
$option
|;	

#$option

}

sub pagetableheader{
  print  qq|

<table $listprint border=0 width=100%>
|;


#if($form->{print} && $form->{l_accnoheading}&& $form->{sort} eq "accno"){
 print "<tr $listprint>";
 map {$column_data{$_}="<td $listprint >&nbsp;</td>"} @column_index;
#$column_data{transdate} = "<td $listprint nowrap>A/C No.: $ref->{accno}</td>";
 #$column_data{accdesc} = "<td $listprint >A/C Name: $ref->{accdesc}</td>";
 #$column_data{credit} = "<td $listprint >GL REF : $glref</td>";
# $column_data{amount} = "<td $listprint >GL REF : $glref</td>";
#print "<td $listprint colspan=$colspan >&nbsp;</td>";
#map { print  "$column_data{$_}\n" } @column_index;

if($form->{sort} eq "accno" ){
$colspan2=$colspan-1;
if( $form->{l_subtotal}){
print qq|<tr>
	<td $listprint colspan=$colspan2><br><b>$column_title{"$form->{sort}"} :</b>$ref->{"$form->{sort}"}
|;
 	  print qq|
	  	&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{accdesc} :</b>$ref->{accdesc}|;
  	print qq|
	</td>
	<td $listprint >GL REF : $glref</td>
	</tr>
 |;
}
}else{
$colspan2=$colspan;
if( $form->{l_subtotal}){
	print qq|<tr>
	<td $listprint colspan=$colspan2><br><b>$column_title{"$form->{sort}"} :</b>$ref->{"$form->{sort}"}</td>
|;
}	
}



print  "</tr>";
	

#}



print qq|
<tr $listheading >
|;
if($form->{l_sr}){
	print "<th $listprint>".$locale->text('SR')."$line</th>";
}
map { print  "$column_header{$_}\n" } @column_index;

print  "</tr>";
	
}

sub pagefooting{
	    print "<tr $listrow$i $mouseaction[$i]  >";
	if($form->{l_sr}){
		print "<td $listprint >$line&nbsp;</td>";
	}
		
	    map { $column_data{$_} = "<td $listprint >$line&nbsp;</td>" } @column_index;
	    
	    if(!$form->{l_subtotal}){
	    $column_data{accdesc} = "<td $listprint >$line Page SubTotal C/F to page $pagenum</td>";
	    $column_data{amount} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalamount, 2, "0.00")."</td>";
	    $column_data{debit} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotaldebit , 2, "0.00") ."</td>";
	    $column_data{credit} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "0.00")."</td>";
	    }else{
	    $column_data{accdesc} = "<td $listprint >$line SubTotal C/F to page $pagenum</td>";
	    $column_data{amount} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalamount2, 2, "0.00")."</td>";
	    $column_data{debit} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotaldebit2 , 2, "0.00") ."</td>";
	    $column_data{credit} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalcredit2, 2, "0.00")."</td>";
		    
	    }
	    
 	    map { print "\n$column_data{$_}" } @column_index;
     
	     #14/10
	     ($dbname) = split /\_/, $myconfig{dbname};
	     $dbname =~ tr/a-z/A-Z/;
	     
	     #15/10 set the page number
	 #    $pagenum++;
	     
	     #16/10 show the date, time and title and the bottom
	     print qq|

	   </tr>
	</table>
	|;	
}


sub generate_report_all {
   map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr fy));
 if(!$form->{print}){
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
    $lastline=$locale->text('Click on "Ref No." to edit transaction');
     $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
     }else{
    $line = "<hr size=3 noshade>";
    $fontsize="size=2";
    $listprint="class=print";
    $listheading="class=print";
    $listtop="class=print";
    $listrow="class=print";
    $listsubtotal="class=print";
  }
  
  GL->all_transactions(\%myconfig, \%$form);

  #14/10 Change to Cheque No in BP
  $form->{transtypeno1} = $form->{transtypeno};
  $form->{transtypeno1} =~ tr/0123456789-//d;
  
   $form->{title} =~ s/ /%20/g;
   
   $callback = "$form->{script}?action=continue&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&print=$form->{print}&title=$form->{title}&nextfocus=transtype";
   $form->{title} =~ s/%20/ /g;
   
  %acctype = ( 'A' => $locale->text('Asset'),
               'L' => $locale->text('Liability'),
	       'Q' => $locale->text('Equity'),
	       'I' => $locale->text('Income'),
	       'E' => $locale->text('Expense'),
	     );

  unless ($form->{category} eq 'X') {
    $form->{title} .= " : ".$locale->text($acctype{$form->{category}});
  }
  if ($form->{accno1}) {
    $callback .= "&accno1=$form->{accno1}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Account')." : $form->{accno1} $form->{U_description}";
  }
  if ($form->{accdesc}) {
    $callback .= "&accdesc=$form->{accdesc}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Account Desc.')." : $form->{accdesc} $form->{account_description}";
  }
    if ($form->{transtypeno}) {
    $callback .= "&transtypeno=$form->{transtypeno}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Trans Type.')." : $form->{transtypeno} $form->{transtype}";
  }
  if ($form->{batchno}) {
    $callback .= "&batchno=$form->{batchno}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Batch No.')." : $form->{batchno} $form->{batch}";
  }
  if ($form->{transnono}) {
    $callback .= "&transnono=$form->{transnono}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Trans No.')." : $form->{transnono} $form->{transno}";
  }
    if ($form->{subtransnono}) {
    $callback .= "&subtransnono=$form->{subtransnono}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Sub Trans No.')." : $form->{subtransnono} $form->{subtransno}";
  }
    if ($form->{subb}) {
    $callback .= "&sub=$form->{subb}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Sub No.')." : $form->{subb} $form->{subb}";
  }
 if ($form->{project}) {
    $callback .= "&project=$form->{project}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Project No.')." : $form->{project} $form->{project}";
  }
  if ($form->{gifi_accno}) {
    $callback .= "&gifi_accno=$form->{gifi_accno}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('GIFI')." : $form->{gifi_accno} $form->{gifi_account_description}";
  }
  if ($form->{source}) {
    $callback .= "&source=".$form->escape($form->{source});
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Ref No.')." : $form->{source}";
  }
  if ($form->{description}) {
    $callback .= "&description=".$form->escape($form->{description});
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Description')." : $form->{description}";
  }
  if ($form->{datefrom}) {
    $callback .= "&datefrom=$form->{datefrom}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('From')." ".$locale->date(\%myconfig, $form->{datefrom}, 1);
  }
  if ($form->{dateto}) {
    $callback .= "&dateto=$form->{dateto}";
    if ($form->{datefrom}) {
      $option .= " ";
    } else {
      $option .= "\n<br>" if $option;
    }
    $option .= $locale->text('To')." ".$locale->date(\%myconfig, $form->{dateto}, 1);
  }
  
	$sourceheading =$locale->text('Ref No.');


  @columns = qw( project subb transdate  batch id  source   accno accdesc   gifi_accno debit credit amount);

  if ($form->{accno}) {
    @columns = grep !/accno/, @columns;
  }
  if ($form->{accdesc}) {
    @columns = grep !/accdesc/, @columns;
  } 
  if ($form->{batch}) {
    @columns = grep !/batch/, @columns;
  }
 if ($form->{subb}) {
    @columns = grep !/subb/, @columns;
  }
  if ($form->{project}) {
    @columns = grep !/project/, @columns;
  }
  if ($form->{gifi_accno}) {
    @columns = grep !/gifi_accno/, @columns;
  }

  
  
  
  $href = "$callback&sort=$form->{sort}";        # needed for accno
 
 

  
  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
    
        if($item eq "accdesc"){
	    if ($form->{"l_description"} eq "Y") {

	    @column_index = grep !/accdesc/, @column_index;
	    push @column_index, "accdesc";

	    }
    }

  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
 @column_index = grep !/$form->{sort}/, @column_index;
  
    if($form->{sort} eq "accno"){
	    $form->{l_accdesc} ="";
	    if (!$form->{l_description}){
		    @column_index = grep !/accdesc/, @column_index;
	    }
  }
 

  }

  if ($form->{l_total} eq 'Y') {
    $callback .= "&l_total=Y";
    $href .= "&l_total=Y";
  }
    if ($form->{l_description} eq 'Y') {
    $callback .= "&l_description=Y";
    $href .= "&l_description=Y";
  }
  
    if ($form->{l_sr} eq 'Y') {
    $callback .= "&l_sr=Y";
    $href .= "&l_sr=Y";
  }

    if ($form->{l_accnoheading} eq 'Y') {
    $callback .= "&l_accnoheading=Y";
    $href .= "&l_accnoheading=Y";
  }

    if ($form->{l_grandtotal} eq 'Y') {
    $callback .= "&l_grandtotal=Y";
    $href .= "&l_grandtotal=Y";
  }


  $callback .= "&category=$form->{category}";
  $href .= "&category=$form->{category}";

   $callback .= "&rowcount=$form->{rowcount}";
  $href .= "&rowcount=$form->{rowcount}";

   if (($form->{l_description} eq 'Y') && ($form->{l_accdesc} eq 'Y')) {
   	$description =$locale->text('Account Name & Description');
  }else{
     if ($form->{l_accdesc} eq 'Y') {
    	$description =$locale->text('Account Name');
     }else{
    	$description =$locale->text('Description');
	     
     }

  }

  #$column_header{sr} = "<th $listprint >".$locale->text('SR')."$line</th>";
 $column_title{id} = $locale->text('ID');
  $column_title{transdate} = $locale->text('Date');
  $column_title{source} = $sourceheading;
  #$column_header{description} = "<th $listprint ><a $listprint href=$callback&sort=description>".$locale->text('Description')."</a>$line</th>";
  $column_title{debit} = $locale->text('Debit');
  $column_title{credit} = $locale->text('Credit');
  $column_title{amount} = $locale->text('Amount');
  $column_title{accno} = $locale->text('Account');
  $column_title{accdesc} = $description;
  $column_title{batch} = $locale->text('Trans No.');
  $column_title{transtype} = $locale->text('Trans No.');
  $column_title{subb} = $locale->text('Sub No.');
  $column_title{project} = $locale->text('Project No.');
  $column_title{gifi_accno} = $locale->text('GIFI');


  $column_header{id} = "<th $listprint ><a $listprint href=$callback&sort=id>$line$column_title{id}</a>$line</th>";
  $column_header{transdate} = "<th $listprint nowrap><a $listprint href=$callback&sort=transdate>$line$column_title{transdate}</a>$line</th>";
  $column_header{source} = "<th $listprint nowrap><a $listprint href=$callback&sort=source>$line$column_title{source}</a>$line</th>";
  #$column_header{description} = "<th $listprint ><a $listprint href=$callback&sort=description>".$locale->text('Description')."</a>$line</th>";
  $column_header{debit} = "<th $listprint >$line$column_title{debit}$line</th>";
  $column_header{credit} = "<th $listprint >$line$column_title{credit}$line</th>";
  $column_header{amount} = "<th $listprint >$line$column_title{amount}$line</th>";
  $column_header{accno} = "<th $listprint nowrap><a $listprint href=$callback&sort=accno>$line$column_title{accno}</a>$line</th>";
  $column_header{accdesc} = "<th $listprint  nospan><a $listprint href=$callback&sort=accno>$line$column_title{accdesc}</a>$line</th>";
  $column_header{batch} = "<th $listprint nowrap><a $listprint href=$callback&sort=transtype>$line$column_title{batch}</a>$line</th>";
  $column_header{subb} = "<th $listprint ><a $listprint href=$callback&sort=subb>$line$column_title{subb}</a>$line</th>";
  $column_header{project} = "<th $listprint ><a $listprint href=$callback&sort=project>$line$column_title{project}</a>$line</th>";
  $column_header{gifi_accno} = "<th $listprint ><a $listprint href=$callback&sort=gifi_accno>$line$column_title{gifi_accno}</a>$line</th>";

  $colspan = $#column_index + 1;

  $form->header;  
  
  
  #14/10 determine the title in GL
  $form->{transtypeno2} = $form->{transtypeno};
  $form->{transtypeno2} =~ tr/0123456789-//d;


	  #$form->{title} .= " For Jan ".$form->{fy}." -  Dec ".$form->{fy};

  if($form->{transtypeno} eq "OB"){
  $form->{title} = $locale->text('Opening Balance as at ').$form->{datefrom};
}
  
  #15/10 set latest date and time
  $nowdate = strftime "%d%m%y", localtime;
  $nowtime = strftime "%I%M ", localtime;	
	
  #10/10 extract the db name
  ($dbname) = split /\_/, $myconfig{dbname};
  $dbname =~ tr/a-z/A-Z/;  
  
  #14/10 page number at right upper corner
  $pagenum = 1;
  $glref++;
  #14/10 move the company name and title to top of the page
  
	    $option ='' if(!$form->{l_option})  ;


  print  qq|

<body bgcolor=ffffff $listprint>

|;


  # add sort to callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  # initial item for subtotals
  if (@{ $form->{GL} }) {
    $sameitem = $form->{GL}->[0]->{$form->{sort}};
  }else{
		&pageheading;
		&pagetableheader;
  
  }

  
  foreach $ref (@{ $form->{GL} }) {
	  if(!$stopprintheading){
		&pageheading;
		&pagetableheader;
		$stopprintheading="true";
	  }

    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
	#&pageheading;
	#if($form->{print}){
	$r+=7;
	###new heading/footer for new subtotal
		#&pagefooting;

	 $glref++;
	print qq|
	</table>
	|;
	 &pagetableheader;
	#}
 
      }
    }
	
	#16/10 change the output value
	### need to update
	if($form->{transtypeno2} eq "BP" || $form->{transtypeno2} eq "CV" || $form->{transtypeno2} eq "CP"){
		$ref->{amount} = $ref->{amount}*-1;
	}
	if($ref->{amount} > 0){
		    $pagetotalamount += $ref->{amount};
	}
	if($form->{transtypeno1} eq "GJ" || $form->{transtypeno1} eq "OB"){
		$ref->{credit} *= -1;
	}
	
	if($ref->{transtype} eq "OB"){
		$total_ob+=$ref->{debit};	
	}
	
	
	
    $subtotaldebit += $ref->{debit};
    $subtotalcredit += $ref->{credit};
    $subtotalamount += $ref->{amount};

    $totaldebit += $ref->{debit};
    $totalcredit += $ref->{credit};
    $totalamount += $ref->{amount};     
    		
    $pagetotaldebit += $ref->{debit};
    $pagetotalcredit += $ref->{credit};
    
          if($ref->{description} eq ""){
	$ref->{description} = "Invoice of $ref->{source}";
#	$form->dberror($ref->{description});
      }
  
  
if (($form->{l_description} eq 'Y') && ($form->{l_accdesc} eq 'Y')) {
   	$description ="$ref->{accdesc}<br>Desc:$ref->{description}";
  }else{
     if ($form->{l_accdesc} eq 'Y') {
    	$description ="$ref->{accdesc}";
     }else{
     	$description ="$ref->{description}";
	     
     }

  }

  
  #16/10 temporary set the sequence of the OB, need to find a better way to solve this problem,
  #the code just able to solve the display problem
  if($form->{transtypeno2} eq "OB"){
	  ++$number;
	  $ref->{transno}="";
	  
  }


      $ref->{debit} = $form->format_amount(\%myconfig, $ref->{debit}, 2, "0.00");
    $ref->{credit} = $form->format_amount(\%myconfig, $ref->{credit}, 2, "0.00");
   $ref->{amount} = $form->format_amount(\%myconfig, $ref->{amount}, 2, "0.00");
      $j++;
      

  
    #$column_data{sr} = "<td $listprint><font $fontsize >$j</td>";
    $column_data{id} = "<td $listprint>$ref->{id}</td>";
    $column_data{transdate} = "<td $listprint>$ref->{transdate}</td>";
    $column_data{source} = "<td $listprint><a  $listprint href=$ref->{module}.pl?action=edit&nextfocus=transtype&id=$ref->{id}&vc=$form->{vc}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{source}</td>";
   # $column_data{description} = "<td $listprint><font $fontsize >$ref->{description}</td>";
    $column_data{debit} = "<td align=right $listprint>$ref->{debit}$ref->{debit1}</td>";
    $column_data{credit} = "<td align=right $listprint>$ref->{credit}$ref->{credit1}</td>";
    $column_data{amount} = "<td align=right $listprint>$ref->{amount}</td>";
    $column_data{accno} = "<td $listprint>$ref->{accno}</td>";
    $column_data{accdesc} = "<td width=50% $listprint>$description</td>";
    $column_data{batch} = "<td $listprint><a $listprint  href=$ref->{module}.pl?action=edit&nextfocus=transtype&id=$ref->{id}&vc=$form->{vc}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{transtype}-$ref->{batch}-$ref->{transno}$number$ref->{subtransno}</a></td>";
    $column_data{subb} = "<td $listprint>$ref->{subb}</td>";
    $column_data{project} = "<td $listprint>$ref->{project}</td>";
    $column_data{gifi_accno} = "<td $listprint>$ref->{gifi_accno}&nbsp;</td>";
   
   $currentaccno=$ref->{accno};
    $i++; $i %= 2;    $r++;$not++;$total_nat++;
    print  "<tr $listrow$i $mouseaction[$i] >";
    if($form->{l_sr}){

    	print "<td $listprint>$j</td>";
    }
    map { print "$column_data{$_}\n" } @column_index;

    print  "</tr>";
    
    #pagebreak printing
    if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){
	$pagenum++;
 $subtotaldebit2= $subtotaldebit ;
 $subtotalcredit2= $subtotalcredit ;
 $subtotalamoun2= $subtotalamount ;
	&pagefooting;
	print qq|
	 <p style="page-break-before: always">&nbsp;</p>
	 |;
	   
	 &pageheading;
	 &pagetableheader;
	print qq|
	<tr>
	|; 	 
	map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
	if(!$form->{l_subtotal}){
	     $column_data{accdesc} = "<td $listprint >***Subtotal B/F for Page $pagenum </td>";
	     $column_data{amount} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalamount, 2, "0.00")."</td>";
	    $column_data{debit} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotaldebit , 2, "0.00") . "</td>";
	    $column_data{credit} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "0.00") . "</td>";
	}else{
	     $column_data{accdesc} = "<td $listprint >***Subtotal B/F for Page $pagenum </td>";
	     $column_data{amount} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $subtotalamount2, 2, "0.00")."</td>";
	    $column_data{debit} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $subtotaldebit2 , 2, "0.00") . "</td>";
	    $column_data{credit} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $subtotalcredit2, 2, "0.00") . "</td>";
		
	}
	map { print "\n$column_data{$_}" } @column_index;
	print qq|
	</tr>
	|;
	$r=0;

}

  }

  &gl_subtotal if ($form->{l_subtotal} eq 'Y');
  
  
  #14/10 Change the text
  $subtotalheading =$locale->text('Total For').$form->{transtypeno}."-".$form->{batchno}."&nbsp;&nbsp;";

  map { $column_data{$_} = "<td $listprint>&nbsp;</td>" } @column_index;

  $column_data{accdesc} = "<th $listprint align=right>".$subtotalheading."</th>";
  $column_data{debit} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $totaldebit, 2, "0.00")."$line</th>";
  $column_data{credit} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $totalcredit, 2, "0.00")."$line</th>";
  $column_data{amount} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalamount, 2, "0.00")."$line</th>";

  if($lastline2 eq 'Y' ){
	$lastline = "<p align=right>".$locale->text('Total for BAT NO. ').$form->{transtypeno}."-".$form->{batchno}."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."</p><br>".$lastline;
  }

  if($form->{l_total} eq 'Y'){
	  print  qq|
	  <tr $listtotal >|;
    
    	if($form->{l_sr}){
    	print "<td $listprint>&nbsp;</td>";
    }

    	map { print  "$column_data{$_}\n" } @column_index;
	print  qq|</tr>|;
  }
	
	
	 #FIlnal Grand TOtal
  $subtotalheading =$locale->text('***GRAND TOTAL');
  $subtotalheading.="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; DR: ".$form->format_amount(\%myconfig, $totaldebit-$total_ob, 2, "0.00")." &nbsp;&nbsp; CR: ".$form->format_amount(\%myconfig, $totalcredit-$total_ob, 2, "0.00")."";

  map { $column_data{$_} = "<td $listprint>&nbsp;</td>" } @column_index;

  $column_data{transdate} = "<th $listprint align=right>".$locale->text('TOTAL N.O.T.:')."$total_nat</th>";
  $column_data{accdesc} = "<th $listprint align=center>$line".$subtotalheading."$line</th>";
#  $column_data{debit} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $totaldebit-$total_ob, 2, "&nbsp;")."$line</th>";
#  $column_data{credit} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $totalcredit-$total_ob, 2, "&nbsp;")."$line</th>";
 
  if($lastline2 eq 'Y' ){
	$lastline = "<p align=right>".$locale->text('Total for BAT NO. ').$form->{transtypeno}."-".$form->{batchno}."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."</p><br>".$lastline;
  }

  if($form->{l_grandtotal} eq 'Y'){
	  print  qq|
	  <tr $listtotal>|;
    
    	if($form->{l_sr}){
    	print "<td $listprint>&nbsp;</td>";
    }

    	map { print  "$column_data{$_}\n" } @column_index;
	print  qq|</tr>|;
  }

 
 #19/10 push the $nowdate, $nowtime to the bottom
 # if($pushrow eq 'T'){
 #	 $countrow = $r+2;
  #
  #	if($countrow == 23){
 #		$addrows = "<tr><td>&nbsp;</td></tr>\n<tr><td>&nbsp;</td></tr>";
 #	}
 #	elsif($countrow < 23){
 #		$temp = $form->{rowcount}-$countrow;
 #		$temp =  $temp * 2 + 2;	 
 #		for($i=0; $i<=$temp; $i++){
 #			$addrows .= "<tr><td>&nbsp;</td></tr>\n";
 #		}
 #	}
  #}
  #elsif($pushrow eq 'F'){
 #	 $countrow = $r+2;
	 
 
 # 	if($countrow == 45){
 #		$addrows = "<tr><td>&nbsp;</td></tr>\n<tr><td>&nbsp;</td></tr>";
 #	}
 #	elsif($countrow < 45){
 #		$temp = $form->{rowcount}-$countrow-2;
		#$temp =  $temp * 2 + 2;	 
 #		for($i=0; $i<=$temp; $i++){
 #			$addrows .= "<tr><td>&nbsp;</td></tr>\n";
 #		}
 #	}
  #}
  	print  qq|
  <!-- COMMENT OUT THIS
  	$addrows
 	</tr>
 	<tr>
 	<td></td>
 	<td colspan=2 align=left nowrap>$form->{titlebottom}</td>
 	<td></td>
 	<td align=right colspan=3 nowrap>$nowdate-$nowtime</td>
	</tr> 	-->

	
 	</table>
    	<p>
 	$lastline
 	</body>
 	</html>
 	|;
}
##################################################################################################################################################


sub gl_subtotal {

  $subtotaldebit_p = $form->format_amount(\%myconfig, $subtotaldebit, 2, "0.00");
  $subtotalcredit_p = $form->format_amount(\%myconfig, $subtotalcredit, 2, "0.00");
  $subtotalamount_p = $form->format_amount(\%myconfig, $subtotalamount, 2, "0.00");
    

###SHOW SUBTOTAL
  map { $column_data{$_} = "<th $listprint >&nbsp;</th>" } qw( transdate id source accdesc accno batch project subb);
  $column_data{debit} = "<th align=right $listprint >$line$subtotaldebit_p</font></td>";
  $column_data{credit} = "<th align=right $listprint >$line$subtotalcredit_p</font></td>";
  $column_data{amount} = "<th align=right $listprint >$line$subtotalamount_p</font></td>";


  print "<tr $listsubtotal >";
    if($form->{l_sr}){

    	print "<th $listprint >&nbsp;</th>";
    }
 map { print "$column_data{$_}\n" } @column_index;
  print "</tr>";

###SHOW SUBTOTAL FOOTER
  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } qw( transdate id source accdesc accno batch project subb );
 $subtotal2 = $subtotaldebit-$subtotalcredit; 
  $subtotal2_p = $form->format_amount(\%myconfig, $subtotal2, 2, "&nbsp;");
 $column_data{batch} = "<th align=left $listprint >N.O.T. : $not</font></td>";
$column_data{accdesc} = "<th align=right $listprint >***Total OF A/C NO: $currentaccno</font></td>";
 $column_data{debit} = "<th align=right $listprint >$line&nbsp;</font></td>";
 $column_data{credit} = "<th align=right $listprint >$line$subtotal2_p</font></td>";
 $column_data{amount} = "<th align=right $listprint >$line$subtotal2_p</font></td>";

 if($form->{sort} eq "accno"){
  print "<tr $listsubtotal>";
    if($form->{l_sr}){

    	print "<td $listprint >&nbsp;</td>";
    }
 map { print "$column_data{$_}\n" } @column_index;
  print "</tr>";
 }


  $subtotaldebit = 0;
  $subtotalcredit = 0;
  $subtotalamount = 0;
  $not=0;


  $sameitem = $ref->{$form->{sort}};
}


sub edit {	
  GL->transaction(\%myconfig, \%$form);

  $form->{locked} = ($form->datetonum($form->{transdate}, \%myconfig) <= $form->datetonum($form->{closedto}, \%myconfig));

  $form->{title} = "Edit";

  &form_header;

  $i = 1;
  foreach $ref (@{ $form->{GL} }) {
    $form->{"selectaccno_$i"} = $ref->{accno}."--".$ref->{description};
    if ($ref->{amount} < 0) {
      $form->{"debit_$i"} = $form->format_amount(\%myconfig, $ref->{amount} * -1, 2);
    } else {
      $form->{"credit_$i"} = ($ref->{amount} > 0) ? $form->format_amount(\%myconfig, $ref->{amount}, 2) : "";
    }

    &form_row($i++);
  }

  &form_row($i);

  &form_footer;
}


sub update_form {
 if($form->{transdate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{transdate};
 }
  # we use this only to set a default date
  GL->transaction(\%myconfig, \%$form);

if($lastdate){
 $form->{transdate}=$lastdate;
$form->{batch}=$lastbatch;
}


  @a = ();
  $count = 0;
  @flds = (qw(accno debit credit ));

  for $i (1 .. $form->{rowcount}) {
   
   unless (($form->{"debit_$i"} eq "") && ($form->{"credit_$i"} eq "")) {
        $form->{"debit_$i"} = $form->parse_amount(\%myconfig, $form->{"debit_$i"});
      $form->{"credit_$i"} = $form->parse_amount(\%myconfig, $form->{"credit_$i"});
     # take accno apart
    #  if($form->{"accno1_$i"}){
	#($form->{"accno_$i"}) =($form->{"accno1_$i"})
    #  }else{
	    $form->{"selectaccno_$i"}=$form->{"accno_$i"};
      ($form->{"accno_$i"}) = split(/--/, $form->{"accno_$i"});
    # }
      $form->{"debit_$i"} = $form->format_amount(\%myconfig, $form->{"debit_$i"}, 2, "");
      $form->{"credit_$i"} = $form->format_amount(\%myconfig, $form->{"credit_$i"}, 2, "");

      push @a, {};
      $j = $#a;

      map { $a[$j]->{$_} = $form->{"${_}_$i"} } @flds;
      $count++;
    }
  }

  for $i (1 .. $count) {
    $j = $i - 1;
    map { $form->{"${_}_$i"} = $a[$j]->{$_} } @flds;
  }

  for $i ($count + 1 .. $form->{rowcount}) {
    map { delete $form->{"${_}_$i"} } @flds;
  }

  $form->{rowcount} = $count;
	
	$x =$form->{rowcount}+1;
#	$form->{"nextfocus"}  = "accno11_$x";


  	&display_form;
  
}


sub display_form {

  &form_header;

  $form->{rowcount}++;
  for $i (1 .. $form->{rowcount}) {
    &form_row($i);
  }

      $form->{"totaldebit"} = $form->format_amount(\%myconfig, $form->{"totaldebit"}, 2, "");
      $form->{"totalcredit"} = $form->format_amount(\%myconfig, $form->{"totalcredit"}, 2, "");

	#$form->{"nextfocus"}  = "accno1_$form->{rowcount}";
  print qq|<tr class=listsubtotal>
  <td></td>
  <td align=right>$form->{"totaldebit"}</td>
  <td align=right>$form->{"totalcredit"}</td>


</tr>


|;

  &form_footer;

}


sub form_row {
  my $i = shift;

 # <option value='$ref->{accno}--$ref->{description}'>
 my $chart =$form->{chart2};
 $chart =~ s/\(/;brak/g;
$form->{"selectaccno_$i"} =~ s/\(/;brak/g;

$chart =~ s/\)/;2brak/g;
$form->{"selectaccno_$i"} =~ s/\)/;2brak/g;

$chart =~ s/\[/;brek/g;
$form->{"selectaccno_$i"} =~ s/\[/;brek/g;

$chart =~ s/\]/;2brek/g;
$form->{"selectaccno_$i"} =~ s/\]/;2brek/g;


  $chart =~ s/ selected//;
#$form->dberror($form->{"selectaccno_$i"});
  $chart =~ s/<option value='$form->{"selectaccno_$i"}'>$form->{"selectaccno_$i"}/<option selected value='$form->{"selectaccno_$i"}'>$form->{"selectaccno_$i"}/;
  
  $chart =~ s/;brak/\(/g;
$form->{"selectaccno_$i"} =~ s/;brak/\(/g;

$chart =~ s/;2brak/\)/g;
$form->{"selectaccno_$i"} =~ s/;2brak/\)/g;

   $chart =~ s/;brek/\[/g;
$form->{"selectaccno_$i"} =~ s/;brek/\[/g;

$chart =~ s/;2brek/\]/g;
$form->{"selectaccno_$i"} =~ s/;2brek/\]/g;


  print qq|<tr>
  <td>
<select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name="accno_$i">$chart</select></td>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="debit_$i" size=10 value=$form->{"debit_$i"}></td>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="credit_$i" size=10 value=$form->{"credit_$i"}></td>


</tr>
<input type=hidden name=rowcount value=$i>
|;

  $form->{"totaldebit"} +=$form->parse_amount(\%myconfig,$form->{"debit_$i"});
  $form->{"totalcredit"} +=$form->parse_amount(\%myconfig,$form->{"credit_$i"});
}



sub form_header {

  $title = $form->{title};
  $form->{title} = $locale->text("$title General Ledger Transaction");

# $locale->text('Add General Ledger Transaction')
# $locale->text('Edit General Ledger Transaction')

  map { $form->{$_} =~ s/"/&quot;/g } qw(source description chart);

  if (($rows = $form->numtextrows($form->{description}, 50)) > 1) {
    $description = qq|<textarea name=description rows=$rows cols=50 wrap=soft>$form->{description}</textarea>|;
  } else {
    $description = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=description size=50 value="$form->{description}">|;
  }


  $colspan = 3;


  $form->header;

  print qq|
<script>
<!--
function stb(){document.myform.$form->{nextfocus}.focus();parent.document.title ="$form->{title}";}

function autoComplete (field, select, property, forcematch) {
	var found = false;
	for (var i = 0; i < select.options.length; i++) {
	if (select.options[i][property].toUpperCase().indexOf(field.value.toUpperCase()) == 0) {
		found=true; break;
		}
	}
	if (found) { select.selectedIndex = i; }
	else { select.selectedIndex = -1; }
	if (field.createTextRange) {
		if (forcematch && !found) {
			field.value=field.value.substring(0,field.value.length-1); 
			return;
			}
		var cursorKeys ="8;46;37;38;39;40;33;34;35;36;45;";
		if (cursorKeys.indexOf(event.keyCode+";") == -1) {
			var r1 = field.createTextRange();
			var oldValue = r1.text;
			var newValue = found ? select.options[i][property] : oldValue;
			if (newValue != field.value) {
				field.value = newValue;
				var rNew = field.createTextRange();
				rNew.moveStart('character', oldValue.length) ;
				rNew.select();
				}
			}
		}
	}
	
// -->
</script>

<body bgcolor=ffffff onLoad=stb()>

<form method=post name=myform action=$form->{script}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=id type=hidden value=$form->{id}>


<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=chart type=hidden value="$form->{chart}">
<input type=hidden name=closedto value=$form->{closedto}>
<input type=hidden name=locked value=$form->{locked}>
<input type=hidden name=title value="$title">
<input type=hidden name=action value='Update Form'>
<input type=hidden name=keys >
<table border=1>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>
<table>
<tr>

  <th align=right>|.$locale->text('Ref No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=source value="$form->{source}"></td>
  <th align=right>|.$locale->text('Date').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdate size=11 value=$form->{transdate} title="($myconfig{dateformat})">
             <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].transdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    
  </td>

</tr>

<tr>
  <th align=right>|.$locale->text('Trans No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transtype  size=4 value="$form->{transtype}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=batch size=6 value="$form->{batch}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transno  size=4 value="$form->{transno}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subtransno  size=2 value="$form->{subtransno}"></td>
  <th align=right>|.$locale->text('Project No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=project value="$form->{project}"></td>
</tr>

<tr>
  <th align=right>|.$locale->text('Sub No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subb value="$form->{subb}"></td></tr>

<tr>

  <th align=right>|.$locale->text('Description').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=description size=50 value="$form->{description}"></td>

</tr>

</table>
</td></tr>

<tr class=listheading >

  <th><font color=ffffff>|.$locale->text('Account').qq|</th>
  <th><font color=ffffff>|.$locale->text('Debit').qq|</th>
  <th><font color=ffffff>|.$locale->text('Credit').qq|</th>

</tr>
|;

}


sub form_footer {

  print qq|

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=nextfocus type=hidden value="$form->{nextfocus}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

</table>

<br>
|;

  $transdate = $form->datetonum($form->{transdate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);

  if ($form->{id}) {
    print qq|<input class=submit type=submit name=action value="|.$locale->text('Update Form').qq|">
|;

    if (!$form->{revtrans}) {
      if (!$form->{locked}) {
	print qq|
	<input class=submit type=submit name=action value="|.$locale->text('Post Transaction').qq|">
	<input class=submit type=submit name=action value="|.$locale->text('Delete Transaction').qq|">
|;
      }
    }

    if ($transdate > $closedto) {
      print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Post As New Transaction').qq|">
|;
    }

  } else {
    if ($transdate > $closedto) {
      print qq|<input class=submit type=submit name=action value="|.$locale->text('Update Form').qq|">
      <input class=submit type=submit name=action value="|.$locale->text('Post Transaction').qq|">|;
    }
  }

  print "</form>

</body>
</html>
";

}


sub delete_transaction {

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  map { $form->{$_} =~ s/"/&quot;/g } qw(source description chart);

  foreach $key (keys %$form) {
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Are you sure you want to delete Transaction').qq| $form->{source}</h4>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Transaction').qq|">
</form>
|;

}


sub yes_delete_transaction {

  $form->isdeleted(GL->delete_transaction(\%myconfig, \%$form));

}


sub post_transaction {

  # check if there is something in source and date
  $form->isblank("source", $locale->text('Ref No. missing!'));
  $form->isblank("transdate", $locale->text('Transaction Date missing!'));

  $transdate = $form->datetonum($form->{transdate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);

  # this is just for the wise guys
  $form->error($locale->text('Cannot post transaction for a closed period!')) if ($transdate <= $closedto);

  $rc = GL->post_transaction(\%myconfig, \%$form);

  if ($rc == -1) {
    $form->error($locale->text("Cannot have a value in both Debit and Credit!"));
  }

  if ($rc == -2) {
    $form->error($locale->text("Debit and credit out of balance!"));
  }

  $form->isposted($rc);
}


sub post_template {

  # check if there is something in source and date
  $form->isblank("template", $locale->text('Template missing!'));


  # this is just for the wise guys
  #$form->error($locale->text('Cannot post Template for a closed period!')) if ($transdate <= $closedto);

  $rc = GL->post_template(\%myconfig, \%$form);

  if ($rc == -1) {
    $form->error($locale->text("Cannot have a value in both Debit and Credit!"));
  }

  if ($rc == -2) {
    $form->error($locale->text("Debit and credit out of balance!"));
  }

  $form->isposted($rc);

}


sub post_as_new_transaction {

  $form->{id} = 0;
  &post_transaction;

}


