#=====================================================================
# SQL-Ledger, Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Order entry module
#
#======================================================================


use SL::creditnote;
use SL::IR;
#use SL::IS;
use SL::GL;
use SL::OE;
#$form->{must_select_item}="true";
	$form->{show_all_price}="true";

#	$form->{pagebreak}="true";
#	$form->{save_before_click}="true";

$form->{print_invoice_mod}="print_so" if ! $form->{print_invoice_mod};

#$form->dberror($form->{print_invoice_mod});

require "$form->{path}/io.pl";
require "format/$form->{print_invoice_mod}.pl";

1;
# end of main


sub add {
  #####australia modify

 if(!$form->{page} ||	!$form->{pagerows}){
	 $form->{pagerows}=5;
	$form->{page}=1;
 }
 
  if ($form->{type} eq 'purchase_order') {
    $form->{title} = $locale->text('Debit Notes');
    $form->{vc} = 'vendor';
  }
  if ($form->{type} eq 'sales_order') {
    $form->{title} = $locale->text('Credit Notes');
    $form->{vc} = 'customer';
  }
    if($form->{orddate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{orddate};
 $accno1=$form->{accno_1};
 $accno2=$form->{accno_2};
 

 }
  
  &order_links;

  # lock the exchangerate field
  $form->{forex} = 1;
  $form->{"forex_1"} = 1;
  	GL->transaction(\%myconfig, \%$form);
  $form->{callback} = "$form->{script}?action=add&type=$form->{type}&print_invoice_mod=$form->{print_invoice_mod}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

 if($lastdate){
 $form->{orddate}=$lastdate;
$form->{batch}=$lastbatch;
$form->{accno_2}=$accno2;
$form->{accno_1}=$accno1;
}
 $form->{ordnumber}="";

  &prepare_order;

}


sub edit {
  #####australia modify

 if(!$form->{page} ||	!$form->{pagerows}){
	 $form->{pagerows}=5;
	$form->{page}=1;
 }
 ####the following is used from gl click edit
  if ($form->{vc} eq 'vendor') {
    $form->{title} = $locale->text('Edit Debit Note');
    $form->{type} = 'purchase_order';
  }
  if ($form->{vc} eq 'customer') {
    $form->{title} = $locale->text('Edit Credit Note');
    $form->{type} = 'sales_order';
  }


  if ($form->{type} eq 'purchase_order') {
    $form->{title} = $locale->text('Edit Debit Note');
    $form->{vc} = 'vendor';
  }
  if ($form->{type} eq 'sales_order') {
    $form->{title} = $locale->text('Edit Credit Note');
    $form->{vc} = 'customer';
  }
  
  
  
 	GL->transaction(\%myconfig, \%$form);
 &order_links;
    $form->{taxincluded} = 'true';
    
    

 foreach $ref (@{ $form->{GL} }) {
	 if($ref->{amount} && $ref->{amount}  > 0){
    $form->{"accno_2"} = $ref->{accno}."--".$ref->{description};
    }else{
   $form->{"accno_1"} = $ref->{accno}."--".$ref->{description};
 	 
    }

  }
  &prepare_order;

}


sub order_links {

  # get vendors / customers
  $form->all_vc(\%myconfig, $form->{vc});
#$form->dberror($form->{printcount});
 
  # retrieve order
  creditnote->retrieve_order(\%myconfig, \%$form);

  # build the popup menus
  foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
    if ($ref->{id} == $form->{"$form->{vc}_id"}) {
      $form->{chart2} = "$ref->{name}--$ref->{id}";
    #  $form->{accno_2} = $ref->{"$form->{vc}number"}."--".$ref->{name};
    }
    $form->{"select$form->{vc}"} .= "<option>$ref->{name}--$ref->{id}\n";
  }

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];
  
  map { $form->{selectcurrency} .= "<option>$_\n" } @curr;

  # forex
  $form->{forex} = $form->{exchangerate};
    $form->{locked} = ($form->datetonum($form->{orddate}, \%myconfig) <= $form->datetonum($form->{closedto}, \%myconfig));

}


sub prepare_order {

  $form->{new_form} = !$form->{id} unless (exists $form->{new_form});

  $form->{format} = "html";
  $form->{media} = "screen";
  $form->{sendmode} = "attachment";
  $form->{copies} = 2;

  if ($form->{id}) {
    
    map { $form->{$_} =~ s/"/&quot;/g } qw(invnumber shippingpoint notes);
    
    $form->{creditlimit} = $form->format_amount(\%myconfig, $form->{creditlimit}, 0);
    $form->{creditremaining} = $form->format_amount(\%myconfig, $form->{creditremaining}, 0);
    $i=0;
    foreach $ref (@{ $form->{order_details} } ) {
      $i++;
      map { $form->{"${_}_$i"} = $ref->{$_} } keys %{ $ref };
      $form->{"discount_$i"} = $form->format_amount(\%myconfig, $form->{"discount_$i"} * 100);

      ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
      $dec = length $dec;
      $decimalplaces = ($dec > 2) ? $dec : 2;
      
      $form->{"sellprice_$i"} = $form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces);
      $form->{"qty_$i"} = $form->format_amount(\%myconfig, $form->{"qty_$i"});
      
      map { $form->{"${_}_$i"} =~ s/"/&quot;/g } qw(partnumber description unit);
      $form->{rowcount} = $i;
    }
  } else {
    if ($form->{type} eq 'purchase_order') {
      IR->get_vendor(\%myconfig, \%$form);
    }
    if ($form->{type} eq 'sales_order') {
      IS->get_customer(\%myconfig, \%$form);
    }
  }
 creditnote->last_invoice(\%myconfig, \%$form);
 if(!$form->{ordnumber}){
   $form->{ordnumber}=$form->{lastinvnumber};
      $form->{ordnumber}++;

  }
if($form->{save_before_click}){
   creditnote->save_order(\%myconfig, \%$form);
   $form->{new_form}="true";
}

if(!$form->{"printl_$x"}){
  &display_form;
}
  
}


sub form_header {
  my $chart_1;
  my $chart_2;
#	$form->{chart} ="<option>".$form->{chart};
#	$form->{chart} =~ s/\n/\n<option>/g;

	 $i = 1;


#$form->{"accno_2"}=$form->{"$form->{vc}number"}; 

   foreach $item (split /\n/, $form->{chart}) {
	   $form->{chartGL}.="<option value='$item'>$item";
   }
   
    $form->{chart2}="";
    $form->{transdate}=$form->{orddate};

	if( $form->{vc} eq 'vendor'){
	  $form->create_links("AP", \%myconfig, "vendor");
	
	   foreach $key (keys %{ $form->{AP_links} }) {
	    
	    	foreach $ref (@{ $form->{AP_links}{$key} }) {
	      $form->{"chart$key"} .="<option value='$ref->{accno}--$ref->{description}'>$ref->{accno}--$ref->{description}\n";
	    }
	}

	  $form->{chart1}=$form->{"chartAP"};
	  $form->{chart2}=$form->{"chartGL"};
	  
	  $form->{dc}="Debit";
	
	}
 # $form->dberror($form->{accno_1});
#australia
	if( $form->{vc} eq 'customer'){
	  $form->create_links("AR", \%myconfig, "customer");
	
	  foreach $key (keys %{ $form->{AR_links} }) {
	    
	    foreach $ref (@{ $form->{AR_links}{$key} }) {
	      $form->{"chart$key"} .="<option value='$ref->{accno}--$ref->{description}'>$ref->{accno}--$ref->{description}\n";
	    }
	}

	  $form->{chart2}=$form->{"chartAR"};
	  $form->{chart1}=$form->{"chartGL"};
	  $form->{dc}="Credit";

	}

  	
  
  $form->{taxincluded} = ($form->{taxincluded}) ? "checked" : "";

  if ($form->{type} eq 'purchase_order') {
    $colspan = 6;
  }
  if ($form->{type} eq 'sales_order') {
    $colspan = 7;
  }

  # set option selected
#australia
#foreach $item ($form->{vc}, currency) {
#    $form->{"select$item"} =~ s/ selected//;
#    $form->{"select$item"} =~ s/option value='$form->{$item}'>\Q$form->{$item}\E/option selected value='$form->{$item}'>$form->{$item}/;
# }

$form->{"chart1"} =~ s/\(/;brak/g;
$form->{"chart2"} =~ s/\(/;brak/g;

$form->{"chart1"} =~ s/\)/;2brak/g;
$form->{"chart2"} =~ s/\)/;2brak/g;

$form->{"chart1"} =~ s/\[/;brek/g;
$form->{"chart2"} =~ s/\[/;brek/g;

$form->{"chart1"} =~ s/\]/;2brek/g;
$form->{"chart2"} =~ s/\]/;2brek/g;
##########
$form->{"accno_1"} =~ s/\(/;brak/g;
$form->{"accno_2"} =~ s/\(/;brak/g;

$form->{"accno_1"} =~ s/\)/;2brak/g;
$form->{"accno_2"} =~ s/\)/;2brak/g;

$form->{"accno_1"} =~ s/\[/;brek/g;
$form->{"accno_2"} =~ s/\[/;brek/g;

$form->{"accno_1"} =~ s/\]/;2brek/g;
$form->{"accno_2"} =~ s/\]/;2brek/g;

    $form->{"chart1"} =~ s/ selected//;
    $form->{"chart1"} =~ s/option value='$form->{accno_1}'>\Q$form->{accno_1}\E/option selected value='$form->{accno_1}'>$form->{accno_1}/;
   $form->{"chart2"} =~ s/ selected//;
    $form->{"chart2"} =~ s/option value='$form->{accno_2}'>\Q$form->{accno_2}\E/option selected value='$form->{accno_2}'>$form->{accno_2}/;
   
      $form->{"chart1"} =~ s/;brak/\(/g;
$form->{"chart2"} =~ s/;brak/\(/g;

$form->{"chart1"} =~ s/;2brak/\)/g;
$form->{"chart2"} =~ s/;2brak/\)/g;

   $form->{"chart1"} =~ s/;brek/\[/g;
$form->{"chart2"} =~ s/;brek/\[/g;

$form->{"chart1"} =~ s/;2brek/\]/g;
$form->{"chart2"} =~ s/;2brek/\]/g;
###########
      $form->{"accno_1"} =~ s/;brak/\(/g;
$form->{"accno_2"} =~ s/;brak/\(/g;

$form->{"accno_1"} =~ s/;2brak/\)/g;
$form->{"accno_2"} =~ s/;2brak/\)/g;

   $form->{"accno_1"} =~ s/;brek/\[/g;
$form->{"accno_2"} =~ s/;brek/\[/g;

$form->{"accno_1"} =~ s/;2brek/\]/g;
$form->{"accno_2"} =~ s/;2brek/\]/g;



  $form->{exchangerate} = $form->format_amount(\%myconfig, $form->{exchangerate});

  $exchangerate = qq|&nbsp;|;
  if ($form->{currency} ne $form->{defaultcurrency}) {
    if ($form->{forex}) {
      $exchangerate = qq|<input type=hidden name=exchangerate value=$form->{exchangerate}>$form->{exchangerate}|;
    } else {
      $exchangerate = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=exchangerate size=10 value=$form->{exchangerate}>|;
    }
  }
  $exchangerate .= qq|
<input type=hidden name=forex value=$form->{forex}>
|;

  
  $vclabel = ucfirst $form->{vc};
  $vclabel = $locale->text($vclabel);
  
  $form->header;
   $form->{title1}= qq|$form->{title} [ No : $form->{ordnumber}, Date : $form->{orddate}] |;
 
  print qq|
<script>
<!--
function stb(){document.myform.$form->{nextfocus}.focus();parent.document.title ="$form->{title1}";}

function autoComplete (field, select, property, forcematch) {
	var found = false;
	for (var i = 0; i < select.options.length; i++) {
	if (select.options[i][property].toUpperCase().indexOf(field.value.toUpperCase()) == 0) {
		found=true; break;
		}
	}
	if (found) { select.selectedIndex = i; }
	else { select.selectedIndex = -1; }
	if (field.createTextRange) {
		if (forcematch && !found) {
			field.value=field.value.substring(0,field.value.length-1); 
			return;
			}
		var cursorKeys ="8;46;37;38;39;40;33;34;35;36;45;";
		if (cursorKeys.indexOf(event.keyCode+";") == -1) {
			var r1 = field.createTextRange();
			var oldValue = r1.text;
			var newValue = found ? select.options[i][property] : oldValue;
			if (newValue != field.value) {
				field.value = newValue;
				var rNew = field.createTextRange();
				rNew.moveStart('character', oldValue.length) ;
				rNew.select();
				}
			}
		}
	}
	
// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>

<form method=post action=$form->{script}  name=myform>

<input type=hidden name=id value=$form->{id}>
<input type=hidden name=new_form value=$form->{new_form}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=vc value=$form->{vc}>

<input type=hidden name=title value="$form->{title}">

<input type=hidden name=$form->{vc}_id value=$form->{"$form->{vc}_id"}>
<input type=hidden name=discount value=$form->{discount}>
<input type=hidden name=chartGL value="$form->{chartGL}">

<input type=hidden name=must_select_item value=$form->{must_select_item}>
<input type=hidden name=show_all_price value=$form->{show_all_price}>
<input type=hidden name=pagebreak value=$form->{pagebreak}>
<input type=hidden name=print_invoice_mod value=$form->{print_invoice_mod}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=action value='Update Form'>
<input type=hidden name=closedto value='$form->{closedto}'>
<input type=hidden name=locked value='$form->{locked}'>


<table border=0  ><tr><td>

<table border=1 >
<tr class=listtop bgcolor=000000><th>
<font color=ffffff>$form->{title}</font></th></tr>

<tr>
<td>

<table cellspacing=0 cellpadding=0 border=0>
<tr>
  <th align=right>|.$locale->text('Trans No.').qq|</th>
  <td nowrap>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transtype  size=4 value="$form->{transtype}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=batch size=6 value="$form->{batch}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transno  size=4 value="$form->{transno}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subtransno  size=2 value="$form->{subtransno}"></th>
  </td>
  <th align=right>|.$locale->text('Sub No.').qq|</th>
    <td nowrap>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subb  size=4 value="$form->{subb}">
    </td>
  <th align=right>|.$locale->text('Project No.').qq|</th>
    <td nowrap>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=project  size=4 value="$form->{project}">
  </td>
</tr>


<tr><th align=right>|.$locale->text('Debit').qq|</th>
<td colspan=4><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name="accno_1"  onChange="this.form.accno11.value=this.options[this.selectedIndex].value">$form->{chart1}</select></td>

</tr>



<tr><th align=right>|.$locale->text('Credit').qq|</th>
  <td colspan=4><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name="accno_2"  onChange="this.form.accno21.value=this.options[this.selectedIndex].value">$form->{chart2}</select></td>

</tr>
|;
#<tr>
#  <td align=right >

#  <b>$vclabel</b>&nbsp;
#  </td>
#  <td  nowrap>
#  <select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=$form->{vc}  onChange="this.form.ven.value=this.options[this.selectedIndex].value">$form->{"select$form->{vc}"}</select><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="ven" size=20 value="$form->{"ven"}" ONKEYUP="autoComplete(this,this.form.$form->{vc},'value',true)">&nbsp;
#   </td>
#  <td>
 
#  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxincluded class=checkbox type=checkbox value=1 $form->{taxincluded}>&nbsp;<b>|.$locale->text('Tax Included').qq|</b>

##  </td>
#</tr>

#<input type=hidden name=select$form->{vc} value="$form->{"select$form->{vc}"}">

 # &email_options;

  print qq|

<tr>
  <td   align=right nowrap>
  <b>|.$locale->text( $form->{dc}.' Number').qq|</b>&nbsp;
    </td>
  <td>

  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=10 value="$form->{ordnumber}">

  </td>
   <td   align=right nowrap>
  <b>|.$locale->text('Last  '.$form->{dc}.' Number').qq|</b> : &nbsp;
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=lastinvnumber type=hidden value="$form->{lastinvnumber}">
 
  $form->{lastinvnumber}

  </td>
</tr>

<tr>
  <td  align=right nowrap>
  <b>|.$locale->text('Currency').qq|</b>&nbsp;
      </td>
  <td>
  <select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=currency>$form->{selectcurrency}</select>&nbsp;
      </td>
  <td align=right>
  <b>|.$locale->text('Exchangerate').qq|</b>&nbsp;
      </td>
  <td  colspan=2>
  $exchangerate

  </td>
  <input type=hidden name=selectcurrency value="$form->{selectcurrency}">
  <input type=hidden name=defaultcurrency value=$form->{defaultcurrency}>
</tr>

<tr>
  <td   align=right nowrap>
  <b>|.$locale->text('Date').qq|&nbsp;
        </td>
  <td>

  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=orddate size=11 value=$form->{orddate} title="($myconfig{dateformat})">&nbsp;
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].orddate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
          </td>
 
</tr>

<tr>
  <td align=right nowrap>
  <b>|.$locale->text('Freight').qq|</b>&nbsp;
        </td>
  <td>
 
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shippingpoint size=35 value="$form->{shippingpoint}">&nbsp;
         </td>

</tr>
<tr>
  <td align=right nowrap>
  <b>|.$locale->text('Sales Person').qq|</b>&nbsp;
        </td>
  <td>
 
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=salesperson size=35 value="$form->{salesperson}">&nbsp;
         </td>

</tr>

<input type=hidden name=taxpart value="$form->{taxpart}">
<input type=hidden name=taxservice value="$form->{taxservice}">

<input type=hidden name=taxaccounts value="$form->{taxaccounts}">
	    <input type=hidden name="taxincluded" value="true">

|;

  foreach $item (split / /, $form->{taxaccounts}) {
    print qq|
<input type=hidden name="${item}_rate" value=$form->{"${item}_rate"}>
<input type=hidden name="${item}_description" value="$form->{"${item}_description"}">
|;
  }

}


sub form_footer {

  $form->{DF}{$form->{format}} = "checked";
  $form->{OP}{$form->{media}} = "checked";
  $form->{SM}{$form->{sendmode}} = "checked";
  
  $form->{invtotal} = $form->{invsubtotal};

  if (($rows = $form->numtextrows($form->{notes}, 50, 8)) < 2) {
    $rows = 2;
  }
  $notes = qq|<textarea name=notes rows=$rows cols=50 wrap=soft>$form->{notes}</textarea>|;

$form->{taxincluded}="true";
  if (!$form->{taxincluded}) {

    foreach $item (split / /, $form->{taxaccounts}) {
      if ($form->{"${item}_base"}) {
	$form->{invtotal} += $form->{"${item}_total"} = $form->round_amount($form->{"${item}_base"} * $form->{"${item}_rate"}, 2);
	$form->{"${item}_total"} = $form->format_amount(\%myconfig, $form->{"${item}_total"}, 2);

	$tax .= qq|
	    <input type=hidden name="${item}_base1" value="$form->{"${item}_base"}">
	    <input type=hidden name="${item}_rate1" value="$form->{"${item}_rate"}">
         <input type=hidden name="${item}_description1" value="$form->{"${item}_description"}">
	    <input type=hidden name="${item}_total1" value="$form->{"${item}_total"}">
	<tr>
	  <th align=right>$form->{"${item}_description"}</th>
	  <td align=right>$form->{"${item}_total"}</td>
	</tr>
	|;
      }
    }

    $form->{invsubtotal} = $form->format_amount(\%myconfig, $form->{invsubtotal}, 2);

    $subtotal = qq|
      <tr>
  	    <input type=hidden name="invsubtotal" value=$form->{invsubtotal}>
        <th align=right>|.$locale->text('Subtotal').qq|</th>
        <td align=right>$form->{invsubtotal}</td>
      </tr>
      |;

  }


  $form->{invtotal} = $form->format_amount(\%myconfig, $form->{invtotal}, 2);
  $x=$form->{rowcount}-1;
    if(!$form->{"show_all_price"}){
  	$form->{"title2_$x"}="";
  }

  print qq|
  </table>
  </td>
  </tr>
<tr>
  <td colspan=$colspan>
    <table>
    <tr>
      <td colspan=1>
      <table>
        $subtotal

	$tax

	<tr>
	  <th align=right>|.$locale->text('Total').qq|</th>
  	    <input type=hidden name="invtotal" value=$form->{invtotal}>
	  <td align=right>$form->{invtotal}</td>
        </tr>

      </table>
      </td>|,

      qq|<td>
        <table>
	  <tr>
	    <th>|.$locale->text('Notes').qq|</th>
         </tr>

	  <tr>
	    <td>$notes</td>
 	<td>$form->{"title2_$x"}</td>
	  </tr>
	  
	  
	  



	</table>
      </td>

    </tr>


    </table>

  </td>
</tr>

</table>

</td>
</tr>

</table>
<br>			  <input type=hidden name=action value=update_form2>

|;

#  &print_options;

  if(!$form->{readonly}){
# &print_options;

  $invdate = $form->datetonum($form->{orddate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  
   if ($form->{id}) {
    print qq|
    <input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
    |;
   #####australia modify
   if($form->{pagebreak}){
  		print qq|<br>|;
		for $j (1 ..(( $i/$form->{pagerows})+1) ) {
			  print qq|
			  <input class=submit type=submit name=page value=' $j '>	  
			  |;
		  }
  		print qq|<br>|;
   }
  print qq|
   <input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
|;

    if (!$form->{revtrans}) {
      if (!$form->{locked}) {
	print qq|
	<input class=submit type=submit name=action value="|.$locale->text('Save').qq|">
	<input class=submit type=submit name=action value="|.$locale->text('Delete').qq|">
|;
      }
    }

#    if ($invdate > $closedto) {
#      print qq|
#      <input class=submit type=submit name=action value="|.$locale->text('Post As New Invoice').qq|">
#|;
 #   }

  } else {
    if ($invdate > $closedto) {
      print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
   |;
    #####australia modify
    if($form->{pagebreak}){
		print qq|<br>|;
		for $j (1 ..(( $i/$form->{pagerows})+1) ) {
			  print qq|
			  <input class=submit type=submit name=page value=' $j '>	  
			  |;
		  }
  		print qq|<br>|;
    }
  print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
      <input class=submit type=submit name=action value="|.$locale->text('Save').qq|">
    |;
    }
  }
  }

  print qq| 

</td>
</tr>

</table>

<input type=hidden name=rowcount value=$form->{rowcount}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

</form>
|

.$locale->text('Enter a number or description and click on "Update Form"')
.qq|<br>|
.$locale->text('To remove any items delete the number and click on "Update Form"')

.qq|

</body>
</html>
|;

}


sub save{
	&save_order;	
}

sub delete{
	&delete_order;	
}

sub print{
	&print_order;	
}

sub update{
	&update_form;	
}



sub update_form {
   #####australia modify
  $form->{page}=$form->{focus}/$form->{pagerows};

 ($form->{page},$dec) = split(/\./,$form->{page});
if($dec >=0){
	  $form->{page}++;	  
  }

  
&update_form2;
}

sub update_form2 {

  # if there is a new name get new values
 # ($null, $vc_id) = split /--/, $form->{$form->{vc}};
 # if ($form->{"$form->{vc}_id"} ne $vc_id) {
 #   map { delete $form->{"${_}_rate"} } ($form->{taxaccounts});
 $salesperson = $form->{salesperson};
   # $form->{"$form->{vc}_id"} = $vc_id;
    if ($form->{type} eq 'purchase_order') {
   ( $form->{AP},$null ) = split /--/, $form->{accno_1};
      IR->get_vendorid(\%myconfig, \%$form);
      IR->get_vendor(\%myconfig, \%$form);
    }
    if ($form->{type} eq 'sales_order') {
     ( $form->{AR},$null ) = split /--/, $form->{accno_2};
    IS->get_customerid(\%myconfig, \%$form);
    $form->{customer_id}=    $form->{customer_id2};
     IS->get_customer(\%myconfig, \%$form);
    }
    
    if($salesperson){
	    $form->{salesperson}=$salesperson;    
    }
 # }
 #the following statement must be coresspondent to the io.pl sub form_row();
  #this statment will reorder the sequence of rows
  for $j(1..$form->{rowcount}){
	  if($form->{"sr_$j"} ne $form->{"sr2_$j"}){
	  for ($i=$form->{"sr2_$j"};$i > $form->{"sr_$j"};--$i){
	       @column_index = qw(partnumber description onhand qty unit   sellprice  lastcost discount bin part_ordnumber last_parts_qty ord_parts qty po_details partnotes id inventory_Accno bin	      income_accno expense_accno listprice assembly taxaccounts parts_id linetotal po delivery_date  remark2);

	          map { $form->{$_."t"} =  $form->{$_."_$form->{\"sr2_$i\"}"} } @column_index;

		  $k=$i-1;
		  map { $form->{$_."_$form->{\"sr2_$i\"}"} =  $form->{$_."_$form->{\"sr2_$k\"}"} } @column_index;

		  map { $form->{$_."_$form->{\"sr2_$k\"}"} =  $form->{$_."t"} } @column_index;

		 
	  }
	  }
  }
  ###end of statement of reorder
  
  $buysell = 'buy';
  $buysell = 'sell' if ($form->{vc} eq 'vendor');
  $form->{exchangerate} = $exchangerate if ($form->{forex} = ($exchangerate = $form->check_exchangerate(\%myconfig, $form->{currency}, $form->{orddate}, $buysell)));
  
  $form->{exchangerate} = $form->parse_amount(\%myconfig, $form->{exchangerate});

   $i = $form->{rowcount};
  $form->{focus}=$form->{rowcount};
	$form->{"nextfocus"}  = "partnumber_$i";

  if (($form->{"partnumber_$i"} eq "") && ($form->{"description_$i"} eq "")) {

    &check_form;
    
  } else {
   $form->{"partnumber_$i"} =~ s/'/\\'/g;
$form->{"description_$i"} =~ s/'/\\'/g;

    if ($form->{type} eq 'purchase_order') {
      IR->retrieve_item(\%myconfig, \%$form);
    }
    if ($form->{type} eq 'sales_order') {
      IS->retrieve_item(\%myconfig, \%$form);
    }

    my $rows = scalar @{ $form->{item_list} };
    
    $form->{"discount_$i"} = $form->format_amount(\%myconfig, $form->{discount} * 100);

    if ($rows) {
      $form->{"qty_$i"}                     = 1 unless ($form->{"qty_$i"});
      
      if ($rows > 1 || $form->{must_select_item}) {
	&select_item;
	exit;
      } else {
	map { $form->{item_list}[$i]{$_} =~ s/"/&quot;/g } qw(partnumber description unit);
	map { $form->{"${_}_$i"} = $form->{item_list}[0]{$_} } keys %{ $form->{item_list}[0] };

	($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
	$dec = length $dec;
	$decimalplaces = ($dec > 2) ? $dec : 2;
	
        # if there is an exchange rate adjust sellprice
        if (($form->{exchangerate} * 1) != 0) {
	  $form->{"sellprice_$i"} /= $form->{exchangerate};
	}
		    
	$form->{"sellprice_$i"} = $form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces);
	$form->{"qty_$i"} =  $form->format_amount(\%myconfig, $form->{"qty_$i"});

      }

      &display_form;

    } else {
      # ok, so this is a new part
      # ask if it is a part or service item

      $form->{"id_$i"}		= 0;
      $form->{"unit_$i"}	= $locale->text('ea');

      &new_item;
      
    }
  }
}



sub search {
  
  if ($form->{type} eq 'purchase_order') {
   	  $form->{dc}="Debit";
   $selection = "<option selected>" . $locale->text('All Vendors') ."\n";
    $form->{title} = $locale->text( $form->{dc}.' Note');
    $form->{vc} = 'vendor';
  }
  if ($form->{type} eq 'sales_order') {
 	  $form->{dc}="Credit";
   $selection = "<option selected>" . $locale->text('All Customers') ."\n";
    $form->{title} = $locale->text( $form->{dc}.' Note');
    $form->{vc} = 'customer';
  }

  # setup vendor / customer selection
  $form->all_vc(\%myconfig, "$form->{vc}");
  
  foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }
 
  $vclabel = ucfirst $form->{vc};
  $vclabel = $locale->text($vclabel);
  
# $locale->text('Vendor')
# $locale->text('Customer')
  

  $form->header;

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr><td>

<table>

<tr>

<th align=right>$vclabel</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=$form->{vc}>$selection</select></td>

</tr>

<tr>

<th align=right>|.$locale->text( $form->{dc}.' Number').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=20 value='$form->{ordnumber}'></td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11 title=($myconfig{dateformat})>
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11 title=($myconfig{dateformat})>
  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['search'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>

    </td>

</tr>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<input type=hidden name=sort value=transdate>

<tr>
<th align=right>|.$locale->text('Include in Report').qq|</th>
<td colspan=3>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=checkbox value=Y $form->{l_sr}>&nbsp;|.$locale->text('SR').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=checkbox value=Y $form->{l_id}>&nbsp;|.$locale->text('ID').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_trans" class=checkbox type=checkbox value=Y  $form->{l_trans}>&nbsp;|.$locale->text('Trans no.').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subb" class=checkbox type=checkbox value=Y  $form->{l_subb}>&nbsp;|.$locale->text('Sub no.').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_project" class=checkbox type=checkbox value=Y  $form->{l_project}>&nbsp;|.$locale->text('Project').qq|<br>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=checkbox value=Y  $form->{l_ordnumber}>&nbsp;|.$locale->text( $form->{dc}.' Number').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=checkbox value=Y  $form->{l_transdate}>&nbsp;|.$locale->text('Date').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_number" class=checkbox type=checkbox value=Y  $form->{l_number}>&nbsp;|.$locale->text( 'Acc No.').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" class=checkbox type=checkbox value=Y  $form->{l_name}>&nbsp;$vclabel Name
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=checkbox value=Y  $form->{l_amount}>&nbsp;|.$locale->text('Amount').qq|<br>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=checkbox value=Y $form->{l_subtotal}>&nbsp;|.$locale->text('Subtotal').qq|
 <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_printl" class=checkbox type=checkbox value=Y $form->{l_printl}>&nbsp;|.$locale->text('Print').qq|<br>
  
</td>

</tr>

</table>

</td></tr>
</table>

<p>
<input type=hidden name=nextsub value=orders>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=dc value=$form->{dc}>
<input type=hidden name=print_invoice_mod value=$form->{print_invoice_mod}>

<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
</form>

<p>|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;
 # <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_reqdate" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Required by').qq|<br>
 # <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_netamount" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Amount').qq|
 # <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_tax" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Tax').qq|

}

sub more{
   @columns = qw(sr trans subb project transdate ordnumber reqdate id number  name  netamount tax amount printl);
    map { $form->{"l_$_"} = "checked" if $form->{"l_$_"} eq "Y" } @columns;

 &search;
}

sub search_short {
  
  if ($form->{type} eq 'purchase_order') {
   	  $form->{dc}="Debit";
   $selection = "<option selected>" . $locale->text('All Vendors') ."\n";
    $form->{title} = $locale->text( $form->{dc}.' Note Report');
    $form->{vc} = 'vendor';
  }
  if ($form->{type} eq 'sales_order') {
 	  $form->{dc}="Credit";
   $selection = "<option selected>" . $locale->text('All Customers') ."\n";
    $form->{title} = $locale->text( $form->{dc}.' Note Report');
    $form->{vc} = 'customer';
  }

  # setup vendor / customer selection
  $form->all_vc(\%myconfig, "$form->{vc}");
  
  foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }
 
  $vclabel = ucfirst $form->{vc};
  $vclabel = $locale->text($vclabel);
  
# $locale->text('Vendor')
# $locale->text('Customer')
  

  $form->header;

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr><td>

<table>

<tr>

<th align=right>$vclabel</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=$form->{vc}>$selection</select></td>

</tr>

<tr>

<th align=right>|.$locale->text( $form->{dc}.' Number').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=20 value='$form->{ordnumber}'></td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11 title=($myconfig{dateformat})>
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11 title=($myconfig{dateformat})>
  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['search'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>

    </td>

</tr>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<input type=hidden name=sort value=transdate>
|;

print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=hidden value=Y $form->{l_sr}>&nbsp;| if $form->{l_sr};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=hidden value=Y $form->{l_id}>&nbsp;| if $form->{l_id};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_trans" class=checkbox type=hidden value=Y $form->{l_trans}>&nbsp;| if $form->{l_trans};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subb" class=checkbox type=hidden value=Y $form->{l_subb}>&nbsp;| if $form->{l_subb};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_project" class=checkbox type=hidden value=Y $form->{l_project}>&nbsp;| if $form->{l_project};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=hidden value=Y $form->{l_ordnumber}>&nbsp;| if $form->{l_ordnumber};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=hidden value=Y $form->{l_transdate}>&nbsp;| if $form->{l_transdate};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_number" class=checkbox type=hidden value=Y $form->{l_number}>&nbsp;| if $form->{l_number};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" class=checkbox type=hidden value=Y $form->{l_name}>&nbsp;| if $form->{l_name};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=hidden value=Y $form->{l_amount}>&nbsp;| if $form->{l_amount};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=hidden value=Y $form->{l_subtotal}>&nbsp;| if $form->{l_subtotal};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_printl" class=checkbox type=hidden value=Y $form->{l_printl}>&nbsp;| if $form->{l_printl};
  

 print qq|
</table>

</td></tr>
</table>

<p>
<input type=hidden name=nextsub value=orders>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=dc value=$form->{dc}>
<input type=hidden name=print_invoice_mod value=$form->{print_invoice_mod}>

<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('More').qq|">
</form>

<p>|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;
 # <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_reqdate" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Required by').qq|<br>
 # <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_netamount" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Amount').qq|
 # <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_tax" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Tax').qq|

}


sub orders {
     $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
    
  # split vendor / customer
  ($namevc, $form->{"$form->{vc}_id"}) = split(/--/, $form->{$form->{vc}});
  
  # $form->{..._id} is needed in OE->transactions
  creditnote->transactions(\%myconfig, \%$form);

  # construct href
  $href = "$form->{script}?path=$form->{path}&action=orders&type=$form->{type}&print_invoice_mod=$form->{print_invoice_mod}&vc=$form->{vc}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&ordnumber=" . $form->escape($form->{ordnumber}) . "&$form->{vc}=" . $form->escape($form->{$form->{vc}});

  # construct callback
  $name =~ s/&/_/g;
  $callback = "$form->{script}?path=$form->{path}&action=orders&type=$form->{type}&print_invoice_mod=$form->{print_invoice_mod}&vc=$form->{vc}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&ordnumber=$form->{ordnumber}&$form->{vc}=$name";

  @columns = $form->sort_columns(qw(trans subb project transdate ordnumber reqdate id number  name  netamount tax amount printl));

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;
      
      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }
  
  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }
 
     if ($form->{"l_sr"} eq "Y") {
      unshift (@column_index, "sr") ;

      # add column to callback
      $callback .= "&l_sr=Y";
     $href .= "&l_sr=Y";
  }
  if ($form->{vc} eq 'vendor') {
    $form->{title} = $locale->text( $form->{dc}.' Note');
    $name = $locale->text('Vendor');
  }
  if ($form->{vc} eq 'customer') {
    $form->{title} = $locale->text( $form->{dc}.' Note');
    $name = $locale->text('Customer');
  }
   $column_title{printl} =  $locale->text('Print');

  $column_header{sr} = qq|<th><a class=listheading href=$href&sort=id><font color=ffffff>|.$locale->text('SR').qq|</font></a></th>|;
  $column_header{id} = qq|<th><a class=listheading href=$href&sort=id><font color=ffffff>|.$locale->text('ID').qq|</font></a></th>|;
  $column_header{transdate} = qq|<th><a class=listheading href=$href&sort=transdate><font color=ffffff>|.$locale->text('Date').qq|</font></a></th>|;
  $column_header{reqdate} = qq|<th><a class=listheading href=$href&sort=reqdate><font color=ffffff>|.$locale->text('Required by').qq|</font></a></th>|;
  $column_header{ordnumber} = qq|<th><a class=listheading href=$href&sort=ordnumber><font color=ffffff>|.$locale->text('Order').qq|</font></a></th>|;
  $column_header{number} = qq|<th><a class=listheading href=$href&sort=name><font color=ffffff>|.$locale->text('Acc no').qq|</font></a></th>|;
  $column_header{name} = qq|<th><a class=listheading href=$href&sort=name><font color=ffffff>$name</font></a></th>|;
  $column_header{netamount} = qq|<th><font color=ffffff>|.$locale->text('Amount').qq|</font></th>|;
  $column_header{tax} = qq|<th><font color=ffffff>|.$locale->text('Tax').qq|</font></th>|;
  $column_header{amount} = qq|<th><font color=ffffff>|.$locale->text('Total').qq|</font></th>|;
  $column_header{trans} = "<th><a class=listheading href=$href&sort=transtype,batch,transno,subtransno><font color=ffffff>".$locale->text('Trans No.')."</font></th>";
   $column_header{subb} = "<th><a class=listheading href=$href&sort=transtype,batch,transno,subtransno><font color=ffffff>".$locale->text('Sub No.')."</font></th>";
   $column_header{project} = "<th><a class=listheading href=$href&sort=transtype,batch,transno,subtransno><font color=ffffff>".$locale->text('Project No.')."</font></th>";
  $column_header{printl} =  "<th $listprint><a $listheading>$line$column_title{printl}$line</th>";

  
  #($name) = split /--/, $form->{name};
  
  if ($form->{"$form->{vc}_id"}) {
    $option .= $namevc;
  }
  if ($form->{transdatefrom}) {
    $option .= "\n<br>".$locale->text('From')." ".$locale->date(\%myconfig, $form->{transdatefrom}, 1);
  }
  if ($form->{transdateto}) {
    $option .= "\n<br>".$locale->text('To')." ".$locale->date(\%myconfig, $form->{transdateto}, 1);
  }
   if ($form->{ordnumber}) {
    $option .= "\n<br>".$locale->text('Debit Number')." ". $form->{ordnumber};
  }
   
  $form->header;

  $colspan = $#column_index + 1;
 $option = "" if !$form->{l_option};
  print qq|
 <script>
<!--

function set(n) 
{
               temp = document.myform.elements.length  ;
                 
               for (i=0; i < temp; i++)
	{   document.myform.elements[i].checked=n;
	   }
} 

function Invers(){

temp = document.myform.elements.length ;
                 
for (i=0; i < temp; i++){

          if(document.myform.elements[i].checked == 1){document.myform.elements[i].checked = 0;}
                else {document.myform.elements[i].checked = 1}
               
              }

}
// -->
</script>

<body bgcolor=ffffff>
<form method=post action=creditnote.pl name=myform>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=printtitle value='$form->{printtitle}'>
<table  border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$option</td></tr>

<tr class=listheading bgcolor=336666>|;

map { print "\n$column_header{$_}" } @column_index;

print qq|
</tr>
|;

  # add sort and escape callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  if (@{ $form->{OE} }) {
    $sameitem = $form->{OE}->[0]->{$form->{sort}};
  }

  foreach $oe (@{ $form->{OE} }) {

    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $oe->{$form->{sort}}) {
	&subtotal;
	$sameitem = $oe->{$form->{sort}};
      }
    }
    
    $column_data{netamount} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{netamount}, 2, "&nbsp;")."</td>";
    $column_data{tax} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{amount} - $oe->{netamount}, 2, "&nbsp;")."</td>";
    $column_data{amount} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{amount}, 2, "&nbsp;")."</td>";
  $column_data{trans} = "<td>$oe->{transtype}-$oe->{batch}-$oe->{transno}$oe->{subtransno}</td>";
   $column_data{subb} = "<td>$oe->{subb}</td>";
    $column_data{project} = "<td>$oe->{project}</td>";
   $column_data{printl} =  "<td  $listprint ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=\"printl_".($j+1)."\" type=checkbox class=checkbox value=".($j+1)." 0> </td>" ;

    $totalnetamount += $oe->{netamount};
    $totalamount += $oe->{amount};
    $totalpaid += $oe->{paid};

    $subtotalnetamount += $oe->{netamount};
    $subtotalamount += $oe->{amount};
++$j;
     $column_data{id} = "<td>$oe->{id}</td>";
   $column_data{sr} = "<td>$j</td>";
    $column_data{transdate} = "<td>$oe->{transdate}&nbsp;</td>";
    $column_data{reqdate} = "<td>$oe->{reqdate}&nbsp;</td>";

   if($oe->{invoice}){
		$column_data{ordnumber} = "<td><input type=hidden name=id_".($j+1)." value=$oe->{id}><a href=creditnote.pl?path=$form->{path}&action=edit&print_invoice_mod=$form->{print_invoice_mod}&type=$form->{type}&id=$oe->{id}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$oe->{ordnumber}</a></td>";
        }else{
      $dateto=$form->datetonum($oe->{transdate}, \%myconfig);
      if($form->{vc} eq "customer"){
		$vc = "customer_id"
      }else{
		$vc = "vendor_id"

      }
      
       $notes =$oe->{notes};
	  $notes =~ s/ /%20/g;

	$column_data{ordnumber} = "<td><a href=creditnote2.pl?$form->{vc}_id=$oe->{$vc}&vc=$form->{vc}&path=$form->{path}&action=edit&type=$form->{type}&print_invoice_mod=$form->{print_invoice_mod}&id=$oe->{id}&login=$form->{login}&sessionid=$form->{sessionid}&ordnumber=$oe->{ordnumber}&callback=$callback&transdate=$oe->{transdate}&notes=$notes>$oe->{ordnumber}</a></td>";

}
    $column_data{name} = "<td width=50%>$oe->{name}</td>";
   $column_data{number} = "<td>$oe->{number}</td>";

    $i++; $i %= 2;$j++;
    print "<tr class=listrow$i $mouseaction[$i] >";
    
    map { print "\n$column_data{$_}" } @column_index;

    print qq|
    </tr>
|;

  }
  
  if ($form->{l_subtotal} eq 'Y') {
    &subtotal;
  }
  
  # print totals
  print qq|<tr class=listtotal bgcolor=000000>|;
  
  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;
  
  $column_data{netamount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{tax} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount - $totalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{amount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."</font></th>";

  map { print "\n$column_data{$_}" } @column_index;

  print qq|
  </tr>
  
</table>
|;
  if($form->{l_printl}  ){
	  print qq| 
	    <br><br><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=button onclick=Invers() type=button value="|.$locale->text('Select All').qq|"> <input class=submit type=submit name=action value="|.$locale->text('Print Invoices').qq|">
	  	<input type=hidden name=sessionid value=$form->{sessionid}>
		<input type=hidden name=printcount value=$j>

	  |;
  }
  
  
  print qq|
<p>|.$locale->text('Click on table headers to sort table').qq|
<br>|.$locale->text('Click on '. $form->{dc}.' number to edit transaction')

.qq|
  </form>
</body>
</html>
|;

}


sub print_invoices{
#require "$form->{path}/is.pl";
	 $form->header;
 print qq|<body bgcolor="#ffffff">|;
 for $x (1 .. $form->{printcount}) {
 $form->{"pid_$x"} =$form->{"id_$x"};

 }
 
 for $x (1 .. $form->{printcount}) {
 $form->{title} = ($form->{type} eq 'purchase_order') ? $locale->text('D E B I T &nbsp;&nbsp; N O T E S') : $locale->text('C R E D I T &nbsp;&nbsp; N O T E S');
 # $form->{printtitle}="I N V O I C E";
 
 $form->{id} =$form->{"pid_$x"};
 # $form->save_query(\%$form,$myconfig->{dbname},$form->{"id_$x"});

  $form->{currentrow}=0;


 $form->{page}=0;
 #$i=0;
$form->{paidaccounts}=0;
$form->{rowcount}=0;

$form->{invtotal}=0;
$form->{invsubtotal}=0;


	 if($form->{"printl_$x"}){
	#$form->dberror($form->{id});
 
	  ####print invoice
			  map { $form->{$_} = $myconfig{$_} } (qw(company address tel fax businessnumber nativecurr fy));
			  $form->{address} =~ s/\\n/<br>/g;
			
			#  $form->{type} = "invoice";
			  $form->{label} = $locale->text('Invoice');
			  $form->{vc} = "customer";
			  $form->{printpage}=1;
			  $form->{pagetotal}=0;
			  $form->{invsubtotal}=0;
			   $y=0;
			  $form->{currentrow}=0;
			  $form->{page}=1;
			 # IS->customer_details(\%myconfig, \%$form);
			 delete $form->{order_details};		
	  &order_links;
	  &prepare_order; 
	      IS->get_customer(\%myconfig, \%$form);
			  &print_form_header;
			  for $z (1 .. $form->{rowcount}) {
#$form->dberror($form->{rowcount}." ".$form->{"partnumber_$form->{currentrow}"});
				  $form->{currentrow}++;
		         	 $form->{"sellprice_$form->{currentrow}"} =~ s/,//g;
		         	 $form->{"qty_$form->{currentrow}"} =~ s/,//g;
				 $form->{"linetotal_$form->{currentrow}"} = $form->{"sellprice_$form->{currentrow}"}*$form->{"qty_$form->{currentrow}"};
				 $form->{"sellprice_$form->{currentrow}"} = $form->format_amount(\%myconfig, $form->{"sellprice_$form->{currentrow}"} , 2);
				 $form->{"qty_$form->{currentrow}"} = $form->format_amount(\%myconfig, $form->{"qty_$form->{currentrow}"} , 0);
				 $y++;
				 $form->{invsubtotal}+=$form->{"linetotal_$form->{currentrow}"};

				    if($form->{printinvoicerowcount} > $y){
					    &print_form_row;
				    }else{
					    &print_form_row;
					     &print_page_footer;
					    print qq| <p style="page-break-before: always">&nbsp;</p>|;
					    $form->{page}++;
					    &print_form_header;
					     &print_page_header;
					    $y=0;
				    
				   }
				  

			  }
 	$form->{"invsubtotal"} =~ s/,//g;
      $form->{"invsubtotal"} = $form->format_amount(\%myconfig, $form->{"invsubtotal"} , 2);

			  &print_form_footer;
			 print qq| </table><p style="page-break-before: always">&nbsp;</p>|;
	###print all end
	 }


 }
  print qq|    </body></html>|;

}



sub subtotal {

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;
  
  $column_data{netamount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{tax} = "<td align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalamount - $subtotalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{amount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalamount, 2, "&nbsp;")."</font></th>";
  $column_data{paid} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalpaid, 2, "&nbsp;")."</font></th>";

  $subtotalnetamount = 0;
  $subtotalamount = 0;
  $subtotalpaid = 0;

  print "<tr class=listsubtotal bgcolor=333366>";
  
  map { print "\n$column_data{$_}" } @column_index;

  print qq|
  </tr>
|;

}


sub save_order {

  $form->isblank("ordnumber", $locale->text('Order Number missing!'));
  $form->isblank("orddate", $locale->text('Order Date missing!'));
      $form->isblank("invtotal", $locale->text('Total is zero!'));

  $form->isblank("exchangerate", $locale->text('Exchangerate missing!')) if ($form->{currency} ne $form->{defaultcurrency});

  &validate_items;

  # if the vendor changed get new values
#  ($null, $vc_id) = split /--/, $form->{$form->{vc}};
 # if ($form->{"$form->{vc}_id"} ne $vc_id) {
 #   $form->{"$form->{vc}_id"} = $vc_id;
 #   if ($form->{vc} eq 'vendor') {
 #     IR->get_vendor(\%myconfig, \%$form);
 #   }
 #   if ($form->{vc} eq 'customer') {
 #     IS->get_customer(\%myconfig, \%$form);
 #   }
 # }


  # this is for the notes section for the [email] Subject
  $form->{label} = ($form->{type} eq 'sales_order') ? $locale->text( $form->{dc}.' Note') : $locale->text( $form->{dc}.' Note');
  
 
  if ($form->{type} eq 'purchase_order') {
 ( $form->{accno_1},$null ) = split /--/, $form->{accno_1};
	   $form->{AP}=$form->{accno_1};
  	IR->get_vendorid(\%myconfig, \%$form);  
  }
  
  if ($form->{type} eq 'sales_order') {
 ( $form->{accno_2},$null ) = split /--/, $form->{accno_2};
	   $form->{AR}=$form->{accno_2};
  	IS->get_customerid(\%myconfig, \%$form);  
  }
$form->{callback}.="&nextfocus=transtype&transtype=$form->{transtype}&batch=$form->{batch}&subtransno=$form->{subtransno}&orddate=$form->{orddate}";

  if (creditnote->save_order(\%myconfig, \%$form)) {
    if ($form->{new_form}) {
$form->{transno}++;

      $form->header;
      
      print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

      print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Do you want to create another '. $form->{dc}.' Note?').qq|</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes').qq|">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('No').qq|">

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}&transno=$form->{transno}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=print_invoice_mod value=$form->{print_invoice_mod}>

</form>

</body>
</html>
|;

    } else {
      $form->isposted(1);
    }

  }

}



sub delete_order {

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  # delete action variable
  delete $form->{action};

  foreach $key (keys %$form) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|
  .$locale->text('Are you sure you want to delete '. $form->{dc}.' Note Number').qq| $form->{ordnumber}
</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Order').qq|">
</form>

</body>
</html>
|;


}



sub yes_delete_order {

  $form->isdeleted(creditnote->delete_order(\%myconfig, \%$form));

}



sub print_order {
   ( $form->{accno_2},$null ) = split /--/, $form->{accno_2};
   ( $form->{accno_1},$null ) = split /--/, $form->{accno_1};

  if ($form->{type} eq 'purchase_order') {
	   $form->{AP}=$form->{accno_1};
  	IR->get_vendorid(\%myconfig, \%$form);  }
  if ($form->{type} eq 'sales_order') {
	   $form->{AR}=$form->{accno_2};
  	IS->get_customerid(\%myconfig, \%$form);  }
	
  $form->{label} = ($form->{type} eq 'sales_order') ? $locale->text( $form->{dc}.' Notes') : $locale->text( $form->{dc}.' Notes');
 $form->{credit}=1;
  map { $form->{$_} = $myconfig{$_} } (qw(company address tel fax businessnumber nativecurr fy));
  $form->{address} =~ s/\\n/<br>/g;
  $form->{notes} =~ s/\\n/<br>/g;

  $form->{title} = ($form->{type} eq 'purchase_order') ? $locale->text('D E B I T &nbsp;&nbsp; N O T E S') : $locale->text('C R E D I T &nbsp;&nbsp; N O T E S');

   $form->{page}=0;
  $form->{printpage}=1;
  
  $form->header;
  if($form->{type} eq 'sales_order'){
  IS->customer_details(\%myconfig, \%$form);
  }else{
  IR->vendor_details(\%myconfig, \%$form);
	  
  }
 print qq|<body bgcolor=ffffff>|;
 		    $form->{page}++;
  &print_form_header;
  for $i (1 .. $form->{rowcount}-1) {
  $form->{"description_$i"} =~ s/\\n/<br>/g;
	  $form->{currentrow}++;
	    $r++;
	    if($form->{printinvoicerowcount} > $r){
		    &print_form_row;
	    }else{
		    &print_form_row;
		     &print_page_footer;
		    print qq| <p style="page-break-before: always">&nbsp;</p>|;
		    $form->{page}++;
		    &print_form_header;
		     &print_page_header;
		    $r=0;
	    
	   }
	  
  }
  
  &print_form_footer;
  
 # &print_form;

}


sub vendor_details {

  ($null, $vendor_id) = split /--/, $form->{vendor};
  if ($vendor_id != $form->{vendor_id}) {
    $form->{vendor_id} = $vendor_id;
    IR->get_vendor(\%myconfig, \%$form);
  }

  # get address for vendor
  IR->vendor_details(\%myconfig, \%$form);
  
}


sub create_invoice {
  
  $form->isblank("ordnumber", $locale->text( $form->{dc}.' Note missing!'));
  $form->isblank("orddate", $locale->text( $form->{dc}.' Date missing!'));

  $form->{invdate} = $form->current_date(\%myconfig);

  $form->{orderid} = $form->{id};
  $form->{id} = '';
  $form->{rowcount}--;
  $form->{new_form} = '';

  if ($form->{type} eq 'purchase_order') {
  #  $form->{title} = $locale->text('Add Vendor Invoice');
    $form->{script} = 'ir.pl';
    $script = "ir";
  }
  if ($form->{type} eq 'sales_order') {
   # $form->{title} = $locale->text('Add Customer Invoice');
    $form->{script} = 'is.pl';
    $script = "is";
  }

  # locale messages
  $locale = new Locale "$myconfig{countrycode}", "$script";

  require "$form->{path}/$form->{script}";

  map { $form->{"select$_"} = "" } ($form->{vc}, currency);

  &invoice_links;

  &prepare_invoice;

}


sub yes_keep_order {

  $form->isposted(1);

}


sub no_delete_order {

  $form->isdeleted(creditnote->delete_order(\%myconfig, \%$form));
  
}


