#=====================================================================
# SQL-Ledger, Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Order entry module
#
#======================================================================


use SL::adjust;
use SL::IR;
use SL::IS;
use SL::IC;
require "$form->{path}/io.pl";

1;
# end of main


sub add {
   #####australia modify
 if(!$form->{page} ||	!$form->{pagerows}){
	 $form->{pagerows}=5;
	$form->{page}=1;
 }
  if ($form->{type} eq 'sales_order') {
    $form->{title} = $locale->text('Goods Adjustment');
    $form->{vc} = 'customer';
  }
 if ($form->{type} eq 'purchase_order') {
    $form->{title} = $locale->text('Goods Adjustment');
    $form->{vc} = 'vendor';
  }
if ($form->{type} eq 'adjust') {
    $form->{title} = $locale->text('Stock Adjust');
    $form->{vc} = 'customer';
  }
if ($form->{type} eq 'os') {
    $form->{title} = $locale->text('Opening Stock');
    $form->{vc} = 'customer';
  }
  $form->{callback} = "$form->{script}?action=add&type=$form->{type}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

  &order_links;

  # lock the exchangerate field
  $form->{forex} = 1;
  $form->{"forex_1"} = 1;
  if($form->{allitem}){
  IC->all_item_id(\%myconfig, \%$form);
  }
  
  
  adjust->last_invoice(\%myconfig, \%$form);
   $form->{ordnumber}=$form->{lastinvnumber};
   $form->{ordnumber}++;

   
   $form->{nextfocus}="ordnumber";
  &prepare_order;

}


sub edit {
   #####australia modify
 if(!$form->{page} ||	!$form->{pagerows}){
	 $form->{pagerows}=5;
	$form->{page}=1;
 }
  if ($form->{type} eq 'purchase_order') {
    $form->{title} = $locale->text('Goods Adjustment ');
    $form->{vc} = 'vendor';
  }
  if ($form->{type} eq 'sales_order') {
    $form->{title} = $locale->text('Edit Sales Order');
    $form->{vc} = 'customer';
  }
  if ($form->{type} eq 'adjust') {
    $form->{title} = $locale->text('Stock Adjust');
    $form->{vc} = 'customer';
  }

    if ($form->{type} eq 'os') {
    $form->{title} = $locale->text('Opening Stock');
    $form->{vc} = 'customer';
  }
  
  &order_links;
   $form->{nextfocus}="ordnumber";

  &prepare_order;

}


sub order_links {

  # get vendors / customers
 # $form->all_vc(\%myconfig, $form->{vc});

  # retrieve order
  adjust->retrieve_order(\%myconfig, \%$form);

  # build the popup menus
  foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
    if ($ref->{id} == $form->{"$form->{vc}_id"}) {
      $form->{$form->{vc}} = "$ref->{name}--$ref->{id}";
    }
    $form->{"select$form->{vc}"} .= "<option>$ref->{name}--$ref->{id}\n";
  }

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];

  map { $form->{selectcurrency} .= "<option>$_\n" } @curr;

  # forex
  $form->{forex} = $form->{exchangerate};
  $form->{locked} = ($form->datetonum($form->{orddate}, \%myconfig) <= $form->datetonum($form->{closedto}, \%myconfig));

}


sub prepare_order {

  $form->{new_form} = !$form->{id} unless (exists $form->{new_form});

  $form->{format} = "html";
  $form->{media} = "screen";
  $form->{sendmode} = "attachment";
  $form->{copies} = 2;

  if ($form->{id}) {

    map { $form->{$_} =~ s/"/&quot;/g } qw(invnumber shippingpoint notes);

    $form->{creditlimit} = $form->format_amount(\%myconfig, $form->{creditlimit}, 0);
    $form->{creditremaining} = $form->format_amount(\%myconfig, $form->{creditremaining}, 0);

    foreach $ref (@{ $form->{order_details} } ) {
      $i++;
      map { $form->{"${_}_$i"} = $ref->{$_} } keys %{ $ref };
      $form->{"discount_$i"} = $form->format_amount(\%myconfig, $form->{"discount_$i"} * 100);

      ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
      $dec = length $dec;
      $decimalplaces = ($dec > 2) ? $dec : 2;
      
      $form->{"sellprice_$i"} = $form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces);
      $form->{"qty_$i"} = $form->format_amount(\%myconfig, $form->{"qty_$i"});

      map { $form->{"${_}_$i"} =~ s/"/&quot;/g } qw(partnumber description unit);
      $form->{rowcount} = $i;
    }
  } else {
    if ($form->{type} eq 'purchase_order') {
      IR->get_vendor(\%myconfig, \%$form);
    }
    if ($form->{type} eq 'sales_order') {
      IS->get_customer(\%myconfig, \%$form);
    }
  }

  &display_form;

}


sub form_header {

  $form->{taxincluded} = ($form->{taxincluded}) ? "checked" : "";

  if ($form->{type} eq 'purchase_order') {
    $colspan = 6;
  }
  if ($form->{type} eq 'sales_order') {
    $colspan = 7;
  }

  # set option selected
  foreach $item ($form->{vc}, currency) {
    $form->{"select$item"} =~ s/ selected//;
    $form->{"select$item"} =~ s/option>\Q$form->{$item}\E/option selected>$form->{$item}/;
  }
    
  $form->{exchangerate} = $form->format_amount(\%myconfig, $form->{exchangerate});

  $exchangerate = qq|&nbsp;|;
  if ($form->{currency} ne $form->{defaultcurrency}) {
    if ($form->{forex}) {
      $exchangerate = qq|<input type=hidden name=exchangerate value=$form->{exchangerate}>$form->{exchangerate}|;
    } else {
      $exchangerate = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=exchangerate size=10 value=$form->{exchangerate}>|;
    }
  }
  $exchangerate .= qq|
<input type=hidden name=forex value=$form->{forex}>
|;

  
  $vclabel = ucfirst $form->{vc};
  $vclabel = $locale->text($vclabel);
  
  $form->header;
  
  print qq|
<script>
<!--
function stb(){document.myform.$form->{nextfocus}.focus();parent.document.title ="$form->{title}";}

// -->
</script>
<body bgcolor=ffffff  onLoad=stb()>

<form method=post action=$form->{script} name=myform>

<input type=hidden name=id value=$form->{id}>
<input type=hidden name=new_form value=$form->{new_form}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=readonly value=$form->{readonly}>
<input type=hidden name=closedto value=$form->{closedto}>

<input type=hidden name=title value="$form->{title}">

<input type=hidden name=$form->{vc}_id value=$form->{"$form->{vc}_id"}>
<input type=hidden name=discount value=$form->{discount}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=locked value=$form->{locked}>


<table border=0><tr><td>

<table border=1 width=100%>
<tr class=listtop bgcolor=000000><th>
<font color=ffffff>$form->{title}</font></th></tr>

<tr>
<td>

<table cellspacing=0 cellpadding=0>


<input type=hidden name=$form->{vc} value="0--0">

<input type=hidden name=select$form->{vc} value="$form->{"select$form->{vc}"}">

|;


  print qq|

<tr>
  <td colspan=$colspan nowrap>
  <b>|.$locale->text('Adjust Number').qq|</b>&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=10 value="$form->{ordnumber}">

  </td>
</tr>


<tr>
  <td colspan=$colspan nowrap>
  <b>|.$locale->text('Adjust Date').qq|&nbsp;($myconfig{dateformat})</b>&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=orddate size=11 value=$form->{orddate}>&nbsp;<b>
         <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].orddate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
  </td>
</tr>


<input type=hidden name=taxpart value="$form->{taxpart}">
<input type=hidden name=taxservice value="$form->{taxservice}">

<input type=hidden name=taxaccounts value="$form->{taxaccounts}">

|;

  foreach $item (split / /, $form->{taxaccounts}) {
    print qq|
<input type=hidden name="${item}_rate" value=$form->{"${item}_rate"}>
<input type=hidden name="${item}_description" value="$form->{"${item}_description"}">
|;
  }

}


sub form_footer {

  $form->{DF}{$form->{format}} = "checked";
  $form->{OP}{$form->{media}} = "checked";
  $form->{SM}{$form->{sendmode}} = "checked";
  
  $form->{invtotal} = $form->{invsubtotal};

  if (($rows = $form->numtextrows($form->{notes}, 50, 8)) < 2) {
    $rows = 2;
  }
  $notes = qq|<textarea name=notes rows=$rows cols=50 wrap=soft>$form->{notes}</textarea>|;


  if (!$form->{taxincluded}) {
    
    foreach $item (split / /, $form->{taxaccounts}) {
      if ($form->{"${item}_base"}) {
	$form->{invtotal} += $form->{"${item}_total"} = $form->round_amount($form->{"${item}_base"} * $form->{"${item}_rate"}, 2);
	$form->{"${item}_total"} = $form->format_amount(\%myconfig, $form->{"${item}_total"}, 2);
	
	$tax .= qq|
	<tr>
	  <th align=right>$form->{"${item}_description"}</th>
	  <td align=right>$form->{"${item}_total"}</td>
	</tr>
	|;
      }
    }

    $form->{invsubtotal} = $form->format_amount(\%myconfig, $form->{invsubtotal}, 2);
    
    $subtotal = qq|
      <tr>
        <th align=right>|.$locale->text('Subtotal').qq|</th>
        <td align=right>$form->{invsubtotal}</td>
      </tr>
      |;

  }


  $form->{invtotal} = $form->format_amount(\%myconfig, $form->{invtotal}, 2);

  print qq|
<tr>
  <td colspan=$colspan>
    <table>
    <tr>
      <td colspan=2>
      <table>
        $subtotal

	$tax
	
	<tr>
	  <th align=right>|.$locale->text('Total').qq|</th>
	  <td align=right>$form->{invtotal}</td>
        </tr>
	
      </table>
      </td>|,
      
      qq|<td>
        <table>
	  <tr>
	    <th>|.$locale->text('Notes').qq|</th>
          </tr>
	
	  <tr>
	    <td>$notes</td>
	  </tr>
	</table>
      </td>

    </tr>

    </table>

  </td>
</tr>

</table>

</td>
</tr>

</table>
			  <input type=hidden name=action value=update_form2>
|;
   #####australia modify
   
      #####australia modify

 #  if($form->{pagebreak}){
 #  print qq|<br>|;
#		for $j (1 ..(( $i/$form->{pagerows})+1) ) {
#			  print qq|
#			  <input class=submit type=submit name=page value=$j>	  
#			  |;
#		  }
  		print qq|<br>|;
#
#   }

# if(!$form->{readonly}){
#  print qq|

#<br>
#<input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
#    |;
#   if($form->{pagebreak}){
 # 		print qq|<br>|;
#		for $j (1 ..(( $i/$form->{pagerows})+1) ) {
#			  print qq|
#			  <input class=submit type=submit name=page value=' $j '>	  
#			  |;
#		  }
 # 		print qq|<br>|;
#   }
#  print qq|
#<input class=submit type=submit name=action value="|.$locale->text('Save').qq|">
#|;

 #   if ($form->{id}) {
#      print qq|
#<input class=submit type=submit name=action value="|.$locale->text('Delete').qq|">
#|;
 #   }
#}
#######################################333

  if(!$form->{readonly}){
# &print_options;

  $invdate = $form->datetonum($form->{orddate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  
   if ($form->{id}) {
    print qq|
    <input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
    |;
   #####australia modify
   if($form->{pagebreak}){
  		print qq|<br>|;
		for $j (1 ..(( $i/$form->{pagerows})+1) ) {
			  print qq|
			  <input class=submit type=submit name=page value=' $j '>	  
			  |;
		  }
  		print qq|<br>|;
   }
  print qq|
   <input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
|;

    if (!$form->{revtrans}) {
      if (!$form->{locked}) {
	print qq|
	<input class=submit type=submit name=action value="|.$locale->text('Save').qq|">
	<input class=submit type=submit name=action value="|.$locale->text('Delete').qq|">
|;
      }
    }

#    if ($invdate > $closedto) {
#      print qq|
 #     <input class=submit type=submit name=action value="|.$locale->text('Post As New Invoice').qq|">
#|;
#    }

  } else {
    if ($invdate > $closedto) {
      print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
   |;
    #####australia modify
    if($form->{pagebreak}){
		print qq|<br>|;
		for $j (1 ..(( $i/$form->{pagerows})+1) ) {
			  print qq|
			  <input class=submit type=submit name=page value=' $j '>	  
			  |;
		  }
  		print qq|<br>|;
    }
  print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
      <input class=submit type=submit name=action value="|.$locale->text('Save').qq|">
    |;
    }
  }
  }


  print qq| 

</td>
</tr>

</table>

<input type=hidden name=rowcount value=$form->{rowcount}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

</form>
|

.$locale->text('Enter a number or description and click on "Update Form"')
.qq|<br>|
.$locale->text('To remove any items delete the number and click on "Update Form"')

.qq|

</body>
</html>
|;

}

sub save{
	&save_order;	
}

sub delete{
	&delete_order;	
}
sub update{
	&update_form;	
}

   #####australia modify
sub update_form {
  $form->{page}=$form->{focus}/$form->{pagerows};
 #$form->dberror($form->{page});
 ($form->{page},$dec) = split(/\./,$form->{page});
if($dec >=0){
	  $form->{page}++;	  
  }

  
&update_form2;
}
   #####australia modify

sub update_form2 {

  # if there is a new name get new values
  ($null, $vc_id) = split /--/, $form->{$form->{vc}};
  if ($form->{"$form->{vc}_id"} ne $vc_id) {
    # delete tax accounts
    map { delete $form->{"${_}_rate"} } ($form->{taxaccounts});
    
    $form->{"$form->{vc}_id"} = $vc_id;
    if ($form->{type} eq 'purchase_order') {
      IR->get_vendor(\%myconfig, \%$form);
    }
    if ($form->{type} eq 'sales_order') {
      IS->get_customer(\%myconfig, \%$form);
    }
  }

  $buysell = 'buy';
  $buysell = 'sell' if ($form->{vc} eq 'vendor');
  $form->{exchangerate} = $exchangerate if ($form->{forex} = ($exchangerate = $form->check_exchangerate(\%myconfig, $form->{currency}, $form->{orddate}, $buysell)));
  
  $form->{exchangerate} = $form->parse_amount(\%myconfig, $form->{exchangerate});

  my $i = $form->{rowcount};
   #####australia modify

  $form->{focus}=$form->{rowcount};
	$form->{"nextfocus"}  = "partnumber_$i";

  if (($form->{"partnumber_$i"} eq "") && ($form->{"description_$i"} eq "")) {

    &check_form;
    
  } else {
   $form->{"partnumber_$i"} =~ s/'/\\'/g;
$form->{"description_$i"} =~ s/'/\\'/g;

    if ($form->{type} eq 'purchase_order') {
      IR->retrieve_item(\%myconfig, \%$form);
    }
    if ($form->{type} eq 'sales_order') {
      IS->retrieve_item(\%myconfig, \%$form);
    }
    if ($form->{type} eq 'adjust') {
      IS->retrieve_item(\%myconfig, \%$form);
    }
        if ($form->{type} eq 'os') {
      IS->retrieve_item(\%myconfig, \%$form);
    }
    my $rows = scalar @{ $form->{item_list} };
    
    $form->{"discount_$i"} = $form->format_amount(\%myconfig, $form->{discount} * 100);

    if ($rows) {
      $form->{"qty_$i"}                     = 1 unless ($form->{"qty_$i"});
      
      if ($rows > 1) {
	&select_item;
	exit;
      } else {
	map { $form->{item_list}[$i]{$_} =~ s/"/&quot;/g } qw(partnumber description unit);
	map { $form->{"${_}_$i"} = $form->{item_list}[0]{$_} } keys %{ $form->{item_list}[0] };

	($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
	$dec = length $dec;
	$decimalplaces = ($dec > 2) ? $dec : 2;
	
        # if there is an exchange rate adjust sellprice
        if (($form->{exchangerate} * 1) != 0) {
	  $form->{"sellprice_$i"} /= $form->{exchangerate};
	}
		    
	$form->{"sellprice_$i"} = $form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces);
	$form->{"qty_$i"} =  $form->format_amount(\%myconfig, $form->{"qty_$i"});

      }

      &display_form;

    } else {
      # ok, so this is a new part
      # ask if it is a part or service item

      $form->{"id_$i"}		= 0;
      $form->{"unit_$i"}	= $locale->text('ea');

      &new_item;
      
    }
  }
}



sub search2 {
$form->{transdatefrom} =$form->current_date(\%myconfig) if $form->{currentdate};

  if ($form->{type} eq 'purchase_order') {
    $selection = "<option selected>" . $locale->text('All Vendors') ."\n";
    $form->{title} = $locale->text('Stock Adjustment Reports');
    $form->{vc} = 'vendor';
  }
  if ($form->{type} eq 'sales_order') {
    $selection = "<option selected>" . $locale->text('All Customers') ."\n";
    $form->{title} = $locale->text('Sales Orders');
    $form->{vc} = 'customer';
  }
  if ($form->{type} eq 'adjust') {
  #  $selection = "<option selected>" . $locale->text('All Vendors') ."\n";
    $form->{title} = $locale->text('Goods Adjustment');
   # $form->{vc} = 'vendor';
  }

  # setup vendor / customer selection
 # $form->all_vc(\%myconfig, "$form->{vc}");

 # foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
 #   $selection .= "<option>$ref->{name}--$ref->{id}\n";
 # }

 # $vclabel = ucfirst $form->{vc};
 # $vclabel = $locale->text($vclabel);

# $locale->text('Vendor')
# $locale->text('Customer')
  

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script} name=myform>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr><td>

<table>



<input type=hidden name=$form->{vc} value="0--0">



<tr>

<th align=right>|.$locale->text('From').qq|<br></th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11 title=($myconfig{dateformat})>
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
</td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11 title=($myconfig{dateformat})>
  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
</td>

</tr>
<tr>

<th align=right>|.$locale->text('Adjust Number').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=20></td>

</tr>
<tr>

<th align=right>|.$locale->text('Part Number').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=partnumber size=20></td>

</tr>
<input type=hidden name=sort value=transdate>

<tr>
<th align=right>|.$locale->text('Include in Report').qq|</th>
<td colspan=3>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('ID').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Adjust Number').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Adjust Date').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_type" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Type').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_login" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Employee').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_partnumber" class=checkbox type=checkbox value=Y  checked>&nbsp;|.$locale->text('Part Number').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_description" class=checkbox type=checkbox value=Y  checked>&nbsp;|.$locale->text('Description').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_qty" class=checkbox type=checkbox value=Y  checked>&nbsp;|.$locale->text('Quantity').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sellprice" class=checkbox type=checkbox value=Y >&nbsp;|.$locale->text('Sell Price').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_unit" class=checkbox type=checkbox value=Y  checked>&nbsp;|.$locale->text('Unit').qq|

</td>

</tr>

</table>

</td></tr>
</table>

<p>
<input type=hidden name=nextsub value=orders2>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
</form>

<p>|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;

}

sub search {
$form->{transdatefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};
 
  if ($form->{type} eq 'purchase_order') {
    $selection = "<option selected>" . $locale->text('All Vendors') ."\n";
    $form->{title} = $locale->text('Stock Adjustment Reports');
    $form->{vc} = 'vendor';
  }
  if ($form->{type} eq 'sales_order') {
    $selection = "<option selected>" . $locale->text('All Customers') ."\n";
    $form->{title} = $locale->text('Sales Orders');
    $form->{vc} = 'customer';
  }
  if ($form->{type} eq 'adjust') {
  #  $selection = "<option selected>" . $locale->text('All Vendors') ."\n";
    $form->{title} = $locale->text('Stock Adjustment Reports');
   # $form->{vc} = 'vendor';
  }
  # setup vendor / customer selection
 # $form->all_vc(\%myconfig, "$form->{vc}");

 # foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
 #   $selection .= "<option>$ref->{name}--$ref->{id}\n";
 # }

 # $vclabel = ucfirst $form->{vc};
 # $vclabel = $locale->text($vclabel);

# $locale->text('Vendor')
# $locale->text('Customer')
  

  $form->header;

  print qq|
  <script>
<!--

function stb(){
        parent.document.title ="$form->{title}";
}


// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>

<form method=post action=$form->{script} name=myform>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr><td>

<table>



<input type=hidden name=$form->{vc} value="0--0">

<tr>

<th align=right>|.$locale->text('Adjust Number').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=20></td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11 title=($myconfig{dateformat}) value=$form->{transdatefrom}>
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
</td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11 title=($myconfig{dateformat})  value=$form->{transdateto}>
  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
</td>

</tr>

<input type=hidden name=sort value=transdate>

<tr>
<th align=right>|.$locale->text('Include in Report').qq|</th>
<td colspan=3>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('ID').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Adjust Number').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_type" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Type').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Adjust Date').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_login" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Employee').qq|

</td>

</tr>

</table>

</td></tr>
</table>

<p>
<input type=hidden name=nextsub value=orders>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
</form>

<p>|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;

}

sub orders2 {
    $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
    
  # split vendor / customer
  ($name, $form->{"$form->{vc}_id"}) = split(/--/, $form->{$form->{vc}});

  # $form->{..._id} is needed in OE->transactions
  $data ="";
  $from = "";

  adjust->transactions2(\%myconfig, \%$form);

  # construct href
  $href = "$form->{script}?path=$form->{path}&action=orders&type=$form->{type}&vc=$form->{vc}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&ordnumber=" . $form->escape($form->{ordnumber}) . "&$form->{vc}=" . $form->escape($form->{$form->{vc}});

  # construct callback
  $name =~ s/&/_/g;
  $callback = "$form->{script}?path=$form->{path}&action=orders&type=$form->{type}&vc=$form->{vc}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&ordnumber=$form->{ordnumber}&$form->{vc}=$name";

  @columns = $form->sort_columns(qw(id transdate type ordnumber login partnumber description  qty sellprice unit  ));

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
      $data .= "";
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }


  if ($form->{vc} eq 'vendor') {
    $form->{title} = $locale->text('Stock Adjustment Reports');
    $name = $locale->text('Vendor');
  }
  if ($form->{vc} eq 'customer') {
    $form->{title} = $locale->text('Sales Orders');
    $name = $locale->text('Customer');
  }
  if ($form->{type} eq 'adjust') {
  #  $selection = "<option selected>" . $locale->text('All Vendors') ."\n";
    $form->{title} = $locale->text('Stock Adjustment Reports');
   # $form->{vc} = 'vendor';
  }
  $column_header{id} = qq|<th><a class=listheading href=$href&sort=id><font color=ffffff>|.$locale->text('ID').qq|</font></a></th>|;
  $column_header{transdate} = qq|<th><a class=listheading href=$href&sort=transdate><font color=ffffff>|.$locale->text('Adjust Date').qq|</font></a></th>|;
  $column_header{type} = qq|<th><a class=listheading href=$href&sort=transdate><font color=ffffff>|.$locale->text('Type').qq|</font></a></th>|;
  $column_header{ordnumber} = qq|<th><a class=listheading href=$href&sort=ordnumber><font color=ffffff>|.$locale->text('Adjust Number').qq|</font></a></th>|;
  $column_header{login} = qq|<th><font color=ffffff>|.$locale->text('Employee').qq|</font></th>|;
  $column_header{partnumber} = qq|<th><font color=ffffff>|.$locale->text('Partnumber').qq|</font></th>|;
  $column_header{description} = qq|<th><font color=ffffff>|.$locale->text('Description').qq|</font></th>|;
  $column_header{qty} = qq|<th><font color=ffffff>|.$locale->text('Qty').qq|</font></th>|;
  $column_header{sellprice} = qq|<th><font color=ffffff>|.$locale->text('SellpPrice').qq|</font></th>|;
  $column_header{unit} = qq|<th><font color=ffffff>|.$locale->text('Unit').qq|</font></th>|;


  ($name) = split /--/, $form->{name};
  if ($form->{"$form->{vc}_id"}) {
    $option .= $name;
  }
  if ($form->{transdatefrom}) {
    $option .= "\n<br>".$locale->text('From')." ".$locale->date(\%myconfig, $form->{transdatefrom}, 1);
  }
  if ($form->{transdateto}) {
    $option .= "\n<br>".$locale->text('To')." ".$locale->date(\%myconfig, $form->{transdateto}, 1);
  }

  $form->header;

  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$option</td></tr>

<tr class=listheading bgcolor=336666>|;

map { print "\n$column_header{$_}" } @column_index;

print qq|
</tr>
|;

  # add sort and escape callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  if (@{ $form->{OE} }) {
    $sameitem = $form->{OE}->[0]->{$form->{sort}};
  }

  foreach $oe (@{ $form->{OE} }) {

    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $oe->{$form->{sort}}) {
	&subtotal;
	$sameitem = $oe->{$form->{sort}};
      }
    }

    #$column_data{netamount} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{netamount}, 2, "&nbsp;")."</td>";
    #$column_data{tax} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{amount} - $oe->{netamount}, 2, "&nbsp;")."</td>";
    #$column_data{amount} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{amount}, 2, "&nbsp;")."</td>";

    $totalnetamount += $oe->{netamount};
    $totalamount += $oe->{amount};
    $totalpaid += $oe->{paid};

    $subtotalnetamount += $oe->{netamount};
    $subtotalamount += $oe->{amount};
$type = uc $oe->{type};
    $column_data{id} = "<td>$oe->{id}</td>";
    $column_data{transdate} = "<td nowrap>$oe->{transdate}&nbsp;</td>";
    $column_data{type} = "<td>$type</td>";
    $column_data{ordnumber} = "<td><a href=adjust.pl?path=$form->{path}&readonly=1&action=edit&type=$oe->{type}&id=$oe->{id}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$oe->{ordnumber}</a></td>";
    $column_data{login} = "<td>$oe->{login}</td>";
    $column_data{partnumber} = "<td>$oe->{partnumber}</td>";
    $column_data{description} = "<td>$oe->{description}</td>";
    $column_data{qty} = "<td>$oe->{qty}</td>";
    $column_data{sellprice} = "<td>$oe->{sellprice}</td>";
    $column_data{unit} = "<td>$oe->{unit}</td>";

    $i++; $i %= 2;
    print "<tr class=listrow$i $mouseaction[$i] >";

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
    </tr>
|;

  }

  if ($form->{l_subtotal} eq 'Y') {
    &subtotal;
  }

  # print totals
  print qq|<tr class=listtotal bgcolor=000000>|;
  
  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;

 # $column_data{netamount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;")."</font></th>";
 # $column_data{tax} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount - $totalnetamount, 2, "&nbsp;")."</font></th>";
 # $column_data{amount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."</font></th>";

  map { print "\n$column_data{$_}" } @column_index;

  print qq|
  </tr>
  
</table>

<p>|.$locale->text('Click on table headers to sort table').qq|
<br>|.$locale->text('Click on Adjust number to edit transaction')

.qq|

</body>
</html>
|;

}


sub orders {
    $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
    
  # split vendor / customer
  ($name, $form->{"$form->{vc}_id"}) = split(/--/, $form->{$form->{vc}});

  # $form->{..._id} is needed in OE->transactions
  $data ="";
  $from = "";

  adjust->transactions(\%myconfig, \%$form);

  # construct href
  $href = "$form->{script}?path=$form->{path}&action=orders&type=$form->{type}&vc=$form->{vc}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&ordnumber=" . $form->escape($form->{ordnumber}) . "&$form->{vc}=" . $form->escape($form->{$form->{vc}});

  # construct callback
  $name =~ s/&/_/g;
  $callback = "$form->{script}?path=$form->{path}&action=orders&type=$form->{type}&vc=$form->{vc}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&ordnumber=$form->{ordnumber}&$form->{vc}=$name";

  @columns = $form->sort_columns(qw(id transdate type ordnumber login   ));

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
      $data .= "";
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }


  if ($form->{vc} eq 'vendor') {
    $form->{title} = $locale->text('Stock Adjustment Reports');
    $name = $locale->text('Vendor');
  }
  if ($form->{vc} eq 'customer') {
    $form->{title} = $locale->text('Sales Orders');
    $name = $locale->text('Customer');
  }
  if ($form->{type} eq 'adjust') {
  #  $selection = "<option selected>" . $locale->text('All Vendors') ."\n";
        $form->{title} = $locale->text('Stock Adjustment Reports');
# $form->{vc} = 'vendor';
  }
  $column_header{id} = qq|<th><a class=listheading href=$href&sort=id><font color=ffffff>|.$locale->text('ID').qq|</font></a></th>|;
  $column_header{type} = qq|<th><a class=listheading href=$href&sort=transdate><font color=ffffff>|.$locale->text('Type').qq|</font></a></th>|;
  $column_header{transdate} = qq|<th><a class=listheading href=$href&sort=transdate><font color=ffffff>|.$locale->text('Adjust Date').qq|</font></a></th>|;
  $column_header{ordnumber} = qq|<th><a class=listheading href=$href&sort=ordnumber><font color=ffffff>|.$locale->text('Adjust Number').qq|</font></a></th>|;
  $column_header{login} = qq|<th><font color=ffffff>|.$locale->text('Employee').qq|</font></th>|;


  ($name) = split /--/, $form->{name};
  if ($form->{"$form->{vc}_id"}) {
    $option .= $name;
  }
  if ($form->{transdatefrom}) {
    $option .= "\n<br>".$locale->text('From')." ".$locale->date(\%myconfig, $form->{transdatefrom}, 1);
  }
  if ($form->{transdateto}) {
    $option .= "\n<br>".$locale->text('To')." ".$locale->date(\%myconfig, $form->{transdateto}, 1);
  }

  $form->header;

  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$option</td></tr>

<tr class=listheading bgcolor=336666>|;

map { print "\n$column_header{$_}" } @column_index;

print qq|
</tr>
|;

  # add sort and escape callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  if (@{ $form->{OE} }) {
    $sameitem = $form->{OE}->[0]->{$form->{sort}};
  }

  foreach $oe (@{ $form->{OE} }) {

    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $oe->{$form->{sort}}) {
	&subtotal;
	$sameitem = $oe->{$form->{sort}};
      }
    }

    #$column_data{netamount} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{netamount}, 2, "&nbsp;")."</td>";
    #$column_data{tax} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{amount} - $oe->{netamount}, 2, "&nbsp;")."</td>";
    #$column_data{amount} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{amount}, 2, "&nbsp;")."</td>";

    $totalnetamount += $oe->{netamount};
    $totalamount += $oe->{amount};
    $totalpaid += $oe->{paid};

    $subtotalnetamount += $oe->{netamount};
    $subtotalamount += $oe->{amount};

    $type = uc $oe->{type};
    
    $column_data{id} = "<td>$oe->{id}</td>";
    $column_data{transdate} = "<td>$oe->{transdate}&nbsp;</td>";
    $column_data{type} = "<td>$type&nbsp;</td>";
    $column_data{ordnumber} = "<td><a href=adjust.pl?path=$form->{path}&action=edit&type=$form->{type}&id=$oe->{id}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$oe->{ordnumber}</a></td>";
    $column_data{login} = "<td>$oe->{login}</td>";

    $i++; $i %= 2;
    print "<tr class=listrow$i $mouseaction[$i] >";

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
    </tr>
|;

  }

  if ($form->{l_subtotal} eq 'Y') {
    &subtotal;
  }

  # print totals
  print qq|<tr class=listtotal bgcolor=000000>|;
  
  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;

 # $column_data{netamount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;")."</font></th>";
 # $column_data{tax} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount - $totalnetamount, 2, "&nbsp;")."</font></th>";
 # $column_data{amount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."</font></th>";

  map { print "\n$column_data{$_}" } @column_index;

  print qq|
  </tr>
  
</table>

<p>|.$locale->text('Click on table headers to sort table').qq|
<br>|.$locale->text('Click on Adjust number to edit transaction')

.qq|

</body>
</html>
|;

}





sub save_order {

  $form->isblank("ordnumber", $locale->text('Order Number missing!'));
  $form->isblank("orddate", $locale->text('Order Date missing!'));

  $form->isblank("exchangerate", $locale->text('Exchangerate missing!')) if ($form->{currency} ne $form->{defaultcurrency});

  &validate_items;

  # if the vendor changed get new values
  ($null, $vc_id) = split /--/, $form->{$form->{vc}};
  if ($form->{"$form->{vc}_id"} ne $vc_id) {
    $form->{"$form->{vc}_id"} = $vc_id;
    if ($form->{vc} eq 'vendor') {
      IR->get_vendor(\%myconfig, \%$form);
    }
    if ($form->{vc} eq 'customer') {
      IS->get_customer(\%myconfig, \%$form);
    }
  }


  # this is for the notes section for the [email] Subject
  $form->{label} = ($form->{type} eq 'sales_order') ? $locale->text('Sales Order') : $locale->text('Purchase Order');


  if (adjust->save_order(\%myconfig, \%$form)) {
    if ($form->{new_form}) {

      $form->header;
      
      print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

      print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Do you want to create another Order?').qq|</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes').qq|">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('No').qq|">

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

</form>

</body>
</html>
|;

    } else {
      $form->isposted(1);
    }

  }

}

sub delete_order {

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  # delete action variable
  delete $form->{action};

  foreach $key (keys %$form) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Are you sure you want to delete Adjust Number').qq| $form->{adnumber}</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Invoice').qq|">
</form>
|;


}



sub yes_delete_invoice {

  $form->isdeleted(adjust->delete_invoice(\%myconfig, \%$form));

}




