#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors: Antonio Gallardo <agssa@ibw.com.ni>
#                Benjamin Lee <benjaminlee@consultant.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# backend code for reports
#
#======================================================================

package RP;

$decimalplaces = 0;
sub get_cogs {
  my ($dbh,  $myconfig, $accno, $form) = @_;
  my $query = qq|select 'Purchase' as description,sum(amount) as amount from acc_trans,chart where acc_trans.chart_id=chart.id and  category = 'A' and link like '%PL_cogs%' and amount < 0
  		union all
		select 'Closing Stock' as description,sum(amount)*-1 as amount from acc_trans,chart where acc_trans.chart_id=chart.id and  category = 'A' and  link like '%PL_cogs%'
		;
|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  while ($ref = $sth->fetchrow_hashref(NAME_lc)) {
      push(@{$form->{cogs_account}}, "$ref->{description}");

    # add amount or a -
    push(@{$form->{cogs_this_period}}, $form->format_amount($myconfig, $ref->{amount}* -1, $decimalplaces, "- "));
  }
  

}

sub check_cogs {
  my ($dbh,  $accno, $form) = @_;
  my $query = qq|SELECT * FROM  chart WHERE accno='$accno' and link like '%PL_cogs%' 
  		|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  $ref = $sth->fetchrow_hashref(NAME_lc);
  
  return 1 if ($ref);
  return 0;

}



sub income_statement {
  my ($self, $myconfig, $form) = @_;
  $decimalplaces=2;
  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $last_period = 0;
  my $where = '1 = 1';

  # if there are any dates construct a where
  if ($form->{fromdate} || $form->{todate}) {
    if ($form->{fromdate}) {
      $where .= " AND transdate >= '$form->{fromdate}'";
    }
    if ($form->{todate}) {
      $where .= " AND transdate <= '$form->{todate}'";
    }
  }
    if ($form->{project}) {
      $where .= " AND project = '$form->{project}'";
    }
    if ($form->{sub}) {
      $where .= " AND sub = '$form->{sub}'";
    }
  foreach my $key (qw(I E S P)) {
    &get_accounts($dbh, $last_period, $where, $key, $form);
  }
  
  $where = '1 = 1';
  # if there are any compare dates
  if ($form->{comparefromdate} || $form->{comparetodate}) {
    if ($form->{comparefromdate}) {
      $where .= " AND transdate >= '$form->{comparefromdate}'";
    }
    if ($form->{comparetodate}) {
      $where .= " AND transdate <= '$form->{comparetodate}'";
    }

    $last_period = 1;

    foreach $key (qw(I E S P)) {
      &get_accounts($dbh, $last_period, $where, $key, $form);
    }
  }  

  
  # disconnect


  # now we got $form->{I}{accno}{ }
  # and $form->{E}{accno}{  }
  # build income accounts
  
  foreach $key (sort keys %{ $form->{I} }) {
    # push description onto array
    push(@{$form->{income_account}}, "$form->{I}{$key}{description}");
    
    # keep running total
    $form->{total_income_this_period} += $form->{I}{$key}{this};
    
    # add amount or a -
    push(@{$form->{income_this_period}}, $form->format_amount($myconfig, $form->{I}{$key}{this}, $decimalplaces, "- "));
    
    # add amount or - for last period
    if ($last_period) {
      $form->{total_income_last_period} += $form->{I}{$key}{last};

      push(@{$form->{income_last_period}}, $form->format_amount($myconfig,$form->{I}{$key}{last}, $decimalplaces, "- "));
    }
  }

  
    # build cogs accounts

    foreach $key (sort keys %{ $form->{S} }) {
    # push description onto array
    
     if( &check_cogs($dbh, $form->{S}{$key}{accno}, $form) ){
	     if(!$cogs){
       		&get_cogs($dbh, $myconfig,$form->{S}{$key}{accno}, $form);
		$cogs='true';
	     }
    
     }else{
     push(@{$form->{cogs_account}}, "$form->{S}{$key}{description}");
     # keep running total
    
    # add amount or a -
    push(@{$form->{cogs_this_period}}, $form->format_amount($myconfig, $form->{S}{$key}{this}* -1, $decimalplaces, "- "));
     }
     
    $form->{total_cogs_this_period} += ($form->{S}{$key}{this}* -1);
    
    # add amount or - for last period
    if ($last_period) {
     if( &check_cogs($dbh, $form->{S}{$key}{accno}, $form)){
	     if(!$cogs){
       		&get_cogs($dbh, $form->{S}{$key}{accno}, $form);
   		$cogs='true';
	     }
 
     }else{

      push(@{$form->{cogs_last_period}}, $form->format_amount($myconfig,$form->{S}{$key}{last}* -1, $decimalplaces, "- "));
     }
            $form->{total_cogs_last_period} += ($form->{S}{$key}{last}* -1);
    }
  }
  

  # build expense accounts
  foreach $key (sort keys %{ $form->{E} }) {
    push(@{$form->{expense_account}}, "$form->{E}{$key}{description}");
    
    $form->{total_expenses_this_period} += ($form->{E}{$key}{this} * -1);

    push(@{$form->{expenses_this_period}}, $form->format_amount($myconfig, $form->{E}{$key}{this} * -1, $decimalplaces, "- "));
    
    if ($last_period) {
      $form->{total_expenses_last_period} += ($form->{E}{$key}{last} * -1);

      push(@{$form->{expenses_last_period}}, $form->format_amount($myconfig, $form->{E}{$key}{last} * -1, $decimalplaces, "- "));
    }
  }

    # build P/L accounts
  foreach $key (sort keys %{ $form->{P} }) {
    push(@{$form->{profit_account}}, "$form->{P}{$key}{description}");
    
    $form->{total_profit_this_period} += ($form->{P}{$key}{this} );

    push(@{$form->{profit_this_period}}, $form->format_amount($myconfig, $form->{P}{$key}{this} , $decimalplaces, "- "));
    
    if ($last_period) {
      $form->{total_profit_last_period} += ($form->{P}{$key}{last} );

      push(@{$form->{profit_last_period}}, $form->format_amount($myconfig, $form->{P}{$key}{last} , $decimalplaces, "- "));
    }
  }
  
  
  # totals for income and expenses
  $form->{total_income_this_period} = $form->round_amount($form->{total_income_this_period}, $decimalplaces);
  $form->{total_expenses_this_period} = $form->round_amount($form->{total_expenses_this_period}, $decimalplaces);
  $form->{total_cogs_this_period} = $form->round_amount($form->{total_cogs_this_period}, $decimalplaces);

  # total for income/loss
  $form->{total_this_period} = $form->{total_income_this_period} -$form->{total_cogs_this_period}- $form->{total_expenses_this_period};
  $form->{gross_profit_this_period} = $form->{total_income_this_period} -$form->{total_cogs_this_period};
   $form->{nettotal_profit_this_period} = $form->{total_this_period} +$form->{total_profit_this_period};
 
  if ($last_period) {
    # total for income/loss
    $form->{total_last_period} = $form->format_amount($myconfig, $form->{total_income_last_period} -$form->{total_cogs_last_period}- $form->{total_expenses_last_period}, $decimalplaces, "- ");
    $form->{gross_profit_last_period} = $form->format_amount($myconfig, $form->{total_income_last_period} -$form->{total_cogs_last_period}, $decimalplaces, "- ");
    
    # totals for income and expenses for last_period
    $form->{total_income_last_period} = $form->format_amount($myconfig, $form->{total_income_last_period}, $decimalplaces, "- ");
    $form->{total_expenses_last_period} = $form->format_amount($myconfig, $form->{total_expenses_last_period}, $decimalplaces, "- ");
    $form->{total_cogs_last_period} = $form->format_amount($myconfig, $form->{total_cogs_last_period}, $decimalplaces, "- ");
  $form->{nettotal_profit_last_period} = $form->{total_last_period} +$form->{total_profit_last_period};

  }


  $form->{total_income_this_period} = $form->format_amount($myconfig,$form->{total_income_this_period}, $decimalplaces, "- ");
   $form->{total_expenses_this_period} = $form->format_amount($myconfig,$form->{total_expenses_this_period}, $decimalplaces, "- ");
  $form->{total_cogs_this_period} = $form->format_amount($myconfig,$form->{total_cogs_this_period}, $decimalplaces, "- ");
  $form->{total_this_period} = $form->format_amount($myconfig,$form->{total_this_period}, $decimalplaces, "- ");
  $form->{gross_profit_this_period} = $form->format_amount($myconfig,$form->{gross_profit_this_period}, $decimalplaces, "- ");
  $form->{nettotal_profit_this_period} = $form->format_amount($myconfig,$form->{nettotal_profit_this_period}, $decimalplaces, "- ");
  $dbh->disconnect;

}

sub get_fa {
  my ( $dbh, $form,$myconfig,$where) = @_;
  
  # connect to database
 # my $dbh = $form->dbconnect($myconfig);

 $where2='1=1';
# $where2.= " and extract ( year from transdate) = '$myconfig{fy}')" if ($myconfig{fy});

 $where2.= " and extract ( year from transdate) =extract ( year from date '$form->{asofdate}')" if ($form->{asofdate});

#  my $query = qq|SELECT c.accno,c.id,max(fa.cost) as cost, sum(fa.accum) as accum                 
#                 FROM 	fixedasset as fa,  chart as c
#	         WHERE 	fa.chart_id=c.id
#		 and $where2
#		 and c.accno=$form->{accno} group by accno,c.id|;

my $query = qq|
select * from (
select *,amount-accum as value from (select chart_id, accno,description,sum(amount)*-1 AS AMOUNT from acc_trans,chart where chart.id=acc_trans.chart_id and chart.category='F' and AMOUNT < 0 and $where group by chart_id,accno,description) as foo0
left outer join(
select chart_id,accno as accno1,sum(amount) AS ACCUM from acc_trans,chart where chart.id=acc_trans.chart_id and chart.category='F' and AMOUNT > 0 and $where group by chart_id,accno,description
) as foo1 on (foo1.accno1 like foo0.accno\|\|'%' )
 ) as foo ;

|;


  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  #$form->dberror($myconfig{fy});
  while (my $fa1 = $sth->fetchrow_hashref(NAME_lc)) {
   # push @{ $form->{fixed_asset} }, $fa1;
  #$form->{cost}=$fa1->{cost};
  #$form->{accum}=$fa1->{accum};

  # push description onto array
   push(@{$form->{fixed_asset_account}}, "$fa1->{description}");
   push(@{$form->{fixed_asset_accno}}, "$fa1->{accno}");
 
   my $dbh = $form->dbconnect($myconfig);

  $dbh->disconnect;

   push(@{$form->{fixed_asset_cost}}, $form->format_amount($myconfig, $fa1->{amount}, $decimalplaces, "- "));
   push(@{$form->{fixed_asset_accum}},  $form->format_amount($myconfig, $fa1->{accum}, $decimalplaces, "- "));

   $form->{total_fixed_assets_this_period} += $fa1->{amount}-$fa1->{accum};
    $form->{total_fixed_assets_cost_this_period} += $fa1->{amount} ;
    $form->{total_fixed_assets_accum_this_period} += $fa1->{accum} ;

    push(@{$form->{fixed_asset_this_period}}, $form->format_amount($myconfig, $fa1->{amount}-$fa1->{accum}, $decimalplaces, "- "));
    push(@{$form->{fixed_asset_cost_this_period}}, $form->format_amount($myconfig, $fa1->{cost}, $decimalplaces, "- "));
    push(@{$form->{fixed_asset_accum_this_period}}, $form->format_amount($myconfig, $fa1->{accum} , $decimalplaces, "- "));

    if ($last_period) {
      $form->{total_fixed_assets_last_period} += $form->{F}{$key}{last} * -1;

      push(@{$form->{fixed_asset_last_period}}, $form->format_amount($myconfig, $form->{F}{$key}{last} * -1, $decimalplaces, "- "));
    }

  }

  
  
  $sth->finish;
 
}

sub balance_sheet {
  my ($self, $myconfig, $form) = @_;
  $decimalplaces=2;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $last_period = 0;
  my $where = '1 = 1';

  # if there are any dates construct a where
  if ($form->{asofdate}) {
    $where .= " AND transdate <= '$form->{asofdate}'";

    $form->{this_period} = "$form->{asofdate}";
    $form->{period} = "$form->{asofdate}";
    
  }
    if ($form->{project}) {
      $where .= " AND project = '$form->{project}'";
    }
    if ($form->{sub}) {
      $where .= " AND sub = '$form->{sub}'";
    }

  foreach my $key (qw(A L Q D C F)) {
    &get_accounts($dbh, $last_period, $where, $key, $form);
  }

#  $where = '1 = 1';
  # if there are any compare dates
  if ($form->{compareasofdate}) {
    $where .= " AND transdate <= '$form->{compareasofdate}'";

    $last_period = 1;
    foreach $key (qw(A L Q D C F)) {
      &get_accounts($dbh, $last_period, $where, $key, $form);
    }
  
    $form->{last_period} = "$form->{compareasofdate}";

  }  

  
  # disconnect
  &get_fa($dbh, $form,$myconfig,$where);
  $dbh->disconnect;


 	$x=0;
	$x1=0;



  
  # now we got $form->{A}{accno}{ }    assets
  # and $form->{L}{accno}{ }           liabilities
  # and $form->{Q}{accno}{ }           equity
  # build asset accounts
  
  foreach $key (sort keys %{ $form->{A} }) {
    # push description onto array
    push(@{$form->{asset_account}}, "$form->{A}{$key}{description}");
    push(@{$form->{asset_accno}}, "$form->{A}{$key}{accno}");

    $form->{total_assets_this_period} += $form->{A}{$key}{this} * -1;

    push(@{$form->{asset_this_period}}, $form->format_amount($myconfig, $form->{A}{$key}{this} * -1, $decimalplaces, "- "));

    if ($last_period) {
      $form->{total_assets_last_period} += $form->{A}{$key}{last} * -1;

      push(@{$form->{asset_last_period}}, $form->format_amount($myconfig, $form->{A}{$key}{last} * -1, $decimalplaces, "- "));
    }
  }
################ different;
##build fix Asset account
    #push(@{$form->{asset_account}}, "$form->{D}{$key}{description}");
 #
#	$x=0;
#	$x1=0;

#  foreach $key (sort keys %{ $form->{F} }) {
    # push description onto array
#   push(@{$form->{fixed_asset_account}}, "$form->{F}{$key}{description}");
#   push(@{$form->{fixed_asset_accno}}, "$form->{F}{$key}{accno}");
# $form->{accno}=$form->{F}{$key}{accno};

#   my $dbh = $form->dbconnect($myconfig);
#  &get_fa($dbh, $form,$myconfig,$where);

#  $dbh->disconnect;

#   push(@{$form->{fixed_asset_cost}}, "$form->{cost}");
#   push(@{$form->{fixed_asset_accum}}, "$form->{accum}");

#    $form->{total_fixed_assets_this_period} += $form->{F}{$key}{this} * -1;
 #   $form->{total_fixed_assets_cost_this_period} += $form->{cost} ;
#    $form->{total_fixed_assets_accum_this_period} += $form->{accum} ;

#    push(@{$form->{fixed_asset_this_period}}, $form->format_amount($myconfig, $form->{F}{$key}{this} * -1, $decimalplaces, "- "));
#    push(@{$form->{fixed_asset_cost_this_period}}, $form->format_amount($myconfig, $form->{cost}, $decimalplaces, "- "));
#    push(@{$form->{fixed_asset_accum_this_period}}, $form->format_amount($myconfig, $form->{accum} , $decimalplaces, "- "));

#    if ($last_period) {
#      $form->{total_fixed_assets_last_period} += $form->{F}{$key}{last} * -1;

#      push(@{$form->{fixed_asset_last_period}}, $form->format_amount($myconfig, $form->{F}{$key}{last} * -1, $decimalplaces, "- "));
#    }

#  }

################33

################ different;
##build debtors account
    #push(@{$form->{asset_account}}, "$form->{D}{$key}{description}");
    push(@{$form->{asset_account}}, "Debtors");

	$x=0;
	$x1=0;

  foreach $key (sort keys %{ $form->{D} }) {
    # push description onto array

    $form->{total_assets_this_period} += $form->{D}{$key}{this} * -1;
    $x +=  $form->{D}{$key}{this} * -1;


    if ($last_period) {
      $form->{total_assets_last_period} += $form->{D}{$key}{last} * -1;
   	$x1 +=  $form->{D}{$key}{last} * -1;

    }
  }
      push(@{$form->{asset_last_period}}, $form->format_amount($myconfig,$x1 , $decimalplaces, "- "));
    push(@{$form->{asset_this_period}}, $form->format_amount($myconfig, $x, $decimalplaces, "- "));

################33

  # build liability accounts
  foreach $key (sort keys %{ $form->{L} }) {
    push(@{$form->{liability_account}}, "$form->{L}{$key}{description}");
    push(@{$form->{liability_accno}}, "$form->{L}{$key}{accno}");
   $form->{total_liabilities_this_period} += $form->{L}{$key}{this};

    push(@{$form->{liability_this_period}}, $form->format_amount($myconfig, $form->{L}{$key}{this}, $decimalplaces, "- "));

    if ($last_period) {
      $form->{total_liabilities_last_period} += $form->{L}{$key}{last};

      push(@{$form->{liability_last_period}}, $form->format_amount($myconfig, $form->{L}{$key}{last}, $decimalplaces, "- "));
    }
  }

##################################
  # build creditor accounts
    push(@{$form->{liability_account}}, "Creditors");
 	$x=0;
	$x1=0;
 foreach $key (sort keys %{ $form->{C} }) {
    $form->{total_liabilities_this_period} += $form->{C}{$key}{this};
    $x +=  $form->{C}{$key}{this} ;


    if ($last_period) {
      $form->{total_liabilities_last_period} += $form->{C}{$key}{last};
		$x1 +=$form->{C}{$key}{last};
    }
  }
      push(@{$form->{liability_last_period}}, $form->format_amount($myconfig,$x1 , $decimalplaces, "- "));
    push(@{$form->{liability_this_period}}, $form->format_amount($myconfig, $x, $decimalplaces, "- "));

################################
  # build equity accounts
  foreach $key (sort keys %{ $form->{Q} }) {
    push(@{$form->{equity_account}}, "$form->{Q}{$key}{description}");
    push(@{$form->{equity_accno}}, "$form->{Q}{$key}{accno}");
    $form->{total_equity_this_period} += $form->{Q}{$key}{this};

    push(@{$form->{equity_this_period}}, $form->format_amount($myconfig, $form->{Q}{$key}{this}, $decimalplaces, "- "));
    
    if ($last_period) {
      $form->{total_equity_last_period} += $form->{Q}{$key}{last};

      push(@{$form->{equity_last_period}}, $form->format_amount($myconfig, $form->{Q}{$key}{last}, $decimalplaces, "- "));
    }
  }

  
  # totals for assets, liabilities
  $form->{total_net_assets_this_period}=$form->round_amount(($form->{total_assets_this_period}-$form->{total_liabilities_this_period}+$form->{total_fixed_assets_this_period}), $decimalplaces);
 $form->{working_capital_this_period}=$form->round_amount(($form->{total_assets_this_period}-$form->{total_liabilities_this_period}), $decimalplaces);
  $form->{total_assets_this_period} = $form->round_amount($form->{total_assets_this_period}, $decimalplaces);
  $form->{total_liabilities_this_period} = $form->round_amount($form->{total_liabilities_this_period}, $decimalplaces);

  # calculate retained earnings
  $form->{earnings_this_period} = $form->{total_assets_this_period} - $form->{total_liabilities_this_period} - $form->{total_equity_this_period}+$form->{total_fixed_assets_this_period};

  push(@{$form->{equity_this_period}}, $form->format_amount($myconfig, $form->{earnings_this_period}, $decimalplaces, "- "));
  
  $form->{total_equity_this_period} = $form->round_amount($form->{total_equity_this_period} + $form->{earnings_this_period}, $decimalplaces);
  
  # add liability + equity
  $form->{total_this_period} = $form->format_amount($myconfig, $form->{total_liabilities_this_period} + $form->{total_equity_this_period}, $decimalplaces, "- ");


  if ($last_period) {
    # totals for assets, liabilities
    $form->{total_assets_last_period} = $form->round_amount($form->{total_assets_last_period}, $decimalplaces);
    $form->{total_liabilities_last_period} = $form->round_amount($form->{total_liabilities_last_period}, $decimalplaces);
    

    # calculate retained earnings
    $form->{earnings_last_period} = $form->{total_assets_last_period} - $form->{total_liabilities_last_period} - $form->{total_equity_last_period};

    push(@{$form->{equity_last_period}}, $form->format_amount($myconfig,$form->{earnings_last_period}, $decimalplaces, "- "));
    
    $form->{total_equity_last_period} = $form->round_amount($form->{total_equity_last_period} + $form->{earnings_last_period}, $decimalplaces);

    # add liability + equity
    $form->{total_last_period} = $form->format_amount($myconfig, $form->{total_liabilities_last_period} + $form->{total_equity_last_period}, $decimalplaces, "- ");

  }

  
 $form->{total_net_assets_this_period} = $form->format_amount($myconfig, $form->{total_net_assets_this_period}, $decimalplaces, "- ") if ($form->{total_net_assets_this_period} != 0);

  $form->{working_capital_this_period} = $form->format_amount($myconfig, $form->{working_capital_this_period}, $decimalplaces, "- ") if ($form->{working_capital_this_period} != 0);

  $form->{total_fixed_assets_this_period} = $form->format_amount($myconfig, $form->{total_fixed_assets_this_period}, $decimalplaces, "- ") if ($form->{total_fixed_assets_this_period} != 0);
  $form->{total_fixed_assets_last_period} = $form->format_amount($myconfig, $form->{total_fixed_assets_last_period}, $decimalplaces, "- ") if ($form->{total_fixed_assets_last_period} != 0);
  $form->{total_fixed_assets_cost_this_period} = $form->format_amount($myconfig, $form->{total_fixed_assets_cost_this_period}, $decimalplaces, "- ") if ($form->{total_fixed_assets_cost_this_period} != 0);
  $form->{total_fixed_assets_accum_this_period} = $form->format_amount($myconfig, $form->{total_fixed_assets_accum_this_period}, $decimalplaces, "- ") if ($form->{total_fixed_assets_accum_this_period} != 0);

  $form->{total_liabilities_last_period} = $form->format_amount($myconfig, $form->{total_liabilities_last_period}, $decimalplaces, "- ") if ($form->{total_liabilities_last_period} != 0);
  
  $form->{total_equity_last_period} = $form->format_amount($myconfig, $form->{total_equity_last_period}, $decimalplaces, "- ") if ($form->{total_equity_last_period} != 0);
  
  $form->{total_assets_last_period} = $form->format_amount($myconfig, $form->{total_assets_last_period}, $decimalplaces, "- ") if ($form->{total_assets_last_period} != 0);
  
  $form->{total_assets_this_period} = $form->format_amount($myconfig, $form->{total_assets_this_period}, $decimalplaces, "- ");
  
  $form->{total_liabilities_this_period} = $form->format_amount($myconfig, $form->{total_liabilities_this_period}, $decimalplaces, "- ");
  
  $form->{total_equity_this_period} = $form->format_amount($myconfig, $form->{total_equity_this_period}, $decimalplaces, "- ");
  
}


sub get_accounts {
  my ($dbh, $last_period, $where, $category, $form) = @_;

  my $query = qq|SELECT chart.accno, sum(acc_trans.amount) AS amount, 
                 chart.description
                 FROM acc_trans, chart
                 WHERE $where
	         AND chart.id = acc_trans.chart_id
 	         AND chart.category = '$category'
		 GROUP BY accno, description|;

  if ($form->{accounttype} eq 'gifi') {
    $query = qq|SELECT g.accno, SUM(a.amount) AS amount,
                g.description
		FROM gifi g, chart c, acc_trans a
		WHERE $where
		AND c.id = a.chart_id
      		AND c.gifi_accno = g.accno
		And c.category = '$category'
		GROUP BY g.accno, g.description
	     UNION
		SELECT '' AS accno, SUM(a.amount) AS amount,
		'' AS description,'' as link
		FROM gifi g, chart c, acc_trans a
		WHERE $where
		AND c.id = a.chart_id
		AND c.gifi_accno = ''
		And c.category = '$category'|;
  }

  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    next if ($form->round_amount($ref->{amount}, $decimalplaces) == 0);
    
    $form->{$category}{$ref->{accno}}{description} = $ref->{description};
    $form->{$category}{$ref->{accno}}{accno} = $ref->{accno};
    if ($last_period) {
      $form->{$category}{$ref->{accno}}{last} = $ref->{amount};
    } else {
      $form->{$category}{$ref->{accno}}{this} = $ref->{amount};
    }
  }

  $sth->finish;

  if ($form->{l_heading}) {
    # add headings
    $query = qq|SELECT accno, description
		FROM chart
		WHERE chart.category = '$category'
		AND charttype = 'H'
		ORDER by accno|;

    if ($form->{accounttype} eq 'gifi') {
      $query = qq|SELECT g.accno, g.description
		  FROM gifi g, chart c
		  WHERE c.category = '$category'
		  AND c.charttype = 'H'
		  AND c.gifi_accno = g.accno
		  ORDER BY accno|;
    }

    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
    
    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      $form->{$category}{$ref->{accno}}{description} = $ref->{description};
    }

    $sth->finish;
  }
  
}



# Antonio Gallardo
# for each account that have transactions on the period
# the sub get his Initial Balance (IB) and the sum of
# credits and debits for the period.
sub trial_balance_details {
  my ($self, $myconfig, $form) = @_;

  my $dbh = $form->dbconnect($myconfig);

  # if there are any dates construct a where
  my $where = "1 = 1";
  
  if ($form->{fromdate} || $form->{todate}) {
    if ($form->{fromdate}) {
      $where .= " AND transdate >= '$form->{fromdate}'";
    }
    if ($form->{todate}) {
      $where .= " AND transdate <= '$form->{todate}'";
    }
  }
    if ($form->{project}) {
      $where .= " AND project = '$form->{project}'";
    }
    if ($form->{sub}) {
      $where .= " AND sub = '$form->{sub}'";
    }

  # First we take the sum of debit and credit of each account in the period
  $query = qq|SELECT accno, description,count(accno) as count, charttype, category,
              SUM(amount) AS amount
              FROM chart, acc_trans
              WHERE chart.id = acc_trans.chart_id
	      AND $where
              GROUP BY accno, description, charttype, category
           UNION
	      SELECT accno, description,0.0 as count, charttype, category, 0.0 AS amount
	      FROM chart
	      WHERE charttype = 'H'
	      ORDER BY accno|;

  if ($form->{accounttype} eq 'gifi') {
    $query = qq|SELECT g.accno, g.description, c.charttype, c.category,
		SUM(a.amount) AS amount
		FROM gifi g, chart c, acc_trans a
		WHERE c.id = a.chart_id
      		AND c.gifi_accno = g.accno
		AND $where
		GROUP BY g.accno, g.description, c.charttype, c.category
	     UNION
		SELECT '' AS accno, '' AS description, 'A' AS charttype, 'X' AS category,
		SUM(a.amount) AS amount
		FROM chart c, acc_trans a
		WHERE c.id = a.chart_id
		AND c.gifi_accno = ''
		AND $where
	     UNION
		SELECT g.accno, g.description, c.charttype, c.category, 0.0 AS amount
		FROM gifi g, chart c
		WHERE c.charttype = 'H'
		AND c.gifi_accno = g.accno
		ORDER BY accno|;
  }


  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  # calculate the debit and credit in the period
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    $ref->{amount} = $form->round_amount($ref->{amount}, 2);
    next if ($ref->{charttype} eq 'A' && $ref->{amount} == 0);
    if ($ref->{amount} < 0) {
      $ref->{debit} = -$ref->{amount};
    } else {
      $ref->{credit} = $ref->{amount};
    }
    push @{ $form->{TB} }, $ref;
  }

  $sth->finish;
  $dbh->disconnect;
  
}


sub aging {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);
  my $invoice = ($form->{arap} eq 'ar') ? 'is' : 'ir';
  
  $form->{todate} = $form->current_date($myconfig) unless ($form->{todate});

  my $where = ($form->{"$form->{ct}_id"}) ? qq|$form->{ct}.id = $form->{"$form->{ct}_id"}| : "1 = 1";
  if ($form->{"$form->{ct}code"}) {
	    $where .= " AND $form->{ct}code like '$form->{'$form->{ct}code'}%' ";

   }
   
      if ($form->{locationcode}) {
	    $where .= " AND locationcode like '$form->{locationcode}%' ";

   }
   
         if ($form->{salesperson}) {
	    $where .= " AND salesperson like '$form->{salesperson}%' ";

   }
   
  # select outstanding vendors or customers, depends on $ct
  my $query = qq|SELECT DISTINCT $form->{ct}.id, name
                 FROM $form->{ct}, $form->{arap}
		 WHERE $where
                 AND $form->{arap}.$form->{ct}_id = $form->{ct}.id
                 AND paid != amount
                 AND (transdate <= date '$form->{todate}')
                 ORDER BY name|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror;


  # for each company that has some stuff outstanding
  while ( my ($outstanding_entity_id) = $sth->fetchrow_array ) {

    $query = qq|

-- between 0-30 days

	
	SELECT $form->{ct}.id, $form->{ct}.name,
	"invnumber", "transdate","ordnumber",
	(amount - paid) as "c0", 0.00 as "c30", 0.00 as "c60", 0.00 as "c90",
	"duedate", invoice, $form->{arap}.id AS transid
	FROM $form->{arap}, $form->{ct} 
	WHERE paid != amount
	AND $form->{arap}.$form->{ct}_id = $form->{ct}.id
	AND $form->{ct}.id = $outstanding_entity_id
	AND (
	        transdate <= (date '$form->{todate}' - interval '0 days') 
	        AND transdate >= (date '$form->{todate}' - interval '30 days')
	    )
	
	UNION
	SELECT $form->{ct}.id, $form->{ct}.name,
	"ordnumber" as invnumber, "transdate", '',
	(amount*-1 )  as "c0", 0.00 as "c30", 0.00 as "c60", 0.00 as "c90",
	"transdate", true, creditnote.id AS transid
	FROM creditnote, $form->{ct} 
	WHERE  creditnote.$form->{ct}_id = $form->{ct}.id 
	AND $form->{ct}.id = $outstanding_entity_id
	AND (
		transdate < (date '$form->{todate}' - interval '0 days') 
		AND transdate >= (date '$form->{todate}' - interval '30 days')
		)
	
	UNION
-- between 31-60 days
	SELECT $form->{ct}.id, $form->{ct}.name,
	"ordnumber", "transdate", '',
	0.00 as "c0", (amount*-1 ) as "c30", 0.00 as "c60", 0.00 as "c90",
	"transdate", true, creditnote.id AS transid
	FROM creditnote, $form->{ct} 
	WHERE  creditnote.$form->{ct}_id = $form->{ct}.id 
	AND $form->{ct}.id = $outstanding_entity_id
	AND (
		transdate < (date '$form->{todate}' - interval '30 days') 
		AND transdate >= (date '$form->{todate}' - interval '60 days')
		)
	
	UNION
	
	SELECT $form->{ct}.id, $form->{ct}.name,
	"invnumber", "transdate", "ordnumber",
	0.00 as "c0", (amount - paid) as "c30", 0.00 as "c60", 0.00 as "c90",
	"duedate", invoice, $form->{arap}.id AS transid
	FROM $form->{arap}, $form->{ct}
	WHERE paid != amount 
	AND $form->{arap}.$form->{ct}_id = $form->{ct}.id 
	AND $form->{ct}.id = $outstanding_entity_id
	AND (
		transdate < (date '$form->{todate}' - interval '30 days') 
		AND transdate >= (date '$form->{todate}' - interval '60 days')
		)

	UNION
  
-- between 61-90 days
	SELECT $form->{ct}.id, $form->{ct}.name,
	"ordnumber", "transdate", '',
	0.00 as "c0", 0.00 as "c30", (amount*-1 ) as "c60", 0.00 as "c90",
	"transdate", true, creditnote.id AS transid
	FROM creditnote, $form->{ct} 
	WHERE  creditnote.$form->{ct}_id = $form->{ct}.id 
	AND $form->{ct}.id = $outstanding_entity_id
	AND (
		transdate < (date '$form->{todate}' - interval '60 days') 
		AND transdate >= (date '$form->{todate}' - interval '90 days')
		)	
	UNION
	
	SELECT $form->{ct}.id, $form->{ct}.name,
	"invnumber", "transdate", "ordnumber",
	0.00 as "c0", 0.00 as "c30", (amount - paid) as "c60", 0.00 as "c90",
	"duedate", invoice, $form->{arap}.id AS transid
	FROM $form->{arap}, $form->{ct} 
	WHERE paid != amount
	AND $form->{arap}.$form->{ct}_id = $form->{ct}.id 
	AND $form->{ct}.id = $outstanding_entity_id
	AND (
		transdate < (date '$form->{todate}' - interval '60 days') 
		AND transdate >= (date '$form->{todate}' - interval '90 days')
		)

	UNION
  
-- over 90 days
	SELECT $form->{ct}.id, $form->{ct}.name,
	"ordnumber", "transdate", '',
	0.00 as "c0", 0.00 as "c30", 0.00 as "c60", (amount*-1 ) as "c90",
	"transdate", true, creditnote.id AS transid
	FROM creditnote, $form->{ct} 
	WHERE  creditnote.$form->{ct}_id = $form->{ct}.id 
	AND $form->{ct}.id = $outstanding_entity_id
	AND transdate < (date '$form->{todate}' - interval '90 days') 
	
	UNION
	
	SELECT $form->{ct}.id, $form->{ct}.name,
	"invnumber", "transdate", "ordnumber",
	0.00 as "c0", 0.00 as "c30", 0.00 as "c60", (amount - paid) as "c90",
	"duedate", invoice, $form->{arap}.id AS transid
	FROM $form->{arap}, $form->{ct} 
	WHERE paid != amount
	AND $form->{arap}.$form->{ct}_id = $form->{ct}.id 
	AND $form->{ct}.id = $outstanding_entity_id
	AND transdate < (date '$form->{todate}' - interval '90 days') 

	ORDER BY
  
  id, invnumber, transdate
  
		|;

    if($form->{summary}){
    	$query = qq| select id,name,sum(c0) as c0,sum(c30) as c30,sum(c60) as c60,sum(c90) as c90 from ($query) as foo group by id,name|;
    }
    my $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
#$form->dberror( $form->{AG} );
    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      $ref->{module} = ($ref->{invoice}) ? $invoice : $form->{arap};
      push @{ $form->{AG} }, $ref;
    }
    
    $sth->finish;

  }

  $sth->finish;
  # disconnect
  $dbh->disconnect;

}


sub get_taxaccounts {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get tax accounts
  my $query = qq|SELECT accno, description
                 FROM chart
		 WHERE link LIKE '%CT_tax%'
                 ORDER BY accno|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror;

  while ( my ($accno, $description) = $sth->fetchrow_array ) {
    push @{ $form->{taxaccounts} }, "$accno--$description";
  }
  $sth->finish;

  # get gifi tax accounts
  my $query = qq|SELECT DISTINCT ON (g.accno) g.accno, g.description
                 FROM gifi g, chart c
		 WHERE g.accno = c.gifi_accno
		 AND c.link LIKE '%CT_tax%'
                 ORDER BY accno|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror;

  while ( my ($accno, $description) = $sth->fetchrow_array ) {
    push @{ $form->{gifi_taxaccounts} }, "$accno--$description";
  }
  $sth->finish;

  $dbh->disconnect;

}



sub tax_report {

  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # build WHERE
  my $where = qq|WHERE ac.trans_id = a.id
	         AND ac.chart_id = ch.id|;
		 

  if ($form->{accno} =~ /^gifi_/) {
    my ($null, $accno) = split /_/, $form->{accno};
    $where .= qq|
                 AND ch.gifi_accno = '$accno'|;
  } else {
    $where .= qq|
		 AND ch.accno = '$form->{accno}'|;
  }

  my $table;
  
  if ($form->{db} eq 'ar') {
    $where .= " AND n.id = a.customer_id";
    $table = "customer";
  }
  if ($form->{db} eq 'ap') {
    $where .= " AND n.id = a.vendor_id";
    $table = "vendor";
  }

  # if there are any dates construct a where
  if ($form->{fromdate} || $form->{todate}) {
    if ($form->{fromdate}) {
      $where .= " AND ac.transdate >= '$form->{fromdate}'";
    }
    if ($form->{todate}) {
      $where .= " AND ac.transdate <= '$form->{todate}'";
    }
  }

  
  my $query = qq|SELECT a.id, a.invoice, ac.transdate, a.invnumber,
                        n.name, a.netamount,|;
  my $sortorder = join ', ', $form->sort_columns(qw(transdate invnumber name));
  $sortorder = $form->{sort} unless $sortorder;
  
  if ($form->{db} eq 'ar') {
    $query .= " ac.amount AS tax";
  }
  if ($form->{db} eq 'ap') {
    $query .= " ac.amount * -1 AS tax";
  }

  $query .= qq|
               FROM acc_trans ac, "$form->{db}" a, "$table" n, chart ch
	       $where
	       ORDER by $sortorder|;

  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while ( my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{TR} }, $ref;
  }

  $sth->finish;
  $dbh->disconnect;

}


1;


