/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class TriggerResultSet
extends SingleRowResultSet {
    private ArrayList m_tupleChanges;
    private final TupleDesc m_tupleDesc;
    private final Tuple m_tuple;
    private final boolean m_readOnly;

    public TriggerResultSet(TupleDesc tupleDesc, Tuple tuple, boolean bl) throws SQLException {
        this.m_tupleDesc = tupleDesc;
        this.m_tuple = tuple;
        this.m_readOnly = bl;
    }

    public void cancelRowUpdates() throws SQLException {
        this.m_tupleChanges = null;
    }

    public int getConcurrency() throws SQLException {
        return this.m_readOnly ? 1007 : 1008;
    }

    public boolean rowUpdated() throws SQLException {
        return this.m_tupleChanges != null;
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (this.m_readOnly) {
            throw new UnsupportedFeatureException("ResultSet is read-only");
        }
        if (this.m_tupleChanges == null) {
            this.m_tupleChanges = new ArrayList();
        }
        this.m_tupleChanges.add(new Integer(n));
        this.m_tupleChanges.add(object);
    }

    public Object[] getChangeIndexesAndValues() {
        ArrayList arrayList = this.m_tupleChanges;
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (arrayList.size() == 0) {
            return null;
        }
        int[] nArray = new int[n /= 2];
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)arrayList.get(n2++);
            objectArray[i] = arrayList.get(n2++);
        }
        return new Object[]{this.m_tuple, nArray, objectArray};
    }

    protected Object getObjectValue(int n) throws SQLException {
        ArrayList arrayList = this.m_tupleChanges;
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (int i = 0; i < n2; i += 2) {
                if (n != (Integer)arrayList.get(i)) continue;
                return arrayList.get(i + 1);
            }
        }
        return this.m_tuple.getObject(this.getTupleDesc(), n);
    }

    protected final TupleDesc getTupleDesc() {
        return this.m_tupleDesc;
    }
}

