<?php

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");

/* form has been submitted, try to send the message */
if (match_referer() && isset($HTTP_POST_VARS) && !isset($from_menu)) {
	$frm = $HTTP_POST_VARS;
	$errormsg = validate_form($frm, $errors, $usertype);

	if (empty($errormsg)) {
		send_form($frm);

		$DOC_TITLE = "Contact_Successful";
		include ("$CFG->dirroot" . "/header.php");
		$t = new Template();
		$t->set_file(array("page" => "templates/" . $SESSION["lang"] . "/contact_success.ihtml"));
		$t->set_var("firstpage", "$CFG->firstpage");
		$t->pparse("out", "page");
		include ("$CFG->dirroot" . "/footer.php");
		die;
	}
} else if (is_logged_in()) {
	$qid = new PGM_Sql;
	$frm = load_user_profile(&$qid);
	$frm["name"] = $frm["firstname"] . " " . $frm["lastname"];
}

$DOC_TITLE = "Contact_Us";
include ("$CFG->dirroot" . "/header.php");
include ("$CFG->dirroot" . "/form_header.php");
if (empty($errormsg)) {	// we are loading the form for the first time
	$frm["acceptadvert"] = 1;
}

$t = new Template();
$t->set_file(array("page" => "templates/contact_form.ihtml"));
include ("$CFG->localelangdir" . "/global-common.inc.php");
include ("$CFG->localelangdir" . "/global-users.inc.php");
$t->set_var("ME", $ME);
$t->set_var("star", return_star());
$t->set_var(array(
	"frm_name"		=> ov($frm["name"]),
	"errors_name"		=> errmsg($errors->name),
	"frm_address"		=> ov($frm["address"]),
	"errors_address"	=> errmsg($errors->address),
	"frm_number"		=> ov($frm["number"]),
	"errors_number"		=> errmsg($errors->number),
	"frm_city"		=> ov($frm["city"]),
	"errors_city"		=> errmsg($errors->city),
	"frm_country"		=> ov($frm["country"]),
	"errors_country"	=> errmsg($errors->country),
	"frm_zip_code"		=> ov($frm["zip_code"]),
	"errors_zip_code"	=> errmsg($errors->zip_code),
	"frm_phone"		=> ov($frm["phone"]),
	"errors_phone"		=> errmsg($errors->phone),
	"frm_fax"		=> ov($frm["fax"]),
	"errors_fax"		=> errmsg($errors->fax),
	"frm_mobilephone"	=> ov($frm["mobilephone"]),
	"errors_mobilephone"	=> errmsg($errors->mobilephone),
	"frm_email"		=> ov($frm["email"]),
	"errors_email"		=> errmsg($errors->email),
	"frm_authdata"		=> $frm["authdata"] ? "checked" : "",
	"frm_acceptadvert"	=> $frm["acceptadvert"] ? "checked" : "",
	"frm_message"		=> ov($frm["message"]),
	"errors_message"	=> errmsg($errors->message),
));
$t->pparse("out", "page");

include ("$CFG->dirroot" . "/footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_form(&$frm, &$errors) {
/* validate the contact form, and return the error messages in a string.  if
 * the string is empty, then there are no errors */

	global $CFG, $SESSION;

	$errors = new Object;
	$msg = "";

	validate_name($frm["name"], &$errors, &$msg);
	validate_address($frm["address"], &$errors, &$msg);
	validate_number($frm["number"], &$errors, &$msg);
	validate_city($frm["city"], &$errors, &$msg);
	validate_country($frm["country"], &$errors, &$msg);
	validate_zip_code($frm["zip_code"], &$errors, &$msg);
	validate_phone($frm["phone"], &$errors, &$msg);
	validate_fax($frm["fax"], &$errors, &$msg);
	validate_mobilephone($frm["mobilephone"], &$errors, &$msg);
	validate_email($frm["email"], &$errors, &$msg);
	validate_message($frm["message"], &$errors, &$msg);

	return $msg;
}

function send_form(&$frm) {

	global $CFG, $SESSION;
	global $subject_contact, $contact, $yes;
	include ($CFG->globalerror);

	$emailbody = "";
	$emailbody .= $contact[NameOrCompanyName] . stripslashes($frm["name"]);
	$emailbody .= "\n\n" . $contact[Address] . "\n" . stripslashes($frm["address"]);
	$emailbody .= " " . stripslashes($frm["number"]);
	$emailbody .= "\n" . stripslashes($frm["city"]);
	$emailbody .= "\n" . stripslashes($frm["country"]);
	$emailbody .= "\n" .   $frm["zip_code_lang"] . ": " . stripslashes($frm["zip_code"]);
	$emailbody .= "\n\n" . $contact[Phone] . $frm["phone"];
	$emailbody .= "\n\n" . $contact[Fax] . $frm["fax"];
	$emailbody .= "\n\n" . $contact[MobilePhone] . $frm["mobilephone"];
	$emailbody .= "\n\n" . $contact[EMail] . $frm["email"];
	$emailbody .= "\n\n" . $contact[AuthData];
	if ($frm["authdata"]) $emailbody .= strtoupper($yes);
	$emailbody .= "\n\n" . $contact[AuthAdvert];
	if ($frm["acceptadvert"]) $emailbody .= strtoupper($yes);
	$emailbody .= "\n\n" . $contact[Message] . "\n\n" . stripslashes($frm["message"]) . "\n";

	mail(
		"$CFG->seller_fullname <$CFG->seller_email>",
		$subject_contact,
		$emailbody,
		"From: $CFG->support");
}

?>
