<?php

/* orders.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();

$qid = new PGM_Sql;
$qid_order = new PGM_Sql;
$qid_items = new PGM_Sql;
$qid_user = new PGM_Sql;

$DOC_TITLE = "Orders_Log_cc";
include ("$CFG->dirroot" . "/header.php");

switch (nvl($mode)) {
	case "details" :
		print_order_details($id, $SESSION["user"]["username"]);
		break;

	default :
		print_order_list($SESSION["user"]["username"]);
		break;
}

include ("$CFG->dirroot" . "/footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function print_order_details($id, $username) {
/* loads up the details for an order and displays it */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number;
//	include ($CFG->globalerror);
	include ("$CFG->localedir" . $SESSION["lang"] . "/global-names.inc.php");
	global $qid_order, $qid_items, $qid_user;

	$qid_order->Query("
		SELECT o.*, os.name AS state_name
		FROM orderscc o, orders_states os
		WHERE o.state_id = os.id AND o.id = '$id'
	");
	if ($qid_order->num_rows() < 1) {
		$t = new Template();
		$t->set_file(array("page" => "templates/no_such_order.ihtml"));
		include ("$CFG->localelangdir" . "/global-common.inc.php");
		$t->pparse("out", "page");
		return;
	} else {
		$qid_order->next_record();
	}

	get_order_items(&$qid_items, $id);

	$appoggio = $qid_order->f("username");
	$qid_user->Query("
		SELECT usertype, fiscalcode, email
		FROM users
		WHERE username = '$appoggio'
	");
	$qid_user->next_record();

	$t = new Template();
	$t->set_file(array("page" => "templates/order_details.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-users.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"order_id"		=> ov($id),
		"order_state_name"	=> $qid_order->f("state_name"),
		"order_date"		=> $userday[$qid_order->f("weekday")] . " " . $qid_order->f("day") . " " . $usermonth[$qid_order->f("month")] . " " . $qid_order->f("year"),
		"order_amount"		=> $qid_order->f("amount"),
		"order_famount"		=> formatted_price($qid_order->f("amount")),
		"order_custinfo"	=> nl2br(ov($qid_order->f("custinfo"))),
		"user_fiscalcode"	=> $qid_user->f("fiscalcode"),
		"user_email"		=> $qid_user->f("email"),
		"order_notes"		=> nl2br(ov($qid_order->f("notes")))
	));
	$t->set_block("page", "usertype_pf", "usertype_pf_blck");
	$t->set_var("usertype_pf_blck", "");
	$t->set_block("page", "usertype_az", "usertype_az_blck");
	$t->set_var("usertype_az_blck", "");
	if ($qid_user->f("usertype") == "pf")
		$t->parse("usertype_pf_blck", "usertype_pf", true);
	else
		$t->parse("usertype_az_blck", "usertype_az", true);
	$t->set_block("page", "weight_used", "weight_used_blck");
	$t->set_var(array("weight_used_blck" => ""));
	if ($SESSION["weight_used"])
		$t->parse("weight_used_blck", "weight_used", true);
	$t->set_block("page", "iva_used", "iva_used_blck");
	$t->set_var(array("iva_used_blck" => ""));
	if ($SESSION["iva_used"])
		$t->parse("iva_used_blck", "iva_used", true);
	$t->set_block("page", "item_row", "item_rows");
	$t->set_var("item_rows", "");
		$t->set_block("item_row", "weight_used_row", "weight_used_row_blck");
		$t->set_block("item_row", "iva_used_row", "iva_used_row_blck");
	while ($qid_items->next_record()) {
		$t->set_var("weight_used_row_blck", "");
		$t->set_var("iva_used_row_blck", "");
		$t->set_var(array(
			"prod_curr_price"	=> $qid_items->f("curr_price"),
			"prod_fcurr_price"	=> formatted_price($qid_items->f("curr_price")),
			"prod_purchase_price"	=> $qid_items->f("purchase_price"),
			"prod_fpurchase_price"	=> formatted_price($qid_items->f("purchase_price")),
			"prod_qty"		=> $qid_items->f("qty"),
			"prod_total"		=> $qid_items->f("total"),
			"prod_ftotal"		=> formatted_price($qid_items->f("total"))
		));
		$appoggio = ($qid_items->f("lname") != "" && $qid_items->f("name") == $qid_items->f("oiname")) ? ov($qid_items->f("lname")) : ov($qid_items->f("oiname"));
		if ($qid_items->f("name") != $qid_items->f("oiname"))
			$appoggio = "<div class=\"warning\">" . $appoggio . "</div>";
		if ($qid_items->f("name") != "")
			$appoggio = "<a href=\"" . "$CFG->wwwroot" . "/admin/products.php?mode=details&product_id=" . $qid_items->f("product_id") . "\">" . $appoggio . "</a>";
		$t->set_var("prod_name", $appoggio);
		if ($SESSION["weight_used"]) {
			$t->set_var(array(
				"prod_purchase_weight"	=> $qid_items->f("purchase_weight"),
				"prod_fpurchase_weight"	=> formatted_weight ($qid_items->f("purchase_weight"))
			));
			$t->parse("weight_used_row_blck", "weight_used_row", true);
		}
		if ($SESSION["iva_used"]) {
			$t->set_var("prod_purchase_iva", $qid_items->f("purchase_iva"));
			$t->parse("iva_used_row_blck", "iva_used_row", true);
		}
		$t->parse("item_rows", "item_row", true);
	}
	$t->set_block("page", "delivery_used", "delivery_used_blck");
	$t->set_var(array("delivery_used_blck" => ""));
	if ($SESSION["delivery_used"]) {
		$t->set_var(array(
			"order_delivery"	=> $qid_order->f("delivery"),
			"order_fdelivery"	=> formatted_price($qid_order->f("delivery"))
		));
		$t->parse("delivery_used_blck", "delivery_used", true);
	}
	$t->pparse("out", "page");
}

function print_order_list($username) {
/* reads a list of orders from the database and displays them, we will use
 * a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
//	global $page_number, $datachanged;
	global $HTTP_GET_VARS;
//	include ($CFG->globalerror);
	include ("$CFG->localedir" . $SESSION["lang"] . "/global-names.inc.php");
	global $qid;

	if (!isset($HTTP_GET_VARS["page_number"]) || $HTTP_GET_VARS["datachanged"]) {
		$qid->Query("
			SELECT o.*, os.name AS state_name
			FROM orderscc o, orders_states os
			WHERE o.state_id = os.id AND username = '$username'
			ORDER BY os.name, o.id ASC
  		");

		$SESSION["numr"] = $qid->num_rows();
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$qid->next_record();
			$SESSION["orderscc"][$i]["id"] = $qid->f("id");
			$SESSION["orderscc"][$i]["date"] = $userday[$qid->f("weekday")] . " " . $qid->f("day") . " " . $usermonth[$qid->f("month")] . " " . $qid->f("year");
			$SESSION["orderscc"][$i]["custinfo"] = $qid->f("custinfo");
			$SESSION["orderscc"][$i]["amount"] = $qid->f("amount");
			$SESSION["orderscc"][$i]["notes"] = $qid->f("notes");
			$SESSION["orderscc"][$i]["state_name"] = $qid->f("state_name");
		}
		if (!isset($HTTP_GET_VARS["page_number"])) {
			$page_number = 1;
		} else $page_number = $HTTP_GET_VARS["page_number"];
	} else $page_number = $HTTP_GET_VARS["page_number"];

	if ($SESSION["numr"] > $SESSION["orders_per_page"]) {
		$first = ($page_number-1)*$SESSION["orders_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["orders_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["orders_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["orders_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	if ($SESSION["numr"] == 0) {
		$t = new Template();
		$t->set_file(array("page" => "templates/no_orders.ihtml"));
		include ("$CFG->localelangdir" . "/global-common.inc.php");
		$t->pparse("out", "page");
	} else {
		$t = new Template();
		$t->set_file(array("page" => "templates/ordercc_list.ihtml"));
		include ("$CFG->localelangdir" . "/global-common.inc.php");
		$t->set_var("ME", $ME);
		$t->set_block("page", "pages_links_top", "pages_links_top_blck");
		$t->set_var("pages_links_top_blck", "");
		$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
		$t->set_var("pages_links_bottom_blck", "");
		if ($num_pages > 1) {
			$summary_report .= " " . $on . " " . $num_pages . " " . $pages;
			include ("pages_links.php");
			$t->set_var("pages_links", $pages_links);
			$t->parse("pages_links_top_blck", "pages_links_top", true);
			$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
			$t->set_var("page_number", $page_number);
		}
		$t->set_block("page", "item_row", "item_rows");
		$t->set_var("item_rows", "");
		for ($i=$first; $i<=$last; $i++) {
			$t->set_var(array(
				"session_order_id"		=> ov($SESSION["orderscc"][$i]["id"]),
				"session_order_state_name"	=> ov($SESSION["orderscc"][$i]["state_name"]),
				"session_order_date"		=> $SESSION["orderscc"][$i]["date"],
				"session_order_amount"		=> $SESSION["ordersca"][$i]["amount"],
				"session_order_famount"		=> formatted_price($SESSION["orderscc"][$i]["amount"])
			));
			$t->parse("item_rows", "item_row", true);
		}
		$t->pparse("out", "page");
	}
}

?>
