<?php
/* products.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();
require_priv("admin");
require ("$CFG->libdir" . "/" . "$CFG->dbms" . "_adminqueries.inc.php");

$qid = new PGM_Sql;

$DOC_TITLE = "Products_Management_i18n";
include ("header.php");

switch (nvl($mode)) {
	case "edit" :
		print_edit_product_form($product_id);
		break;

	case "del" :
		delete_product($product_id);
		break;

	case "update" :
		$errors = new Object;
		$errormsg = "";
		validate_product_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_product_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		validate_product_extended_description($HTTP_POST_VARS["extended_description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_product($product_id, $HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm = $HTTP_POST_VARS;
			$frm["newmode"] = "update";
			$frm["submit_caption"] = "Save_Changes";
			include ("$CFG->dirroot" . "/form_header.php");
			load_product_form_template($frm, $id, $errors);
		}
		break;

	case "import" :
		print_import_products_form();
		break;

	case "update_imp" :
		if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none")
			print_import_products_form();
		else
			import_products($HTTP_POST_FILES);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_product_list();
		break;
}

include ("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function load_product_form_template($frm, $product_id, $errors) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$t = new Template();
	$t->set_file(array("page" => "templates/product_i18n_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"				=> $frm["newmode"],
		"product_id"				=> $product_id,
		"frm_name"				=> ov($frm["name"]),
		"i18n"					=> ov($SESSION["i18n"]),
		"frm_lname"				=> ov($frm["lname"]),
		"errors_name"				=> errmsg($errors->product_name),
		"frm_product_description"		=> ov($frm["description"]),
		"frm_product_ldescription"		=> ov($frm["ldescription"]),
		"errors_product_description"		=> errmsg($errors->product_description),
		"frm_product_extended_description"	=> ov($frm["description"]),
		"frm_product_lextended_description"	=> ov($frm["lextended_description"]),
		"errors_product_extended_description"	=> errmsg($errors->product_extended_description),
		"frm_submit_caption"			=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function print_edit_product_form($product_id) {
/* print a category form so we can edit the selected category */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	/* load up the information for the category */
	get_product_info(&$qid, $product_id);
	$qid->next_record();
	$frm["name"] = $qid->f("name");
	$frm["lname"] = $qid->f("lname");
	$frm["description"] = $qid->f("description");
	$frm["ldescription"] = $qid->f("ldescription");
	$frm["extended_description"] = $qid->f("extended_description");
	$frm["lextended_description"] = $qid->f("lextended_description");

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	load_product_form_template($frm, $product_id, $errors);
}

function delete_product($product_id) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	$qid->Query("
		DELETE FROM products_i18n
		WHERE product_id = '$product_id' AND lang = '$SESSION[i18n]'
	");
	$qid->Query("
		SELECT name FROM products
		WHERE id = '$product_id'
	");
	$qid->next_record();
	$prod->name = $qid->f("name");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/product_i18n_deleted.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"prod_name"	=> ov($prod->name),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function update_product($product_id, $frm) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid->Query("
		DELETE FROM products_i18n
		WHERE product_id = '$product_id' AND lang = '$SESSION[i18n]'
	");
	$qid->Query("
		INSERT INTO products_i18n (product_id, lang, name, description, extended_description)
		VALUES ('$product_id', '$SESSION[i18n]', '$frm[name]', '$frm[product_ldescription]', '$frm[product_lextended_description]')
	");
	$qid->Query("
		SELECT name FROM products
		WHERE id = '$product_id'
	");
	$qid->next_record();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/product_i18n_updated.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"frm_name"	=> ov($qid->f("name")),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function print_product_list() {

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $datachanged;
//	include ($CFG->globalerror);
	global $qid;

	if (!isset($page_number) || $datachanged) {
		get_allproducts_info(&$qid);
		$SESSION["numr"] = $qid->num_rows();
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$qid->next_record();
			$SESSION["products"][$i]["product_id"] = $qid->f("product_id");
			$SESSION["products"][$i]["name"] = $qid->f("name");
			$SESSION["products"][$i]["lname"] = $qid->f("lname");
			$SESSION["products"][$i]["special_level"] = $qid->f("special_level");
			$SESSION["products"][$i]["description"] = $qid->f("description");
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["products_per_page"]) {
		$first = ($page_number-1)*$SESSION["products_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["products_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["products_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["products_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/product_i18n_list.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		include ("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "product_row", "product_rows");
	$t->set_var("product_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
			"session_products_id"			=> $SESSION["products"][$i]["product_id"],
			"session_products_name"			=> ov($SESSION["products"][$i]["name"]),
			"i18n"					=> ov($SESSION["i18n"]),
			"session_products_lname"		=> ov($SESSION["products"][$i]["lname"]),
			"session_products_special_level"	=> $SESSION["products"][$i]["special_level"],
			"session_products_description"		=> ovwbr($SESSION["products"][$i]["description"])
		));
		$t->parse("product_rows", "product_row", true);
	}
	$t->pparse("out", "page");
}

function print_import_products_form() {
/* print the import category form so we can add/update categories from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Button_Label";
	$frm["newmode"] = "update_imp";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"			=> $frm["newmode"],
		"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
		"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function import_products($HTTP_POST_FILES) {
/* Import categories from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->globalerror);
	$errors = new Object;
	global $qid;

	/* Let's open a transaction */
	$qid->begin();

	$fcontents = file ($HTTP_POST_FILES['userfile']['tmp_name']);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
		/* Empty parent = "Top" */
		if (strlen(trim($fldarr[0])) == 0)
			$fldarr[0] = "Top";
		/* dangerous characters quoting */
		for ($i=0; $i<5; $i++)
			$fldarr[$i] = addslashes($fldarr[$i]);

		/* Let's see if the product exists ... */
		$qid->Query("
			SELECT id FROM products WHERE name = '$fldarr[0]'
		");
		if ($qid->num_rows() == 0) {
			/* ... if it doesn't exist let's return an error ... */
			echo $line_num . $Err_ImpProd_i18n . $fldarr[0] . "'.<br>";
		} else {
			/* ... otherwise let's save its ID ... */
			$qid->next_record();
			$pid = $qid->f("id");

			$qid->Query("
				DELETE FROM products_i18n
				WHERE product_id = '$pid' AND lang = '$fldarr[1]'
			");
			$qid->Query("
				INSERT INTO products_i18n (product_id, lang, name, description, extended_description)
				VALUES ('$pid', '$fldarr[1]', '$fldarr[2]', '$fldarr[3]', '$fldarr[4]')
			");
		}
	}

	/* Let's close the transaction */
	$qid->commit();
	
	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
}

?>
