<?php
/* (c) 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */
/* with contribution for the script structure 
   from categories.php (c) 2000 Ying Zhang (ying@zippydesign.com) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();
require_priv("admin");

$qid = new PGM_Sql;

$DOC_TITLE = "Languages";
include ("header.php");

switch (nvl($mode)) {
	case "add" :
		print_add_lang_form();
		break;

	case "edit" :
//		if (!($id == 0))
//			print_edit_lang_form($lang);
// Currently not implemented for safety reasons
			print_lang_list();
		break;

	case "del" :
//		if (!($id == 0))
//			delete_lang($lang);
// Currently not implemented for safety reasons
			print_lang_list();
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_lang(&$qid, $HTTP_POST_VARS["lang"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_lang($HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["lang"] = $HTTP_POST_VARS["lang"];
			$frm["newmode"] = "insert";
			$frm["submit_caption"] = "Add_Lang";
			include ("$CFG->dirroot" . "/form_header.php");
			load_lang_form_template($frm, $errors);
		}
		break;

	case "update" :
//		if ($id == 0)
//			break;
// Currently not implemented for safety reasons
			print_lang_list();
		break;

	case "choose" :
		select_lang($lang);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_lang_list();
		break;
}

include ("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function load_lang_form_template($frm, $errors) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$t = new Template();
	$t->set_file(array("page" => "templates/lang_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"		=> $frm["newmode"],
		"frm_lang"		=> $frm["lang"],
		"errors_lang"		=> errmsg($errors->lang),
		"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function print_add_lang_form() {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	/* set default values for the reset of the fields */
	$frm["newmode"] = "insert";
	$frm["lang"] = "";
	$frm["submit_caption"] = "Add_Lang";

	load_lang_form_template($frm, $errors);
}

function print_edit_lang_form($lang) {
// Currently not implemented for safety reasons
}

function delete_lang($lang) {
// Currently not implemented for safety reasons
}

function insert_lang($frm) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	$qid->Query("INSERT INTO languages (lang) VALUES ('$frm[lang]')");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/lang_added.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"frm_lang"      => ov($frm[lang]),
		"backurl"       => $backurl
	));
	$t->pparse("out", "page");
}

function update_lang($frm) {
// Currently not implemented for safety reasons
}

function select_lang($lang) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$SESSION["i18n"] = $lang;

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/lang_selected.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"frm_lang"      => ov($lang),
		"backurl"       => $backurl
	));
	$t->pparse("out", "page");
}

function print_lang_list() {

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $datachanged;
//	include ($CFG->globalerror);
	global $qid;

	$qid->Query("SELECT lang FROM languages ORDER BY lang");

	$t = new Template();
	$t->set_file(array("page" => "templates/lang_list.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("i18n", $SESSION["i18n"]);
	$t->set_block("page", "lang_row", "lang_rows");
	$t->set_var("lang_rows", "");
	while ($qid->next_record()) {
		$t->set_var("lang", $qid->f("lang"));
		$t->parse("lang_rows", "lang_row", true);
	}
	$t->pparse("out", "page");
}

?>
