<?php
/* (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000 Oleg V. Kalashnikov <oleg@ok.gnu.zp.ua> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */

function get_order_items(&$qid_items, $id) {

	$qid_items->Query("
		SELECT
			 oi.product_id
			,oi.name AS oiname
			,p.name
			,p.price AS curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM	order_items oi, products p
		WHERE	oi.product_id = p.id AND order_id = '$id'
		UNION
		SELECT
			 oi.product_id
			,oi.name AS oiname
			,'' as name
			,0 as curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM order_items oi
		WHERE order_id = '$id' AND
			NOT EXISTS
			(
				SELECT
					id
				FROM products
				WHERE id = oi.product_id
			)
	");
}

function find_products(&$qid, $stringtsf_stripped, $case_sensitive=0, $concatenation) {

	if ($case_sensitive) {
		$l_matches_regex = "~";
	} else {
		$l_matches_regex = "~*";
	}

	$l_array_of_elements = explode(" ",$stringtsf_stripped);
	foreach($l_array_of_elements as $l_search_element){
		if ($l_search_element != "") {
			$l_search_element = ereg_replace ("\.", "[.]", $l_search_element);
			$l_search_condition.="(p.name $l_matches_regex '$l_search_element' OR p.description $l_matches_regex '$l_search_element' OR p.extended_description $l_matches_regex '$l_search_element') $concatenation ";
		}
	}

	if ($concatenation == "OR") {
		$l_search_condition.="FALSE";
	} else {
		$l_search_condition.="TRUE";
	}

//	$qid = new PGM_Sql;
	$qid->Query("
		SELECT p.*, b.name AS bname, i.iva
		FROM products p, brands b, iva i
		WHERE p.brand_id = b.id AND p.iva_id = i.id AND ($l_search_condition) ORDER BY p.name, b.name
	");

//	return $qid;
}

function advanced_find_products(&$qid, $frm) {

	$l_search_condition = "";

	// Prepare for searching products with name within a limited range
	if (!empty($frm["product_name_min"]))
		$l_search_condition = "(p.name >= '$frm[product_name_min]')";
	if (!empty($frm[product_name_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(p.name <= '$frm[product_name_max]')";
	}
	
	// Prepare for searching words in the product name
	$prod_stripped = ereg_replace ("\+", "", $frm[product_name_in]);
	$prod_stripped = ereg_replace ("\.", "[.]", $frm[product_name_in]);
	if (!empty($prod_stripped)) {
		$prod_concatenation = $frm[prod_concatenation];
		$prod_case_sensitive = $frm[prod_case_sensitive];
		if ($prod_case_sensitive) {
			$prod_l_matches_regex = "~";
		} else {
			$prod_l_matches_regex = "~*";
		}

		$l_array_of_elements = explode(" ",$prod_stripped);
		$prod_l_search_condition = "(";
		foreach($l_array_of_elements as $l_search_element) {
			if ($l_search_element != "") 
				$prod_l_search_condition.="(p.name $prod_l_matches_regex '$l_search_element') $prod_concatenation ";
		}

		if ($prod_concatenation == "OR") {
			$prod_l_search_condition.="FALSE)";
		} else {
			$prod_l_search_condition.="TRUE)";
		}
	}
	if (isset($prod_l_search_condition)) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= $prod_l_search_condition;
	}

	if (!empty($frm["brand_id"])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= " brand_id = '$frm[brand_id]' ";
	}

	// Prepare for searching products with description within a limited range
	if (!empty($frm[description_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(p.description >= '$frm[description_min]')";
	}
	if (!empty($frm[description_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(p.description <= '$frm[description_max]')";
	}

	// Prepare for searching words in the product description
	$desc_stripped = ereg_replace ("\+", "", $frm[name_in]);
	$desc_stripped = ereg_replace ("\.", "[.]", $frm[name_in]);
	if (!empty($desc_stripped)) {
		$desc_concatenation = $frm[desc_concatenation];
		$desc_case_sensitive = $frm[desc_case_sensitive];
		if ($desc_case_sensitive) {
			$desc_l_matches_regex = "~";
		} else {
			$desc_l_matches_regex = "~*";
		}

		$l_array_of_elements = explode(" ",$desc_stripped);
		$desc_l_search_condition = "(";
		foreach($l_array_of_elements as $l_search_element) {
			if ($l_search_element != "") 
				$desc_l_search_condition.="(p.description $desc_l_matches_regex '$l_search_element' OR p.extended_description $desc_l_matches_regex '$l_search_element') $desc_concatenation ";
		}

		if ($desc_concatenation == "OR") {
			$desc_l_search_condition.="FALSE)";
		} else {
			$desc_l_search_condition.="TRUE)";
		}
	}
	if (isset($desc_l_search_condition)) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= $desc_l_search_condition;
	}

	// Prepare for searching products with prices within a limited range
	if (!empty($frm[price_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(price >= '$frm[price_min]')";
	}
	if (!empty($frm[price_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(price <= '$frm[price_max]')";
	}

	// Prepare for searching products with discount within a limited range
	if (!empty($frm[discount_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(discount >= '$frm[discount_min]')";
	}
	if (!empty($frm[discount_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(discount <= '$frm[discount_max]')";
	}

	// Prepare for searching products with discount qty within a limited range
	if (!empty($frm[discqty_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(discqty >= '$frm[discqty_min]')";
	}
	if (!empty($frm[discqty_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(discqty <= '$frm[discqty_max]')";
	}

	// Prepare for searching products with weight within a limited range
	if (!empty($frm[weight_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(weight >= '$frm[weight_min]')";
	}
	if (!empty($frm[weight_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(weight <= '$frm[weight_max]')";
	}

//	$qid = new PGM_Sql;
	$qid->Query("
		SELECT p.*, b.name AS bname, i.iva
		FROM products p, brands b, iva i
		WHERE p.brand_id = b.id AND p.iva_id = i.id AND $l_search_condition
		ORDER BY p.name, b.name
	");

//	return $qid;
}

function build_catbrowser(&$qid, &$output, $parent=1, $indent="..") {

	$qid->Query("
		CREATE TEMPORARY TABLE tmp_categories ()
		INHERITS (categories)
	");
	$qid->Query("
		INSERT INTO tmp_categories
		SELECT * FROM categories WHERE id <> 1
	");
	pg_build_catbrowser(&$qid, &$output, $parent=1, $indent="..");
	$qid->Query("DROP TABLE tmp_categories");
}

function pg_build_catbrowser(&$qid, &$output, $parent=1, $indent="..") {

	global $CFG, $SESSION;

//	$qid = new PGM_Sql;
	$qid->Query("
		SELECT id, name
		FROM tmp_categories
		WHERE parent_id = '$parent'
		ORDER BY special_level, name
	");

	$cat = array();
	$numr = $qid->num_rows();
	for ($i=0; $i<$numr; $i++) {
//		$qid->seek($i);
		$qid->next_record();
		$cat[$i]["id"] = $qid->f("id");
		$cat[$i]["name"] = $qid->f("name");
	}
	$qid->Query("
		DELETE FROM tmp_categories
		WHERE parent_id = '$parent'
	");
//	$qid->close();

	for ($i=0; $i<$numr; $i++) {
		$output .= $indent . stripslashes($cat[$i]["name"]) . "^" . "$CFG->wwwroot" . "/shopping/?" . getenv("QUERY_STRING") . "&id=" . $cat[$i]["id"] . "^" . $SESSION["catbrowser_target"] . "\n";
		if ($cat[$i]["id"] != $parent) {
			pg_build_catbrowser(&$qid, $output, $cat[$i]["id"], $indent.".");
		}
	}
}

function build_catbrowser_js(&$qid, &$output, $parent=1, $indent="..") {

	$qid->Query("
		CREATE TEMPORARY TABLE tmp_categories ()
		INHERITS (categories)
	");
	$qid->Query("
		INSERT INTO tmp_categories
		SELECT * FROM categories WHERE id <> 1
	");
	pg_build_catbrowser_js(&$qid, &$output, $parent=1, $indent="..");
	$qid->Query("DROP TABLE tmp_categories");
}

function pg_build_catbrowser_js(&$qid, &$output, $parent=1, $indent="..") {

	global $CFG;

//	global $qid_bcjs;
//	$qid = new PGM_Sql;
	$qid->Query("
		SELECT id, name
		FROM tmp_categories
		WHERE parent_id = '$parent'
		ORDER BY special_level, name
	");
	$cat = array();
	$numr = $qid->num_rows();
	for ($i=0; $i<$numr; $i++) {
//		$qid->seek($i);
		$qid->next_record();
		$cat[$i]["id"] = $qid->f("id");
		$cat[$i]["name"] = $qid->f("name");
	}
	$qid->Query("
		DELETE FROM tmp_categories
		WHERE parent_id = '$parent' AND id <> 1
	");
//	$qid->close();

	for ($i=0; $i<$numr; $i++) {
//		if (getenv("QUERY_STRING") == "")
			$output .= $indent . $cat[$i]["name"] . "^" . "$CFG->wwwroot" . "/shopping/?id=" . $cat[$i]["id"] . "\n";
//		else
//			$output .= $indent . $cat[$i]["name"] . "^" . "$CFG->wwwroot" . "/shopping/?" . getenv("QUERY_STRING") . "&id=" . $cat[$i]["id"] . "\n";
		if ($cat[$i]["id"] != $parent) {
			pg_build_catbrowser_js(&$qid, $output, $cat[$i]["id"], $indent.".");
		}
	}
}

function build_category_tree(&$qid, &$output, &$preselected, $parent=1, $indent="") {

	$qid->Query("
		CREATE TEMPORARY TABLE tmp_categories ()
		INHERITS (categories)
	");
	$qid->Query("
		INSERT INTO tmp_categories
		SELECT * FROM categories
	");
	pg_build_category_tree(&$qid, &$output, &$preselected, $parent=1, $indent="");
	$qid->Query("DROP TABLE tmp_categories");
}

function pg_build_category_tree(&$qid, &$output, &$preselected, $parent=1, $indent="") {
/* recursively go through the category tree, starting at a parent, and
 * drill down, printing options for a selection list box.  preselected
 * items are marked as being selected.  this is not an efficient algorithm
 * because it has to issue one query per category!!  it's only used because it
 * is easy to understand.
 */

//	$qid = new PGM_Sql;
	$qid->Query("
		SELECT id, name
		FROM tmp_categories
		WHERE parent_id = '$parent'
		ORDER BY special_level, name
	");

	$cat = array();
	$numr = $qid->num_rows();
	for ($i=0; $i<$numr; $i++) {
//		$qid->seek($i);
		$qid->next_record();
		$cat[$i]["id"] = $qid->f("id");
		$cat[$i]["name"] = $qid->f("name");
	}
	$qid->Query("
		DELETE FROM tmp_categories
		WHERE parent_id = '$parent'
	");
//	$qid->close();

	for ($i=0; $i<$numr; $i++) {
		$selected = in_array($cat[$i]["id"], $preselected) ? "selected" : "";
		$output .= "<option value=\"" . ov($cat[$i]["id"]) . "\" $selected>" . $indent . ov($cat[$i]["name"]);
		if ($cat[$i]["id"] != $parent) {
			pg_build_category_tree(&$qid, $output, $preselected, $cat[$i]["id"], $indent."&nbsp;&nbsp;");
		}
	}
}

?>
