<?php
/* application.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/* turn on verbose error reporting (15) to see all warnings and errors */
//error_reporting(15);

/* define a generic object */
class object {};

/* setup the configuration object */
$CFG = new object;

$CFG->dbms = "pgsql";	// PostgreSQL
//$CFG->dbms = "mysql";	// MySQL

$CFG->myname = "PgMarket 1.5.2 (development)";

$CFG->wwwroot     = "/~pratesi/pgmarket";	// without an ending "/"
$CFG->dirroot     = "/home/pratesi/public_html/pgmarket";	// without an ending "/"
$CFG->firstpage   = "$CFG->wwwroot" . "/firstpage.php";
$CFG->templatedir = "$CFG->dirroot" . "/templates/";	// with an ending "/"
$CFG->libdir      = "$CFG->dirroot" . "/lib";	// without an ending "/"
$CFG->libwww      = "$CFG->wwwroot" . "/lib";	// without an ending "/"
$CFG->localedir   = "$CFG->dirroot" . "/locale/";	// with an ending "/"
$CFG->productswww = "$CFG->wwwroot" . "/products/";	// with an ending "/"
$CFG->productsdir = "$CFG->dirroot" . "/products/";	// with an ending "/"
$CFG->images      = "$CFG->wwwroot" . "/images/";	// with an ending "/"
$CFG->wordlist    = "$CFG->libdir" . "/wordlist.txt";

$CFG->pnmpath     = "/usr/bin";	// without an ending "/"

$CFG->support     = "pratesi@localhost";	// "Technical support" at PgMarket
$subject_contact = "Contattaci!";
$subject_cash_on_delivery = "Ordine con Pagamento in Contrassegno";
$subject_credit_card = "Ordine con Pagamento con Carta di Credito";
$CFG->seller_fullname = "Marco Pratesi";
$CFG->seller_email = "pratesi@localhost";

/* define database error handling behavior, since we are in development stages
 * we will turn on all the debugging messages to help us troubleshoot */
$DB_DEBUG = true;
$DB_DIE_ON_FAIL = true;

/* load up standard libraries */
require ("$CFG->libdir" . "/stdlib.inc.php");
require ("$CFG->libdir" . "/db_" . "$CFG->dbms" . ".inc.php");	// PHPLib...
require ("$CFG->libdir" . "/" . "$CFG->dbms" . "_queries.inc.php");
require ("$CFG->libdir" . "/pgmarket.inc.php");
require ("$CFG->libdir" . "/cart.inc.php");
require ("$CFG->libdir" . "/template.inc.php");
require ("$CFG->libdir" . "/misc_settings.inc.php");

/* setup some global variables */
$ME = qualified_me();

/* start up the sessions, to keep things clean and manageable we will just
 * use one array called SESSION to store our persistent variables.   */
session_start();
session_register("SESSION");

/* initialize the SESSION variable if necessary */
if (! isset($SESSION)) {
	$SESSION = array();
}

// Loaded modules
if (! isset($SESSION["frames_used"])) {
	$SESSION["frames_used"] = 1;
	$SESSION["catbrowser_target"] = "bodyframe";
//	$SESSION["frames_used"] = 0;
//	$SESSION["catbrowser_target"] = "main";
}
if (! isset($SESSION["layersmenu_used"]))
	$SESSION["layersmenu_used"] = 1;
$SESSION["brand_used"] = 1;
$SESSION["iva_used"] = 1;
//$SESSION["iva_value"] = 0;	// not significant if IVA is used
$IVA = "IVA";
$SESSION["weight_used"] = 1;
$SESSION["delivery_used"] = 1;

$SESSION["max_file_size_import"] = 10000000;	// upload of import files
$SESSION["max_file_size_images"] = 500000;	// upload of product images

session_register("CART");

/* initialize the CART objct if necessary */
if (! isset($CART)) {
	$CART = new Cart;
}

$yes = "si";
//$yes = "yes";
// choose the default language if not set
if (! isset($SESSION["lang"])) {
	$SESSION["lang"] = "it";
//	$SESSION["lang"] = "us";
}
$CFG->globalerror = "$CFG->localedir" . $SESSION["lang"] . "/global-error.inc.php";
$CFG->localelangdir = "$CFG->localedir" . $SESSION["lang"];

//include ($CFG->global);

$currency = "Lit";
$lire2euro = 1936.27;
//$currency = "$";
$SESSION["price_must_be_integer"] = 1;
	// 1 --> the price must be integer (Italian Lit, for example)
	// 0 --> the price can be float (US Dollars, for example)
function print_formatted_price($price) {
	global $currency, $lire2euro;
	echo $currency . " " . number_format ($price, 0, ",", ".") . "<br>&euro; " . number_format ($price/$lire2euro, 2, ",", ".");
//	echo $currency . " " . number_format ($price, 0, ",", ".");
//	echo $currency . " " . number_format ($price, 2, ".", ",");
}
function formatted_price($price) {
	global $currency, $lire2euro;
	return $currency . " " . number_format ($price, 0, ",", ".") . "<br>&euro; " . number_format ($price/$lire2euro, 2, ",", ".");
//	return $currency . " " . number_format ($price, 0, ",", ".");
//	return $currency . " " . number_format ($price, 2, ".", ",");
}
function formatted_price_text($price) {
	global $currency, $lire2euro;
	return $currency . " " . number_format ($price, 0, ",", ".") . " - Euro " . number_format ($price/$lire2euro, 2, ",", ".");
//	return $currency . " " . number_format ($price, 0, ",", ".");
//	return $currency . " " . number_format ($price, 2, ".", ",");
}

$weightunity = "Kg";
$SESSION["weightmax"] = 10000.0;
function print_formatted_weight($weight) {
	echo number_format ($weight, 2, ",", ".");
//	echo number_format ($weight, 2, ".", ",");
}
function formatted_weight($weight) {
	return number_format ($weight, 2, ",", ".");
//	return number_format ($weight, 2, ".", ",");
}

$ordersdb["Customer"]	= "Cliente             :";
$ordersdb["Phone"]	= "Recapito telefonico :";
$ordersdb["Address"]	= "Indirizzo           :";
$ordersdb["Cash_On_Delivery"] = "Pagamento in Contrassegno";
$ordersdb["Order"] = "Ordine";
$ordersdb["Username"] = "Username";
$ordersdb["Date"] = "Data";
$ordersdb["Comments"] = "Commenti";
$ordersdb["TOTAL"] = "TOTALE";
$ordersdb["Product"] = "Prodotto";
$ordersdb["Unit_Price"] = "Prezzo unitario";
$ordersdb["Number_of_items"] = "Numero di pezzi";
$ordersdb["Delivery"] = "Spedizione";

$contact["NameOrCompanyName"]	= "Nome (Ragione Sociale): ";
$contact["Address"] = "Indirizzo:";
$contact["Phone"]		= "Telefono:  ";
$contact["Fax"]			= "Fax:       ";
$contact["MobilePhone"]		= "Cellulare: ";
$contact["EMail"]		= "E-Mail:    ";
$contact["AuthData"]		= "Autorizzazione al trattamento dei dati personali:  ";
$contact["AuthAdvert"]		= "Disponibilita` a ricevere materiale pubblicitario: " ;
$contact["Message"]		= "Messaggio:";

$adminday[1] = "Lunedi";
$adminday[2] = "Martedi";
$adminday[3] = "Mercoledi";
$adminday[4] = "Giovedi";
$adminday[5] = "Venerdi";
$adminday[6] = "Sabato";
$adminday[0] = "Domenica";

$adminmonth[1] = "Gennaio";
$adminmonth[2] = "Febbraio";
$adminmonth[3] = "Marzo";
$adminmonth[4] = "Aprile";
$adminmonth[5] = "Maggio";
$adminmonth[6] = "Giugno";
$adminmonth[7] = "Luglio";
$adminmonth[8] = "Agosto";
$adminmonth[9] = "Settembre";
$adminmonth[10] = "Ottobre";
$adminmonth[11] = "Novembre";
$adminmonth[12] = "Dicembre";

?>
