<?

/* orders.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();

$DOC_TITLE = "Orders_Log_cc";
include("$CFG->dirroot"."/header.php");

switch (nvl($mode)) {
	case "details" :
		show_order_details($id, $SESSION["user"]["username"]);
		break;

	default :
		print_order_list($SESSION["user"]["username"]);
		break;
}

include("$CFG->dirroot"."/footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function show_order_details($id, $username) {
/* loads up the details for an order and displays it */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number;
//	include ($CFG->globalerror);

	$qid_order = db_query("
	SELECT o.*, os.name AS state_name
	FROM orderscc o, orders_states os
	WHERE o.state_id = os.id AND o.id = '$id'
	");
	if (db_num_rows($qid_order) < 1) {
		$t = new Template();
		$t->set_file(array("page" => "templates/no_such_order.ihtml"));
		require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
		$t->pparse("out", "page");
//		include("templates/no_such_order.ihtml");
		return;
	}

	if ($CFG->dbms == "pgsql") {
		$qid_items = db_query("
		SELECT
			 oi.product_id
			,p.name
			,p.price AS curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM	order_items oi, products p
		WHERE	oi.product_id = p.id AND order_id = '$id'
		UNION
		SELECT
			 oi.product_id
			,'-' as name
			,0 as curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM order_items oi
		WHERE order_id = '$id' AND
			NOT EXISTS
			(
				SELECT
					id
				FROM products
				WHERE id = oi.product_id
			)
		");
	} else if ($CFG->dbms == "mysql") {
		$qid_items = db_query("
		SELECT
			 oi.product_id
			,p.name
			,p.price AS curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM	order_items oi LEFT JOIN products p ON (oi.product_id = p.id)
		WHERE	order_id = '$id'
		");
	}

	$order = db_fetch_object($qid_order, 0);

	$qid_user = db_query("
	SELECT usertype, fiscalcode, email
	FROM users
	WHERE username = '$order->username'
	");
	$user = db_fetch_object($qid_user, 0);

	$t = new Template();
	$t->set_file(array("page" => "templates/order_details.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-users.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
			"order_id"		=> ov($id),
			"order_state_name"	=> $order->state_name,
			"order_date"		=> ov($order->date),
			"order_amount"		=> $order->amount,
			"order_famount"		=> formatted_price($order->amount),
			"order_custinfo"	=> nl2br(ov($order->custinfo)),
			"user_fiscalcode"	=> $user->fiscalcode,
			"user_email"		=> $user->email,
			"order_notes"		=> nl2br(ov($order->notes))
	));
	if ($user->usertype == "pf") {
		$t->set_block("page", "usertype_pf", "usertype_pf_blck");
		$t->set_var(array("usertype_pf_blck", ""));
		$t->parse("usertype_pf_blck", "usertype_pf", true);
	} else {
		$t->set_block("page", "usertype_az", "usertype_az_blck");
		$t->set_var(array("usertype_az_blck", ""));
		$t->parse("usertype_az_blck", "usertype_az", true);
	}
	$t->set_block("page", "weight_used", "weight_used_blck");
	$t->set_var(array("weight_used_blck" => ""));
	if ($SESSION["weight_used"])
		$t->parse("weight_used_blck", "weight_used", true);
	$t->set_block("page", "iva_used", "iva_used_blck");
	$t->set_var(array("iva_used_blck" => ""));
	if ($SESSION["iva_used"])
		$t->parse("iva_used_blck", "iva_used", true);
	$t->set_block("page", "item_row", "item_rows");
	$t->set_var("item_rows", "");
		$t->set_block("item_row", "weight_used_row", "weight_used_row_blck");
		$t->set_block("item_row", "iva_used_row", "iva_used_row_blck");
	$numr = db_num_rows($qid_items);
	for ($i=0; $i<$numr; $i++) {
		$t->set_var("weight_used_row_blck", "");
		$t->set_var("iva_used_row_blck", "");
		$prod = db_fetch_object($qid_items, $i);
		$t->set_var(array(
				"prod_product_id"	=> ov($prod->product_id),
				"prod_name"		=> ov($prod->name),
				"prod_curr_price"	=> $prod->curr_price,
				"prod_fcurr_price"	=> formatted_price($prod->curr_price),
				"prod_purchase_price"	=> $prod->purchase_price,
				"prod_fpurchase_price"	=> formatted_price($prod->purchase_price),
				"prod_qty"		=> $prod->qty,
				"prod_total"		=> $prod->total,
				"prod_ftotal"		=> formatted_price($prod->total)
		));
		if ($SESSION["weight_used"]) {
			$t->set_var(array(
					"prod_purchase_weight"	=> $prod->purchase_weight,
					"prod_fpurchase_weight"	=> formatted_weight ($prod->purchase_weight)
			));
			$t->parse("weight_used_row_blck", "weight_used_row", true);
		}
		if ($SESSION["iva_used"]) {
			$t->set_var("prod_purchase_iva", $prod->purchase_iva);
			$t->parse("iva_used_row_blck", "iva_used_row", true);
		}
		$t->parse("item_rows", "item_row", true);
	}
	$t->set_block("page", "delivery_used", "delivery_used_blck");
	$t->set_var(array("delivery_used_blck" => ""));
	if ($SESSION["delivery_used"]) {
		$t->set_var(array(
				"order_delivery"	=> $order->delivery,
				"order_fdelivery"	=> formatted_price($order->delivery)
		));
		$t->parse("delivery_used_blck", "delivery_used", true);
	}
	$t->pparse("out", "page");
//	include("templates/order_details.ihtml");
}

function print_order_list($username) {
/* reads a list of orders from the database and displays them, we will use
 * a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number, $dbchanged;
//	include ($CFG->globalerror);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT o.id, o.username, o.date, o.custinfo, o.amount, o.notes, os.name AS state_name
		FROM orderscc o, orders_states os
		WHERE o.state_id = os.id AND username = '$username'
		ORDER BY os.name, o.id ASC
  		");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["orderscc"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["orders_per_page"]) {
		$first = ($page_number-1)*$SESSION["orders_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["orders_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["orders_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["orders_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	if ($SESSION["numr"] == 0) {
		$t = new Template();
		$t->set_file(array("page" => "templates/no_orders.ihtml"));
		require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
		$t->pparse("out", "page");
//		include("templates/no_orders.ihtml");
	} else {
		$t = new Template();
		$t->set_file(array("page" => "templates/orderca_list.ihtml"));
		require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
		$t->set_var("ME", $ME);
		$t->set_block("page", "pages_links_top", "pages_links_top_blck");
		$t->set_var("pages_links_top_blck", "");
		$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
		$t->set_var("pages_links_bottom_blck", "");
		if ($num_pages > 1) {
			$summary_report .= " " . $on . " " . $num_pages . " " . $pages;
			require("pages_links.php");
			$t->set_var("pages_links", $pages_links);
			$t->parse("pages_links_top_blck", "pages_links_top", true);
			$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
			$t->set_var("page_number", $page_number);
		}
		$t->set_block("page", "item_row", "item_rows");
		$t->set_var("item_rows", "");
		for ($i=$first; $i<=$last; $i++) {
			$t->set_var(array(
					"session_order_id"		=> ov($SESSION["orderscc"][$i]["id"]),
					"session_order_state_name"	=> ov($SESSION["orderscc"][$i]["state_name"]),
					"session_order_date"		=> ov($SESSION["orderscc"][$i]["date"]),
					"session_order_amount"		=> $SESSION["orderscc"][$i]["amount"],
					"session_order_famount"		=> formatted_price($SESSION["orderscc"][$i]["amount"])
			));
			$t->parse("item_rows", "item_row", true);
		}
		$t->pparse("out", "page");
//		include("templates/orderca_list.ihtml");
	}
}

?>
