<?

/* orders.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi (pratesi@telug.it) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

$DOC_TITLE = $Orders_Log_cc;
include("templates/header.ihtml");

switch (nvl($mode)) {
	case "details" :
		show_order_details($id);
		break;

	case "edit" :
		print_edit_order_form($id);
		break;

	case "delete" :
		delete_order($id);
		print_order_list();
		break;

	case "update" :
		update_order($HTTP_POST_VARS);
		print_order_list();
		break;

	default :
		print_order_list();
		break;
}

include("templates/footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function show_order_details($id) {
/* loads up the details for an order and displays it */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number;
	include ($CFG->global);

	$qid_order = db_query("
	SELECT o.*, os.name AS state_name
	FROM orderscc o, orders_states os
	WHERE o.state_id = os.id AND o.id = '$id'
	");
	$qid_items = db_query("
	SELECT
		 oi.product_id
		,p.name
		,p.price AS curr_price
		,oi.price AS purchase_price
		,oi.iva AS purchase_iva
		,oi.weight AS purchase_weight
		,oi.qty
		,oi.price * oi.qty AS total
	FROM	order_items oi, products p
	WHERE	oi.product_id = p.id AND order_id = '$id'
	UNION
	SELECT
		 oi.product_id
		,'-' as name
		,0 as curr_price
		,oi.price AS purchase_price
		,oi.iva AS purchase_iva
		,oi.weight AS purchase_weight
		,oi.qty
		,oi.price * oi.qty AS total
	FROM order_items oi
	WHERE order_id = '$id' AND
		NOT EXISTS
		(
			SELECT
				id
			FROM products
			WHERE id = oi.product_id
		)
	");
/* For MySQL
	$qid_items = db_query("
	SELECT
		 oi.product_id
		,p.name
		,p.price AS curr_price
		,oi.price AS purchase_price
		,oi.iva AS purchase_iva
		,oi.weight AS purchase_weight
		,oi.qty
		,oi.price * oi.qty AS total
	FROM	order_items oi LEFT JOIN products p ON (oi.product_id = p.id)
	WHERE	order_id = '$id'
	");
*/

	$order = db_fetch_object($qid_order, 0);

	$qid_user = db_query("
	SELECT usertype, fiscalcode, email
	FROM users
	WHERE username = '$order->username'
	");
	$user = db_fetch_object($qid_user, 0);

	include("templates/order_details.ihtml");
}

function print_edit_order_form($id) {
// print an order form so we can edit the selected order

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number;
	include ($CFG->global);

	$qid_order = db_query("SELECT * FROM orderscc WHERE id = '$id'");
	$frm = db_fetch_array($qid_order, 0);
	$qid_orders_states = db_query("SELECT * FROM orders_states ORDER BY name");
	$frm["order_state"] = array();
	$numr = db_num_rows($qid_orders_states);
	$frm["num_orders_states"] = $numr;
	for ($i=0; $i<$numr; $i++) {
		$order_state = db_fetch_object($qid_orders_states, $i);
		$frm["order_state"][$i]["id"] = $order_state->id;
		$frm["order_state"][$i]["name"] = $order_state->name;
	}
	$qid_items = db_query("
	SELECT
		 oi.product_id
		,p.name
		,p.price AS curr_price
		,oi.price AS purchase_price
		,oi.iva AS purchase_iva
		,oi.weight AS purchase_weight
		,oi.qty
		,oi.price * oi.qty AS total
	FROM	order_items oi, products p
	WHERE	oi.product_id = p.id AND order_id = '$id'
	UNION
	SELECT
		 oi.product_id
		,'-' as name
		,0 as curr_price
		,oi.price AS purchase_price
		,oi.iva AS purchase_iva
		,oi.weight AS purchase_weight
		,oi.qty
		,oi.price * oi.qty AS total
	FROM order_items oi
	WHERE order_id = '$id' AND
		NOT EXISTS
		(
			SELECT
				id
			FROM products
			WHERE id = oi.product_id
		)
	");
/* For MySQL
	$qid_items = db_query("
	SELECT
		 oi.product_id
		,p.name
		,p.price AS curr_price
		,oi.price AS purchase_price
		,oi.iva AS purchase_iva
		,oi.weight AS purchase_weight
		,oi.qty
		,oi.price * oi.qty AS total
	FROM	order_items oi LEFT JOIN products p ON (oi.product_id = p.id)
	WHERE	order_id = '$id'
	");
*/

	$qid_user = db_query("
	SELECT usertype, fiscalcode, email
	FROM users
	WHERE username = '$frm[username]'
	");

	$order = db_fetch_object($qid_order, 0);
	$user = db_fetch_object($qid_user, 0);

	$frm["newmode"] = "update";
	$frm["submit_caption"] = $Save_Changes;
	include("templates/order_form.ihtml");
}

function delete_order($id) {
// cancella un ordine

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$qid = db_begin();
	$qid = db_query("DELETE FROM orderscc WHERE id = '$id'");
	$qid = db_query("DELETE FROM order_items WHERE order_id = '$id'");
	$qid = db_commit();

	include("templates/order_deleted.ihtml");
}

function update_order($frm) {
// update the order record in the database

	$qid = db_query("
	UPDATE orderscc SET
		 custinfo = '$frm[custinfo]'
		,notes = '$frm[notes]'
		,ournotes = '$frm[ournotes]'
		,state_id = '$frm[state_id]'
	WHERE id = '$frm[id]'
	");
}

function print_order_list() {
/* reads a list of orders from the database and displays them, we will use
 * a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number, $dbchanged;
	include ($CFG->global);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT o.id, o.username, o.date, o.custinfo, o.amount, o.notes, os.name AS state_name
		FROM orderscc o, orders_states os
		WHERE o.state_id = os.id
		ORDER BY os.name, o.id ASC
  		");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["orderscc"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["orders_per_page"]) {
		$first = ($page_number-1)*$SESSION["orders_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["orders_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["orders_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["orders_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	include("templates/ordercc_list.ihtml");
}

?>
