/*
 * AttributeTypes.java
 *
 * Created on 31 de julio de 2002, 09:14
 */

package pgclibrary.objects;
import java.util.*;
import java.sql.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class AttributeType {
    private long oid = 0;
    private String name = new String();
    private int size = -1;
    protected static Vector instances = new Vector();
    
    /** Creates a new instance of AttributeType */
    private AttributeType() {
    }
    
    public boolean search(String _name){
        boolean retorno = false;
        try{
            ResultSet rs = Database.getMainConnection().getQueryGenerator().getAttributeType(_name);
            if(rs.next()){
                oid = rs.getLong("oid");
                setName(rs.getString("type_name"));
                size = rs.getInt("type_size");
                retorno = true;
            }
    } catch (Exception e){
            e.printStackTrace();
        }
        return retorno;
    }
    
    public long getOID(){
        return oid;
    }
    private void setName(String _name){
        if(_name != null){
            name = _name;
        } else {
            name = new String();
        }
    }
    public String getName(){
        return name;
    }
    public int getSize(){
        return size;
    }
    
    public long getSQLType() {
        switch ((int) oid) {
            case 16: 
            case 1560: 
                return Types.BIT;
            case 20: 
            case 21: 
            case 22: 
            case 23: 
                return Types.INTEGER;
            case 1700: 
            case 790: 
            case 701: 
            case 700: 
                return Types.DOUBLE;
            case 18: 
            case 25: 
            case 1042: 
            case 1043: 
                return Types.CHAR;
            case 1082: 
                return Types.DATE;
            case 1083: 
                return Types.TIME;
            case 1084: 
                return Types.TIMESTAMP;
        }
        System.out.println(getName() + " - " + oid);
        return -1*oid;
    }
    
    public static AttributeType getInstance(String _name){
        AttributeType retorno = null;
        for(int i=0; (i < instances.size()) && (retorno == null); i++){
            AttributeType tmp = (AttributeType) instances.get(i);
            if(tmp.getName().equals(_name)){
                retorno = tmp;
            }
        }
        return retorno;
    }
    public static void addInstance(AttributeType _column){
        if ((_column != null) && (getInstance(_column.getName()) == null)){ 
            instances.add(_column);
        }
    }
    
    public static AttributeType searchObject(String _name){
        AttributeType retorno = getInstance(_name);
        
        if(retorno == null){
            retorno = new AttributeType();
            if(retorno.search(_name)){
                addInstance(retorno);
            } else {
                System.out.println("Atribute type not found");
                retorno = null;
            }
        }
        return retorno;
    }
}
