/*
* DatabaseQuerys_7_1.java
*
* Created on 14 de agosto de 2002, 11:38
*/

package pgclibrary.dataaccess;
import java.sql.*;
import org.apache.log4j.Logger;
/**
 *
 * @author  nestor
 */
public class DatabaseQuerys_7_1 extends DatabaseQuerys
{
    protected MainConnection connection = null;

    private static Logger logger = Logger.getLogger( DatabaseQuerys.class );

    /** Creates a new instance of DatabaseQuerys_7_1 */
    public DatabaseQuerys_7_1(MainConnection _connection)
    {
        connection = _connection;
    }

    public ResultSet getGroups(String _groupName)
    {
      ResultSet retorno = null;
      final String query = "select "
                         + " groname as group_name,  grolist as user_list "
                         + " from pg_group where groname=? ";
      try
      {
        PreparedStatement prep = connection.prepareStatement( query );
        prep.setString(1, _groupName);

        retorno = prep.executeQuery();

        logger.info( "getGroups " + _groupName  );
        connection.getConnection().clearWarnings();
      }
      catch (SQLException e)
      {
        logger.debug( "Error getting groups", e );
      }
      return retorno;
    }

    public ResultSet getTableColumn(String _tableName, String _columnName)
    {
        ResultSet retorno = null;
        final String query ="select  "
            + " attname as column_name, "
            + " attnum as column_number, "
            + " attnotnull as column_notnull, "
            + " typname as type_name, "
            + " case when pg_attribute.attlen > 0 then pg_attribute.attlen "
            + "         when pg_attribute.atttypmod > 0 then pg_attribute.atttypmod-4  "
            + "              else -1 end as column_size, "
            + " adsrc as default_value "
            + " from pg_class, pg_type, pg_attribute left join pg_attrdef "
            + " on pg_attribute.attrelid = pg_attrdef.adrelid and pg_attribute.attnum = pg_attrdef.adnum "
            + " where pg_attribute.attrelid=pg_class.oid and pg_type.oid = atttypid "
            + " and pg_class.relname=? and pg_attribute.attname=? ";
        try
        {
          PreparedStatement prep = connection.prepareStatement(query);
          prep.setString(1, _tableName);
          prep.setString(2, _columnName);
          retorno = prep.executeQuery();
          logger.info( "getTableColumn " + _tableName + " column " + _columnName );
          connection.getConnection().clearWarnings();
        }
        catch (SQLException e)
        {
          logger.debug("Error getting columns", e );
        }
        return retorno;
    }

    public String getColumnDescription(String _tableName, String _columnName)
    {
        String retorno = "";
        final String query = "select "
            + " obj_description(pg_attribute.oid) as description "
            + " from pg_attribute, pg_class "
            + " where pg_class.oid = pg_attribute.attrelid and relname=? and attname=? ";
        try
        {
            PreparedStatement prep = connection.prepareStatement(query);
            prep.setString(1, _tableName);
            prep.setString(2, _columnName);
            ResultSet rs = prep.executeQuery();

            if ( (rs != null ) && ( rs.next() ) )
            {
              retorno  = rs.getString("description");
              if ( retorno == null )
              {
                retorno = "";
              }
            }
            rs.close();
            prep.close();
            logger.info( "getTableColumnDescription " + _tableName + " column " + _columnName );
            connection.getConnection().clearWarnings();

        } catch (SQLException e)
        {
            logger.debug("Error getting column description", e );
        }
        return retorno;
    }

    public ResultSet getAttributeType(String _name)
    {
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " oid, typname as type_name, typlen as type_size  "
            + " from pg_type where typname = ?");
            prep.setString(1, _name);
            retorno = prep.executeQuery();
            logger.info("getAttributeType " + _name );
            connection.getConnection().clearWarnings();
        } catch (SQLException e)
        {
            logger.debug("Error getting attribute type", e );
        }
        return retorno;
    }

    public ResultSet getDatabases(String _name){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " datname as database_name, usename as  database_dba, "
            + "  datistemplate as database_template, datallowconn as database_allowconn "
            + " from pg_database, pg_user where pg_user.usesysid = datdba "
            + " and datname=?");
            prep.setString(1, _name);
            retorno = prep.executeQuery();

            logger.info( "Get Databases "+ _name );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getUser(String _name){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " usename as user_name, usesysid as user_sysid, "
            + " usecreatedb as user_dbcreator, valuntil as user_limitdate "
            + " from pg_user where usename=?");
            prep.setString(1, _name);
            retorno = prep.executeQuery();

            logger.info( "getUser " + _name );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }
    public ResultSet getUser(long _sysID){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " usename as user_name, usesysid as user_sysid, "
            + " usecreatedb as user_dbcreator, valuntil as user_limitdate "
            + " from pg_user where usesysid=?");
            prep.setLong(1, _sysID);
            retorno = prep.executeQuery();

            logger.info( "getUser " + _sysID );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getIndex(String _name){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " relname as index_name, indisclustered as index_cluster, "
            + " indisunique as index_unique, "
            + " indisprimary as index_primary "
            + " from pg_index, pg_class "
            + " where pg_class.oid = indexrelid and relname = ? ");
            prep.setString(1, _name);
            retorno = prep.executeQuery();

            logger.info( "getIndex " + _name );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getColumnNames(String _tableName){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " attname as column_name "
            +" from pg_attribute, pg_class "
            + " where pg_attribute.attrelid=pg_class.oid and attnum > 0 "
            + "     and pg_class.relname=? ");
            prep.setString(1, _tableName);
            retorno = prep.executeQuery();

            logger.info( "getColumnNames " + _tableName );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public String getTableDescription(String _tableName){
        String retorno = new String();

        try{
            PreparedStatement prep = connection.prepareStatement("select "
             + " obj_description(oid) as description "
             + " from pg_class where relname=? ");
            prep.setString(1, _tableName);
            ResultSet rs = prep.executeQuery();
            if ((rs != null) && (rs.next())){
                if (rs.getString("description") != null){
                    retorno = rs.getString("description");
                }
            }
            rs.close();
            prep.close();

            logger.info( "getDescription " + _tableName );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getView(String _viewname){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " usename as view_owner, relname as view_name, "
            + " definition as view_definition "
            + " from pg_views, pg_class, pg_user  "
            + " where pg_class.relname = pg_views.viewname "
            + " and usesysid=relowner and viewname=?");

            prep.setString(1, _viewname);
            retorno = prep.executeQuery();

            logger.info( "getView " + _viewname );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getSequence(String _sequenceName){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " sequence_name, usename as sequence_owner,  "
            + " last_value, increment_by, max_value, min_value, "
            + " cache_value, is_cycled, is_called"
            + " from " +_sequenceName+ " , pg_class, pg_user  "
            + " where sequence_name = relname and pg_user.usesysid = relowner");
            retorno = prep.executeQuery();

            logger.info( "getSequence " + _sequenceName );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getTable(String _tableName){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " relname as table_name, relpages as table_pages, "
            + " usename as table_owner "
            + " from pg_class, pg_user "
            + " where pg_user.usesysid=relowner and relname=?");
            prep.setString(1, _tableName);
            retorno = prep.executeQuery();

            logger.info( "getTable " + _tableName );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getIndexNames(String _tableName){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select a.relname as index_name "
            + " from pg_index, pg_class a, pg_class b where a.oid = pg_index.indexrelid "
            + " and b.oid = pg_index.indrelid and b.relname =? ");
            prep.setString(1, _tableName);
            retorno = prep.executeQuery();

            logger.info( "getIndexNames " + _tableName );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getTableForeignKey(String _tableName, String _foreignKeyName){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
                + " tgenabled as fk_enabled, tgconstrname as fk_name, "
                + " tgdeferrable as fk_deferrable, tgconstrname as fk_name, "
                + " b.relname as fk_table, tgnargs as fk_argnum, "
                + " tgargs as fk_arguments ,  "
                + " (select proname from pg_trigger a, pg_proc "
                + "     where a.tgconstrname = pg_trigger.tgconstrname and tgtype=9 "
                + "     and pg_proc.oid = a.tgfoid) as del_proc, "
                + " (select proname from pg_trigger a, pg_proc "
                + "     where a.tgconstrname= pg_trigger.tgconstrname and tgtype=17 "
                + "     and pg_proc.oid = a.tgfoid) as upd_proc "
                + " from pg_trigger, pg_class a, pg_class b  "
                + " where tgisconstraint = true and tgtype=21 "
                + "     and tgrelid = a.oid and tgconstrrelid = b.oid "
		+ "     and a.relname = ? and tgconstrname=? ");
            prep.setString(1, _tableName);
            prep.setString(2, _foreignKeyName);
            retorno = prep.executeQuery();

            logger.info( "getTableForeignKey " + _tableName + " keyName " + _foreignKeyName );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getTableForeignKeyNames(String _tableName){
        ResultSet retorno = null;
        try{
            PreparedStatement prep = connection.prepareStatement("select "
                + " tgconstrname as fk_name  "
                + " from pg_trigger, pg_class "
                + " 	where tgisconstraint = true and tgtype=21 "
		+ " and tgrelid = pg_class.oid and pg_class.relname = ? ");
            prep.setString(1, _tableName);
            retorno = prep.executeQuery();

            logger.info( "getTableForeignKeyNames " + _tableName );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getViewNames(){
        ResultSet retorno = null;
        try{
            retorno = connection.getStatement().executeQuery("select "
            + " relname as view_name from pg_class "
            + " where relkind='v' order by relname");

            logger.info( "getViewNames" );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getSequenceNames(){
        ResultSet retorno = null;
        try{
            retorno = connection.getStatement().executeQuery("select "
            + " relname as sequence_name from pg_class "
            + " where relkind='S' order by relname");

            logger.info( "getSequenceNames" );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getUserNames(){
        ResultSet retorno = null;
        try{
            retorno = connection.getStatement().executeQuery("select "
            + " usename as user_name from pg_user order by usename");

            logger.info( "getUserNames" );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getGroupNames(){
        ResultSet retorno = null;
        try{
            retorno = connection.getStatement().executeQuery("select "
            + " groname as group_name from pg_group "
            + " order by groname");

            logger.info( "getGroupNames" );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getDatabaseNames(){
        ResultSet retorno = null;
        try{
            retorno = connection.getStatement().executeQuery("select "
            + " datname as database_name from pg_database order by datname");

            logger.info( "getDatabaseNames" );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }

    public ResultSet getTableNames(){
        ResultSet retorno = null;
        try{
            retorno = connection.getStatement().executeQuery("select "
            + " relname as table_name from pg_class "
            + " where relkind='r' order by relname");

            logger.info( "getTableNames" );
            connection.getConnection().clearWarnings();
        } catch (SQLException e){
            logger.debug( "Sql Error", e );
        }
        return retorno;
    }
}
