/*
 * PrincipalFrame_listener.java
 *
 * Created on 18 de julio de 2002, 15:35
 */

package frames;
import java.awt.event.*;
import java.lang.*;
import frames.*;

/**
 *
 * @author  nestor
 */
public class PrincipalFrameListener implements ActionListener {
    public static final String AC_EXIT = "exit";
    public static final String AC_CONNECT = "connect";
    public static final String AC_DISCONNECT = "disconnect";
    public static final String AC_SAVE_OPTIONS = "save_options";
    public static final String AC_RESTORE_OPTIONS = "restore_options";
    public static final String AC_SQL_WINDOW = "sql_window";
    public static final String AC_REFRESH = "refresh";
    public static final String AC_VACUUM = "vacuum";
    
    private PrincipalFrame frame = null;
    
    /** Creates a new instance of PrincipalFrame_listener */
    public PrincipalFrameListener(PrincipalFrame _frame){
        frame = _frame;
    }
    
    public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
        if(actionEvent.getActionCommand().equals(AC_EXIT)){
            frame.close();
        }
        if(actionEvent.getActionCommand().equals(AC_CONNECT)){
            ConnectDialog conn = new ConnectDialog(frame);
            conn.show();
            frame.refreshData();
        }
        if(actionEvent.getActionCommand().equals(AC_DISCONNECT)){
            frame.disconnect();
        }
        if(actionEvent.getActionCommand().equals(AC_SAVE_OPTIONS)){
            frame.getSystemProperties().writeProperties();
        }
        if(actionEvent.getActionCommand().equals(AC_RESTORE_OPTIONS)){
            frame.getSystemProperties().readProperties();
        }
        if(actionEvent.getActionCommand().equals(AC_SQL_WINDOW)){
            frame.openNewSQLWindow();
        }
        if(actionEvent.getActionCommand().equals(AC_REFRESH)){
            frame.refreshData();
        }
        if(actionEvent.getActionCommand().equals(AC_VACUUM)){
            frame.vacuum();
        }
    }
}
