/*
 * ViewList.java
 *
 * Created on 31 de julio de 2002, 10:58
 */

package components.treeObjects;
import pgclibrary.objects.*;
import java.sql.*;
import java.util.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class ViewList extends TreeInfo {
    
    /** Creates a new instance of ViewList */
    public ViewList(RootElement source) {
        super(source);
        setIcon("/images/view.gif");
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            ResultSet rs =  getConnection().getQueryGenerator().getViewNames();
            while((rs != null) && rs.next()){
                addProperty(new Element(this, new View(getDatabase(), rs.getString("view_name")))); 
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
        }
    }
    
    public Object getOID() {
        return toString();
    }
    
    public String toString(){
        return "Views";
    }
    
    public Database getDatabase(){
        return ((RootElement) getOwner()).getDatabase();
    }
}

