/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.JOptionPane;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.TableColumn;
import pgclibrary.objects.TableForeignKey;
import pgclibrary.objects.TableIndex;
import pgclibrary.objects.User;
import pgclibrary.utilities.Utilities;

public class Table
extends DBObject {
    private long pages_number = 0L;
    private Vector columns = null;
    private Vector index = null;
    private Vector foreign_keys = null;
    private String description = null;

    public Table(DBObject dBObject, String string) {
        super(dBObject);
        this.search(string);
    }

    public Table(DBObject dBObject) {
        super(dBObject);
    }

    public boolean Drop() {
        boolean bl = false;
        try {
            bl = this.getConnection().executeUpdate("DROP TABLE " + this.getName()) > 0;
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, sQLException.getMessage(), "Can't drop object", 0);
        }
        return bl;
    }

    public void insertRecord(Vector vector) throws SQLException {
        PreparedStatement preparedStatement = this.prepareInsertStatement();
        int n = 0;
        while (n < this.getColumns().size()) {
            this.setStatementValue(preparedStatement, (String)vector.get(n), (TableColumn)this.getColumns().get(n), n + 1);
            ++n;
        }
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public void updateRecord(Vector vector) throws SQLException {
        PreparedStatement preparedStatement = this.prepareUpdateStatement();
        int n = 0;
        int n2 = 0;
        while (n2 < this.getColumns().size()) {
            this.setStatementValue(preparedStatement, (String)vector.get(n), (TableColumn)this.getColumns().get(n2), n + 1);
            ++n;
            ++n2;
        }
        Vector vector2 = ((TableIndex)this.getPrimaryKeys().get(0)).getColumns();
        int n3 = 0;
        while (n3 < vector2.size()) {
            this.setStatementValue(preparedStatement, (String)vector.get(n), (TableColumn)vector2.get(n3), n + 1);
            ++n;
            ++n3;
        }
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public void deleteRecord(Vector vector) throws SQLException {
        PreparedStatement preparedStatement = this.prepareDeleteStatement();
        Vector vector2 = ((TableIndex)this.getPrimaryKeys().get(0)).getColumns();
        int n = 0;
        while (n < vector2.size()) {
            this.setStatementValue(preparedStatement, (String)vector.get(n), (TableColumn)vector2.get(n), n + 1);
            ++n;
        }
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public String getDeleteSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP TABLE ");
        stringBuffer.append(this.getName());
        stringBuffer.append("; \n\t");
        return stringBuffer.toString();
    }

    public String getInsertSQL() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" ( ");
        int n = 0;
        while (n < this.getColumns().size()) {
            if (n > 0) {
                stringBuffer.append(", \n\t");
            }
            object = (TableColumn)this.getColumns().get(n);
            stringBuffer.append(((TableColumn)object).getInsertSQL());
            ++n;
        }
        object = this.getPrimaryKeys();
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            stringBuffer.append(", \n\t");
            stringBuffer.append(((TableIndex)((Vector)object).get(n2)).getInsertSQL());
            ++n2;
        }
        object = this.getForeignKeys();
        int n3 = 0;
        while (n3 < ((Vector)object).size()) {
            stringBuffer.append(", \n\t");
            stringBuffer.append(((TableForeignKey)((Vector)object).get(n3)).getInsertSQL());
            ++n3;
        }
        stringBuffer.append(" \n);\n");
        object = this.getNotPrimaryKeyIndex();
        int n4 = 0;
        while (n4 < ((Vector)object).size()) {
            stringBuffer.append(((TableIndex)((Vector)object).get(n4)).getInsertSQL());
            stringBuffer.append("\n");
            ++n4;
        }
        stringBuffer.append(this.getCommentSQL());
        int n5 = 0;
        while (n5 < this.getColumns().size()) {
            TableColumn tableColumn = (TableColumn)this.getColumns().get(n5);
            stringBuffer.append(tableColumn.getCommentSQL());
            stringBuffer.append("\n");
            ++n5;
        }
        return stringBuffer.toString();
    }

    public boolean search(String string) {
        boolean bl = false;
        try {
            this.initialize();
            ResultSet resultSet = this.getConnection().getQueryGenerator().getTable(string);
            if (resultSet != null && resultSet.next()) {
                this.setName(resultSet.getString("table_name"));
                this.setNumberOfPages(resultSet.getLong("table_pages"));
                this.setCreator(new User((DBObject)this, resultSet.getString("table_owner")));
                bl = true;
            }
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return bl;
    }

    public void initialize() {
        super.initialize();
        this.pages_number = 0L;
        this.columns = null;
        this.foreign_keys = null;
        this.index = null;
        this.description = null;
    }

    public long getNumberOfPages() {
        return this.pages_number;
    }

    public Vector getColumns() {
        if (this.columns == null) {
            this.columns = new Vector();
            try {
                ResultSet resultSet = this.getConnection().getQueryGenerator().getColumnNames(this.getName());
                while (resultSet != null && resultSet.next()) {
                    TableColumn tableColumn = new TableColumn(this, resultSet.getString("column_name"));
                    this.columns.add(tableColumn);
                }
                resultSet.close();
                resultSet.getStatement().close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return this.columns;
    }

    public int getColumnIndex(String string) {
        string = string.toUpperCase();
        int n = -1;
        Vector vector = this.getColumns();
        int n2 = 0;
        while (n2 < vector.size() && n < 0) {
            if (((TableColumn)vector.get(n2)).getName().equals(string)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public Vector getIndexes() {
        if (this.index == null) {
            this.index = new Vector();
            try {
                ResultSet resultSet = this.getConnection().getQueryGenerator().getIndexNames(this.getName());
                while (resultSet != null && resultSet.next()) {
                    TableIndex tableIndex = new TableIndex(this, resultSet.getString("index_name"));
                    this.index.add(tableIndex);
                }
                resultSet.close();
                resultSet.getStatement().close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return this.index;
    }

    public Vector getPrimaryKeys() {
        Vector vector = new Vector();
        Vector vector2 = this.getIndexes();
        int n = 0;
        while (n < vector2.size()) {
            if (((TableIndex)vector2.get(n)).isPrimary()) {
                vector.add(vector2.get(n));
            }
            ++n;
        }
        return vector;
    }

    public Vector getNotPrimaryKeyIndex() {
        Vector vector = new Vector();
        Vector vector2 = this.getIndexes();
        int n = 0;
        while (n < vector2.size()) {
            if (!((TableIndex)vector2.get(n)).isPrimary()) {
                vector.add(vector2.get(n));
            }
            ++n;
        }
        return vector;
    }

    public Vector getForeignKeys() {
        if (this.foreign_keys == null) {
            this.foreign_keys = new Vector();
            try {
                ResultSet resultSet = this.getConnection().getQueryGenerator().getTableForeignKeyNames(this.getName());
                while (resultSet != null && resultSet.next()) {
                    TableForeignKey tableForeignKey = new TableForeignKey(this, resultSet.getString("fk_name"));
                    this.foreign_keys.add(tableForeignKey);
                }
                resultSet.close();
                resultSet.getStatement().close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return this.foreign_keys;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getConnection().getQueryGenerator().getTableDescription(this.getName());
        }
        return this.description;
    }

    public void refresh() {
        this.search(this.getName());
    }

    private PreparedStatement prepareInsertStatement() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" ( ");
        int n = 0;
        while (n < this.getColumns().size()) {
            TableColumn tableColumn = (TableColumn)this.getColumns().get(n);
            stringBuffer.append(tableColumn.getName());
            if (n < this.getColumns().size() - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(" ) VALUES ( ");
        int n2 = 0;
        while (n2 < this.getColumns().size()) {
            stringBuffer.append(" ?");
            if (n2 < this.getColumns().size() - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(" )");
        return this.getConnection().prepareStatement(stringBuffer.toString());
    }

    private PreparedStatement prepareUpdateStatement() throws SQLException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" SET ");
        int n = 0;
        while (n < this.getColumns().size()) {
            object = (TableColumn)this.getColumns().get(n);
            stringBuffer.append(((DBObject)object).getName());
            stringBuffer.append("= ? ");
            if (n < this.getColumns().size() - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(" WHERE ");
        object = ((TableIndex)this.getPrimaryKeys().get(0)).getColumns();
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            TableColumn tableColumn = (TableColumn)((Vector)object).get(n2);
            stringBuffer.append(tableColumn.getName());
            stringBuffer.append("=? ");
            if (n2 < ((Vector)object).size() - 1) {
                stringBuffer.append(" and ");
            }
            ++n2;
        }
        return this.getConnection().prepareStatement(stringBuffer.toString());
    }

    private PreparedStatement prepareDeleteStatement() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" WHERE ");
        Vector vector = ((TableIndex)this.getPrimaryKeys().get(0)).getColumns();
        int n = 0;
        while (n < vector.size()) {
            TableColumn tableColumn = (TableColumn)vector.get(n);
            stringBuffer.append(tableColumn.getName());
            stringBuffer.append("=? ");
            if (n < vector.size() - 1) {
                stringBuffer.append(" and ");
            }
            ++n;
        }
        return this.getConnection().prepareStatement(stringBuffer.toString());
    }

    private void setStatementValue(PreparedStatement preparedStatement, String string, TableColumn tableColumn, int n) {
        int n2 = (int)tableColumn.getColumnType().getSQLType();
        if (n2 < 0) {
            n2 = 1;
        }
        try {
            if (string != null && string.length() > 0) {
                switch (n2) {
                    case -7: {
                        preparedStatement.setBoolean(n, Utilities.parseBoolean(string));
                        break;
                    }
                    case 1: {
                        preparedStatement.setString(n, string);
                        break;
                    }
                    case 4: {
                        preparedStatement.setInt(n, Integer.parseInt(string));
                        break;
                    }
                    case 91: {
                        preparedStatement.setDate(n, new Date(Utilities.parseDate(string, "MM/dd/yyyy").getTime()));
                        break;
                    }
                    case 92: {
                        preparedStatement.setTime(n, new Time(Utilities.parseDate(string, "HH:mm:ss").getTime()));
                        break;
                    }
                    case 93: {
                        preparedStatement.setTimestamp(n, new Timestamp(Utilities.parseDate(string, "MM/dd/yyyy HH:mm:ss").getTime()));
                        break;
                    }
                    case 8: {
                        preparedStatement.setDouble(n, Double.parseDouble(string));
                    }
                }
            } else {
                preparedStatement.setNull(n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getCommentSQL() {
        String string = new String();
        String string2 = this.getDescription();
        if (string2 != null && string2.length() > 0) {
            string = "COMMENT ON TABLE " + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return string;
    }

    private void setNumberOfPages(long l) {
        this.pages_number = l;
    }

    private void setDescription(String string) {
        this.description = string != null ? string : new String();
    }
}

