/*
 * Decompiled with CFR 0.152.
 */
package frames;

import components.CreditsPanel;
import components.DatabaseRootPanel;
import components.LoggingPanel;
import components.TreeControl;
import components.TreeElementsPanel;
import components.TreeListener;
import components.TreeToolbar;
import components.database.DatabasePanel;
import components.group.GroupPanel;
import components.sequence.SequencePanel;
import components.table.TablePanel;
import components.treeObjects.Element;
import components.treeObjects.RootElement;
import components.treeObjects.TreeInfo;
import components.user.UserPanel;
import components.view.ViewPanel;
import frames.PrincipalFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.Database;
import pgclibrary.objects.Group;
import pgclibrary.objects.Sequence;
import pgclibrary.objects.Table;
import pgclibrary.objects.User;
import pgclibrary.objects.View;

public class PrincipalFrameComponent
extends JSplitPane {
    private PrincipalFrame frame = null;
    private TreeControl tree_control = null;
    private TreeToolbar tree_toolbar = null;
    private TreeInfo last_selected = null;
    private CreditsPanel default_panel = new CreditsPanel();
    private DatabaseRootPanel dbRootPanel = new DatabaseRootPanel();
    private TablePanel tablePanel = new TablePanel();
    private ViewPanel viewPanel = new ViewPanel();
    private UserPanel userPanel = new UserPanel();
    private GroupPanel groupPanel = new GroupPanel();
    private DatabasePanel databasePanel = new DatabasePanel();
    private SequencePanel sequencePanel = new SequencePanel();
    private TreeElementsPanel treePanel = new TreeElementsPanel();
    private JSplitPane dataComponent = new JSplitPane(0);
    private TreeListener listener = null;
    static /* synthetic */ Class class$components$treeObjects$RootElement;
    static /* synthetic */ Class class$components$treeObjects$Element;
    static /* synthetic */ Class class$pgclibrary$objects$Table;
    static /* synthetic */ Class class$pgclibrary$objects$View;
    static /* synthetic */ Class class$pgclibrary$objects$Database;
    static /* synthetic */ Class class$pgclibrary$objects$User;
    static /* synthetic */ Class class$pgclibrary$objects$Group;
    static /* synthetic */ Class class$pgclibrary$objects$Sequence;
    static /* synthetic */ Class class$components$treeObjects$TreeInfo;

    public PrincipalFrameComponent(PrincipalFrame _frame) {
        this.frame = _frame;
        this.setPreferredSize(new Dimension(600, 400));
        this.setDividerLocation(200);
        this.setOneTouchExpandable(true);
        this.listener = new TreeListener(this);
        this.tree_control = new TreeControl(this.frame);
        this.tree_toolbar = new TreeToolbar(this);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.tree_toolbar, "North");
        temp.add((Component)new JScrollPane(this.tree_control), "Center");
        this.setLeftComponent(temp);
        this.dataComponent.setDividerLocation(Integer.parseInt(this.frame.getSystemProperties().getProperty("LOG_DIVIDER_LOCATION", "400")));
        this.dataComponent.setOneTouchExpandable(true);
        this.dataComponent.setRightComponent(new LoggingPanel());
        this.setRightComponent(this.dataComponent);
        this.refreshTree();
    }

    public void updateSelectedObject(TreeInfo _obj) {
        int location = this.dataComponent.getDividerLocation();
        int lastLocation = this.dataComponent.getLastDividerLocation();
        if (_obj == null) {
            this.last_selected = null;
            this.dataComponent.setLeftComponent(this.default_panel);
        } else if (this.last_selected == null || this.last_selected != _obj) {
            this.last_selected = _obj;
            if (_obj.getClass() == (class$components$treeObjects$RootElement == null ? (class$components$treeObjects$RootElement = PrincipalFrameComponent.class$("components.treeObjects.RootElement")) : class$components$treeObjects$RootElement)) {
                this.dbRootPanel.setDatabase(((RootElement)_obj).getDatabase());
                this.dataComponent.setLeftComponent(this.dbRootPanel);
            } else if (_obj.getClass() == (class$components$treeObjects$Element == null ? (class$components$treeObjects$Element = PrincipalFrameComponent.class$("components.treeObjects.Element")) : class$components$treeObjects$Element)) {
                DBObject tmp_element = ((Element)_obj).getSource();
                if (tmp_element.getClass() == (class$pgclibrary$objects$Table == null ? (class$pgclibrary$objects$Table = PrincipalFrameComponent.class$("pgclibrary.objects.Table")) : class$pgclibrary$objects$Table)) {
                    this.tablePanel.setTable((Table)tmp_element);
                    this.dataComponent.setLeftComponent(this.tablePanel);
                } else if (tmp_element.getClass() == (class$pgclibrary$objects$View == null ? (class$pgclibrary$objects$View = PrincipalFrameComponent.class$("pgclibrary.objects.View")) : class$pgclibrary$objects$View)) {
                    this.viewPanel.setView((View)tmp_element);
                    this.dataComponent.setLeftComponent(this.viewPanel);
                } else if (tmp_element.getClass() == (class$pgclibrary$objects$Database == null ? (class$pgclibrary$objects$Database = PrincipalFrameComponent.class$("pgclibrary.objects.Database")) : class$pgclibrary$objects$Database)) {
                    this.databasePanel.setDatabase((Database)tmp_element);
                    this.dataComponent.setLeftComponent(this.databasePanel);
                } else if (tmp_element.getClass() == (class$pgclibrary$objects$User == null ? (class$pgclibrary$objects$User = PrincipalFrameComponent.class$("pgclibrary.objects.User")) : class$pgclibrary$objects$User)) {
                    this.userPanel.setUser((User)tmp_element);
                    this.dataComponent.setLeftComponent(this.userPanel);
                } else if (tmp_element.getClass() == (class$pgclibrary$objects$Group == null ? (class$pgclibrary$objects$Group = PrincipalFrameComponent.class$("pgclibrary.objects.Group")) : class$pgclibrary$objects$Group)) {
                    this.groupPanel.setGroup((Group)tmp_element);
                    this.dataComponent.setLeftComponent(this.groupPanel);
                } else if (tmp_element.getClass() == (class$pgclibrary$objects$Sequence == null ? (class$pgclibrary$objects$Sequence = PrincipalFrameComponent.class$("pgclibrary.objects.Sequence")) : class$pgclibrary$objects$Sequence)) {
                    this.sequencePanel.setSequence((Sequence)tmp_element);
                    this.dataComponent.setLeftComponent(this.sequencePanel);
                }
            } else if ((class$components$treeObjects$TreeInfo == null ? (class$components$treeObjects$TreeInfo = PrincipalFrameComponent.class$("components.treeObjects.TreeInfo")) : class$components$treeObjects$TreeInfo).isInstance(_obj)) {
                this.treePanel.setTreeElement(_obj);
                this.dataComponent.setLeftComponent(this.treePanel);
            } else {
                this.last_selected = null;
                this.dataComponent.setLeftComponent(this.default_panel);
            }
        }
        this.dataComponent.setDividerLocation(location);
        this.dataComponent.setLastDividerLocation(lastLocation);
        this.tree_toolbar.refreshValidation();
    }

    public TreeInfo getLastSelected() {
        return this.last_selected;
    }

    public void newObject() {
    }

    public void deleteObject() {
        if (this.getLastSelected() != null && this.getLastSelected().getClass() == (class$components$treeObjects$Element == null ? (class$components$treeObjects$Element = PrincipalFrameComponent.class$("components.treeObjects.Element")) : class$components$treeObjects$Element)) {
            DBObject tmp_element = ((Element)this.getLastSelected()).getSource();
            if (JOptionPane.showConfirmDialog(this.frame, "Do you want to delete the object " + tmp_element.getName()) == 0 && tmp_element.Drop()) {
                this.refreshTree();
            }
        }
    }

    public void editObject() {
    }

    public void refreshValidation() {
        boolean valid;
        if (this.frame != null && !(valid = this.frame.getDatabase().validate())) {
            this.dataComponent.setLeftComponent(this.default_panel);
        }
    }

    public void refreshTree() {
        this.frame.setDatabase(Database.getMainConnection());
        this.tree_control.refreshTree();
        this.tree_toolbar.refreshValidation();
    }

    public void setDataComponent(Component _component) {
        this.dataComponent.setLeftComponent(_component);
    }

    public TreeListener getListener() {
        return this.listener;
    }

    public JSplitPane getDataComponent() {
        return this.dataComponent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

