/*
 * Decompiled with CFR 0.152.
 */
package components.user;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import pgclibrary.objects.User;
import pgclibrary.utilities.SUtilities;
import pgclibrary.utilities.Utilities;

public class UserPanel
extends JTabbedPane {
    User user_object = null;
    JTextField name = new JTextField(20);
    JTextField validlimit = new JTextField(20);
    JTextField dbcreator = new JTextField(20);
    JTextField superuser = new JTextField(20);
    JTextField traceuser = new JTextField(20);
    JTextArea sql = new JTextArea();

    public UserPanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setUser(User user) {
        this.user_object = user;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
    }

    public void refreshProperties() {
        this.refreshDefaultPanel();
    }

    private void insertDefaultTab() {
        this.name.setEditable(false);
        this.validlimit.setEditable(false);
        this.dbcreator.setEditable(false);
        this.superuser.setEditable(false);
        this.traceuser.setEditable(false);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        this.sql.setEditable(false);
        jSplitPane.setBottomComponent(new JScrollPane(this.sql));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(SUtilities.getHorPanel("User Name :", this.name));
        jPanel.add(SUtilities.getHorPanel("Valid Until :", this.validlimit));
        jPanel.add(SUtilities.getHorPanel("Is DB Creator :", this.dbcreator));
        jPanel.add(SUtilities.getHorPanel("Is Super User :", this.superuser));
        jPanel.add(SUtilities.getHorPanel("Is Trace User :", this.traceuser));
        jSplitPane.setTopComponent(SUtilities.centerComponent(jPanel));
        this.addTab("General", jSplitPane);
    }

    private void refreshDefaultPanel() {
        this.name.setText(this.user_object.getName());
        this.sql.setText(this.user_object.getInsertSQL());
        this.validlimit.setText(Utilities.formatDate(this.user_object.getValidLimit(), "MM/dd/yyyy HH:mm:ss"));
        this.dbcreator.setText(Utilities.formatBoolean(this.user_object.isDBCreateor()));
        this.superuser.setText(Utilities.formatBoolean(this.user_object.isSuperUser()));
        this.traceuser.setText(Utilities.formatBoolean(this.user_object.isTraceUser()));
        this.repaint();
    }
}

