/*
 * Decompiled with CFR 0.152.
 */
package components.treeObjects;

import java.util.Vector;
import javax.swing.ImageIcon;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.objects.Database;

public abstract class TreeInfo {
    private ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/shim.gif"));
    protected Vector errors = new Vector();
    private Vector properties = null;
    private TreeInfo owner = null;

    public TreeInfo(TreeInfo treeInfo) {
        this.owner = treeInfo;
    }

    public abstract void rebuildProperties();

    public abstract Object getOID();

    public boolean validate() {
        this.errors = new Vector();
        if (Database.getMainConnection() == null) {
            this.errors.add("No initializations parameters defined.");
            this.errors.add("See the connection parameters.");
        } else if (!Database.getMainConnection().isConnected()) {
            this.errors.add("The connection is not initialized.");
            this.errors.add("See the connection parameters.");
        }
        return this.errors.size() == 0;
    }

    public void refreshProperties() {
        this.properties = null;
    }

    public Vector getProperties() {
        if (this.properties == null) {
            this.rebuildProperties();
        }
        return this.properties;
    }

    public int getPropertyIndex(TreeInfo treeInfo) {
        Vector vector = this.getProperties();
        int n = -1;
        if (treeInfo != null) {
            int n2 = 0;
            while (n2 < vector.size() && n < 0) {
                TreeInfo treeInfo2 = (TreeInfo)vector.get(n2);
                if (treeInfo.equals(treeInfo2)) {
                    n = n2;
                }
                ++n2;
            }
        }
        return n;
    }

    public void addProperty(TreeInfo treeInfo) {
        if (treeInfo != null) {
            if (this.properties == null) {
                this.properties = new Vector();
            }
            this.properties.add(treeInfo);
        }
    }

    public void removeProperty(TreeInfo treeInfo) {
        int n;
        if (treeInfo != null && (n = this.getPropertyIndex(treeInfo)) >= 0) {
            this.properties.remove(n);
        }
    }

    public void removeAllProperties() {
        this.properties = new Vector();
    }

    public int getSize() {
        return this.getProperties().size();
    }

    public boolean isInitialized() {
        return this.properties != null;
    }

    public boolean equals(Object object) {
        TreeInfo treeInfo;
        boolean bl = false;
        if (object.getClass() == this.getClass() && (treeInfo = (TreeInfo)object).getOID() == this.getOID()) {
            bl = true;
        }
        return bl;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    protected void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    protected void setIcon(String string) {
        this.icon = new ImageIcon(this.getClass().getResource(string));
    }

    public Vector getErrors() {
        return this.errors;
    }

    public String getErrorString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.errors.size()) {
            stringBuffer.append((String)this.errors.get(n));
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public TreeInfo getOwner() {
        return this.owner;
    }

    public MainConnection getConnection() {
        return Database.getMainConnection();
    }
}

