/*
 * TableList.java
 *
 * Created on 31 de julio de 2002, 10:58
 */

package pgclibrary.treeObjects;
import pgclibrary.objects.*;
import java.sql.*;
import java.util.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class TableList extends TreeInfo {
    
    /** Creates a new instance of TableList */
    public TableList(RootElement  source) {
        super(source);
        setIcon("/images/table.png");
    }
    
    public Object getOID() {
        return toString();
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            ResultSet rs = getConnection().getQueryGenerator().getTableNames();
            while((rs != null) && rs.next()){
                addProperty(new Element(this, new Table(getDatabase(), rs.getString("TABLE_NAME"))));
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
        }
    }
    
    public String toString(){
        return "Tables";
    }
    
    public Database getDatabase(){
        return ((RootElement) getOwner()).getDatabase();
    }
}
