/*
 * dataSourceResultSet.java
 *
 * Created on 14 de septiembre de 2001, 11:16
 */

package pgclibrary.dataaccess;

import java.text.*;
import java.util.*;
import java.sql.*;

/** This implements a datasource from a ResultSet.
 *
 *
 * @author NMarsollier
 * @version 1.0
 * @see DataSource
 */
public class dataSourceResultSet extends dataSource {
    SimpleDateFormat espFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    
    // Consulta de la base de datos
    String query = new String();
    MainConnection connection = null;
    
    // Registros actuales
    private Statement stat = null;
    private ResultSet rs = null;
    private  boolean eof = false;
    private int row_count = -1;
    
    public dataSourceResultSet() {
    }
    
    /** Close and clear resulset.
     */    
    public void close(){
        if(rs != null){
            try{
                rs.close();
            } catch (SQLException e){};
            try{
                stat.close();
            } catch (SQLException e){};
        }
    }
    
    /** Close and clear the resultSet
     * @throws Throwable From ResultSet.
     */    
    protected void finalize()  throws Throwable {
        close();
    }
    
    /** Creates a new object.
     */
    public dataSourceResultSet(MainConnection _conn, String _query) {
        connection = _conn;
        query = _query;
    }
    
    /** Sets the data to see.
     * @param _conn MainConnection to execute.
     * @param _query Query to execute.
     */
    public void setResultSet(MainConnection _conn, String _query)  {
        connection = _conn;
        query = _query;
    }
    
    /**
     */    
    public void setColumnNames(ArrayList _columnNames){
    }
    public void removeColumnName(String _columnName){
    }
    public void addColumnName(String _columnName){
    }
    
    /** Moves to the first record.
     */    
    public void goTop(){
        if(rs == null){
            requeryInternal();
        }
        try {
            rs.beforeFirst();
        } catch (Exception e) {}
        setRowNum(0);
        eof = false;
    }
    
    /** moves to the next record.
     * @return true if has more records.
     */    
    public boolean next(){
        if(rs == null){
            requeryInternal();
        }
        boolean retorno = false;
        if (rs != null){
            try {
                retorno = rs.next();
                setRowNum(getRowNum()+1);
            } catch (Exception e) {}
        }
        if(!retorno){
            eof = true;
        }
        return retorno;
    }
    
    /** True if has no more elements.
     * @return True if its the last element.
     */    
    public boolean eof(){
        if(rs == null){
            requeryInternal();
        }
        return eof;
    }
    
    /** Return the element at specific column
     * @param _col Element Column.
     * @return Value stored.
     */    
    public String getElementAt(int _col){
        String resultado = new String();
        if(rs == null){
            requeryInternal();
        }
        
        try{
            ResultSetMetaData rsmd = rs.getMetaData();
            switch (rsmd.getColumnType(_col)){
                case java.sql.Types.DATE:
                case java.sql.Types.TIMESTAMP:
                    java.sql.Timestamp tmp = rs.getTimestamp(_col);
                    if(tmp != null){
                        resultado = espFormat.format(tmp);
                    }
                    break;
                default: resultado = rs.getString(_col);
            }
        } catch (SQLException e) {}
        return resultado;
    }
    
    /** Return the column count.
     * @return Column count
     */    
    public int getColumnCount(){
        if(rs == null){
            requeryInternal();
        }
        return getColumnNames().size();
    }
    
    /** Return column size.
     * @param _col Column number.
     * @return Column size
     */    
    public int getColumnSize(int _col){
        int retorno = 10;
        try{
            ResultSetMetaData rsmd = rs.getMetaData();
            retorno = rsmd.getColumnDisplaySize(_col);
        } catch (SQLException e) {}
        
        return validateColumnSize(retorno);
    }
    
    /** Return the row count.
     * @return Row count
     */    
    public int getRowCount(){
        if(rs == null){
            requeryInternal();
        }
        if(row_count == -1){
            String query1= "SELECT COUNT(*) AS CANT FROM ( "
                         + query + ") as tmp ";
            try {
                MainConnection tmp = new MainConnection(connection);
                ResultSet rscant = tmp.executeQuery(query1);
                if((rscant != null) && rscant.next()){
                    row_count = rscant.getInt("CANT");
                }
                rscant.close();
                tmp.close();
            } catch (SQLException e){}
        }
        return row_count;
    }
    
    /** Sets a new filter from record to record.
     * @param _rec_begin from record.
     * @param _rec_end to record.
     */
    public void setDataFilterRecord(int _rec_begin, int _rec_end){
        super.setDataFilterRecord(_rec_begin, _rec_end);
        requeryInternal();
    }
    
    /** Requery the data.
     * @throws SQLException From connection.
     */    
    public void requery() throws SQLException {
        close();
        if (isFiltered()){
            String query1 = query + " limit " + String.valueOf(getRowEnd() -getRowBegin());
            query1 = query1 + " offset " + String.valueOf(getRowBegin());
            stat = connection.getStatement();
            rs = stat.executeQuery(query1);
        } else {
            stat = connection.getStatement();
            rs = stat.executeQuery(query);
        }
        row_count = -1;
        setAllColumnNames();
    }
    private void requeryInternal(){
        try{
            requery();
        } catch (SQLException e){}
    }
    
    private void setAllColumnNames(){
        try{
            ResultSetMetaData rsmd = rs.getMetaData();
            super.getColumnNames().clear();
            int columnas = rsmd.getColumnCount();
            for(int i=0; i<columnas ; i++){
                super.addColumnName(rsmd.getColumnName(i+1));
            }
            goTop();
        } catch (SQLException e){}
    }
}
