package components.view;
import components.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.awt.*;
import pgclibrary.utilities.*;

/**
 * @author  nestor
 */
public class ViewPanel extends JTabbedPane {
    View view_object = null;
    
    JTextField name = new JTextField(20);
    JTextField owner = new JTextField(20);
    JTextArea description = new JTextArea(3, 20);
    
    DataPanel data_panel = new DataPanel();
    ColumnPanel column_panel = new ColumnPanel();

    JTextArea sql = new JTextArea();
    
    /** Creates a new instance of DatabasePanel */
    public ViewPanel() {
        initPanel();
        setPreferredSize(this.getMinimumSize());
    }
    
    public void setView(View _view_object){
        view_object = _view_object;
        refreshProperties();
    }
    
    private void initPanel(){
        setBorder(new EmptyBorder(10,10,10,10));
        insertDefaultTab();
        addTab("Columns", column_panel);
        addTab("Data", data_panel);
        addChangeListener(new ChangeListener(){
                public void stateChanged(ChangeEvent e){
                    refreshProperties();
                }
            }
        );
    }
    
    public void refreshProperties(){
        switch(this.getSelectedIndex()){
            case 0:
                refreshDefaultPanel();
                break;
            case 1:
                column_panel.refresh(view_object);
                break;
            case 2:
                data_panel.refresh(view_object);
                break;
        }
    }
        
    private void insertDefaultTab() {
        name.setEditable(false);
        owner.setEditable(false);
        description.setEditable(false);
        description.setBorder(owner.getBorder());
        description.setBackground(owner.getBackground());
        description.setLineWrap(true);
        JScrollPane dpane = new JScrollPane(description);
        dpane.setPreferredSize(description.getPreferredSize());
        
        JSplitPane panel = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        
        sql.setEditable(false);
        sql.setLineWrap(true);
        panel.setBottomComponent(new JScrollPane(sql));
        
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, BoxLayout.Y_AXIS));
        general_panel.add(SUtilities.getHorPanel("View Name :", name));
        general_panel.add(SUtilities.getHorPanel("View Owner :", owner));
        general_panel.add(SUtilities.getHorPanel("Description :", dpane));
        
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        addTab("General", panel);
    }
    
    private void refreshDefaultPanel(){
        name.setText(view_object.getName());
        owner.setText(view_object.getCreator().getName());
        sql.setText(view_object.getInsertSQL());
        description.setText(view_object.getDescription());
        repaint();
    }
}


