/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.utilities;

import javax.swing.JTextPane;
import pgclibrary.utilities.Utilities;

public class SQLTextParser {
    private JTextPane text = null;
    private int last_offset_read = 0;
    private int _start_off = 0;
    private int _end_off = 0;

    public SQLTextParser(JTextPane _text) {
        this.text = _text;
    }

    public String getCommand(int _offset) {
        return this.getParagraph(_offset);
    }

    public String getNextCommand() {
        String retorno = new String();
        while (retorno.length() == 0 && this.last_offset_read < this._end_off) {
            retorno = this.getParagraph(this.last_offset_read + 2);
        }
        return retorno;
    }

    public String getFirstCommand() {
        return this.getParagraph(0);
    }

    private String getParagraph(int _offset) {
        this._start_off = this.text.getDocument().getStartPosition().getOffset();
        this._end_off = this.text.getDocument().getEndPosition().getOffset() - 1;
        String retorno = new String();
        if (_offset < this._end_off + 1 && _offset >= this._start_off) {
            int start = this.getParagraphStartOffset(_offset);
            this.last_offset_read = this.getParagraphEndOffset(_offset);
            try {
                retorno = this.text.getDocument().getText(start, this.last_offset_read - start);
            }
            catch (Exception e) {
                retorno = new String();
            }
            retorno = Utilities.replaceAll(retorno, "\n", " ");
            retorno = Utilities.replaceAll(retorno, "\t", " ");
            retorno = retorno.trim();
            if (retorno.length() > 0 && retorno.charAt(retorno.length() - 1) == ';') {
                retorno = retorno.substring(0, retorno.length() - 1);
            }
            if (retorno.length() > 0 && retorno.charAt(0) == ';') {
                retorno = retorno.substring(1, retorno.length());
            }
            retorno = retorno.trim();
        }
        return retorno;
    }

    private int getParagraphStartOffset(int _offset) {
        int retorno = _offset;
        if (retorno <= this._start_off) {
            retorno = this._start_off + 1;
        }
        boolean found = false;
        while (!found && --retorno > this._start_off) {
            try {
                if (!this.text.getDocument().getText(retorno, 1).equals("\n")) continue;
                String last = this.getPrevChar(retorno);
                found = last == null || last.equals("\n") || last.equals(";");
            }
            catch (Exception e) {
                found = true;
            }
        }
        return retorno;
    }

    private int getParagraphEndOffset(int _offset) {
        int retorno = _offset - 1;
        boolean found = false;
        while (!found && ++retorno <= this._end_off) {
            try {
                if (!this.text.getDocument().getText(retorno, 1).equals("\n")) continue;
                String last = this.getPrevChar(retorno);
                found = last == null || last.equals("\n") || last.equals(";");
            }
            catch (Exception e) {
                found = true;
            }
        }
        return retorno;
    }

    private String getPrevChar(int offset) {
        String retorno = null;
        try {
            --offset;
            while (offset >= this._start_off && this.text.getDocument().getText(offset, 1).equals(" ")) {
                --offset;
            }
            if (offset >= this._start_off) {
                retorno = this.text.getDocument().getText(offset, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }
}

