/*
 * Decompiled with CFR 0.152.
 */
package components.sequence;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import pgclibrary.objects.Sequence;
import pgclibrary.utilities.SUtilities;

public class SequencePanel
extends JTabbedPane {
    Sequence sequence_object = null;
    JTextField name = new JTextField(20);
    JTextField creator = new JTextField(20);
    JTextArea description = new JTextArea(3, 20);
    JTextField increment = new JTextField(20);
    JTextField last = new JTextField(20);
    JTextField max = new JTextField(20);
    JTextField min = new JTextField(20);
    JTextArea sql = new JTextArea();

    public SequencePanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setSequence(Sequence _sequence_object) {
        this.sequence_object = _sequence_object;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
    }

    public void refreshProperties() {
        this.refreshDefaultPanel();
    }

    private void insertDefaultTab() {
        this.name.setEditable(false);
        this.creator.setEditable(false);
        this.increment.setEditable(false);
        this.last.setEditable(false);
        this.max.setEditable(false);
        this.min.setEditable(false);
        this.description.setEditable(false);
        this.description.setBorder(this.name.getBorder());
        this.description.setBackground(this.name.getBackground());
        this.description.setLineWrap(true);
        JScrollPane dpane = new JScrollPane(this.description);
        dpane.setPreferredSize(this.description.getPreferredSize());
        JSplitPane panel = new JSplitPane(0);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        this.sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(this.sql));
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, 1));
        general_panel.add(SUtilities.getHorPanel("Sequence Name :", this.name));
        general_panel.add(SUtilities.getHorPanel("Creator :", this.creator));
        general_panel.add(SUtilities.getHorPanel("Description :", dpane));
        general_panel.add(SUtilities.getHorPanel("Increment by :", this.increment));
        general_panel.add(SUtilities.getHorPanel("Last Value :", this.last));
        general_panel.add(SUtilities.getHorPanel("Maximum Value :", this.max));
        general_panel.add(SUtilities.getHorPanel("Minimum Value :", this.min));
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        this.addTab("General", panel);
    }

    private void refreshDefaultPanel() {
        this.name.setText(this.sequence_object.getName());
        this.sql.setText(this.sequence_object.getInsertSQL());
        this.creator.setText(this.sequence_object.getCreator().getName());
        this.description.setText(this.sequence_object.getDescription());
        this.increment.setText(String.valueOf(this.sequence_object.getIncrementBy()));
        this.last.setText(String.valueOf(this.sequence_object.getLastValue()));
        this.max.setText(String.valueOf(this.sequence_object.getMaxValue()));
        this.min.setText(String.valueOf(this.sequence_object.getMinValue()));
        this.repaint();
    }
}

