/*
 * UsersPanel.java
 *
 * Created on 1 de agosto de 2002, 16:34
 */

package components.group;
import components.*;
import javax.swing.*;
import java.awt.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class UsersPanel extends JPanel {
    private Group user_object = null;
    private SQLTable data_table = new SQLTable();
    private UsersPanelListener listener = null;
    
    /** Creates a new instance of UsersPanel */
    public UsersPanel() {
        data_table = new SQLTable();
        listener = new UsersPanelListener(this);
        initPanel();
    }
    
    private void initPanel(){
        setLayout(new BorderLayout());
        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        SQLTableModel sql_tm = new SQLTableModel(data_table);
        data_table.setModel(sql_tm);
        
//        add(new UsersPanelToolbar(this), BorderLayout.NORTH);
        add(new JScrollPane(data_table), BorderLayout.CENTER);
    }
    public void refresh(){
        ((SQLTableModel) data_table.getModel()).setDataSource(user_object.getUsersTable());
        repaint();
    }
    public void refresh(Group _user_object){
        user_object = _user_object;
        refresh();
    }
    
    public Group getGroup(){
        return user_object;
    }
    
    public UsersPanelListener getListener(){
        return listener;
    }
    
    public void newUsers(){
    }
    public void deleteUsers(){
    }
}

