/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.User;

public class Database
extends DBObject {
    protected static MainConnection connection = null;
    private String encoding = new String();
    private String template = new String();
    private String location = new String();
    private boolean isTemplate = false;
    private boolean allowConnections = false;

    public Database(MainConnection _connection) {
        super(null);
        Database.setConnection(_connection);
        if (this.validate()) {
            try {
                PreparedStatement prep = this.getConnection().prepareStatement("SELECT OID, * FROM pg_database WHERE DATNAME=?");
                prep.setString(1, this.getConnection().getDatabaseName());
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    this.search(rs.getLong("OID"));
                }
                rs.close();
                prep.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public Database(MainConnection _connection, long oid) {
        super(null);
        Database.setConnection(_connection);
        this.search(oid);
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP DATABASE ");
        retorno.append(this.getName());
        retorno.append(";\n ");
        return retorno.toString();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE DATABASE ");
        retorno.append(this.getName()).append(" ");
        if (this.getLocation().length() > 0 || this.getTemplate().length() > 0 || this.getEncoding().length() > 0) {
            retorno.append("WITH ");
            if (this.getLocation().length() > 0) {
                retorno.append("LOCATION='").append(this.getLocation()).append("' ");
            }
            if (this.getTemplate().length() > 0) {
                retorno.append("TEMPLATE=").append(this.getTemplate()).append(" ");
            }
            if (this.getEncoding().length() > 0) {
                retorno.append("ENCODING=").append(this.getEncoding()).append(" ");
            }
        }
        retorno.append(";\n ");
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(long _oid) {
        boolean retorno = false;
        if (this.validate()) {
            try {
                this.initialize();
                PreparedStatement prep = this.getConnection().prepareStatement("SELECT OID, * FROM pg_database WHERE OID=?");
                prep.setLong(1, _oid);
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    this.setOID(rs.getLong("OID"));
                    this.setName(rs.getString("DATNAME"));
                    this.setDBA(rs.getLong("DATDBA"));
                    this.setTemplate(rs.getBoolean("datistemplate"));
                    this.setAllowConnections(rs.getBoolean("datallowconn"));
                    retorno = true;
                }
                rs.close();
                prep.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return retorno;
    }

    protected void initialize() {
        super.initialize();
        this.isTemplate = false;
        this.allowConnections = false;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean _isTemplate) {
        this.isTemplate = _isTemplate;
    }

    public boolean allowConnections() {
        return this.allowConnections;
    }

    public void setAllowConnections(boolean _allowConnections) {
        this.allowConnections = _allowConnections;
    }

    public void setDBA(User _user) {
        this.setCreator(_user);
    }

    public void setDBA(long _user) {
        this.setCreator(new User(this, _user));
    }

    public User getDBA() {
        return this.getCreator();
    }

    public void setEncoding(String _encoding) {
        this.encoding = _encoding != null ? _encoding : new String();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setTemplate(String _template) {
        this.template = _template != null ? _template : new String();
    }

    public String getTemplate() {
        return this.template;
    }

    public void setLocation(String _location) {
        this.location = _location != null ? _location : new String();
    }

    public String getLocation() {
        return this.location;
    }

    private static void setConnection(MainConnection _connection) {
        connection = _connection;
    }

    public MainConnection getConnection() {
        return connection;
    }

    public static MainConnection getMainConnection() {
        return connection;
    }

    public boolean validate() {
        return connection != null;
    }

    public void refresh() {
        this.search(this.getOID());
    }
}

