/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.postgresql.Connection;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.fastpath.FastpathArg;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.util.PSQLException;

public class LargeObjectManager {
    private Fastpath fp;
    public static final int WRITE = 131072;
    public static final int READ = 262144;
    public static final int READWRITE = 393216;

    private LargeObjectManager() {
    }

    public LargeObjectManager(Connection conn) throws SQLException {
        this.fp = conn.getFastpathAPI();
        ResultSet res = conn.createStatement().executeQuery("select proname, oid from pg_proc where proname = 'lo_open'    or proname = 'lo_close'    or proname = 'lo_creat'    or proname = 'lo_unlink'    or proname = 'lo_lseek'    or proname = 'lo_tell'    or proname = 'loread'    or proname = 'lowrite'");
        if (res == null) {
            throw new PSQLException("postgresql.lo.init");
        }
        this.fp.addFunctions(res);
        res.close();
        DriverManager.println("Large Object initialised");
    }

    public int create() throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(393216)};
        return this.fp.getInteger("lo_creat", args);
    }

    public int create(int mode) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(mode)};
        return this.fp.getInteger("lo_creat", args);
    }

    public void delete(int oid) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(oid)};
        this.fp.fastpath("lo_unlink", false, args);
    }

    public LargeObject open(int oid) throws SQLException {
        return new LargeObject(this.fp, oid, 393216);
    }

    public LargeObject open(int oid, int mode) throws SQLException {
        return new LargeObject(this.fp, oid, mode);
    }

    public void unlink(int oid) throws SQLException {
        this.delete(oid);
    }
}

