/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Zip;

public class Jar
extends Zip {
    private File manifest;
    private boolean manifestAdded;

    public void setJarfile(File jarFile) {
        super.setZipfile(jarFile);
    }

    public void setManifest(File manifestFile) {
        this.manifest = manifestFile;
        if (!this.manifest.exists()) {
            throw new BuildException("Manifest file: " + this.manifest + " does not exist.");
        }
        Zip.PrefixedFileSet fs = new Zip.PrefixedFileSet();
        fs.setDir(new File(this.manifest.getParent()));
        fs.setIncludes(this.manifest.getName());
        fs.setFullpath("META-INF/MANIFEST.MF");
        super.addFileset(fs);
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.manifest == null) {
            String s = "/org/apache/tools/ant/defaultManifest.mf";
            InputStream in = this.getClass().getResourceAsStream(s);
            if (in == null) {
                throw new BuildException("Could not find: " + s);
            }
            this.zipDir(null, zOut, "META-INF/");
            this.zipFile(in, zOut, "META-INF/MANIFEST.MF", System.currentTimeMillis());
        }
        super.initZipOutputStream(zOut);
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if (vPath.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            if (this.manifest == null || !this.manifest.equals(file) || this.manifestAdded) {
                this.log("Warning: selected " + this.archiveType + " files include a META-INF/MANIFEST.MF which will be ignored " + "(please use manifest attribute to " + this.archiveType + " task)", 1);
            } else {
                super.zipFile(file, zOut, vPath);
                this.manifestAdded = true;
            }
        } else {
            super.zipFile(file, zOut, vPath);
        }
    }

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
    }
}

