/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GZip
extends Task {
    private File zipFile;
    private File source;

    public void setZipfile(String zipFilename) {
        this.zipFile = this.project.resolveFile(zipFilename);
    }

    public void setSrc(String src) {
        this.source = this.project.resolveFile(src);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.zipFile == null) {
            throw new BuildException("zipfile attribute is required", this.location);
        }
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.location);
        }
        this.log("Building gzip: " + this.zipFile.getAbsolutePath());
        GZIPOutputStream zOut = null;
        try {
            try {
                zOut = new GZIPOutputStream(new FileOutputStream(this.zipFile));
                if (this.source.isDirectory()) {
                    this.log("Cannot Gzip a directory!", 0);
                } else {
                    this.zipFile(this.source, zOut);
                }
            }
            catch (IOException ioe) {
                String msg = "Problem creating gzip " + ioe.getMessage();
                throw new BuildException(msg, ioe, this.location);
            }
            Object var3_2 = null;
            if (zOut == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (zOut == null) throw throwable;
            try {
                zOut.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        zOut.close();
        return;
    }

    private void zipFile(InputStream in, GZIPOutputStream zOut) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }

    private void zipFile(File file, GZIPOutputStream zOut) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut);
        }
        finally {
            Object var5_4 = null;
            fIn.close();
        }
    }
}

