/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class PlainJUnitResultFormatter
implements JUnitResultFormatter {
    private NumberFormat nf = NumberFormat.getInstance();
    private long lastTestStart = 0L;
    private OutputStream out;
    private StringWriter inner = new StringWriter();
    private PrintWriter wri = new PrintWriter(this.inner);
    private boolean failed = true;

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void startTestSuite(JUnitTest suite) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTestSuite(JUnitTest suite) throws BuildException {
        StringBuffer sb = new StringBuffer("Testsuite: ");
        sb.append(suite.getName());
        sb.append(System.getProperty("line.separator"));
        sb.append("Tests run: ");
        sb.append(suite.runCount());
        sb.append(", Failures: ");
        sb.append(suite.failureCount());
        sb.append(", Errors: ");
        sb.append(suite.errorCount());
        sb.append(", Time elapsed: ");
        sb.append(this.nf.format((double)suite.getRunTime() / 1000.0));
        sb.append(" sec");
        sb.append(System.getProperty("line.separator"));
        sb.append(System.getProperty("line.separator"));
        if (this.out == null) return;
        try {
            try {
                this.out.write(sb.toString().getBytes());
                this.wri.close();
                this.out.write(this.inner.toString().getBytes());
                this.out.flush();
            }
            catch (IOException ioex) {
                throw new BuildException("Unable to write output", (Throwable)ioex);
            }
            Object var4_3 = null;
            if (this.out == System.out) return;
            if (this.out == System.err) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.out == System.out) throw throwable;
            if (this.out == System.err) throw throwable;
            try {
                this.out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        this.out.close();
        return;
    }

    public void startTest(Test t) {
        this.lastTestStart = System.currentTimeMillis();
        this.wri.print("Testcase: " + ((TestCase)t).name());
        this.failed = false;
    }

    public void endTest(Test test) {
        if (this.failed) {
            return;
        }
        this.wri.println(" took " + this.nf.format((double)(System.currentTimeMillis() - this.lastTestStart) / 1000.0) + " sec");
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    public void addError(Test test, Throwable t) {
        this.formatError("\tCaused an ERROR", test, t);
    }

    private void formatError(String type, Test test, Throwable t) {
        if (test != null) {
            this.endTest(test);
        }
        this.failed = true;
        this.wri.println(type);
        this.wri.println(t.getMessage());
        t.printStackTrace(this.wri);
        this.wri.println("");
    }
}

