/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/util/struct/SnapshotCommand.java,v $
 * $Author: ronz $ $Revision: 1.2 $ $Date: 2004/03/09 17:13:44 $
 *
 */

package com.postgres.replic.util.struct;

import java.util.*;

public class SnapshotCommand extends CommandType {
    

    private static final int [] commands =  { DELETE,
                                       UPDATE,
                                       INSERT,
                                       SYNCID,
                                       OK};

    private static Hashtable commandHash = new Hashtable();

    static {
         commandHash.put(new Integer(DELETE), "DELETE");
         commandHash.put(new Integer(UPDATE), "UPDATE");
         commandHash.put(new Integer(UPDATE), "INSERT");
         commandHash.put(new Integer(SYNCID), "SYNCID");
         commandHash.put(new Integer(OK), "OK");
    }


    public SnapshotCommand(int command) throws Exception {
           super(command);
    }

    private void validate(int command) throws Exception {
         if (command < commands[0] || command > commands.length) {
             throw new Exception("SnapshotCommand::validate: unrecognized command: "
             + command);
         }
    }

    public static String decodeCommand(int command) throws Exception {
        if (command < commands[0] || command > commands.length) {
             throw new Exception("SnapshotCommand::decodeCommand: unrecognized command: "
             + command);
         }

        return (String) commandHash.get(new Integer(command));
    }
}
