/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/tools/desc/SlaveAddTable.java,v $
 * $Author: ronz $ $Revision: 1.2 $ $Date: 2004/03/09 17:13:44 $
 *
 */

package com.postgres.replic.tools.desc;

import com.postgres.replic.tools.*;
import java.sql.*;

public class SlaveAddTable extends AddTable {

    private static final String SYS_TABLE = "_RSERV_SLAVE_TABLES_";

    public SlaveAddTable(
    Connection conn,
    String table,
    String column) throws Exception {
        super(conn, table, column);

    }

    /* res[0] will contain oid
       res[1] - AttNum
    */

    public void addTable() throws Exception {

        try {
            getConnection().setAutoCommit(false);
            String [] res = getAttNum(table, column);
            String oid = res [0];
            String attNum = res [1];

            insertRserv(SYS_TABLE, table, column, oid, attNum);
            if (!TEST ) {
                getConnection().commit();
            } else {
                getConnection().rollback();
            }
        } catch (Exception e) {
            try { getConnection().rollback(); } catch (Exception ex) { };
            try { getConnection().setAutoCommit(true); }
            catch (Exception ex) { };
            throw new Exception ("SlaveAddTable::insertRserv: " + e.toString());
        } finally {

        }
    }

}
