/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import org.apache.xalan.xpath.xml.AttList;
import org.apache.xalan.xpath.xml.RawCharacterHandler;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TreeWalker {
    private DocumentHandler m_formatterListener;
    boolean nextIsRaw = false;

    public DocumentHandler getFormatterListener() {
        return this.m_formatterListener;
    }

    public TreeWalker(DocumentHandler documentHandler) {
        this.m_formatterListener = documentHandler;
    }

    public void traverse(Node node) throws SAXException {
        Node node2 = node;
        while (node != null) {
            this.startNode(node);
            Node node3 = node.getFirstChild();
            while (node3 == null) {
                this.endNode(node);
                if (node2.equals(node)) break;
                node3 = node.getNextSibling();
                if (node3 != null || (node = node.getParentNode()) != null && !node2.equals(node)) continue;
                if (node != null) {
                    this.endNode(node);
                }
                node3 = null;
                break;
            }
            node = node3;
        }
    }

    public void traverse(Node node, Node node2) throws SAXException {
        while (node != null) {
            this.startNode(node);
            Node node3 = node.getFirstChild();
            while (node3 == null) {
                this.endNode(node);
                if (node2 != null && node2.equals(node)) break;
                node3 = node.getNextSibling();
                if (node3 != null || (node = node.getParentNode()) != null && (node2 == null || !node2.equals(node))) continue;
                node3 = null;
                break;
            }
            node = node3;
        }
    }

    protected void startNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 8: {
                String string = ((Comment)node).getData();
                if (!(this.m_formatterListener instanceof LexicalHandler)) break;
                LexicalHandler lexicalHandler = (LexicalHandler)((Object)this.m_formatterListener);
                lexicalHandler.comment(string.toCharArray(), 0, string.length());
                return;
            }
            case 9: {
                this.m_formatterListener.startDocument();
                return;
            }
            case 1: {
                NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
                this.m_formatterListener.startElement(node.getNodeName(), new AttList(namedNodeMap));
                return;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                String string = processingInstruction.getNodeName();
                if (string.equals("xslt-next-is-raw") && string.equals("formatter-to-dom")) {
                    this.nextIsRaw = true;
                    return;
                }
                this.m_formatterListener.processingInstruction(processingInstruction.getNodeName(), processingInstruction.getData());
                return;
            }
            case 4: {
                LexicalHandler lexicalHandler;
                String string = ((Text)node).getData();
                boolean bl = this.m_formatterListener instanceof LexicalHandler;
                LexicalHandler lexicalHandler2 = lexicalHandler = bl ? (LexicalHandler)((Object)this.m_formatterListener) : null;
                if (bl) {
                    lexicalHandler.startCDATA();
                }
                this.m_formatterListener.characters(string.toCharArray(), 0, string.length());
                if (!bl) break;
                lexicalHandler.endCDATA();
                return;
            }
            case 3: {
                String string = ((Text)node).getData();
                if (this.nextIsRaw) {
                    this.nextIsRaw = false;
                    if (this.m_formatterListener instanceof RawCharacterHandler) {
                        ((RawCharacterHandler)((Object)this.m_formatterListener)).charactersRaw(string.toCharArray(), 0, string.length());
                        return;
                    }
                    System.out.println("Warning: can't output raw characters!");
                    this.m_formatterListener.characters(string.toCharArray(), 0, string.length());
                    return;
                }
                this.m_formatterListener.characters(string.toCharArray(), 0, string.length());
                return;
            }
            case 5: {
                EntityReference entityReference = (EntityReference)node;
                if (!(this.m_formatterListener instanceof LexicalHandler)) break;
                ((LexicalHandler)((Object)this.m_formatterListener)).startEntity(entityReference.getNodeName());
                return;
            }
        }
    }

    protected void endNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                this.m_formatterListener.endDocument();
                return;
            }
            case 1: {
                this.m_formatterListener.endElement(node.getNodeName());
                return;
            }
            case 5: {
                EntityReference entityReference = (EntityReference)node;
                if (!(this.m_formatterListener instanceof LexicalHandler)) break;
                LexicalHandler lexicalHandler = (LexicalHandler)((Object)this.m_formatterListener);
                lexicalHandler.endEntity(entityReference.getNodeName());
                return;
            }
        }
    }
}

