/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Touch;

public class Get
extends Task {
    private URL source;
    private File dest;
    private boolean verbose = false;
    private boolean useTimestamp = false;
    private boolean ignoreErrors = false;

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.location);
        }
        if (this.dest == null) {
            throw new BuildException("dest attribute is required", this.location);
        }
        if (this.dest.exists() && this.dest.isDirectory()) {
            throw new BuildException("The specified destination is a directory", this.location);
        }
        if (this.dest.exists() && !this.dest.canWrite()) {
            throw new BuildException("Can't write to " + this.dest.getAbsolutePath(), this.location);
        }
        try {
            int length;
            HttpURLConnection httpConnection;
            this.log("Getting: " + this.source);
            long timestamp = 0L;
            boolean hasTimestamp = false;
            if (this.useTimestamp && this.dest.exists()) {
                timestamp = this.dest.lastModified();
                if (this.verbose) {
                    Date t = new Date(timestamp);
                    this.log("local file date : " + t.toString());
                }
                hasTimestamp = true;
            }
            URLConnection connection = this.source.openConnection();
            if (this.useTimestamp && hasTimestamp) {
                connection.setIfModifiedSince(timestamp);
            }
            connection.connect();
            if (connection instanceof HttpURLConnection && (httpConnection = (HttpURLConnection)connection).getResponseCode() == 304) {
                this.log("Not modified - so not downloaded");
                return;
            }
            FileOutputStream fos = new FileOutputStream(this.dest);
            InputStream is = null;
            int i = 0;
            while (i < 3) {
                try {
                    is = connection.getInputStream();
                    break;
                }
                catch (IOException ex) {
                    this.log("Error opening connection " + ex);
                    ++i;
                }
            }
            if (is == null) {
                this.log("Can't get " + this.source + " to " + this.dest);
                if (this.ignoreErrors) {
                    return;
                }
                throw new BuildException("Can't get " + this.source + " to " + this.dest, this.location);
            }
            byte[] buffer = new byte[102400];
            while ((length = is.read(buffer)) >= 0) {
                void ex;
                fos.write(buffer, 0, (int)ex);
                if (!this.verbose) continue;
                System.out.print(".");
            }
            if (this.verbose) {
                System.out.println();
            }
            fos.close();
            is.close();
            if (this.useTimestamp) {
                long remoteTimestamp = connection.getLastModified();
                if (this.verbose) {
                    Date t = new Date(remoteTimestamp);
                    this.log("last modified = " + t.toString() + (remoteTimestamp == 0L ? " - using current time instead" : ""));
                }
                if (remoteTimestamp != 0L) {
                    this.touchFile(this.dest, remoteTimestamp);
                }
            }
        }
        catch (IOException ioe) {
            this.log("Error getting " + this.source + " to " + this.dest);
            if (this.ignoreErrors) {
                return;
            }
            throw new BuildException(ioe, this.location);
        }
    }

    protected boolean touchFile(File file, long timemillis) throws BuildException {
        if (Project.getJavaVersion() != "1.1") {
            Touch touch = (Touch)this.project.createTask("touch");
            touch.setOwningTarget(this.target);
            touch.setTaskName(this.getTaskName());
            touch.setLocation(this.getLocation());
            touch.setFile(file);
            touch.setMillis(timemillis);
            touch.touch();
            return true;
        }
        return false;
    }

    public void setSrc(URL u) {
        this.source = u;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setIgnoreErrors(boolean v) {
        this.ignoreErrors = v;
    }

    public void setUseTimestamp(boolean v) {
        if (Project.getJavaVersion() != "1.1") {
            this.useTimestamp = v;
        }
    }
}

