/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GUnzip
extends Task {
    private File source;
    private File dest;

    public void setSrc(String src) {
        this.source = this.project.resolveFile(src);
    }

    public void setDest(String dest) {
        this.dest = this.project.resolveFile(dest);
    }

    /*
     * Loose catch block
     */
    public void execute() throws BuildException {
        block21: {
            if (this.source == null) {
                throw new BuildException("No source for gunzip specified", this.location);
            }
            if (!this.source.exists()) {
                throw new BuildException("source doesn't exist", this.location);
            }
            if (this.source.isDirectory()) {
                throw new BuildException("Cannot expand a directory", this.location);
            }
            if (this.dest == null) {
                this.dest = new File(this.source.getParent());
            }
            if (this.dest.isDirectory()) {
                String sourceName = this.source.getName();
                int len = sourceName.length();
                this.dest = len > 3 && ".gz".equalsIgnoreCase(sourceName.substring(len - 3)) ? new File(this.dest, sourceName.substring(0, len - 3)) : new File(this.dest, sourceName);
            }
            if (this.source.lastModified() > this.dest.lastModified()) {
                IOException ioex22;
                GZIPInputStream zIn;
                FileOutputStream out;
                block20: {
                    this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
                    out = null;
                    zIn = null;
                    out = new FileOutputStream(this.dest);
                    zIn = new GZIPInputStream(new FileInputStream(this.source));
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        out.write(buffer, 0, count);
                    } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
                    Object var4_9 = null;
                    if (out == null) break block20;
                    try {
                        out.close();
                    }
                    catch (IOException ioex22) {
                        // empty catch block
                    }
                }
                if (zIn != null) {
                    try {
                        zIn.close();
                    }
                    catch (IOException ioex22) {}
                }
                break block21;
                {
                    catch (IOException ioe) {
                        String msg = "Problem expanding gzip " + ioe.getMessage();
                        throw new BuildException(msg, ioe, this.location);
                    }
                }
                catch (Throwable throwable) {
                    IOException ioex22;
                    Object var4_10 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioex22) {
                            // empty catch block
                        }
                    }
                    if (zIn != null) {
                        try {
                            zIn.close();
                        }
                        catch (IOException ioex22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }
}

