/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.printers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Printer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class HTMLPrinter
extends AbstractComponent
implements Printer {
    public void print(Document document, CreationContext creationContext, OutputStream outputStream) throws CreationException, IOException {
        this.printDocument(document, new PrintStream(outputStream));
    }

    private void printAttribute(Attr attr, PrintStream printStream) {
        printStream.print(String.valueOf(attr.getName()) + "=\"" + attr.getValue() + "\"");
    }

    private void printCDATASection(CDATASection cDATASection, PrintStream printStream) {
        this.printString(cDATASection.getData(), printStream);
    }

    private void printComment(Comment comment, PrintStream printStream) {
        printStream.print("<!--" + comment.getData() + "-->");
    }

    private void printDocument(Document document, PrintStream printStream) {
        this.printNodeList(document.getChildNodes(), printStream);
    }

    private void printDocumentFragment(DocumentFragment documentFragment, PrintStream printStream) {
        printStream.print("<!-- Document Fragment Node -->");
    }

    private void printDocumentType(DocumentType documentType, PrintStream printStream) {
        printStream.print("<!-- DOCTYPE " + documentType.getName() + " -->");
    }

    private void printElement(Element element, PrintStream printStream) {
        String string = element.getTagName().toUpperCase();
        printStream.print("<" + string);
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null && namedNodeMap.getLength() > 0) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                printStream.print(' ');
                this.printAttribute((Attr)namedNodeMap.item(n), printStream);
                ++n;
            }
        }
        printStream.print(">");
        if (element.getChildNodes() != null && element.getChildNodes().getLength() > 0) {
            this.printNodeList(element.getChildNodes(), printStream);
        }
        if (string.equals("AREA")) {
            return;
        }
        if (string.equals("BASE")) {
            return;
        }
        if (string.equals("BASEFONT")) {
            return;
        }
        if (string.equals("BR")) {
            return;
        }
        if (string.equals("COL")) {
            return;
        }
        if (string.equals("FRAME")) {
            return;
        }
        if (string.equals("HR")) {
            return;
        }
        if (string.equals("IMG")) {
            return;
        }
        if (string.equals("INPUT")) {
            return;
        }
        if (string.equals("ISINDEX")) {
            return;
        }
        if (string.equals("LINK")) {
            return;
        }
        if (string.equals("META")) {
            return;
        }
        if (string.equals("PARAM")) {
            return;
        }
        printStream.print("</" + string + ">");
    }

    private void printEntity(Entity entity, PrintStream printStream) {
        printStream.print("<!-- Entity Node -->");
    }

    private void printEntityReference(EntityReference entityReference, PrintStream printStream) {
        this.printString(entityReference.getFirstChild().getNodeValue(), printStream);
    }

    private void printNodeList(NodeList nodeList, PrintStream printStream) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            switch (node.getNodeType()) {
                case 2: {
                    this.printAttribute((Attr)node, printStream);
                    break;
                }
                case 4: {
                    this.printCDATASection((CDATASection)node, printStream);
                    break;
                }
                case 8: {
                    this.printComment((Comment)node, printStream);
                    break;
                }
                case 11: {
                    this.printDocumentFragment((DocumentFragment)node, printStream);
                    break;
                }
                case 9: {
                    this.printDocument((Document)node, printStream);
                    break;
                }
                case 10: {
                    this.printDocumentType((DocumentType)node, printStream);
                    break;
                }
                case 1: {
                    this.printElement((Element)node, printStream);
                    break;
                }
                case 6: {
                    this.printEntity((Entity)node, printStream);
                    break;
                }
                case 5: {
                    this.printEntityReference((EntityReference)node, printStream);
                    break;
                }
                case 12: {
                    this.printNotation((Notation)node, printStream);
                    break;
                }
                case 7: {
                    this.printProcessingInstruction((ProcessingInstruction)node, printStream);
                    break;
                }
                case 3: {
                    this.printText((Text)node, printStream);
                    break;
                }
            }
            ++n;
        }
    }

    private void printNotation(Notation notation, PrintStream printStream) {
        printStream.print("<!-- Notation Node -->");
    }

    private void printProcessingInstruction(ProcessingInstruction processingInstruction, PrintStream printStream) {
        printStream.print("<!-- PI:" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "-->");
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void printString(String var1_1, PrintStream var2_2) {
        var3_3 = 0;
        while (var3_3 < var1_1.length()) {
            block100: {
                block105: {
                    block104: {
                        block103: {
                            block102: {
                                block101: {
                                    block99: {
                                        var4_4 = var1_1.charAt(var3_3);
                                        if (var4_4 != '\n') break block99;
                                        var2_2.println();
                                        break block100;
                                    }
                                    if (var4_4 != '\"') break block101;
                                    var2_2.print("&quot;");
                                    break block100;
                                }
                                if (var4_4 != '&') break block102;
                                var2_2.print("&amp;");
                                break block100;
                            }
                            if (var4_4 != '<') break block103;
                            var2_2.print("&lt;");
                            break block100;
                        }
                        if (var4_4 != '>') break block104;
                        var2_2.print("&gt;");
                        break block100;
                    }
                    if (var4_4 != '\u20ac') break block105;
                    var2_2.print("&euro;");
                    break block100;
                }
                if (var4_4 < '\u00a0' || var4_4 > '\u00ff') ** GOTO lbl318
                switch (var4_4) {
                    case '\u00a0': {
                        var2_2.print("&nbsp;");
                        break;
                    }
                    case '\u00a1': {
                        var2_2.print("&iexcl;");
                        break;
                    }
                    case '\u00a2': {
                        var2_2.print("&cent;");
                        break;
                    }
                    case '\u00a3': {
                        var2_2.print("&pound;");
                        break;
                    }
                    case '\u00a4': {
                        var2_2.print("&curren;");
                        break;
                    }
                    case '\u00a5': {
                        var2_2.print("&yen;");
                        break;
                    }
                    case '\u00a6': {
                        var2_2.print("&brvbar;");
                        break;
                    }
                    case '\u00a7': {
                        var2_2.print("&sect;");
                        break;
                    }
                    case '\u00a8': {
                        var2_2.print("&uml;");
                        break;
                    }
                    case '\u00a9': {
                        var2_2.print("&copy;");
                        break;
                    }
                    case '\u00aa': {
                        var2_2.print("&ordf;");
                        break;
                    }
                    case '\u00ab': {
                        var2_2.print("&laquo;");
                        break;
                    }
                    case '\u00ac': {
                        var2_2.print("&not;");
                        break;
                    }
                    case '\u00ad': {
                        var2_2.print("&shy;");
                        break;
                    }
                    case '\u00ae': {
                        var2_2.print("&reg;");
                        break;
                    }
                    case '\u00af': {
                        var2_2.print("&macr;");
                        break;
                    }
                    case '\u00b0': {
                        var2_2.print("&deg;");
                        break;
                    }
                    case '\u00b1': {
                        var2_2.print("&plusmn;");
                        break;
                    }
                    case '\u00b2': {
                        var2_2.print("&sup2;");
                        break;
                    }
                    case '\u00b3': {
                        var2_2.print("&sup3;");
                        break;
                    }
                    case '\u00b4': {
                        var2_2.print("&acute;");
                        break;
                    }
                    case '\u00b5': {
                        var2_2.print("&micro;");
                        break;
                    }
                    case '\u00b6': {
                        var2_2.print("&para;");
                        break;
                    }
                    case '\u00b7': {
                        var2_2.print("&middot;");
                        break;
                    }
                    case '\u00b8': {
                        var2_2.print("&cedil;");
                        break;
                    }
                    case '\u00b9': {
                        var2_2.print("&sup1;");
                        break;
                    }
                    case '\u00ba': {
                        var2_2.print("&ordm;");
                        break;
                    }
                    case '\u00bb': {
                        var2_2.print("&raquo;");
                        break;
                    }
                    case '\u00bc': {
                        var2_2.print("&frac14;");
                        break;
                    }
                    case '\u00bd': {
                        var2_2.print("&frac12;");
                        break;
                    }
                    case '\u00be': {
                        var2_2.print("&frac34;");
                        break;
                    }
                    case '\u00bf': {
                        var2_2.print("&iquest;");
                        break;
                    }
                    case '\u00c0': {
                        var2_2.print("&Agrave;");
                        break;
                    }
                    case '\u00c1': {
                        var2_2.print("&Aacute;");
                        break;
                    }
                    case '\u00c2': {
                        var2_2.print("&Acirc;");
                        break;
                    }
                    case '\u00c3': {
                        var2_2.print("&Atilde;");
                        break;
                    }
                    case '\u00c4': {
                        var2_2.print("&Auml;");
                        break;
                    }
                    case '\u00c5': {
                        var2_2.print("&Aring;");
                        break;
                    }
                    case '\u00c6': {
                        var2_2.print("&AElig;");
                        break;
                    }
                    case '\u00c7': {
                        var2_2.print("&Ccedil;");
                        break;
                    }
                    case '\u00c8': {
                        var2_2.print("&Egrave;");
                        break;
                    }
                    case '\u00c9': {
                        var2_2.print("&Eacute;");
                        break;
                    }
                    case '\u00ca': {
                        var2_2.print("&Ecirc;");
                        break;
                    }
                    case '\u00cb': {
                        var2_2.print("&Euml;");
                        break;
                    }
                    case '\u00cc': {
                        var2_2.print("&Igrave;");
                        break;
                    }
                    case '\u00cd': {
                        var2_2.print("&Iacute;");
                        break;
                    }
                    case '\u00ce': {
                        var2_2.print("&Icirc;");
                        break;
                    }
                    case '\u00cf': {
                        var2_2.print("&Iuml;");
                        break;
                    }
                    case '\u00d0': {
                        var2_2.print("&ETH;");
                        break;
                    }
                    case '\u00d1': {
                        var2_2.print("&Ntilde;");
                        break;
                    }
                    case '\u00d2': {
                        var2_2.print("&Ograve;");
                        break;
                    }
                    case '\u00d3': {
                        var2_2.print("&Oacute;");
                        break;
                    }
                    case '\u00d4': {
                        var2_2.print("&Ocirc;");
                        break;
                    }
                    case '\u00d5': {
                        var2_2.print("&Otilde;");
                        break;
                    }
                    case '\u00d6': {
                        var2_2.print("&Ouml;");
                        break;
                    }
                    case '\u00d7': {
                        var2_2.print("&times;");
                        break;
                    }
                    case '\u00d8': {
                        var2_2.print("&Oslash;");
                        break;
                    }
                    case '\u00d9': {
                        var2_2.print("&Ugrave;");
                        break;
                    }
                    case '\u00da': {
                        var2_2.print("&Uacute;");
                        break;
                    }
                    case '\u00db': {
                        var2_2.print("&Ucirc;");
                        break;
                    }
                    case '\u00dc': {
                        var2_2.print("&Uuml;");
                        break;
                    }
                    case '\u00dd': {
                        var2_2.print("&Yacute;");
                        break;
                    }
                    case '\u00de': {
                        var2_2.print("&THORN;");
                        break;
                    }
                    case '\u00df': {
                        var2_2.print("&szlig;");
                        break;
                    }
                    case '\u00e0': {
                        var2_2.print("&agrave;");
                        break;
                    }
                    case '\u00e1': {
                        var2_2.print("&aacute;");
                        break;
                    }
                    case '\u00e2': {
                        var2_2.print("&acirc;");
                        break;
                    }
                    case '\u00e3': {
                        var2_2.print("&atilde;");
                        break;
                    }
                    case '\u00e4': {
                        var2_2.print("&auml;");
                        break;
                    }
                    case '\u00e5': {
                        var2_2.print("&aring;");
                        break;
                    }
                    case '\u00e6': {
                        var2_2.print("&aelig;");
                        break;
                    }
                    case '\u00e7': {
                        var2_2.print("&ccedil;");
                        break;
                    }
                    case '\u00e8': {
                        var2_2.print("&egrave;");
                        break;
                    }
                    case '\u00e9': {
                        var2_2.print("&eacute;");
                        break;
                    }
                    case '\u00ea': {
                        var2_2.print("&ecirc;");
                        break;
                    }
                    case '\u00eb': {
                        var2_2.print("&euml;");
                        break;
                    }
                    case '\u00ec': {
                        var2_2.print("&igrave;");
                        break;
                    }
                    case '\u00ed': {
                        var2_2.print("&iacute;");
                        break;
                    }
                    case '\u00ee': {
                        var2_2.print("&icirc;");
                        break;
                    }
                    case '\u00ef': {
                        var2_2.print("&iuml;");
                        break;
                    }
                    case '\u00f0': {
                        var2_2.print("&eth;");
                        break;
                    }
                    case '\u00f1': {
                        var2_2.print("&ntilde;");
                        break;
                    }
                    case '\u00f2': {
                        var2_2.print("&ograve;");
                        break;
                    }
                    case '\u00f3': {
                        var2_2.print("&oacute;");
                        break;
                    }
                    case '\u00f4': {
                        var2_2.print("&ocirc;");
                        break;
                    }
                    case '\u00f5': {
                        var2_2.print("&otilde;");
                        break;
                    }
                    case '\u00f6': {
                        var2_2.print("&ouml;");
                        break;
                    }
                    case '\u00f7': {
                        var2_2.print("&divide;");
                        break;
                    }
                    case '\u00f8': {
                        var2_2.print("&oslash;");
                        break;
                    }
                    case '\u00f9': {
                        var2_2.print("&ugrave;");
                        break;
                    }
                    case '\u00fa': {
                        var2_2.print("&uacute;");
                        break;
                    }
                    case '\u00fb': {
                        var2_2.print("&ucirc;");
                        break;
                    }
                    case '\u00fc': {
                        var2_2.print("&uuml;");
                        break;
                    }
                    case '\u00fd': {
                        var2_2.print("&yacute;");
                        break;
                    }
                    case '\u00fe': {
                        var2_2.print("&thorn;");
                        break;
                    }
                    case '\u00ff': {
                        var2_2.print("&yuml;");
                        break;
                    }
lbl318:
                    // 1 sources

                    var2_2.print(var4_4);
                    break;
                }
            }
            ++var3_3;
        }
    }

    private void printText(Text text, PrintStream printStream) {
        this.printString(text.getData(), printStream);
    }
}

