/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DescriptorHandler
extends HandlerBase {
    private static final String EJB_REF = "ejb-ref";
    private static final String HOME_INTERFACE = "home";
    private static final String REMOTE_INTERFACE = "remote";
    private static final String BEAN_CLASS = "ejb-class";
    private static final String PK_CLASS = "prim-key-class";
    protected String currentElement = null;
    protected String currentText = null;
    protected Hashtable ejbFiles = null;
    private Hashtable fileDTDs = new Hashtable();
    private Hashtable resourceDTDs = new Hashtable();
    private boolean inEJBRef = false;
    private File srcDir;

    public void registerFileDTD(String publicId, File dtdFile) {
        this.fileDTDs.put(publicId, dtdFile);
    }

    public void registerResourceDTD(String publicId, String resourceName) {
        this.resourceDTDs.put(publicId, resourceName);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputStream is;
        String dtdResourceName;
        File dtdFile = (File)this.fileDTDs.get(publicId);
        if (dtdFile != null && dtdFile.exists()) {
            try {
                return new InputSource(new FileInputStream(dtdFile));
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        if ((dtdResourceName = (String)this.resourceDTDs.get(publicId)) != null && (is = this.getClass().getResourceAsStream(dtdResourceName)) != null) {
            return new InputSource(is);
        }
        return null;
    }

    public Hashtable getFiles() {
        return this.ejbFiles == null ? new Hashtable() : this.ejbFiles;
    }

    public void startDocument() throws SAXException {
        this.ejbFiles = new Hashtable(10, 1.0f);
        this.currentElement = null;
        this.inEJBRef = false;
    }

    public void startElement(String name, AttributeList attrs) throws SAXException {
        this.currentElement = name;
        this.currentText = "";
        if (name.equals(EJB_REF)) {
            this.inEJBRef = true;
        }
    }

    public void endElement(String name) throws SAXException {
        this.processElement();
        this.currentText = "";
        this.currentElement = "";
        if (name.equals(EJB_REF)) {
            this.inEJBRef = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText = this.currentText + new String(ch, start, length);
    }

    protected void processElement() {
        if (this.inEJBRef) {
            return;
        }
        if (this.currentElement.equals(HOME_INTERFACE) || this.currentElement.equals(REMOTE_INTERFACE) || this.currentElement.equals(BEAN_CLASS) || this.currentElement.equals(PK_CLASS)) {
            File classFile = null;
            String className = this.currentText;
            if (!className.startsWith("java.lang")) {
                className = className.replace('.', File.separatorChar);
                className = className + ".class";
                classFile = new File(this.srcDir, className);
                this.ejbFiles.put(className, classFile);
            }
        }
    }

    public DescriptorHandler(File srcDir) {
        this.srcDir = srcDir;
    }
}

