/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/util/timer/Timer.java,v $
 * $Author: asullivan $ $Revision: 1.1.1.1 $ $Date: 2003/08/26 19:02:34 $
 *
 */

package com.postgres.util.timer;

/**
  * <p>This class implements a simple timer. Every time the
  * timer clock cycle that is specified expires the TimerEvent
  * method on the given TimerListener object will be invoked.
  * This gives the object a chance to perform some type of
  * timeout checking.
  */

public class Timer extends Thread
{
  // TimerListener to receive TimerEvent notifications
  TimerListener m_timerListener;

  // Number of seconds in each timer cycle
  int m_cycle;

  // Object to be supplied with the TimerEvent notification
  Object m_object;
  
  /**
    * <p>Constructs a new Timer object
    *
    * @param timerListener Object that will receive TimerEvent
    * notifications
    * @param cycle Number of seconds in each timer cycle
    */
  public Timer(TimerListener timerListener, int cycle)
    {
      m_timerListener = timerListener;
      m_cycle = cycle;
      m_object = null;
      
    }
  /**
    * <p>Constructs a new Timer object
    *
    * @param timerListener Object that will receive TimerEvent
    * notifications
    * @param cycle Number of seconds in each timer cycle
    * @param object Object to be supplied with the TimerEvent
    * notification
    */
  public Timer(TimerListener timerListener, int cycle,
               Object object)
    {
      m_timerListener = timerListener;
      m_cycle = cycle;
      m_object = object;
    }

  /**
    * <p>Runs the timer. The timer will run until stopped and
    * fire a TimerEvent notification every clock cycle
    */
  public void run()
    {
      // Loop until stopped
      while (true) {
        try {
          
          // Sleep for the clock cycle
          sleep(m_cycle * 1000);
        }
        catch (InterruptedException ex) {
        }

        // Fire a TimerEvent
        if (m_timerListener != null) {
          m_timerListener.TimerEvent(m_object);
        }
      }
    }
}
