/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMElementWriter {
    private static String lSep = System.getProperty("line.separator");
    private StringBuffer sb = new StringBuffer();
    protected String[] knownEntities = new String[]{"gt", "amp", "lt", "apos", "quot"};

    public void write(Element element, Writer out, int indent, String indentWith) throws IOException {
        int i = 0;
        while (i < indent) {
            out.write(indentWith);
            ++i;
        }
        out.write("<");
        out.write(element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        int i2 = 0;
        while (i2 < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i2);
            out.write(" ");
            out.write(attr.getName());
            out.write("=\"");
            out.write(this.encode(attr.getValue()));
            out.write("\"");
            ++i2;
        }
        out.write(">");
        boolean hasChildren = false;
        NodeList children = element.getChildNodes();
        int i3 = 0;
        while (i3 < children.getLength()) {
            Node child = children.item(i3);
            if (child.getNodeType() == 1) {
                if (!hasChildren) {
                    out.write(lSep);
                    hasChildren = true;
                }
                this.write((Element)child, out, indent + 1, indentWith);
            }
            if (child.getNodeType() == 3) {
                out.write("<![CDATA[");
                out.write(((Text)child).getData());
                out.write("]]>");
            }
            ++i3;
        }
        if (hasChildren) {
            i3 = 0;
            while (i3 < indent) {
                out.write(indentWith);
                ++i3;
            }
        }
        out.write("</");
        out.write(element.getTagName());
        out.write(">");
        out.write(lSep);
    }

    public String encode(String value) {
        this.sb.setLength(0);
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    this.sb.append("&lt;");
                    break;
                }
                case '\"': {
                    this.sb.append("&quot;");
                    break;
                }
                case '&': {
                    int nextSemi = value.indexOf(";", i);
                    if (nextSemi < 0 || !this.isReference(value.substring(i, nextSemi + 1))) {
                        this.sb.append("&amp;");
                        break;
                    }
                    this.sb.append('&');
                    break;
                }
                default: {
                    this.sb.append(c);
                    break;
                }
            }
            ++i;
        }
        return this.sb.toString();
    }

    public boolean isReference(String ent) {
        if (ent.charAt(0) != '&' || !ent.endsWith(";")) {
            return false;
        }
        if (ent.charAt(1) == '#') {
            if (ent.charAt(2) == 'x') {
                try {
                    Integer.parseInt(ent.substring(3, ent.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            try {
                Integer.parseInt(ent.substring(2, ent.length() - 1));
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        String name = ent.substring(1, ent.length() - 1);
        int i = 0;
        while (i < this.knownEntities.length) {
            if (name.equals(this.knownEntities[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

