/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Reference;

public class Property
extends Task {
    protected String name;
    protected String value;
    protected File file;
    protected String resource;
    protected String env;
    protected Reference ref = null;
    protected boolean userProperty = false;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(File location) {
        this.setValue(location.getAbsolutePath());
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
    }

    public Reference getRefid() {
        return this.ref;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public void setEnvironment(String env) {
        this.env = env;
    }

    public String getEnvironment() {
        return this.env;
    }

    public void setUserProperty(boolean userProperty) {
        this.userProperty = userProperty;
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    public void execute() throws BuildException {
        try {
            Object obj;
            if (this.name != null && this.value != null) {
                this.addProperty(this.name, this.value);
            }
            if (this.file != null) {
                this.loadFile(this.file);
            }
            if (this.resource != null) {
                this.loadResource(this.resource);
            }
            if (this.env != null) {
                this.loadEnvironment(this.env);
            }
            if (this.name != null && this.ref != null && (obj = this.ref.getReferencedObject(this.getProject())) != null) {
                this.addProperty(this.name, obj.toString());
            }
        }
        catch (Exception e) {
            throw new BuildException(e, this.location);
        }
    }

    protected void loadFile(File file) throws BuildException {
        block8: {
            Properties props = new Properties();
            this.log("Loading " + file.getAbsolutePath(), 3);
            try {
                if (file.exists()) {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        props.load(fis);
                    }
                    finally {
                        Object var5_5 = null;
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    this.addProperties(props);
                    break block8;
                }
                this.log("Unable to find " + file.getAbsolutePath(), 3);
            }
            catch (Exception ex) {
                throw new BuildException(ex.getMessage(), ex, this.location);
            }
        }
    }

    protected void loadResource(String name) {
        Properties props = new Properties();
        this.log("Resource Loading " + name, 3);
        try {
            ClassLoader cL = this.getClass().getClassLoader();
            InputStream is = null;
            is = cL == null ? ClassLoader.getSystemResourceAsStream(name) : cL.getResourceAsStream(name);
            if (is != null) {
                props.load(is);
                this.addProperties(props);
            } else {
                this.log("Unable to find resource " + name, 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void loadEnvironment(String prefix) {
        Properties props = new Properties();
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.log("Loading Environment " + prefix, 3);
        try {
            Vector osEnv = Execute.getProcEnvironment();
            Enumeration e = osEnv.elements();
            while (e.hasMoreElements()) {
                String entry = (String)e.nextElement();
                int pos = entry.indexOf(61);
                ((Hashtable)props).put(prefix + entry.substring(0, pos), entry.substring(pos + 1));
            }
            this.addProperties(props);
        }
        catch (Exception ex) {
            throw new BuildException(ex, this.location);
        }
    }

    protected void addProperties(Properties props) {
        this.resolveAllProperties(props);
        Enumeration e = ((Hashtable)props).keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            String v = ProjectHelper.replaceProperties(this.project, value, this.project.getProperties());
            this.addProperty(name, value);
        }
    }

    protected void addProperty(String n, String v) {
        if (this.userProperty) {
            if (this.project.getUserProperty(n) == null) {
                this.project.setUserProperty(n, v);
            } else {
                this.log("Override ignored for " + n, 3);
            }
        } else if (this.project.getProperty(n) == null) {
            this.project.setProperty(n, v);
        } else {
            this.log("Override ignored for " + n, 3);
        }
    }

    private void resolveAllProperties(Hashtable props) {
        Hashtable<String, String> unresolvableProperties = new Hashtable<String, String>();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = (String)props.get(name);
            boolean resolved = false;
            while (!resolved) {
                Vector propsInValue = new Vector();
                resolved = true;
                boolean unresolvable = false;
                if (this.extractProperties(value, propsInValue)) {
                    int i = 0;
                    while (i < propsInValue.size()) {
                        String elem = (String)propsInValue.elementAt(i);
                        if (elem.equals(name) || unresolvableProperties.containsKey(elem)) {
                            unresolvable = true;
                            break;
                        }
                        if (this.project.getProperties().containsKey(elem) || props.containsKey(elem)) {
                            resolved = false;
                        }
                        ++i;
                    }
                }
                if (unresolvable) {
                    unresolvableProperties.put(name, value);
                    resolved = true;
                }
                if (resolved) continue;
                value = ProjectHelper.replaceProperties(this.project, value, this.project.getProperties());
                value = ProjectHelper.replaceProperties(this.project, value, props);
                props.put(name, value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean extractProperties(String source, Vector properties) {
        int pos;
        boolean i = false;
        int prev = 0;
        while ((pos = source.indexOf("$", prev)) >= 0) {
            void var5_5;
            if (var5_5 == source.length() - 1) {
                prev = var5_5 + true;
                continue;
            }
            if (source.charAt((int)(var5_5 + true)) != '{') {
                prev = var5_5 + 2;
                continue;
            }
            int endName = source.indexOf(125, (int)var5_5);
            String n = source.substring((int)(var5_5 + 2), endName);
            properties.addElement(n);
            prev = endName + 1;
        }
        return properties.size() > 0;
    }
}

