/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class FixCRLF
extends MatchingTask {
    private int addcr;
    private int addtab;
    private int ctrlz;
    private int tablength = 8;
    private File srcDir;
    private File destDir = null;

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setCr(AddAsisRemove attr) {
        String option = attr.getValue();
        this.addcr = option.equals("remove") ? -1 : (option.equals("asis") ? 0 : 1);
    }

    public void setTab(AddAsisRemove attr) {
        String option = attr.getValue();
        this.addtab = option.equals("remove") ? -1 : (option.equals("asis") ? 0 : 1);
    }

    public void setTablength(int tlength) throws BuildException {
        if (tlength < 2 || (tlength & tlength - 1) != 0) {
            throw new BuildException("tablength must be a positive power of 2", this.location);
        }
        this.tablength = tlength;
    }

    public void setEof(AddAsisRemove attr) {
        String option = attr.getValue();
        this.ctrlz = option.equals("remove") ? -1 : (option.equals("asis") ? 0 : 1);
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
        this.log("options: cr=" + (this.addcr == -1 ? "add" : (this.addcr == 0 ? "asis" : "remove")) + " tab=" + (this.addtab == -1 ? "add" : (this.addtab == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == -1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")) + " tablength=" + this.tablength, 3);
        DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        int i = 0;
        while (i < files.length) {
            int o;
            File srcFile = new File(this.srcDir, files[i]);
            int count = (int)srcFile.length();
            byte[] indata = new byte[count];
            try {
                FileInputStream inStream = new FileInputStream(srcFile);
                inStream.read(indata);
                inStream.close();
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
            int cr = 0;
            int lf = 0;
            int tab = 0;
            int k = 0;
            while (k < count) {
                byte c = indata[k];
                if (c == 13) {
                    ++cr;
                }
                if (c == 10) {
                    ++lf;
                }
                if (c == 9) {
                    ++tab;
                }
                ++k;
            }
            boolean eof = count > 0 && indata[count - 1] == 26;
            this.log(srcFile + ": size=" + count + " cr=" + cr + " lf=" + lf + " tab=" + tab + " eof=" + eof, 3);
            int outsize = count;
            if (this.addcr != 0) {
                outsize -= cr;
            }
            if (this.addcr == 1) {
                outsize += lf;
            }
            if (this.addtab == -1) {
                outsize += tab * (this.tablength - 1);
            }
            if (this.ctrlz == 1) {
                ++outsize;
            }
            byte[] outdata = new byte[outsize];
            int line = o = 0;
            int col = 0;
            int k2 = 0;
            while (k2 < count) {
                switch (indata[k2]) {
                    case 32: {
                        if (this.addtab == 0) {
                            outdata[o++] = 32;
                        }
                        ++col;
                        break;
                    }
                    case 9: {
                        if (this.addtab == 0) {
                            outdata[o++] = 9;
                            ++col;
                            break;
                        }
                        col = (col | this.tablength - 1) + 1;
                        break;
                    }
                    case 13: {
                        if (this.addcr != 0) break;
                        outdata[o++] = 13;
                        ++col;
                        break;
                    }
                    case 10: {
                        if (this.addcr == 1) {
                            outdata[o++] = 13;
                        }
                        outdata[o++] = 10;
                        line = o;
                        col = 0;
                        break;
                    }
                    default: {
                        if (this.addtab > 0 && o + 1 < line + col) {
                            int diff = o - line;
                            while ((diff | this.tablength - 1) < col) {
                                outdata[o++] = 9;
                                diff = o - (line -= this.tablength - 1 - (diff & this.tablength - 1));
                            }
                        }
                        while (o < line + col) {
                            outdata[o++] = 32;
                        }
                        outdata[o++] = indata[k2];
                        ++col;
                    }
                }
                ++k2;
            }
            if (this.ctrlz == 1) {
                if (outdata[o - 1] != 26) {
                    outdata[o++] = 26;
                }
            } else if (this.ctrlz == -1) {
                if (o > 2 && outdata[o - 1] == 10 && outdata[o - 2] == 26) {
                    --o;
                }
                if (o > 1 && outdata[o - 1] == 26) {
                    --o;
                }
            }
            try {
                File destFile = srcFile;
                if (this.destDir != null) {
                    destFile = new File(this.destDir, files[i]);
                }
                FileOutputStream outStream = new FileOutputStream(destFile);
                outStream.write(outdata, 0, o);
                outStream.close();
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
            ++i;
        }
    }

    public FixCRLF() {
        if (System.getProperty("path.separator").equals(":")) {
            this.addcr = -1;
            this.ctrlz = -1;
        } else {
            this.addcr = 1;
            this.ctrlz = 0;
        }
    }

    public static class AddAsisRemove
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "asis", "remove"};
        }
    }
}

