/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.util.DOMElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLJUnitResultFormatter
implements JUnitResultFormatter {
    private NumberFormat nf = NumberFormat.getInstance();
    private Document doc;
    private Element rootElement;
    private Element currentTest;
    private long lastTestStart = 0L;
    private OutputStream out;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void startTestSuite(JUnitTest suite) {
        this.doc = XMLJUnitResultFormatter.getDocumentBuilder().newDocument();
        this.rootElement = this.doc.createElement("testsuite");
        this.rootElement.setAttribute("name", suite.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTestSuite(JUnitTest suite) throws BuildException {
        this.rootElement.setAttribute("tests", "" + suite.runCount());
        this.rootElement.setAttribute("failures", "" + suite.failureCount());
        this.rootElement.setAttribute("errors", "" + suite.errorCount());
        this.rootElement.setAttribute("time", this.nf.format((double)suite.getRunTime() / 1000.0) + " sec");
        if (this.out == null) return;
        OutputStreamWriter wri = null;
        try {
            try {
                wri = new OutputStreamWriter(this.out);
                wri.write("<?xml version=\"1.0\"?>\n");
                new DOMElementWriter().write(this.rootElement, (Writer)wri, 0, "  ");
                ((Writer)wri).flush();
            }
            catch (IOException exc) {
                throw new BuildException("Unable to write log file", (Throwable)exc);
            }
            Object var4_3 = null;
            if (this.out == System.out) return;
            if (this.out == System.err) return;
            if (wri == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.out == System.out) throw throwable;
            if (this.out == System.err) throw throwable;
            if (wri == null) throw throwable;
            try {
                ((Writer)wri).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        ((Writer)wri).close();
        return;
    }

    public void startTest(Test t) {
        this.lastTestStart = System.currentTimeMillis();
        this.currentTest = this.doc.createElement("testcase");
        this.currentTest.setAttribute("name", ((TestCase)t).name());
        this.rootElement.appendChild(this.currentTest);
    }

    public void endTest(Test test) {
        this.currentTest.setAttribute("time", this.nf.format((double)(System.currentTimeMillis() - this.lastTestStart) / 1000.0));
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("failure", test, t);
    }

    public void addError(Test test, Throwable t) {
        this.formatError("error", test, t);
    }

    private void formatError(String type, Test test, Throwable t) {
        if (test != null) {
            this.endTest(test);
        }
        Element nested = this.doc.createElement(type);
        if (test != null) {
            this.currentTest.appendChild(nested);
        } else {
            this.rootElement.appendChild(nested);
        }
        String message = t.getMessage();
        if (message != null && message.length() > 0) {
            nested.setAttribute("message", t.getMessage());
        }
        nested.setAttribute("type", t.getClass().getName());
        StringWriter swr = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)swr, true));
        Text trace = this.doc.createTextNode(swr.toString());
        nested.appendChild(trace);
    }
}

