#!/usr/bin/env python

""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from log import *
from qmldb import *
import SocketServer
from cStringIO import StringIO
import sys

class QmlServHandler(SocketServer.StreamRequestHandler):

	pgmlgraph = None
	DBNAME = ''
	DBHOST = ''
	DBUSER = ''
	DBPWD = ''
	DBPORT = '5432'
	log = LOG('QmlServHandler.log')
	debug = 0
	
	def __init__(self, request, client_address, server):
		SocketServer.StreamRequestHandler.__init__(self, request, client_address, server)
		
	def setup(self):
		self.qmldb = None
		SocketServer.StreamRequestHandler.setup(self)

	def _connect(self):
		if self.qmldb: self.qmldb.close()
		self.qmldb = QmlDb(self.pgmlgraph,self.DBNAME,self.DBUSER,self.DBPWD,self.DBHOST,self.DBPORT,self.log,'QmlDb',self.debug)
			
	def _close(self):
		if self.qmldb: self.qmldb.close()
			
	def handle(self):
		
		ip_client = self.client_address[0]
		
		try:
			
			self.wfile.write("\n\rHello %s\n\r" % ip_client)
			self.log.message("connect from %s" % ip_client)
			stringIO = StringIO()
			stringIOappend = 0
			
			while 1:

				self.log.flush()
				
				line = self.rfile.readline()

				if not line: break

				if stringIOappend: stringIO.write(line)
					
				strippedLine = strip(line)
				if not strippedLine and not stringIOappend: continue

				if self.debug:
					sys.stderr.write('rcv line : "%s"\n' % strippedLine)
				
				if strippedLine == '<sequence>' and not stringIOappend:
					
					stringIOappend = 1
					stringIO.write('%s' % line)
															
				elif strippedLine == '</sequence>' and stringIOappend:

					self._connect() # connection
					
					if stringIOappend:
						stringIOappend = 0
					else:
						continue
					
					try:
						stringIO.seek(0)
						result = self.qmldb.readFile(stringIO)
						if result:
							self.wfile.write("OK\n")
						else:
							self.wfile.write("NOK\n")

					except:
						self.wfile.write("NOK\n")

					stringIO.close()
					stringIO = StringIO()
					
				elif not stringIOappend: # commands with args
					
					l = split(strippedLine)
					command = upper(l[0])
					
					if len(l)==2:

						arg = l[1]

						if command == 'USER':
							self.DBUSER = arg
							self._close()
							
						elif command == 'PASSWORD':
							self.DBPWD = arg
							self._close()
							
						elif command == 'HOST':
							self.DBHOST = arg
							self._close()
							
						elif command == 'DATABASE':
							self.DBNAME = arg
							self._close()
							
						else:
							self.log.warning("unknown command : %s\n" % command)
							self.wfile.write("unknown command : %s\n" % command)
					else:
						
						if command == 'GETSELECT':
							self.qmldb.write_last_select(self.wfile)
						else:
							self.log.warning("unknown syntax : %s\n" % strippedLine)
							self.wfile.write("unknown syntax : %s\n" % strippedLine)
				
		except SystemExit, e:
			self.log.message("disconnect from %s" % ip_client)
			self.log.flush()
			self._close()
			print e

	def finish(self):
		SocketServer.StreamRequestHandler.finish(self)
		self.log.flush()
			

	
