/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jdbc2.optional;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.jdbc2.optional.MysqlPooledConnection;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class LogicalHandle
implements java.sql.Connection {
    private java.sql.Connection mc = null;
    private MysqlPooledConnection mpc = null;
    private String invalidHandleStr = "Logical handle no longer valid";
    private boolean closed;

    public LogicalHandle(MysqlPooledConnection mysqlPooledConnection, java.sql.Connection mysqlConnection) throws SQLException {
        this.mpc = mysqlPooledConnection;
        this.mc = mysqlConnection;
        this.closed = false;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setAutoCommit(autoCommit);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getAutoCommit();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setCatalog(catalog);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public String getCatalog() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getCatalog();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed || this.mc.isClosed();
    }

    public void setHoldability(int arg0) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setHoldability(arg0);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public int getHoldability() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getHoldability();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public long getIdleFor() {
        return ((Connection)this.mc).getIdleFor();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getMetaData();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setReadOnly(readOnly);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.isReadOnly();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.setSavepoint();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.setSavepoint(arg0);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setTransactionIsolation(level);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getTransactionIsolation();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setTypeMap(map);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public Map getTypeMap() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getTypeMap();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getWarnings();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.clearWarnings();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(2, sqlException);
            throw sqlException;
        }
    }

    public synchronized void close() throws SQLException {
        this.close(true);
    }

    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.commit();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public Statement createStatement() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.createStatement();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.createStatement(arg0, arg1, arg2);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.nativeSQL(sql);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareCall(sql);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareCall(arg0, arg1, arg2, arg3);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareStatement(sql);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareStatement(arg0, arg1, arg2, arg3);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareStatement(arg0, arg1);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareStatement(arg0, arg1);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareStatement(arg0, arg1);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.releaseSavepoint(arg0);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.rollback();
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    public void rollback(Savepoint arg0) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.rollback(arg0);
        }
        catch (SQLException sqlException) {
            this.mpc.callListener(1, sqlException);
            throw sqlException;
        }
    }

    protected synchronized void close(boolean fireClosedEvent) throws SQLException {
        if (this.closed) {
            return;
        }
        if (fireClosedEvent) {
            this.mpc.callListener(2, null);
        }
        this.closed = true;
    }
}

